/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.form.baseset;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.msmob.common.consts.DataSourceConfigConst;
import kd.scmc.msmob.pojo.SelectParams;
import org.apache.commons.lang3.StringUtils;

public class ColsTreeSelectPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    private static final Log log = LogFactory.getLog(ColsTreeSelectPlugin.class);
    private static final String CACHE_SELECTED_NODE_IDS = "selectedNodeIds";
    private static final String BT_CANCEL = "cancel";
    private static final String BT_OK = "ok";
    private static final String C_TREE = "tree";
    private static final String C_SEARCH = "search";
    private static final String AP_FILTER = "filterap";
    private SelectParams params;

    private SelectParams getParams() {
        if (this.params == null) {
            this.params = new SelectParams();
            this.params.fillByFormShowParameter(this.getView().getFormShowParameter().getCustomParams());
        }
        return this.params;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BT_CANCEL, BT_OK});
        Search search = (Search)this.getControl(C_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        TreeView tree = (TreeView)this.getControl(C_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindTree();
    }

    private void bindTree() {
        IFormView view = this.getView();
        TreeNode rootNode = this.parseTree();
        TreeView tree = (TreeView)view.getControl(C_TREE);
        tree.addNode(rootNode);
        boolean isMulti = this.getParams().isMulti();
        tree.setMulti(isMulti);
        view.setEnable(Boolean.valueOf(!isMulti), new String[]{AP_FILTER});
        view.setVisible(Boolean.valueOf(!isMulti), new String[]{AP_FILTER});
    }

    private TreeNode parseTree() {
        String treeStr = this.getParams().getJsonTree();
        if (StringUtils.isBlank((CharSequence)treeStr)) {
            return new TreeNode("", "0", ResManager.loadKDString((String)"\u6ca1\u6709\u6307\u5b9a\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"ColsTreeSelectPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]));
        }
        TreeNode rootNode = null;
        try {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)treeStr, TreeNode.class);
        }
        catch (Exception e) {
            rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5b57\u6bb5\u6811\u89e3\u6790\u5931\u8d25\u3002", (String)"ColsTreeSelectPlugin_1", (String)"scmc-msmob-form", (Object[])new Object[0]));
            log.error(String.format("\u5b57\u6bb5\u6811\u89e3\u6790\u5931\u8d25:jsonTree[%s]\u3002", treeStr), (Throwable)e);
        }
        return rootNode;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "ok": {
                this.clickOK(evt);
                break;
            }
            case "cancel": {
                this.clickCancel(evt);
                break;
            }
        }
    }

    private void clickCancel(EventObject evt) {
        this.getView().close();
    }

    private void clickOK(EventObject evt) {
        IFormView view = this.getView();
        List<String> ids = this.getSelectedNodeId();
        JSONArray returnInfo = this.getReturnInfo(ids);
        view.returnDataToParent((Object)returnInfo.toJSONString());
        view.close();
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.getParams().isMulti()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            currNodeId = "";
        }
        this.getPageCache().put(CACHE_SELECTED_NODE_IDS, currNodeId);
    }

    private List<String> getSelectedNodeId() {
        TreeView tree = (TreeView)this.getControl(C_TREE);
        TreeView.TreeState treeState = tree.getTreeState();
        if (this.getParams().isMulti()) {
            return treeState.getCheckedNodeIds();
        }
        ArrayList<String> ids = new ArrayList<String>();
        String nodeId = treeState.getFocusNodeId();
        ids.add(nodeId);
        return ids;
    }

    private JSONArray getReturnInfo(List<String> ids) {
        JSONArray infos = new JSONArray();
        if (ids == null) {
            return infos;
        }
        TreeNode tree = this.parseTree();
        TreeNode node = null;
        for (String id : ids) {
            if ("0".equals(id) || (node = tree.getTreeNode(id, DataSourceConfigConst.PORPERTY_MAX_LEVEL.intValue())) == null) continue;
            JSONObject info = new JSONObject(2);
            info.put("id", (Object)node.getId());
            info.put("text", (Object)node.getText());
            info.put("type", (Object)node.getType());
            Object data = node.getData();
            if (data instanceof Map) {
                Map fieldLenMap = (Map)data;
                Integer minLen = (Integer)fieldLenMap.get("minlength");
                Integer maxLen = (Integer)fieldLenMap.get("maxlength");
                String entryKey = (String)fieldLenMap.get("entrykey");
                String entryName = (String)fieldLenMap.get("entryname");
                int minLength = minLen == null ? 0 : minLen;
                int maxLength = maxLen == null ? 0 : maxLen;
                info.put("minlength", (Object)minLength);
                info.put("maxlength", (Object)maxLength);
                info.put("entrykey", (Object)entryKey);
                info.put("entryname", (Object)entryName);
            }
            infos.add((Object)info);
        }
        return infos;
    }

    public void search(SearchEnterEvent e) {
        List treeNodes;
        String searchText = e.getText();
        TreeNode rootNode = this.parseTree();
        IPageCache pageCache = this.getPageCache();
        String pageId = this.getView().getPageId();
        String searchNodesCacheKey = pageId + "_searchNodes";
        String matchNodesCacheKey = pageId + "_matchNodes";
        String oldSearchTextCacheKey = pageId + "_oldSearchText";
        String searchIndexCacheKey = pageId + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isBlank((CharSequence)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, DataSourceConfigConst.PORPERTY_MAX_LEVEL.intValue());
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, DataSourceConfigConst.PORPERTY_MAX_LEVEL.intValue());
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"ColsTreeSelectPlugin_2", (String)"scmc-msmob-form", (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getView().getControl(C_TREE);
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                    treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                    treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"ColsTreeSelectPlugin_3", (String)"scmc-msmob-form", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent treeNodeCheckEvent) {
    }
}

