/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.form.baseset;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.common.design.strategy.colsselect.IColsSelectStrategy;
import kd.scmc.msmob.common.design.strategy.colsselect.MobColumnSelectStrategy;
import kd.scmc.msmob.common.design.strategy.colsselect.PcColumnSelectStrategy;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.common.utils.PageUtils;

public class DataSourceConfigEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        FormUtils.addClickListener(this, "mobfieldname", "mob_entryidkey", "pc_entryidkey", "pcfieldname", "searchfieldname");
        BasedataEdit mobFormF7 = (BasedataEdit)this.getControl("mobform");
        mobFormF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit pcEntityF7 = (BasedataEdit)this.getControl("pcentityobject");
        pcEntityF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setVisible();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
        this.setVisible();
    }

    private void setEnable() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection entryRows = model.getEntryEntity("entryentity");
        for (int i = 0; i < entryRows.size(); ++i) {
            DynamicObject row = (DynamicObject)entryRows.get(i);
            boolean isPreSet = row.getBoolean("ispreset");
            if (isPreSet) {
                view.setEnable(Boolean.FALSE, i, new String[]{"mobfieldname", "pcfieldname"});
                continue;
            }
            view.setEnable(Boolean.TRUE, i, new String[]{"mobfieldname", "pcfieldname"});
        }
        Boolean isSysPreSet = (Boolean)model.getValue("issyspreset");
        if (isSysPreSet.booleanValue()) {
            view.setEnable(Boolean.FALSE, new String[]{"mobform", "pcentityobject", "description"});
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"mobform", "pcentityobject", "description"});
        }
    }

    private void setVisible() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject mobFormDy = (DynamicObject)model.getValue("mobform");
        if (mobFormDy != null) {
            String mobFormKey = mobFormDy.getString("number");
            if (this.isInheritBaseListTpl(mobFormKey, "mob_base_listtpl")) {
                view.setVisible(Boolean.TRUE, new String[]{"searchfieldpanel"});
                view.setVisible(Boolean.FALSE, new String[]{"entrymappingpanel"});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"searchfieldpanel"});
                view.setVisible(Boolean.TRUE, new String[]{"entrymappingpanel"});
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"searchfieldpanel"});
        }
    }

    private boolean isInheritBaseListTpl(String mobFormKey, String mobBaseListTplKey) {
        if (StringUtils.isEmpty((CharSequence)mobFormKey) || StringUtils.isEmpty((CharSequence)mobBaseListTplKey)) {
            return false;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)mobBaseListTplKey);
        DynamicObject baseForm = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"id", (QFilter[])qFilter.toArray());
        if (baseForm == null) {
            return false;
        }
        String baseFormId = baseForm.getString("id");
        MainEntityType mobFormEntityType = MetadataServiceHelper.getDataEntityType((String)mobFormKey);
        String inheritPath = mobFormEntityType.getInheritPath();
        if (StringUtils.isEmpty((CharSequence)inheritPath)) {
            return false;
        }
        List<String> parentIds = Arrays.asList(inheritPath.split(","));
        return parentIds.contains(baseFormId);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryKey;
        super.beforeDeleteRow(e);
        EntryProp entryProp = e.getEntryProp();
        switch (entryKey = entryProp.getName()) {
            case "entryentity": {
                this.delEntryRowCheck(e, "ispreset");
                break;
            }
            case "searchkeyentry": {
                this.delEntryRowCheck(e, "ispresetsearchkey");
                break;
            }
            case "entrymappingentity": {
                this.delEntryRowCheck(e, "ispresetentrykey");
                break;
            }
        }
    }

    private void delEntryRowCheck(BeforeDeleteRowEventArgs e, String preSetFieldKey) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int[] rowIndexArr = e.getRowIndexs();
        StringBuilder preSetRowBuilder = new StringBuilder();
        for (int index : rowIndexArr) {
            Boolean isPreSet = (Boolean)model.getValue(preSetFieldKey, index);
            if (isPreSet == null || !isPreSet.booleanValue()) continue;
            preSetRowBuilder.append(index + 1).append(" , ");
        }
        String preSetRowsTemp = preSetRowBuilder.toString();
        if (StringUtils.isNotEmpty((CharSequence)preSetRowsTemp)) {
            String preSetRows = preSetRowsTemp.substring(0, preSetRowsTemp.lastIndexOf(" , "));
            String errMsg = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u4e3a\u51fa\u5382\u9884\u8bbe\u6570\u636e\uff0c\u4e0d\u80fd\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSourceConfigEditPlugin_4", (String)"scmc-msmob-form", (Object[])new Object[0]), preSetRows);
            view.showErrorNotification(errMsg);
            e.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        int currRowIndex = model.getEntryCurrentRowIndex("entryentity");
        int entryMappingCurrIndex = model.getEntryCurrentRowIndex("entrymappingentity");
        switch (name = e.getProperty().getName()) {
            case "mobform": {
                this.setVisible();
                this.clearEntryData("entryentity", "entrymappingentity");
                break;
            }
            case "pcentityobject": {
                this.clearEntryData("entryentity", "searchkeyentry", "entrymappingentity");
                break;
            }
            case "mobfieldname": {
                this.clearRowByMobFieldName(model, currRowIndex);
                break;
            }
            case "pcfieldname": {
                this.clearRowByPcFieldName(model, currRowIndex);
                break;
            }
            case "mob_entryidkey": {
                this.clearRowByMobEntryIdKey(model, entryMappingCurrIndex);
                break;
            }
            case "pc_entryidkey": {
                this.clearRowByPcEntryIdKey(model, entryMappingCurrIndex);
                break;
            }
        }
    }

    private void clearRowByPcEntryIdKey(IDataModel model, int currRowIndex) {
        String pcEntryIdKey = (String)model.getValue("pc_entryidkey", currRowIndex);
        if (StringUtils.isEmpty((CharSequence)pcEntryIdKey)) {
            model.beginInit();
            model.setValue("pc_entryidkey", (Object)"", currRowIndex);
            model.setValue("pcentryname", (Object)"", currRowIndex);
            model.setValue("pc_entrykey", (Object)"", currRowIndex);
            this.getView().updateView("entrymappingentity", currRowIndex);
            model.endInit();
        }
    }

    private void clearRowByMobFieldName(IDataModel model, int currRowIndex) {
        model.beginInit();
        String mobFieldName = (String)model.getValue("mobfieldname", currRowIndex);
        if (StringUtils.isEmpty((CharSequence)mobFieldName)) {
            model.setValue("mobfieldkey", (Object)"", currRowIndex);
            model.setValue("mobfieldtype", (Object)"", currRowIndex);
            model.setValue("mobfieldminlen", (Object)"", currRowIndex);
            model.setValue("mobfieldmaxlen", (Object)"", currRowIndex);
            model.setValue("mobentrykey", (Object)"", currRowIndex);
        }
        model.setValue("pcfieldname", (Object)"", currRowIndex);
        model.setValue("pcfieldkey", (Object)"", currRowIndex);
        model.setValue("pcfieldtype", (Object)"", currRowIndex);
        model.setValue("pcfieldminlen", (Object)"", currRowIndex);
        model.setValue("pcfieldmaxlen", (Object)"", currRowIndex);
        this.getView().updateView("entryentity", currRowIndex);
        model.endInit();
    }

    private void clearRowByMobEntryIdKey(IDataModel model, int currRowIndex) {
        String mobEntryKey = (String)model.getValue("mob_entryidkey", currRowIndex);
        if (StringUtils.isEmpty((CharSequence)mobEntryKey)) {
            model.beginInit();
            model.setValue("mob_entryidkey", (Object)"", currRowIndex);
            model.setValue("mobentryname", (Object)"", currRowIndex);
            model.setValue("mob_entrykey", (Object)"", currRowIndex);
            this.getView().updateView("entrymappingentity", currRowIndex);
            model.endInit();
        }
    }

    private void clearRowByPcFieldName(IDataModel model, int currRowIndex) {
        String pcFieldName = (String)model.getValue("pcfieldname", currRowIndex);
        if (StringUtils.isEmpty((CharSequence)pcFieldName)) {
            model.beginInit();
            model.setValue("pcfieldkey", (Object)"", currRowIndex);
            model.setValue("pcfieldtype", (Object)"", currRowIndex);
            model.setValue("pcfieldminlen", (Object)"", currRowIndex);
            model.setValue("pcfieldmaxlen", (Object)"", currRowIndex);
            this.getView().updateView("entryentity", currRowIndex);
            model.endInit();
        }
    }

    private void clearEntryData(String ... entryKeys) {
        IDataModel model = this.getModel();
        for (String entryKey : entryKeys) {
            model.deleteEntryData(entryKey);
            model.batchCreateNewEntryRow(entryKey, 1);
        }
    }

    public void beforeClick(BeforeClickEvent e) {
        String key;
        super.beforeClick(e);
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "mobfieldname": 
            case "pcfieldname": 
            case "searchfieldname": 
            case "pc_entryidkey": 
            case "mob_entryidkey": {
                this.checkEntityInfo(e);
                break;
            }
        }
    }

    private void checkEntityInfo(BeforeClickEvent e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject mobFormDy = (DynamicObject)model.getValue("mobform");
        DynamicObject pcEntityDy = (DynamicObject)model.getValue("pcentityobject");
        if (mobFormDy == null && pcEntityDy != null) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u79fb\u52a8\u8868\u5355\u201d\u3002", (String)"DataSourceConfigEditPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
            view.showTipNotification(errMsg);
            e.setCancel(true);
        } else if (mobFormDy != null && pcEntityDy == null) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201cPC\u7aef\u5b9e\u4f53\u201d\u3002", (String)"DataSourceConfigEditPlugin_1", (String)"scmc-msmob-form", (Object[])new Object[0]);
            view.showTipNotification(errMsg);
            e.setCancel(true);
        } else if (mobFormDy == null && pcEntityDy == null) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u79fb\u52a8\u8868\u5355\u201d\u548c\u201cPC\u7aef\u5b9e\u4f53\u201d\u3002", (String)"DataSourceConfigEditPlugin_2", (String)"scmc-msmob-form", (Object[])new Object[0]);
            view.showTipNotification(errMsg);
            e.setCancel(true);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        this.setVisible();
        switch (key) {
            case "mobfieldname": 
            case "mob_entryidkey": {
                this.clickFieldName("mobform", true, key);
                break;
            }
            case "pcfieldname": 
            case "pc_entryidkey": 
            case "searchfieldname": {
                this.clickFieldName("pcentityobject", false, key);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "sync": {
                OperationResult operationResult = e.getOperationResult();
                if (operationResult == null || !operationResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (name) {
            case "mobform": {
                this.beforeMobFormF7Select(showParameter);
                break;
            }
            case "pcentityobject": {
                showParameter.getListFilterParameter().setFilter(DataSourceConfigHelper.getPcEntityF7Filter());
                break;
            }
        }
    }

    private void beforeMobFormF7Select(ListShowParameter showParameter) {
        Map<String, String> mobFormMap = DataSourceConfigHelper.getMobFormF7Range();
        QFilter qFilter = new QFilter("number", "in", mobFormMap.keySet());
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private void clickFieldName(String entityKey, boolean isMobForm, String fieldName) {
        IColsSelectStrategy colsSelectStrategy;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject entityObject = (DynamicObject)model.getValue(entityKey);
        String entityNumber = entityObject.getString("number");
        IColsSelectStrategy iColsSelectStrategy = colsSelectStrategy = isMobForm ? new MobColumnSelectStrategy() : new PcColumnSelectStrategy();
        if ("mob_entryidkey".equals(fieldName) || "pc_entryidkey".equals(fieldName)) {
            PageUtils.showEntryIdTreePage(view, entityNumber, colsSelectStrategy, new CloseCallBack((IFormPlugin)this, fieldName));
        } else {
            PageUtils.showColsTreePage(view, entityNumber, colsSelectStrategy, new CloseCallBack((IFormPlugin)this, fieldName));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "mobfieldname": 
            case "pcfieldname": 
            case "searchfieldname": 
            case "mob_entryidkey": 
            case "pc_entryidkey": {
                this.callBackFieldName(e, actionId);
                break;
            }
        }
    }

    private void callBackFieldName(ClosedCallBackEvent e, String filedName) {
        JSONArray data = this.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        JSONObject dataJson = JSONObject.parseObject((String)data.get(0).toString());
        String fieldType = (String)dataJson.get((Object)"type");
        if (fieldType != null && fieldType.equals("entryentity")) {
            return;
        }
        IDataModel model = this.getModel();
        Integer minLength = (Integer)dataJson.get((Object)"minlength");
        Integer maxLength = (Integer)dataJson.get((Object)"maxlength");
        String entryKey = (String)dataJson.get((Object)"entrykey");
        String entryName = (String)dataJson.get((Object)"entryname");
        int currEntryIndex = model.getEntryCurrentRowIndex("entryentity");
        if ("mobfieldname".equals(filedName)) {
            String mobFieldKey = (String)dataJson.get((Object)"id");
            model.setValue(filedName, dataJson.get((Object)"text"), currEntryIndex);
            model.setValue("mobfieldkey", (Object)mobFieldKey, currEntryIndex);
            model.setValue("mobfieldtype", (Object)fieldType, currEntryIndex);
            model.setValue("mobfieldmaxlen", (Object)maxLength, currEntryIndex);
            model.setValue("mobfieldminlen", (Object)minLength, currEntryIndex);
            model.setValue("mobentrykey", (Object)entryKey, currEntryIndex);
            this.checkField(currEntryIndex);
        } else if ("mob_entryidkey".equals(filedName)) {
            int currEntryMappingIndex = model.getEntryCurrentRowIndex("entrymappingentity");
            String mobEntryIdKey = (String)dataJson.get((Object)"id");
            model.setValue(filedName, dataJson.get((Object)"text"), currEntryMappingIndex);
            model.setValue("mob_entryidkey", (Object)mobEntryIdKey, currEntryMappingIndex);
            model.setValue("mob_entrykey", (Object)entryKey, currEntryMappingIndex);
            model.setValue("mobentryname", (Object)entryName, currEntryMappingIndex);
        } else if ("pcfieldname".equals(filedName)) {
            String pcFieldKey = (String)dataJson.get((Object)"id");
            model.setValue(filedName, dataJson.get((Object)"text"), currEntryIndex);
            model.setValue("pcfieldkey", (Object)pcFieldKey, currEntryIndex);
            model.setValue("pcfieldtype", (Object)fieldType, currEntryIndex);
            model.setValue("pcfieldmaxlen", (Object)maxLength, currEntryIndex);
            model.setValue("pcfieldminlen", (Object)minLength, currEntryIndex);
            this.checkField(currEntryIndex);
        } else if ("pc_entryidkey".equals(filedName)) {
            int currEntryMappingIndex = model.getEntryCurrentRowIndex("entrymappingentity");
            String pcEntryIdKey = (String)dataJson.get((Object)"id");
            model.setValue(filedName, dataJson.get((Object)"text"), currEntryMappingIndex);
            model.setValue("pc_entryidkey", (Object)pcEntryIdKey, currEntryMappingIndex);
            model.setValue("pc_entrykey", (Object)entryKey, currEntryMappingIndex);
            model.setValue("pcentryname", (Object)entryName, currEntryMappingIndex);
        } else if ("searchfieldname".equals(filedName)) {
            int currSearchEntryIndex = model.getEntryCurrentRowIndex("searchkeyentry");
            model.setValue(filedName, dataJson.get((Object)"text"), currSearchEntryIndex);
            model.setValue("searchfieldkey", dataJson.get((Object)"id"), currSearchEntryIndex);
        }
    }

    private void checkField(int currEntryIndex) {
        boolean checkResult = this.checkFieldType(currEntryIndex);
        if (!checkResult) {
            return;
        }
        this.checkTxtFieldLen(currEntryIndex);
    }

    private boolean checkFieldType(int entryRowIndex) {
        IDataModel model = this.getModel();
        String mobFieldKey = (String)model.getValue("mobfieldkey", entryRowIndex);
        String pcFieldKey = (String)model.getValue("pcfieldkey", entryRowIndex);
        String mobFieldType = (String)model.getValue("mobfieldtype", entryRowIndex);
        String pcFieldType = (String)model.getValue("pcfieldtype", entryRowIndex);
        if (StringUtils.isEmpty((CharSequence)mobFieldKey) || StringUtils.isEmpty((CharSequence)pcFieldKey) || StringUtils.isEmpty((CharSequence)mobFieldType) || StringUtils.isEmpty((CharSequence)pcFieldType)) {
            return true;
        }
        IFormView view = this.getView();
        if (DataSourceConfigHelper.checkTypeExcepted(mobFieldType, pcFieldType)) {
            return true;
        }
        if (!mobFieldType.equals(pcFieldType)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u5b57\u6bb5\u201c%1$s\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u5b57\u6bb5\u201c%2$s\u201d\u7684\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c%3$s\u884c\u4fe1\u606f\u6216\u4fee\u6539\u79fb\u52a8\u8868\u5355\u5b57\u6bb5\u201c%4$s\u201d\u7684\u7c7b\u578b\u3002", (String)"DataSourceConfigEditPlugin_5", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFieldKey, pcFieldKey, entryRowIndex + 1, mobFieldKey);
            view.showErrorNotification(errMsg);
            return false;
        }
        return true;
    }

    private void checkTxtFieldLen(int entryRowIndex) {
        int mobFieldMinLen;
        IDataModel model = this.getModel();
        String mobFieldKey = (String)model.getValue("mobfieldkey", entryRowIndex);
        String pcFieldKey = (String)model.getValue("pcfieldkey", entryRowIndex);
        if (StringUtils.isEmpty((CharSequence)mobFieldKey) || StringUtils.isEmpty((CharSequence)pcFieldKey)) {
            return;
        }
        String mobFieldType = (String)model.getValue("mobfieldtype", entryRowIndex);
        if (!("TextProp".equals(mobFieldType) || "LargeTextProp".equals(mobFieldType) || "MuliLangTextProp".equals(mobFieldType) || "TextAreaProp".equals(mobFieldType))) {
            return;
        }
        IFormView view = this.getView();
        int pcFieldMinLen = (Integer)model.getValue("pcfieldminlen", entryRowIndex);
        if (pcFieldMinLen != (mobFieldMinLen = ((Integer)model.getValue("mobfieldminlen", entryRowIndex)).intValue())) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%1$s\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u6587\u672c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u6700\u5c0f\u957f\u5ea6\u201c%3$s\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c\u201c%4$s\u201d\u884c\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%5$s\u201d\u7684\u201c\u6700\u5c0f\u957f\u5ea6\u201d\u3002", (String)"DataSourceConfigEditPlugin_6", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFieldKey, pcFieldKey, pcFieldMinLen, entryRowIndex + 1, mobFieldKey);
            view.showErrorNotification(errMsg);
            return;
        }
        int pcFieldMaxLen = (Integer)model.getValue("pcfieldmaxlen", entryRowIndex);
        int mobFieldMaxLen = (Integer)model.getValue("mobfieldmaxlen", entryRowIndex);
        if (mobFieldMaxLen != pcFieldMaxLen) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%1$s\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u6587\u672c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u6700\u5927\u957f\u5ea6\u201c%3$s\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c%4$s\u884c\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%5$s\u201d\u7684\u6700\u5927\u957f\u5ea6\u3002", (String)"DataSourceConfigEditPlugin_7", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFieldKey, pcFieldKey, pcFieldMaxLen, entryRowIndex + 1, mobFieldKey);
            view.showErrorNotification(errMsg);
        }
    }

    private JSONArray parseReturnData(ClosedCallBackEvent evt) {
        Object data = evt.getReturnData();
        try {
            return JSON.parseArray((String)((String)data));
        }
        catch (Exception e) {
            String errMsg = ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a%1$s \u53c2\u6570\uff1a%2$s", (String)"DataSourceConfigEditPlugin_3", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(String.format("%s, %s, %s", errMsg, e.getMessage(), data));
        }
    }
}

