/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.form.baseset;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;

public class DataSourceConfigListPlugin
extends AbstractListPlugin {
    private static final String MOB_FORM_ID = "mobform.id";
    private static final String MOB_FORM_NUMBER = "mobform.number";
    private static final String PC_ENTITY_OBJECT_ID = "pcentityobject.id";
    private static final String PC_ENTITY_OBJECT_NUMBER = "pcentityobject.number";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumns = args.getCommonFilterColumns();
        this.filterCommonColumnInit(filterColumns);
    }

    private void filterCommonColumnInit(List<FilterColumn> filterColumns) {
        for (FilterColumn filterColumn : filterColumns) {
            if (!(filterColumn instanceof CommonBaseDataFilterColumn)) continue;
            String fieldName = filterColumn.getFieldName();
            CommonBaseDataFilterColumn baseDataFilterColumn = (CommonBaseDataFilterColumn)filterColumn;
            switch (fieldName) {
                case "mobform.number": {
                    this.mobFormFilterInit(baseDataFilterColumn);
                    break;
                }
                case "pcentityobject.number": {
                    this.pcEntityFilterInit(baseDataFilterColumn);
                    break;
                }
            }
        }
    }

    private void pcEntityFilterInit(CommonBaseDataFilterColumn baseDataFilterColumn) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        QFilter qFilter = DataSourceConfigHelper.getPcEntityF7Filter();
        DynamicObjectCollection entityObjects = QueryServiceHelper.query((String)"bos_entityobject", (String)"number,name", (QFilter[])qFilter.toArray());
        if (entityObjects == null || entityObjects.isEmpty()) {
            return;
        }
        for (DynamicObject entityObject : entityObjects) {
            ComboItem comboItem = new ComboItem();
            String name = entityObject.getString("name");
            String number = entityObject.getString("number");
            comboItem.setValue(number);
            comboItem.setCaption(new LocaleString(name));
            comboItems.add(comboItem);
        }
        baseDataFilterColumn.setComboItems(comboItems);
    }

    private void mobFormFilterInit(CommonBaseDataFilterColumn baseDataFilterColumn) {
        ArrayList<ComboItem> mobComboItems = new ArrayList<ComboItem>(10);
        Map<String, String> mobFormMap = DataSourceConfigHelper.getMobFormF7Range();
        for (Map.Entry<String, String> mobFormEntry : mobFormMap.entrySet()) {
            ComboItem comboItem = new ComboItem();
            String formNumber = mobFormEntry.getKey();
            String formName = mobFormEntry.getValue();
            comboItem.setValue(formNumber);
            comboItem.setCaption(new LocaleString(formName));
            mobComboItems.add(comboItem);
        }
        baseDataFilterColumn.setComboItems(mobComboItems);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        String fieldName;
        super.filterContainerBeforeF7Select(args);
        List customQFilters = args.getCustomQFilters();
        switch (fieldName = args.getFieldName()) {
            case "mobform.id": {
                Map<String, String> mobFormMap = DataSourceConfigHelper.getMobFormF7Range();
                customQFilters.add(new QFilter("number", "in", mobFormMap.keySet()));
                break;
            }
            case "pcentityobject.id": {
                customQFilters.add(DataSourceConfigHelper.getPcEntityF7Filter());
                break;
            }
        }
    }
}

