/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.form.baseset;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.msmob.business.helper.BaseDataFieldBizHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.business.helper.WareHouseIsolateHelper;
import kd.scmc.msmob.business.helper.WarehouseHelper;
import kd.scmc.msmob.common.consts.SCMCBaseBillMobConst;
import kd.scmc.msmob.common.utils.ArrayUtils;
import kd.scmc.msmob.common.utils.FormUtils;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.plugin.form.baseset.InvQueryResultListPlugin;
import kd.scmc.msmob.pojo.InvQueryConfig;
import kd.scmc.msmob.pojo.InvQueryFieldMappingRelation;

public class InvQueryConditionEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected DynamicObject entityData;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"query"});
        FormUtils.addF7Listener(this, "location", "warehouse");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "location": {
                this.setLocationFilter(e, bill, showParameter);
                break;
            }
            case "warehouse": {
                this.setWarehouseFilter(e, showParameter);
                break;
            }
        }
    }

    protected void setLocationFilter(BeforeF7SelectEvent e, IDataModel bill, ListShowParameter showParameter) {
        DynamicObject warehouse = (DynamicObject)bill.getValue("warehouse");
        if (warehouse == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed3\u5e93\u4fe1\u606f\u3002", (String)"QueryMaterialInvAccPlugin_4", (String)"scmc-msmob-form", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            DynamicObjectCollection locationDyc = warehouse.getDynamicObjectCollection("entryentity");
            String locationKey = "location.id";
            Map locationIdMap = ArrayUtils.getDynamicObjectsMap(locationKey, (DynamicObject[])locationDyc.toArray((Object[])new DynamicObject[0]));
            QFilter qFilter1 = new QFilter("id", "in", (Object)locationIdMap.keySet().toArray(new Object[0]));
            showParameter.getListFilterParameter().setFilter(qFilter1);
        }
    }

    protected void setWarehouseFilter(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        ArrayList<Object> orgIds = new ArrayList<Object>();
        if (org == null) {
            String pkSet = (String)this.getView().getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg");
            orgIds = pkSet == null || pkSet.isEmpty() ? orgIds : (List)SerializationUtils.fromJsonString((String)pkSet, List.class);
        } else {
            orgIds.add(org.getPkValue());
        }
        ArrayList<Long> isolateOrgList = new ArrayList<Long>(orgIds.size());
        ArrayList<Long> notIsolateOrgList = new ArrayList<Long>(orgIds.size());
        List<Long> LongOrgIds = this.getLongOrgIds(orgIds);
        WareHouseIsolateHelper.buildIsolateList(LongOrgIds, isolateOrgList, notIsolateOrgList);
        List<Object> wareHouseIds = new ArrayList(16);
        if (!isolateOrgList.isEmpty() && notIsolateOrgList.isEmpty()) {
            List<DynamicObject> warehouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(UserServiceHelper.getCurrentUserId(), isolateOrgList, null);
            for (DynamicObject warehouse : warehouses) {
                wareHouseIds.add(warehouse.getLong("id"));
            }
        } else if (!isolateOrgList.isEmpty()) {
            List<Long> allWarehouse = WarehouseHelper.getAllWarehouse(new ArrayList<Object>(notIsolateOrgList));
            HashSet<Long> warehouseIdSet = new HashSet<Long>(allWarehouse);
            List<DynamicObject> warehouses = WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId(UserServiceHelper.getCurrentUserId(), isolateOrgList, null);
            for (DynamicObject warehouse : warehouses) {
                warehouseIdSet.add(warehouse.getLong("id"));
            }
            wareHouseIds.addAll(warehouseIdSet);
        } else {
            wareHouseIds = !notIsolateOrgList.isEmpty() ? WarehouseHelper.getAllWarehouse(new ArrayList<Object>(notIsolateOrgList)) : WarehouseHelper.getAllWarehouse(orgIds);
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
        filterList.add(new QFilter("id", "in", wareHouseIds));
        showParameter.getListFilterParameter().setQFilters(filterList);
    }

    private List<Long> getLongOrgIds(List<Object> orgIds) {
        ArrayList<Long> LongOrgIds = new ArrayList<Long>(orgIds.size());
        if (orgIds.isEmpty()) {
            return LongOrgIds;
        }
        for (Object orgId : orgIds) {
            if (orgId instanceof Integer) {
                LongOrgIds.add(Long.parseLong(orgId.toString()));
                continue;
            }
            LongOrgIds.add((Long)orgId);
        }
        return LongOrgIds;
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Boolean isEditable = (Boolean)formShowParameter.getCustomParam("isEditable");
        String srcFilterFrom = (String)formShowParameter.getCustomParam("srcFilterFrom");
        String invQueryItemKey = (String)formShowParameter.getCustomParam("invQueryItemKey");
        String invQueryConfigStr = (String)formShowParameter.getCustomParam("invQueryConfig");
        String expandQFilterObj = (String)formShowParameter.getCustomParam("expandQFilter");
        Boolean isSubEntry = (Boolean)formShowParameter.getCustomParam("isSubEntry");
        String mobFromKeyOfMainPage = (String)formShowParameter.getCustomParam("mobFormKeyOfMainPage");
        String currMainEntryRowIndex = (String)formShowParameter.getCustomParam("currMainEntryRowIndex");
        if (isSubEntry.booleanValue()) {
            String mobFromKeyOfSubPage = (String)formShowParameter.getCustomParam("mobFormKeyOfSubPage");
            String currSubEntryRowIndex = (String)formShowParameter.getCustomParam("currSubEntryRowIndex");
            pageCache.put("mobFormKeyOfSubPage", mobFromKeyOfSubPage);
            pageCache.put("currSubEntryRowIndex", currSubEntryRowIndex);
        }
        pageCache.put("expandQFilter", expandQFilterObj);
        pageCache.put("mobFormKeyOfSubPage", mobFromKeyOfMainPage);
        pageCache.put("currMainEntryRowIndex", currMainEntryRowIndex);
        pageCache.put("isSubEntry", isSubEntry.toString());
        pageCache.put("isEditable", isEditable.toString());
        pageCache.put("srcFilterFrom", srcFilterFrom);
        pageCache.put("invQueryItemKey", invQueryItemKey);
        pageCache.put("invQueryConfig", invQueryConfigStr);
        String pcEntityKey = (String)formShowParameter.getCustomParam("pcEntityKey");
        String pcEntityStr = (String)formShowParameter.getCustomParam("datasource");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)pcEntityKey);
        Object[] pcEntityCaches = DynamicObjectSerializeUtil.deserialize((String)pcEntityStr, (DynamicObjectType)dataEntityType);
        this.entityData = (DynamicObject)pcEntityCaches[0];
        this.setModelValue();
    }

    private void setModelValue() {
        if (this.entityData == null) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String invQueryConfigStr = (String)formShowParameter.getCustomParam("invQueryConfig");
        InvQueryConfig invQueryConfig = (InvQueryConfig)SerializationUtils.fromJsonString((String)invQueryConfigStr, InvQueryConfig.class);
        List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations = invQueryConfig.getInvQueryFieldMappingRelations();
        for (InvQueryFieldMappingRelation fieldMappingRelation : invQueryFieldMappingRelations) {
            Boolean isFilter = fieldMappingRelation.getFilter();
            if (!isFilter.booleanValue()) continue;
            String invFilterFieldKey = fieldMappingRelation.getInvFilterFieldKey();
            String pcFieldKey = fieldMappingRelation.getPcFieldKey();
            Object fieldValue = this.getFieldValue(this.entityData, pcFieldKey);
            model.setValue(invFilterFieldKey, fieldValue);
            view.updateView(invFilterFieldKey);
        }
    }

    private Object getFieldValue(DynamicObject entityData, String pcFieldKey) {
        Object fieldValue = null;
        String tempPcFieldKey = pcFieldKey.contains(".") ? pcFieldKey.substring(pcFieldKey.lastIndexOf(".") + 1) : pcFieldKey;
        IDataEntityProperty property = ((BillEntityType)entityData.getDynamicObjectType()).findProperty(tempPcFieldKey);
        if (this.isHeadProp(property)) {
            fieldValue = entityData.get(pcFieldKey);
        } else if (this.isSubEntryProp(property)) {
            IDataEntityType parent = property.getParent();
            IDataEntityType entry = parent.getParent();
            String pcEntryKey = entry.getName();
            String pcSubEntryKey = parent.getName();
            fieldValue = this.getSubEntryFieldValue(entityData, pcEntryKey, pcSubEntryKey, pcFieldKey);
        } else if (this.isEntryProp(property)) {
            String entryKey = property.getParent().getName();
            fieldValue = this.getEntryFieldValue(entityData, entryKey, pcFieldKey);
        }
        fieldValue = this.dealWithFieldValue(entityData, property, fieldValue);
        return fieldValue;
    }

    private Object dealWithFieldValue(DynamicObject entityData, IDataEntityProperty property, Object fieldValue) {
        IDataEntityProperty masterIdProp;
        if (property instanceof MulBasedataProp) {
            fieldValue = BaseDataFieldBizHelper.getMultiBaseDataIdArr(fieldValue);
        } else if (fieldValue != null && property instanceof ItemClassProp) {
            IDataModel model = this.getModel();
            IPageCache pageCache = this.getPageCache();
            String currMainEntryRowIndexStr = pageCache.get("currMainEntryRowIndex");
            int currMainEntryRowIndex = Integer.parseInt(currMainEntryRowIndexStr);
            if (StringUtils.isEmpty((CharSequence)currMainEntryRowIndexStr)) {
                return fieldValue;
            }
            String baseDataTypeFieldKey = ((ItemClassProp)property).getTypePropName();
            IDataEntityType parent = property.getParent();
            if (parent instanceof SubEntryType) {
                String currSubEntryRowIndexStr = pageCache.get("currSubEntryRowIndex");
                if (StringUtils.isEmpty((CharSequence)currSubEntryRowIndexStr)) {
                    return fieldValue;
                }
                String subEntryKey = parent.getName();
                String entryKey = parent.getParent().getName();
                DynamicObjectCollection entryRowColl = entityData.getDynamicObjectCollection(entryKey);
                DynamicObject entryRow = (DynamicObject)entryRowColl.get(currMainEntryRowIndex);
                DynamicObjectCollection subEntryRowColl = entryRow.getDynamicObjectCollection(subEntryKey);
                int currSubEntryRowIndex = Integer.parseInt(currSubEntryRowIndexStr);
                DynamicObject subEntryRow = (DynamicObject)subEntryRowColl.get(currSubEntryRowIndex);
                Object baseDataTypeValue = subEntryRow.get(baseDataTypeFieldKey);
                StringBuilder fullBaseDataTypeKey = new StringBuilder();
                fullBaseDataTypeKey.append(entryKey);
                fullBaseDataTypeKey.append('.');
                fullBaseDataTypeKey.append(subEntryKey);
                fullBaseDataTypeKey.append('.');
                fullBaseDataTypeKey.append(baseDataTypeFieldKey);
                String baseDataTypeFilterFieldKey = this.getPcFieldKeyToInvFilterFieldKey(fullBaseDataTypeKey.toString());
                if (StringUtils.isEmpty((CharSequence)baseDataTypeFilterFieldKey)) {
                    return fieldValue;
                }
                model.setValue(baseDataTypeFilterFieldKey, baseDataTypeValue);
            } else if (parent instanceof EntryType) {
                String entryKey = parent.getName();
                DynamicObjectCollection entryRowColl = entityData.getDynamicObjectCollection(entryKey);
                DynamicObject entryRow = (DynamicObject)entryRowColl.get(currMainEntryRowIndex);
                Object baseDataTypeValue = entryRow.get(baseDataTypeFieldKey);
                StringBuilder fullBaseDataTypeKey = new StringBuilder();
                fullBaseDataTypeKey.append(entryKey);
                fullBaseDataTypeKey.append('.');
                fullBaseDataTypeKey.append(baseDataTypeFieldKey);
                String baseDataTypeFilterFieldKey = this.getPcFieldKeyToInvFilterFieldKey(fullBaseDataTypeKey.toString());
                if (StringUtils.isEmpty((CharSequence)baseDataTypeFilterFieldKey)) {
                    return fieldValue;
                }
                model.setValue(baseDataTypeFilterFieldKey, baseDataTypeValue);
            }
        } else if (fieldValue != null && property instanceof BasedataProp && (masterIdProp = ((RefEntityType)((DynamicObject)fieldValue).getDynamicObjectType()).findProperty("masterid")) instanceof BasedataProp) {
            fieldValue = ((DynamicObject)fieldValue).get("masterid");
        }
        return fieldValue;
    }

    private String getPcFieldKeyToInvFilterFieldKey(String pcFieldKey) {
        IPageCache pageCache = this.getPageCache();
        String invQueryConfigStr = pageCache.get("invQueryConfig");
        InvQueryConfig invQueryConfig = (InvQueryConfig)SerializationUtils.fromJsonString((String)invQueryConfigStr, InvQueryConfig.class);
        List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations = invQueryConfig.getInvQueryFieldMappingRelations();
        for (InvQueryFieldMappingRelation fieldMappingRelation : invQueryFieldMappingRelations) {
            if (!pcFieldKey.equals(fieldMappingRelation.getPcFieldKey())) continue;
            return fieldMappingRelation.getInvFilterFieldKey();
        }
        return "";
    }

    private boolean isHeadProp(IDataEntityProperty property) {
        return property == null ? false : property.getParent() instanceof MainEntityType;
    }

    private boolean isSubEntryProp(IDataEntityProperty property) {
        return property == null ? false : property.getParent() instanceof SubEntryType;
    }

    private boolean isEntryProp(IDataEntityProperty property) {
        return !this.isSubEntryProp(property) && property != null && property.getParent() instanceof EntryType;
    }

    private Object getEntryFieldValue(DynamicObject currEntityObject, String pcEntryKey, String pcEntryFieldKey) {
        IPageCache pageCache = this.getPageCache();
        String currMainEntryRowIndexStr = pageCache.get("currMainEntryRowIndex");
        if (currMainEntryRowIndexStr == null) {
            return null;
        }
        DynamicObjectCollection entryRowColl = currEntityObject.getDynamicObjectCollection(pcEntryKey);
        int currMainEntryRowIndex = Integer.parseInt(currMainEntryRowIndexStr);
        DynamicObject currEntryRow = (DynamicObject)entryRowColl.get(currMainEntryRowIndex);
        pcEntryFieldKey = pcEntryFieldKey.contains(".") ? pcEntryFieldKey.substring(pcEntryFieldKey.lastIndexOf(".") + 1) : pcEntryFieldKey;
        Object fieldValue = currEntryRow.get(pcEntryFieldKey);
        return fieldValue;
    }

    private Object getSubEntryFieldValue(DynamicObject currEntityObject, String pcEntryKey, String pcSubEntryKey, String pcSubEntryFieldKey) {
        IPageCache pageCache = this.getPageCache();
        String currMainEntryRowIndexStr = pageCache.get("currMainEntryRowIndex");
        String currSubEntryRowIndexStr = pageCache.get("currSubEntryRowIndex");
        int currMainEntryRowIndex = Integer.parseInt(currMainEntryRowIndexStr);
        int currSubEntryRowIndex = Integer.parseInt(currSubEntryRowIndexStr);
        DynamicObjectCollection entryRowColl = currEntityObject.getDynamicObjectCollection(pcEntryKey);
        DynamicObject entryRow = (DynamicObject)entryRowColl.get(currMainEntryRowIndex);
        DynamicObjectCollection subEntryRowColl = entryRow.getDynamicObjectCollection(pcSubEntryKey);
        DynamicObject currSubEntryRow = (DynamicObject)subEntryRowColl.get(currSubEntryRowIndex);
        pcSubEntryFieldKey = pcSubEntryFieldKey.contains(".") ? pcSubEntryFieldKey.substring(pcSubEntryFieldKey.lastIndexOf(".") + 1) : pcSubEntryFieldKey;
        Object fieldValue = currSubEntryRow.get(pcSubEntryFieldKey);
        return fieldValue;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setVisible();
    }

    private void setVisible() {
        Boolean isFilter;
        this.hideAllFilterKeys();
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        String invQueryConfigStr = pageCache.get("invQueryConfig");
        InvQueryConfig invQueryConfig = (InvQueryConfig)SerializationUtils.fromJsonString((String)invQueryConfigStr, InvQueryConfig.class);
        List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations = invQueryConfig.getInvQueryFieldMappingRelations();
        HashMap<Boolean, ArrayList<String>> visibleToFilterFieldKeys = new HashMap<Boolean, ArrayList<String>>(16);
        for (InvQueryFieldMappingRelation invQueryFieldMappingRelation : invQueryFieldMappingRelations) {
            isFilter = invQueryFieldMappingRelation.getFilter();
            String invFilterFieldKey = invQueryFieldMappingRelation.getInvFilterFieldKey();
            ArrayList<String> invFilterFieldKeys = (ArrayList<String>)visibleToFilterFieldKeys.get(isFilter);
            if (invFilterFieldKeys == null) {
                invFilterFieldKeys = new ArrayList<String>(10);
            }
            invFilterFieldKeys.add(invFilterFieldKey);
            visibleToFilterFieldKeys.put(isFilter, invFilterFieldKeys);
        }
        for (Map.Entry entry : visibleToFilterFieldKeys.entrySet()) {
            isFilter = (Boolean)entry.getKey();
            List invFilterFieldKeys = (List)entry.getValue();
            view.setVisible(isFilter, invFilterFieldKeys.toArray(new String[invFilterFieldKeys.size()]));
        }
    }

    private void hideAllFilterKeys() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        Set invFilterFieldkeys = model.getDataEntityType().getAllFields().keySet();
        view.setVisible(Boolean.FALSE, invFilterFieldkeys.toArray(new String[invFilterFieldkeys.size()]));
    }

    public void click(EventObject e) {
        String ctrlKey;
        super.click(e);
        Control control = (Control)e.getSource();
        switch (ctrlKey = control.getKey()) {
            case "query": {
                this.query();
                break;
            }
        }
    }

    private void query() {
        IPageCache pageCache = this.getPageCache();
        QFilter qFilter = this.buildInvRealBalanceFilter();
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String isEditableStr = pageCache.get("isEditable");
        String srcFilterFrom = pageCache.get("srcFilterFrom");
        String isSubEntryStr = pageCache.get("isSubEntry");
        String invQueryItemKey = pageCache.get("invQueryItemKey");
        Boolean isEditable = StringUtils.isEmpty((CharSequence)isEditableStr) ? Boolean.FALSE : Boolean.valueOf(isEditableStr);
        Boolean isSubEntry = StringUtils.isEmpty((CharSequence)isSubEntryStr) ? Boolean.FALSE : Boolean.valueOf(isSubEntryStr);
        customParams.put("isEditable", isEditable);
        String expandFilterObj = pageCache.get("expandQFilter");
        QFilter expandFilter = StringUtils.isNotEmpty((CharSequence)expandFilterObj) ? QFilter.fromSerializedString((String)expandFilterObj) : null;
        qFilter = expandFilter == null ? qFilter : qFilter.and(expandFilter);
        customParams.put("filterCondition", qFilter.toSerializedString());
        customParams.put("srcFilterFrom", srcFilterFrom);
        customParams.put("isSubEntry", isSubEntry);
        customParams.put("invQueryItemKey", invQueryItemKey);
        String isFromResultPage = (String)this.getView().getFormShowParameter().getCustomParam("isFromResultPage");
        if ("true".equals(isFromResultPage)) {
            this.getView().returnDataToParent((Object)customParams);
            this.getView().close();
        } else {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "queryOpCallBack");
            customParams.put("pcEntityKey", this.getView().getFormShowParameter().getCustomParam("pcEntityKey"));
            customParams.put("invQueryConfig", this.getView().getFormShowParameter().getCustomParam("invQueryConfig"));
            customParams.put("datasource", this.getView().getFormShowParameter().getCustomParam("datasource"));
            this.showInvQueryResultList(customParams, closeCallBack);
        }
    }

    private void showInvQueryResultList(Map<String, Object> customParams, CloseCallBack closeCallBack) {
        IDataModel model = this.getModel();
        IFormView currentView = this.getView();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            Long orgId = Long.valueOf(org.getPkValue().toString());
            boolean hasViewPermission = PermissionHelper.checkPermission(orgId, MetaUtils.getPcAppId("im_inv_realbalance"), "im_inv_realbalance", "47150e89000000ac");
            customParams.put(InvQueryResultListPlugin.FORM_PARAMETER_FROM_CONDITION, true);
            if (hasViewPermission) {
                PageUtils.showFormPage(currentView, "msmob_invqueryresult", customParams, closeCallBack);
            } else {
                String errMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u8868\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvQueryConditionEditPlugin_INVQUERY_PERMVIEW", (String)"scmc-msmob-form", (Object[])new Object[0]);
                currentView.showErrorNotification(errMsg);
            }
        }
    }

    private QFilter buildInvRealBalanceFilter() {
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        String invQueryConfigStr = pageCache.get("invQueryConfig");
        InvQueryConfig invQueryConfig = (InvQueryConfig)SerializationUtils.fromJsonString((String)invQueryConfigStr, InvQueryConfig.class);
        List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations = invQueryConfig.getInvQueryFieldMappingRelations();
        QFilter invRealBalanceFilter = new QFilter("1", "=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
        for (InvQueryFieldMappingRelation invQueryFieldMapping : invQueryFieldMappingRelations) {
            Boolean isFilter = invQueryFieldMapping.getFilter();
            if (!isFilter.booleanValue()) continue;
            String invRealBalFieldkey = invQueryFieldMapping.getRealBalFieldKey();
            String invFilterFieldKey = invQueryFieldMapping.getInvFilterFieldKey();
            Object fieldValue = model.getValue(invFilterFieldKey);
            if (fieldValue == null || "".equals(fieldValue)) continue;
            if (fieldValue instanceof DynamicObject) {
                Long id = ((DynamicObject)fieldValue).getLong("id");
                StringBuilder newFieldKey = new StringBuilder();
                newFieldKey.append(invRealBalFieldkey);
                newFieldKey.append('.');
                newFieldKey.append("id");
                invRealBalanceFilter.and(newFieldKey.toString(), "=", (Object)id);
                continue;
            }
            if (fieldValue instanceof Object[]) {
                invRealBalanceFilter.and(invRealBalFieldkey, "in", fieldValue);
                continue;
            }
            invRealBalanceFilter.and(invRealBalFieldkey, "=", fieldValue);
        }
        return invRealBalanceFilter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "material": {
                this.materialChanged();
                break;
            }
            case "warehouse": {
                this.warehouseChanged();
                break;
            }
        }
    }

    private void warehouseChanged() {
        this.getModel().setValue("location", null);
    }

    private void materialChanged() {
        IDataModel model = this.getModel();
        model.setValue("auxpty", null);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "queryOpCallBack": {
                this.queryOpCallBack(returnData);
                break;
            }
        }
    }

    private void queryOpCallBack(Object returnData) {
        IFormView view = this.getView();
        view.returnDataToParent(returnData);
        view.close();
    }
}

