/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.form.baseset;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.scmc.msmob.common.utils.ConverterUtils;
import kd.scmc.msmob.common.utils.MobileControlUtils;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.common.utils.reserve.ReserveHelper;
import kd.scmc.msmob.plugin.tpl.basetpl.listtpl.MobBizListMultiOperateTplPlugin;
import kd.scmc.msmob.pojo.FilterCondition;
import kd.scmc.msmob.pojo.PropertyNode;

public class InvQueryResultListPlugin
extends MobBizListMultiOperateTplPlugin {
    public static String FORM_PARAMETER_FROM_CONDITION = "FORM_PARAMETER_FROM_CONDITION";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"back", "filter"});
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        cardEntry.addPagerClickListener((PagerClickListener)this);
    }

    @Override
    public List<FilterCondition> getFilters() {
        IFormView view = this.getView();
        List<FilterCondition> filters = super.getFilters();
        this.addFilters(view, filters);
        return filters;
    }

    private void addFilters(IFormView view, List<FilterCondition> filters) {
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String filterConditionStr = (String)formShowParameter.getCustomParam("filterCondition");
        QFilter qFilter = StringUtils.isNotEmpty((CharSequence)filterConditionStr) ? QFilter.fromSerializedString((String)filterConditionStr) : null;
        QFilter qtyFilter = this.qtyFilter();
        qFilter = qFilter == null ? qtyFilter : qFilter.and(qtyFilter);
        List<FilterCondition> filterConditions = ConverterUtils.getFilterConditionList(Collections.singletonList(qFilter));
        filters.addAll(filterConditions);
    }

    private QFilter qtyFilter() {
        QFilter qtyFilter = new QFilter("baseqty", "!=", (Object)BigDecimal.ZERO);
        qtyFilter.or(new QFilter("qty", "!=", (Object)BigDecimal.ZERO));
        qtyFilter.or(new QFilter("qty2nd", "!=", (Object)BigDecimal.ZERO));
        return qtyFilter;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        if (entryRowCount == 0) {
            return;
        }
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Boolean isEditable = (Boolean)formShowParameter.getCustomParam("isEditable");
        Boolean isSubEntry = (Boolean)formShowParameter.getCustomParam("isSubEntry");
        String srcFilterFrom = (String)formShowParameter.getCustomParam("srcFilterFrom");
        String invQueryItemKey = (String)formShowParameter.getCustomParam("invQueryItemKey");
        pageCache.put("isEditable", String.valueOf(isEditable));
        pageCache.put("srcFilterFrom", srcFilterFrom);
        pageCache.put("isSubEntry", String.valueOf(isSubEntry));
        pageCache.put("invQueryItemKey", invQueryItemKey);
        this.initReserveAndStyle();
    }

    private void initReserveAndStyle() {
        int endRowIndexOfFirstPage = this.getEndRowIndexOfFirstPage();
        this.setReserveInfo(0, endRowIndexOfFirstPage);
        this.setInvTypeAndStatus(0, endRowIndexOfFirstPage);
        this.getView().updateView("entryentity");
    }

    private void setReserveInfo(int startRowIndex, int endRowIndex) {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("entryentity");
        if (entryRowCount == 0) {
            return;
        }
        DataSet reserveDataSet = this.getReserveDataSet(startRowIndex, endRowIndex);
        Map<String, BigDecimal> fieldKeyToValue = this.buildFieldKeyToValue(startRowIndex, endRowIndex, reserveDataSet);
        Map<String, PropertyNode> fieldMapping = this.getFieldMapping();
        this.setReserveValue(fieldMapping, fieldKeyToValue);
    }

    private Map<String, BigDecimal> buildFieldKeyToValue(int startRowIndex, int endRowIndex, DataSet reserveDataSet) {
        IDataModel model = this.getModel();
        HashMap<String, BigDecimal> fieldKeyToValue = new HashMap<String, BigDecimal>(16);
        while (reserveDataSet.hasNext()) {
            Row row = reserveDataSet.next();
            for (int i = startRowIndex; i <= endRowIndex; ++i) {
                Long id = (Long)model.getValue("mobid", i);
                if (!id.equals(row.get("id"))) continue;
                BigDecimal avbQty = row.getBigDecimal("avbbqty");
                BigDecimal avbBaseQty = row.getBigDecimal("avbbaseqty");
                BigDecimal avbQty2nd = row.getBigDecimal("avbbtndqty");
                BigDecimal reserveQty = row.getBigDecimal("reserveqty");
                BigDecimal reserveBaseQty = row.getBigDecimal("reservebaseqty");
                BigDecimal reserveQty2nd = row.getBigDecimal("reserveunit2ndqty");
                model.beginInit();
                String avbQtyKey = "avbqty." + i;
                String avbBaseQtyKey = "avbbaseqty." + i;
                String avbQty2ndKey = "avbqty2nd." + i;
                String lockQtyKey = "lockqty." + i;
                String lockBaseQtyKey = "lockbaseqty." + i;
                String lockQty2ndKey = "lockqty2nd." + i;
                fieldKeyToValue.put(avbQtyKey, avbQty);
                fieldKeyToValue.put(avbBaseQtyKey, avbBaseQty);
                fieldKeyToValue.put(avbQty2ndKey, avbQty2nd);
                fieldKeyToValue.put(lockQtyKey, reserveQty);
                fieldKeyToValue.put(lockBaseQtyKey, reserveBaseQty);
                fieldKeyToValue.put(lockQty2ndKey, reserveQty2nd);
            }
        }
        return fieldKeyToValue;
    }

    private void setReserveValue(Map<String, PropertyNode> fieldMapping, Map<String, BigDecimal> fieldKeyToValue) {
        IDataModel model = this.getModel();
        for (Map.Entry<String, BigDecimal> fieldKeyEntry : fieldKeyToValue.entrySet()) {
            String fieldKeyAndIndex = fieldKeyEntry.getKey();
            int dot = fieldKeyAndIndex.indexOf(".");
            String fieldKey = fieldKeyAndIndex.substring(0, dot);
            int rowIndex = Integer.parseInt(fieldKeyAndIndex.substring(dot + 1));
            BigDecimal fieldValue = fieldKeyEntry.getValue();
            for (Map.Entry<String, PropertyNode> entry : fieldMapping.entrySet()) {
                String mobFieldKey = entry.getKey();
                String pcFieldKey = entry.getValue().getFieldKey();
                if (!pcFieldKey.equals(fieldKey) && !pcFieldKey.contains(fieldKey)) continue;
                model.beginInit();
                model.setValue(mobFieldKey, (Object)fieldValue, rowIndex);
                model.endInit();
            }
        }
    }

    private DataSet getReserveDataSet(int startRowIndex, int endRowIndex) {
        IDataModel model = this.getModel();
        ArrayList<Long> invRealBalanceIds = new ArrayList<Long>(10);
        for (int i = startRowIndex; i <= endRowIndex; ++i) {
            long id = (Long)model.getValue("mobid", i);
            invRealBalanceIds.add(id);
        }
        QFilter qFilter = new QFilter("id", "in", invRealBalanceIds);
        return ReserveHelper.getInvaccAvbbaseqty(qFilter.toArray());
    }

    private void setBasicStyleOfEntryLabel(CardEntry cardEntry, Map<String, BasedataEdit> labelToBaseDataEdit, int startRowIndex, int endRowIndex) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryColl = model.getEntryEntity("entryentity");
        for (Map.Entry<String, BasedataEdit> labelAndBaseData : labelToBaseDataEdit.entrySet()) {
            String labelKey = labelAndBaseData.getKey();
            BasedataEdit baseDataEdit = labelAndBaseData.getValue();
            String fieldKey = baseDataEdit.getKey();
            for (int i = startRowIndex; i <= endRowIndex; ++i) {
                DynamicObject entryRow = (DynamicObject)entryColl.get(i);
                DynamicObject dynamicObject = entryRow.getDynamicObject(fieldKey);
                if (dynamicObject == null) {
                    cardEntry.setChildVisible(false, i, new String[]{labelKey});
                    continue;
                }
                cardEntry.setChildVisible(true, i, new String[]{labelKey});
                String name = dynamicObject.getString("name");
                String number = dynamicObject.getString("number");
                Map<String, Object> propMap = this.getPropMap(fieldKey, number, name);
                if (propMap.isEmpty()) continue;
                MobileControlUtils.setCardEntryRowProperty(cardEntry, labelKey, i, propMap);
            }
        }
    }

    private Map<String, Object> getPropMap(String fieldKey, String number, String name) {
        Map<String, Object> propMap = new HashMap<String, Object>();
        switch (fieldKey) {
            case "invstatus": {
                propMap = this.getInvStatusPropMap(number, name);
                break;
            }
            case "invtype": {
                propMap = this.getInvTypePropMap(number, name);
                break;
            }
        }
        return propMap;
    }

    private Map<String, Object> getInvTypePropMap(String number, String name) {
        Map<String, Object> propMap;
        switch (number) {
            case "112": {
                propMap = MobileControlUtils.buildBasicPropOfLabel(name, "#276FF5", "#F2F9FF", "#85B8FF");
                break;
            }
            default: {
                propMap = MobileControlUtils.buildBasicPropOfLabel(name, "#1BA854", "#F2FFF5", "#6DD18E");
            }
        }
        return propMap;
    }

    private Map<String, Object> getInvStatusPropMap(String number, String name) {
        Map<String, Object> propMap;
        switch (number) {
            case "111": 
            case "114": {
                propMap = MobileControlUtils.buildBasicPropOfLabel(name, "#276FF5", "#F2F9FF", "#85B8FF");
                break;
            }
            case "112": 
            case "113": {
                propMap = MobileControlUtils.buildBasicPropOfLabel(name, "#999999", "#FAFAFA", "#D9D9D9");
                break;
            }
            default: {
                propMap = MobileControlUtils.buildBasicPropOfLabel(name, "#1BA854", "#F2FFF5", "#6DD18E");
            }
        }
        return propMap;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Boolean isEditable = (Boolean)formShowParameter.getCustomParam("isEditable");
        Boolean isSubEntry = (Boolean)formShowParameter.getCustomParam("isSubEntry");
        Boolean isEnableOrVisible = isEditable != false && isSubEntry == false;
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        for (int i = 0; i < entries.size(); ++i) {
            cardEntry.setChildVisible(isEnableOrVisible.booleanValue(), i, new String[]{"cardentryflexpanelap11"});
        }
        view.setVisible(isEnableOrVisible, new String[]{"flexpanelap"});
        this.initReserveAndStyle();
    }

    @Override
    public void pagerClick(PagerClickEvent event) {
        super.pagerClick(event);
        IDataModel model = this.getModel();
        int totalRowCount = model.getEntryRowCount("entryentity");
        int pageRows = event.getPageRows();
        int currPageIndex = event.getCurrentPageIndex();
        int startRowIndex = pageRows * (currPageIndex - 1);
        int currRows = pageRows * currPageIndex;
        int endRowIndex = currRows > totalRowCount ? totalRowCount - 1 : currRows - 1;
        this.setReserveInfo(startRowIndex, endRowIndex);
        this.setInvTypeAndStatus(startRowIndex, endRowIndex);
    }

    private void setInvTypeAndStatus(int startRowIndex, int endRowIndex) {
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount("entryentity");
        if (entryRowCount == 0) {
            return;
        }
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        BasedataEdit invStatusEdit = (BasedataEdit)this.getControl("invstatus");
        BasedataEdit invTypeEdit = (BasedataEdit)this.getControl("invtype");
        HashMap<String, BasedataEdit> labelToBaseDataEdit = new HashMap<String, BasedataEdit>(16);
        labelToBaseDataEdit.put("invstatuslabel", invStatusEdit);
        labelToBaseDataEdit.put("invtypelabel", invTypeEdit);
        this.setBasicStyleOfEntryLabel(cardEntry, labelToBaseDataEdit, startRowIndex, endRowIndex);
    }

    @Override
    public void entryRowClick(RowClickEvent e) {
        Boolean isSelected = (Boolean)this.getModel().getValue("selectedbox", e.getRow());
        this.getModel().beginInit();
        this.getModel().setValue("selectedbox", (Object)(isSelected == false ? 1 : 0), e.getRow());
        this.getModel().endInit();
        this.getView().updateView("selectedbox", e.getRow());
    }

    public void beforeClick(BeforeClickEvent e) {
        String ctrlKey;
        super.beforeClick(e);
        Control control = (Control)e.getSource();
        switch (ctrlKey = control.getKey()) {
            case "back": {
                this.beforeClickBack(e);
                break;
            }
        }
    }

    private void beforeClickBack(BeforeClickEvent e) {
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        DynamicObjectCollection entryColl = model.getEntryEntity("entryentity");
        Map<Boolean, List<DynamicObject>> isSelectedToEntryRows = entryColl.stream().collect(Collectors.groupingBy(entryRow -> entryRow.getBoolean("selectedbox")));
        List<DynamicObject> selectedRows = isSelectedToEntryRows.get(Boolean.TRUE);
        pageCache.put("selected_pkids", selectedRows != null ? selectedRows.stream().map(selectedRow -> selectedRow.getLong("mobid")).collect(Collectors.toList()).toString() : null);
    }

    @Override
    public void click(EventObject e) {
        String ctrlKey;
        super.click(e);
        Control control = (Control)e.getSource();
        switch (ctrlKey = control.getKey()) {
            case "back": {
                this.clickBackData();
                break;
            }
            case "filter": {
                this.clickFilter();
                break;
            }
        }
    }

    private void clickFilter() {
        IFormView view = this.getView();
        Boolean customParam = (Boolean)this.getView().getFormShowParameter().getCustomParam(FORM_PARAMETER_FROM_CONDITION);
        if (customParam != null && customParam.booleanValue()) {
            this.getView().close();
            return;
        }
        IPageCache pageCache = this.getPageCache();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String isEditableStr = pageCache.get("isEditable");
        String isSubEntryStr = pageCache.get("isSubEntry");
        String srcFilterFrom = pageCache.get("srcFilterFrom");
        String invQueryItemKey = pageCache.get("invQueryItemKey");
        Boolean isEditable = (Boolean)customParams.get("isEditable");
        Boolean isSubEntry = (Boolean)customParams.get("isSubEntry");
        isEditable = isEditable == null ? Boolean.valueOf(isEditableStr) : isEditable;
        isSubEntry = isSubEntry == null ? Boolean.valueOf(isSubEntryStr) : isSubEntry;
        srcFilterFrom = StringUtils.isEmpty((CharSequence)srcFilterFrom) ? (String)customParams.get("srcFilterFrom") : srcFilterFrom;
        invQueryItemKey = StringUtils.isEmpty((CharSequence)invQueryItemKey) ? (String)customParams.get("invQueryItemKey") : invQueryItemKey;
        customParams.put("isEditable", isEditable);
        customParams.put("srcFilterFrom", srcFilterFrom);
        customParams.put("isSubEntry", isSubEntry);
        customParams.put("invQueryItemKey", invQueryItemKey);
        customParams.put("isFromResultPage", "true");
        customParams.put("pcEntityKey", this.getView().getFormShowParameter().getCustomParam("pcEntityKey"));
        customParams.put("datasource", this.getView().getFormShowParameter().getCustomParam("datasource"));
        PageUtils.showFormPage(view, "msmob_invquerycondition", customParams, new CloseCallBack((IFormPlugin)this, "msmob_invqueryconditionactionid"));
    }

    private void clickBackData() {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        String selectedId = pageCache.get("selected_pkids");
        view.returnDataToParent((Object)selectedId);
        view.close();
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("msmob_invqueryconditionactionid".equals(actionId)) {
            IFormView view = this.getView();
            Map returnData = (Map)e.getReturnData();
            String filterConditionStr = (String)returnData.get("filterCondition");
            this.getView().getFormShowParameter().setCustomParam("filterCondition", (Object)filterConditionStr);
            this.updateData();
            this.initReserveAndStyle();
            this.getView().updateView();
        }
    }

    private int getEndRowIndexOfFirstPage() {
        IDataModel model = this.getModel();
        CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
        int pageRow = cardEntry.getPageRow();
        int entryRowCount = model.getEntryRowCount("entryentity");
        int currEndRowIndex = entryRowCount > pageRow ? pageRow - 1 : entryRowCount - 1;
        return currEndRowIndex;
    }

    @Override
    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        super.click(mobileSearchTextChangeEvent);
        this.initReserveAndStyle();
    }

    @Override
    public void cancel() {
        super.cancel();
        this.initReserveAndStyle();
    }
}

