/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.form.baseset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.msmob.business.helper.ResultPageHelper;
import kd.scmc.msmob.common.enums.EnableStatusEnum;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.common.utils.PropertyValueUtils;

public class ScanResultConfigEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit mobFormF7 = (BasedataEdit)this.getControl("resultpage");
        mobFormF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit skillFamily = (BasedataEdit)this.getControl("skillname");
        skillFamily.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
    }

    public void setEnable() {
        Boolean isSysPreset = (Boolean)this.getView().getModel().getValue("issyspreset");
        if (Boolean.TRUE.equals(isSysPreset)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo"});
        }
        DynamicObjectCollection entryentity = this.getView().getModel().getEntryEntity("entryentity");
        boolean defaultEnabled = entryentity.stream().anyMatch(entry -> Boolean.TRUE.equals(entry.get("defaultenabled")));
        for (int i = 0; i < entryentity.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(!defaultEnabled), i, new String[]{"isenable"});
        }
    }

    private void setDefaultEnable(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        int count = this.getView().getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < count; ++i) {
            if (i == rowIndex) {
                if (!Boolean.TRUE.equals(changeData.getNewValue())) continue;
                this.getModel().beginInit();
                this.getModel().setValue("isenable", changeData.getNewValue(), i);
                this.getModel().endInit();
                continue;
            }
            this.getModel().beginInit();
            this.getModel().setValue("isenable", (Object)false, i);
            this.getModel().setValue("defaultenabled", (Object)false, i);
            this.getModel().endInit();
        }
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (key) {
            case "defaultenabled": {
                this.setEnable();
                this.setDefaultEnable(changeSet[0]);
                break;
            }
            case "skill_family": {
                if (!PropertyValueUtils.isValueChanged(e, 0)) {
                    return;
                }
                this.getView().getModel().deleteEntryData("entryentity");
                this.getView().getModel().createNewEntryRow("entryentity");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        RefObject afterConfirm = new RefObject();
        if ("enable".equals(key)) {
            boolean exists = QueryServiceHelper.exists((String)this.getModel().getDataEntityType().getName(), (Object)this.getModel().getDataEntity().getPkValue());
            if (!exists || this.getModel().getDataChanged()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5355\u636e\u3002", (String)"ScanResultConfigEditPlugin_2", (String)"scmc-msmob-form", (Object[])new Object[0]));
            }
            boolean isEnable = ResultPageHelper.isEnable(this.getModel().getDataEntity());
            if (isEnable && !operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                DynamicObject skillFamily = (DynamicObject)this.getModel().getValue("skill_family");
                Object name = skillFamily.get("name");
                String message = String.format(ResManager.loadKDString((String)"%s\u6280\u80fd\u65cf\u5df2\u5b58\u5728\u7ed3\u679c\u914d\u7f6e\u9875\uff0c\u662f\u5426\u542f\u7528\u65b0\u914d\u7f6e\uff1f", (String)"ScanResultConfigEditPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]), name.toString());
                this.getView().showConfirm(String.valueOf(message), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("enable"));
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("enable".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            DynamicObject[] load;
            Object skillFamilyId = ResultPageHelper.getSkillFamilyId(this.getModel().getDataEntity().getPkValue());
            for (DynamicObject dataEntity : load = ResultPageHelper.getResultConfigs(skillFamilyId)) {
                dataEntity.set("enable", (Object)EnableStatusEnum.DISABLE.getValue());
            }
            SaveServiceHelper.update((DynamicObject[])load);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation("enable", operateOption);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (name) {
            case "resultpage": {
                this.beforeResultPageF7Select(showParameter);
                break;
            }
            case "skillname": {
                this.beforeSkillNameF7Select(beforeF7SelectEvent);
                break;
            }
        }
    }

    private void beforeSkillNameF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        DynamicObject skillFamily = (DynamicObject)this.getModel().getValue("skill_family");
        if (skillFamily == null || skillFamily.getPkValue() == null) {
            String message = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6280\u80fd\u65cf\u201d\u3002", (String)"ScanResultConfigEditPlugin_1", (String)"scmc-msmob-form", (Object[])new Object[0]);
            beforeF7SelectEvent.setCancel(true);
            this.getView().showTipNotification(message);
            return;
        }
        Object pkValue = skillFamily.getPkValue();
        QFilter filter = new QFilter("mulskillfamily.fbasedataid.id", "=", pkValue);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List skillNameIds = entryEntity.stream().filter(entry -> entry.get("skillname.id") != null).map(dynamicObject -> dynamicObject.get("skillname.id")).collect(Collectors.toList());
        skillNameIds.removeAll(Collections.singleton(null));
        if (!skillNameIds.isEmpty()) {
            filter.and(new QFilter("id", "not in", skillNameIds));
        }
        showParameter.getListFilterParameter().setFilter(filter);
    }

    private void beforeResultPageF7Select(ListShowParameter showParameter) {
        ArrayList<String> mobFormNumber = new ArrayList<String>(4);
        mobFormNumber.add("msmob_scan_result_tpl");
        Map<String, String> mobFormMap = MetaUtils.getMobFormF7Range(mobFormNumber);
        QFilter qFilter = new QFilter("number", "in", mobFormMap.keySet());
        showParameter.getListFilterParameter().setFilter(qFilter);
    }
}

