/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.op;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.plugin.op.validator.DataSourceConfigSyncValidator;
import kd.scmc.msmob.pojo.PropertyNode;

public class DataSourceConfigSyncOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("mobform");
        fieldKeys.add("enable");
        fieldKeys.add("status");
        fieldKeys.add("pcentityobject");
        fieldKeys.add("entryentity.mobfieldkey");
        fieldKeys.add("entryentity.mobfieldtype");
        fieldKeys.add("entryentity.mobfieldminlen");
        fieldKeys.add("entryentity.mobfieldmaxlen");
        fieldKeys.add("entryentity.pcfieldkey");
        fieldKeys.add("entryentity.pcfieldtype");
        fieldKeys.add("entryentity.pcfieldminlen");
        fieldKeys.add("entryentity.pcfieldmaxlen");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new DataSourceConfigSyncValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        for (DynamicObject config : dataEntities = e.getDataEntities()) {
            String status = config.getString("status");
            boolean enable = config.getBoolean("enable");
            if (!enable || !"A".equals(status)) continue;
            String pcEntityObjKey = config.getDynamicObject("pcentityobject").getString("number");
            String mobFormKey = config.getDynamicObject("mobform").getString("number");
            Map<String, PropertyNode> pcPropNodeMap = DataSourceConfigHelper.getPcPropNodeMap(pcEntityObjKey);
            MainEntityType mobDataEntityType = MetadataServiceHelper.getDataEntityType((String)mobFormKey);
            Map mobFormAllFields = mobDataEntityType.getAllFields();
            DynamicObjectCollection entryRows = config.getDynamicObjectCollection("entryentity");
            Iterator iterator = entryRows.iterator();
            while (iterator.hasNext()) {
                int maxLenth;
                int minLenth;
                DynamicObject entryRow = (DynamicObject)iterator.next();
                String mobFieldKey = entryRow.getString("mobfieldkey");
                String pcFieldKey = entryRow.getString("pcfieldkey");
                PropertyNode pcPropNode = pcPropNodeMap.get(pcFieldKey);
                IDataEntityProperty mobProp = (IDataEntityProperty)mobFormAllFields.get(mobFieldKey);
                if (mobProp == null || pcPropNode == null) {
                    iterator.remove();
                    continue;
                }
                Object[] paramArr = new Object[7];
                IMetadata pcPropType = pcPropNode.getType();
                String mobFieldType = this.getPropType((IMetadata)mobProp);
                String pcFieldType = this.getPropType(pcPropType);
                paramArr[0] = mobFieldType;
                paramArr[1] = pcFieldType;
                if (mobProp instanceof TextProp) {
                    minLenth = ((TextProp)mobProp).getMinLenth();
                    maxLenth = ((TextProp)mobProp).getMaxLenth();
                    paramArr[2] = minLenth;
                    paramArr[3] = maxLenth;
                } else {
                    paramArr[2] = 0;
                    paramArr[3] = 0;
                }
                if (pcPropType instanceof TextProp) {
                    minLenth = ((TextProp)pcPropType).getMinLenth();
                    maxLenth = ((TextProp)pcPropType).getMaxLenth();
                    paramArr[4] = minLenth;
                    paramArr[5] = maxLenth;
                } else {
                    paramArr[4] = 0;
                    paramArr[5] = 0;
                }
                paramArr[6] = entryRow.getLong("id");
                paramList.add(paramArr);
            }
        }
        String sql = " update t_mob_fieldmaprelation set  fmobfieldtype = ?, fpcfieldtype = ?,  fmobfieldminlen = ?, fmobfieldmaxlen = ?,  fpcfieldminlen = ?, fpcfieldmaxlen = ?  where fentryid = ?";
        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, paramList);
    }

    private String getPropType(IMetadata prop) {
        if (prop == null) {
            return "";
        }
        String treeNodeType = !(prop instanceof MulBasedataProp) && prop instanceof BasedataProp ? ((BasedataProp)prop).getBaseEntityId() : prop.getClass().getSimpleName();
        return treeNodeType == null ? "" : treeNodeType;
    }
}

