/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.op.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.common.utils.MetaUtils;

public class DataSourceConfigSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String mobFormKey;
            DynamicObject entityObj = dataEntity.getDataEntity();
            DynamicObject mobForm = entityObj.getDynamicObject("mobform");
            String string = mobFormKey = mobForm == null ? "" : mobForm.getString("number");
            if (StringUtils.isNotEmpty((CharSequence)mobFormKey) && !MetaUtils.isExistsMeta(mobFormKey)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u9875\u9762\u5143\u6570\u636e\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSourceConfigServiceImpl_notExists", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFormKey);
                this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
                continue;
            }
            DynamicObjectCollection entrys = entityObj.getDynamicObjectCollection("entryentity");
            if (entrys == null || entrys.isEmpty()) {
                String msg = ResManager.loadKDString((String)"\u6570\u636e\u6e90\u914d\u7f6e\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSourceConfigSubmitValidator_1", (String)"scmc-msmob-form", (Object[])new Object[0]) + "\n";
                this.addMessage(dataEntity, msg, ErrorLevel.Error);
                continue;
            }
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject row = (DynamicObject)entrys.get(i);
                this.checkEntryField(dataEntity, row, i);
            }
        }
    }

    private void checkEntryField(ExtendedDataEntity dataEntity, DynamicObject entryRow, int currEntryIndex) {
        boolean checkResult = this.checkFieldType(dataEntity, entryRow, currEntryIndex);
        if (!checkResult) {
            return;
        }
        this.checkTxtFieldLen(dataEntity, entryRow, currEntryIndex);
    }

    private boolean checkFieldType(ExtendedDataEntity dataEntity, DynamicObject entryRow, int entryRowIndex) {
        String mobFieldKey = entryRow.getString("mobfieldkey");
        String pcFieldKey = entryRow.getString("pcfieldkey");
        String mobFieldType = entryRow.getString("mobfieldtype");
        String pcFieldType = entryRow.getString("pcfieldtype");
        if (StringUtils.isEmpty((CharSequence)mobFieldKey) || StringUtils.isEmpty((CharSequence)pcFieldKey) || StringUtils.isEmpty((CharSequence)mobFieldType) || StringUtils.isEmpty((CharSequence)pcFieldType)) {
            return true;
        }
        if (DataSourceConfigHelper.checkTypeExcepted(mobFieldType, pcFieldType)) {
            return true;
        }
        if (!mobFieldType.equals(pcFieldType)) {
            String mobFormKey = dataEntity.getDataEntity().getString("mobform.number");
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u5b57\u6bb5\u201c%1$s\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u5b57\u6bb5\u201c%2$s\u201d\u7684\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u79fb\u52a8\u8868\u5355\u201c%3$s\u201d\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c\u201c%4$s\u201d\u884c\u4fe1\u606f\u6216\u4fee\u6539\u79fb\u52a8\u8868\u5355\u5b57\u6bb5\u201c%5$s\u201d\u7684\u7c7b\u578b\u3002\n", (String)"DataSourceConfigSubmitValidator_2", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFieldKey, pcFieldKey, mobFormKey, entryRowIndex + 1, mobFieldKey);
            this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
            return false;
        }
        return true;
    }

    private void checkTxtFieldLen(ExtendedDataEntity dataEntity, DynamicObject entryRow, int entryRowIndex) {
        int mobFieldMinLen;
        String mobFieldKey = entryRow.getString("mobfieldkey");
        String pcFieldKey = entryRow.getString("pcfieldkey");
        String mobFormKey = dataEntity.getDataEntity().getString("mobform.number");
        if (StringUtils.isEmpty((CharSequence)mobFieldKey) || StringUtils.isEmpty((CharSequence)pcFieldKey)) {
            return;
        }
        String mobFieldType = entryRow.getString("mobfieldtype");
        if (!("TextProp".equals(mobFieldType) || "LargeTextProp".equals(mobFieldType) || "MuliLangTextProp".equals(mobFieldType) || "TextAreaProp".equals(mobFieldType))) {
            return;
        }
        int pcFieldMinLen = entryRow.getInt("pcfieldminlen");
        if (pcFieldMinLen != (mobFieldMinLen = entryRow.getInt("mobfieldminlen"))) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%1$s\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u6587\u672c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u201c\u6700\u5c0f\u957f\u5ea6[%3$s]\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u79fb\u52a8\u8868\u5355\u201c%4$s\u201d\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c\u201c%5$s\u201d\u884c\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%6$s\u201d\u7684\u201c\u6700\u5c0f\u957f\u5ea6\u201d\u3002", (String)"DataSourceConfigSubmitValidator_3", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFieldKey, pcFieldKey, pcFieldMinLen, mobFormKey, entryRowIndex + 1, mobFieldKey);
            this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
            return;
        }
        int pcFieldMaxLen = entryRow.getInt("pcfieldmaxlen");
        int mobFieldMaxLen = entryRow.getInt("mobfieldmaxlen");
        if (mobFieldMaxLen != pcFieldMaxLen) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%1$s\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u6587\u672c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u201c\u6700\u5927\u957f\u5ea6[%3$s]\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u79fb\u52a8\u8868\u5355\u201c%4$s\u201d\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c\u201c%5$s\u201d\u884c\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%6$s\u201d\u7684\u201c\u6700\u5927\u957f\u5ea6\u201d\u3002", (String)"DataSourceConfigSubmitValidator_4", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFieldKey, pcFieldKey, pcFieldMaxLen, mobFormKey, entryRowIndex + 1, mobFieldKey);
            this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
        }
    }
}

