/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.op.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.msmob.common.utils.MetaUtils;

public class DataSourceConfigSyncValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entrys;
            DynamicObject entityObj = dataEntity.getDataEntity();
            DynamicObject mobForm = entityObj.getDynamicObject("mobform");
            if (mobForm == null) continue;
            String mobFormKey = mobForm.getString("number");
            if (StringUtils.isNotEmpty((CharSequence)mobFormKey) && !MetaUtils.isExistsMeta(mobFormKey)) {
                String errMsg = String.format(ResManager.loadKDString((String)"\u9875\u9762\u5143\u6570\u636e\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSourceConfigServiceImpl_notExists", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFormKey);
                this.addMessage(dataEntity, errMsg, ErrorLevel.Error);
                continue;
            }
            String mobFormNumber = entityObj.getDynamicObject("mobform").getString("number");
            if (!MetaUtils.isPersistent(entityObj)) {
                String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u79fb\u52a8\u8868\u5355\u201c%s\u201d\u7684\u6570\u636e\u6e90\u914d\u7f6e\u518d\u8fdb\u884c\u6570\u636e\u540c\u6b65\u64cd\u4f5c\u3002", (String)"DataSourceConfigSyncValidator_0", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFormNumber) + "\n";
                this.addMessage(dataEntity, msg, ErrorLevel.Error);
            }
            if ((entrys = entityObj.getDynamicObjectCollection("entryentity")) != null && !entrys.isEmpty()) continue;
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u6e90\u914d\u7f6e\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u5206\u5f55\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSourceConfigSyncValidator_1", (String)"scmc-msmob-form", (Object[])new Object[0]) + "\n";
            this.addMessage(dataEntity, msg, ErrorLevel.Error);
        }
    }
}

