/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.op.validator;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;

public class SkillSaveValidator
extends AbstractValidator {
    private static final String BASE_DATA_ID = "fbasedataid";
    private static final String SKILL_FAMILY_ID = "skill_family.id";
    private static final String F_BASE_DATA_ID_ID = "fbasedataid.id";
    private static final String ENTRY_ENTITY_SKILL_NAME_ID = "entryentity.skillname.id";

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            Object pkValue = entity.getPkValue();
            QFilter filter = new QFilter("id", "=", pkValue);
            DynamicObject skillDyn = BusinessDataServiceHelper.loadSingle((String)"msmob_skill", (String)"id,mulskillfamily", (QFilter[])filter.toArray());
            if (skillDyn == null) continue;
            DynamicObjectCollection oldDyn = skillDyn.getDynamicObjectCollection("mulskillfamily");
            DynamicObjectCollection newDyn = entity.getDynamicObjectCollection("mulskillfamily");
            List newSkillFamilyIds = newDyn.stream().map(p -> p.get(F_BASE_DATA_ID_ID)).collect(Collectors.toList());
            oldDyn.removeIf(skill -> newSkillFamilyIds.contains(skill.get(F_BASE_DATA_ID_ID)));
            oldDyn.forEach(skillFamily -> {
                if (BaseDataRefrenceHelper.isRefrenced((String)"msmob_skill_family", (Object)skillFamily.get(F_BASE_DATA_ID_ID))) {
                    QFilter qFilter = new QFilter(SKILL_FAMILY_ID, "=", skillFamily.get(F_BASE_DATA_ID_ID));
                    qFilter.and(new QFilter(ENTRY_ENTITY_SKILL_NAME_ID, "=", skillDyn.getPkValue()));
                    if (QueryServiceHelper.exists((String)"msmob_scan_result_cfg", (QFilter[])qFilter.toArray())) {
                        String name = skillFamily.getDynamicObject(BASE_DATA_ID).getString("name");
                        String msg = String.format(ResManager.loadKDString((String)"%s\u6280\u80fd\u65cf\u5b58\u5728\u5f15\u7528\uff0c\u4e0d\u53ef\u53d6\u6d88\u52fe\u9009\u3002", (String)"SkillSaveValidator_0", (String)"scmc-msmob-form", (Object[])new Object[0]), name);
                        this.addMessage(dataEntity, msg, ErrorLevel.Error);
                    }
                }
            });
        }
    }
}

