/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.PropertyNode;
import kd.scmc.msmob.service.mservice.baseset.IDataSourceConfigService;
import kd.scmc.msmob.service.mservice.baseset.impl.DataSourceConfigServiceImpl;
import kd.scmc.msmob.service.mservice.mobdata.IMobDataService;
import kd.scmc.msmob.service.mservice.mobdata.impl.MobDataServiceImpl;

public abstract class AbstractMobDataModelPlugin
extends AbstractMobBillPlugIn
implements IMobilePage {
    private static final Log log = LogFactory.getLog(AbstractMobDataModelPlugin.class);
    private static final String PC_ENTITY_KEY = "pcentitykey";
    protected DynamicObject[] curData;
    private IMobDataService mobDataService;
    private IDataSourceConfigService dataSourceConfigService;
    protected DataSourceConfig dataSourceConfig;

    @Override
    public IFormView getPcEntityStorageView() {
        return this.getView();
    }

    @Override
    public String getDatasourceConfigMobileKey() {
        return this.getPcEntityStorageView().getEntityId();
    }

    public abstract FilterConstructor getFilterConstructor(FilterConstructor var1);

    protected String getFormKey() {
        return this.getView().getEntityId();
    }

    public String getPcEntityKey() {
        IPageCache pageCache = this.getPageCache();
        String pcEntityKey = pageCache.get(PC_ENTITY_KEY);
        return StringUtils.isEmpty((CharSequence)pcEntityKey) ? this.getDataSourceConfig().getPcEntityKey() : pcEntityKey;
    }

    public String getPcAppId() {
        IPageCache pageCache = this.getPageCache();
        String appid = pageCache.get("pcAppid");
        if (StringUtils.isEmpty((CharSequence)appid)) {
            String pcEntityKey = this.getPcEntityKey();
            appid = MetaUtils.getPcAppId(pcEntityKey);
            pageCache.put("pcAppid", appid);
        }
        return appid;
    }

    public void afterCreateNewData(EventObject e) {
        IFormView pcEntityStorageView = this.getPcEntityStorageView();
        IPageCache pageCache = pcEntityStorageView.getPageCache();
        String cachedString = pageCache.get(PC_ENTITY_KEY);
        if (StringUtils.isEmpty((CharSequence)cachedString)) {
            this.curData = this.readData();
            if (this.curData != null && this.curData.length == 1) {
                DynamicObject pcData = this.curData[0];
                DataSourceConfig dataSourceConfig = this.getDataSourceConfig();
                String pcEntityKey = dataSourceConfig.getPcEntityKey();
                pageCache.put(PC_ENTITY_KEY, pcEntityKey);
                EntityCacheHelper.savePcEntityToPageCache(pcEntityStorageView, pcData);
            }
        } else {
            DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache(this);
            this.curData = new DynamicObject[]{pcEntityFromCache};
            if (pcEntityFromCache == null) {
                this.curData = this.readData();
            }
        }
    }

    public abstract void updateData();

    protected DataSourceConfig getDataSourceConfig() {
        if (this.dataSourceConfig == null) {
            log.info("\u4eceDB\u91cc\u9762\u83b7\u53d6DataSourceConfig");
            IDataSourceConfigService dataSourceConfigService = this.getDataSourceConfigService();
            this.dataSourceConfig = dataSourceConfigService.getDataSourceConfig(this.getFormKey());
        }
        return this.dataSourceConfig;
    }

    public Map<String, PropertyNode> getFieldMapping() {
        DataSourceConfig dataSourceConfig = this.getDataSourceConfig();
        Map<String, PropertyNode> fieldMapping = dataSourceConfig.getFieldMapping();
        return fieldMapping;
    }

    protected List<String> getSearchKey() {
        DataSourceConfig dataSourceConfig = this.getDataSourceConfig();
        List<String> searchFieldKeys = dataSourceConfig.getSearchFieldKeys();
        return searchFieldKeys;
    }

    protected Map<String, List<String>> getMobEntryKeyToFiledKeys() {
        DataSourceConfig dataSourceConfig = this.getDataSourceConfig();
        Map<String, List<String>> mobEntryKeyToFiledKeys = dataSourceConfig.getMobEntryKeyToFieldKeys();
        return mobEntryKeyToFiledKeys;
    }

    public DynamicObject[] readData() {
        IMobDataService mobDataService = this.getMobDataService();
        DynamicObject[] data = mobDataService.loadData(this.getFormKey(), this.getFilterConstructor(new FilterConstructor()), this.dataSourceConfig);
        if (data != null && data.length == 1) {
            DynamicObject singleData = data[0];
            data[0] = BusinessDataServiceHelper.loadSingle((Object)singleData.getPkValue(), (String)singleData.getDataEntityType().getName());
        }
        return data;
    }

    protected IMobDataService getMobDataService() {
        if (this.mobDataService == null) {
            this.mobDataService = new MobDataServiceImpl();
        }
        return this.mobDataService;
    }

    protected IDataSourceConfigService getDataSourceConfigService() {
        if (this.dataSourceConfigService == null) {
            this.dataSourceConfigService = new DataSourceConfigServiceImpl();
        }
        return this.dataSourceConfigService;
    }
}

