/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.property.FlexProp;
import kd.bos.flex.FlexService;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.FlexEdit;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.mvc.SessionManager;
import kd.scmc.msmob.business.helper.BotpHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.EntryMappingIndex;
import kd.scmc.msmob.business.helper.change.VisitingContext;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;
import kd.scmc.msmob.common.utils.LabelAndToolUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.FormPluginHelper;
import kd.scmc.msmob.plugin.tpl.basetpl.IEntryFieldKeys;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.EntryMappingRelationship;
import org.apache.commons.lang3.StringUtils;

public abstract class EntryEditTplPlugin
extends AbstractMobFormPlugin
implements IEntryFieldKeys {
    protected IPropertyChangedHandler propertyChangedHandler;
    private String[] button = new String[]{"addnewap", "closeap", "godownuo", "goupop"};

    @Override
    public String getDatasourceConfigMobileKey() {
        return this.getPcEntityStorageView().getEntityId();
    }

    @Override
    public VisitingContext getVisitingContext() {
        VisitingContext visitingContext = new VisitingContext();
        visitingContext.addEntryMappingIndex(new EntryMappingIndex(this.getPcEntryName(), this.getView()));
        return visitingContext;
    }

    protected String getPcEntryName() {
        DataSourceConfig dataSourceConfig = DataSourceHelper.getDataSourceConfig(this);
        List<EntryMappingRelationship> entryMappingRelationships = dataSourceConfig.getEntryMappingRelationships();
        if (entryMappingRelationships == null || entryMappingRelationships.isEmpty() || entryMappingRelationships.size() > 1) {
            String pcEntryName = DataSourceHelper.getEntryProperty(dataSourceConfig);
            if (StringUtils.isEmpty((CharSequence)pcEntryName)) {
                return "billentry";
            }
            return pcEntryName;
        }
        return entryMappingRelationships.get(0).getPcEntryKey();
    }

    public final void registerPropertyChangedHandler(IPropertyChangedHandler propertyChangedHandler) {
        IPropertyChangedHandler orientHandler = this.propertyChangedHandler;
        this.propertyChangedHandler = context -> {
            if (orientHandler != null) {
                orientHandler.onPropertyChanged(context);
            }
            propertyChangedHandler.onPropertyChanged(context);
        };
    }

    @Override
    public IFormView getPcEntityStorageView() {
        return this.getParentView();
    }

    @Override
    public abstract String getEntryEntity();

    @Override
    public abstract List<String> getFieldKeys();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.button);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IPageCache pageCache = this.getPageCache();
        IFormView view = this.getView();
        String row = pageCache.get("row");
        if (row == null) {
            int entryEntityIndex = this.getView().getParentView().getModel().getEntryCurrentRowIndex(this.getEntryEntity());
            row = String.valueOf(entryEntityIndex);
            pageCache.put("row", row);
        }
        DataSourceConfig dataSourceConfig = DataChangedHandlerHelper.setEntryPageFieldsFromCache(this, Long.valueOf(row).intValue());
        this.getModel().setValue("pcentitykey", (Object)dataSourceConfig.getPcEntityKey());
        LabelAndToolUtils.selBasedataEditLabelValue(view, "unit", "unitlabel");
        LabelAndToolUtils.selBasedataEditLabelValue(view, "unit2nd", "unit2ndlabel");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        this.goPreviousOrGoNext(key);
    }

    protected void goPreviousOrGoNext(String key) {
        int newRowIndex = FormPluginHelper.goPreviousOrGoNext(this, key);
        if (newRowIndex >= 0) {
            DataChangedHandlerHelper.setEntryPageFieldsFromCache(this, newRowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        int row = Integer.parseInt(this.getPageCache().get("row"));
        DataChangedHandlerHelper.onEntryPagePropertyChanged(this, this.propertyChangedHandler, e, row);
    }

    @Deprecated
    public void setParentValue(String parentFieldKey, Object value) {
        int row = Integer.parseInt(this.getPageCache().get("row"));
        IFormView parentView = this.getParentView();
        this.getParentModel().beginInit();
        String[] parentFieldKeyArr = parentFieldKey.split("_");
        if ("$$auxpty".equals(parentFieldKeyArr[0])) {
            FlexEdit flexEdit = (FlexEdit)this.getControl("auxpty");
            IDataModel fModel = flexEdit.getFlexModel();
            MainEntityType flexFieldEntityType = fModel.getDataEntityType();
            DynamicObject flexFieldVal = fModel.getDataEntity();
            FlexEntireData flexEntireData = new FlexEntireData();
            flexEntireData.setFlexData(flexFieldEntityType, flexFieldVal);
            long id = FlexService.saveFlexData((MainEntityType)flexFieldEntityType, (FlexEntireData)flexEntireData);
            flexFieldEntityType.getPrimaryKey().setValue((Object)flexFieldVal, (Object)id);
            DynamicObject flexObject = (DynamicObject)((FlexProp)flexEdit.getProperty()).getComplexType().createInstance();
            flexObject.set("id", (Object)id);
            Map values = flexEntireData.getFlexValue();
            flexObject.set("value", (Object)SerializationUtils.toJsonString((Object)values));
            this.getParentModel().setValue("auxpty", (Object)flexFieldVal, row);
        } else {
            this.getParentModel().setValue(parentFieldKey, value, row);
        }
        this.getParentModel().endInit();
        parentView.updateView();
    }

    public IDataModel getParentModel() {
        return this.getParentView().getModel();
    }

    public IFormView getParentView() {
        return this.getView().getParentView();
    }

    @Deprecated
    protected final IPageCache getParentPageCache() {
        IFormView view = this.getView();
        String parentPageId = view.getParentView().getPageId();
        SessionManager sessionManager = new SessionManager();
        return sessionManager.getPageCache(parentPageId);
    }

    public String getPcEntityKey() {
        return (String)this.getModel().getValue("pcentitykey");
    }

    public Long getBillId() {
        return (Long)this.getModel().getValue("billid");
    }

    @Deprecated
    public DynamicObject getBill() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Boolean isSave = (Boolean)customParams.get("isSave");
        String pcEntityKey = this.getPcEntityKey();
        Long billId = this.getBillId();
        String convertResult = this.getConvertResult();
        DynamicObject bill = StringUtils.isNotEmpty((CharSequence)convertResult) && isSave != null && isSave == false ? BotpHelper.getPushBill(convertResult, false) : EntityCacheHelper.getPcEntityFromCache(this);
        return bill;
    }

    private String getConvertResult() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (String)formShowParameter.getCustomParam("convertResult");
    }

    public void initialize() {
        super.initialize();
        EntityCacheHelper.clearThreadHolder();
    }

    public void destory() {
        super.destory();
        EntityCacheHelper.onPluginDestroyed(this);
    }
}

