/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillEditabilityPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillInfoTplPlugin;
import kd.sdk.mpscmm.msmob.expoint.IMobOperationDataTransferPlugin;

public class MobBillEditTplPlugin
extends MobBillEditabilityPlugin {
    public MobBillEditTplPlugin(MobBillInfoTplPlugin plugin) {
        super(plugin);
        plugin.getOperations().add("save");
        plugin.getOperations().add("submit");
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    public void afterRemove(UploadEvent evt) {
        IPageCache pageCache = this.getView().getPageCache();
        String pcId = pageCache.get("pcId");
        Object[] urls = evt.getUrls();
        if (urls[0] instanceof Map) {
            String uid = ((Map)urls[0]).get("uid").toString();
            AttachmentServiceHelper.remove((String)this.getPcEntityKey(), (Object)pcId, (Object)uid);
        }
    }

    public void beforeBindData(EventObject e) {
        if (this.plugin.curData == null || this.plugin.curData.length == 0) {
            return;
        }
        DynamicObject billObject = this.plugin.curData[0];
        EntityCacheHelper.savePcEntityToPageCache(this.plugin.getView(), billObject);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        final FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (this.plugin.getOperations().contains(operateKey)) {
            DataChangedHandlerHelper.purgeUnchangedEntries(this.plugin, this.plugin.getEntryRowDeletedHandler());
            final MobBillEditTplPlugin mobilePage = this;
            PluginProxy pluginProxy = PluginProxy.create((Object)new IMobOperationDataTransferPlugin(){

                public void beforeDoOperation(AbstractMobBillPlugIn plugIn, BeforeDoOperationEventArgs args) {
                    DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache(mobilePage);
                    String pcEntityCacheStr = EntityCacheHelper.serializeFromEntityToString(pcEntityFromCache);
                    OperateOption option = formOperate.getOption();
                    option.setVariableValue("pcEntityCache", pcEntityCacheStr);
                }
            }, IMobOperationDataTransferPlugin.class, (String)IMobOperationDataTransferPlugin.class.getName(), null);
            pluginProxy.callReplaceIfPresent(p -> {
                p.beforeDoOperation((AbstractMobBillPlugIn)this, args);
                return null;
            });
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "newentry": {
                String mobEntryKey = this.plugin.getEntryEntity();
                DataChangedHandlerHelper.afterEntryAddedOperation(this.plugin, this.plugin.getEntryRowAddedHandler(), mobEntryKey, args);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "editop": {
                this.openEntryEditPage();
                break;
            }
            case "deleteop": 
            case "deleteopvector": 
            case "deleteopflex": {
                this.delEntryRowCfm();
                break;
            }
            case "buttonclose": {
                if (this.hasCfmMsgBeforeClose()) break;
                this.getView().close();
                break;
            }
            case "scanbtn": {
                this.scanClick("scanbtn");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String opItemKey;
        super.itemClick(evt);
        switch (opItemKey = evt.getItemKey()) {
            case "scan": {
                this.scanClick("scan");
                break;
            }
        }
    }

    private void scanClick(String scanBtn) {
        IPageCache pageCache = this.getView().getPageCache();
        pageCache.put("scan_cache_key", scanBtn);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object codeStr = result.get("qrcode_str");
            String scanKey = this.getPageCache().get("scan_cache_key");
            if ("scanbtn".equals(scanKey) || "scan".equals(scanKey)) {
                this.plugin.handleQrCode(codeStr);
            }
        }
    }

    private void openEntryEditPage() {
        String entryFormKey = this.getEntryFormKey();
        if (StringUtils.isNotEmpty((CharSequence)entryFormKey)) {
            MobileFormShowParameter formShowParameter = this.plugin.createShowParameter(entryFormKey, true);
            formShowParameter.setClientParam("requestBeforeClose", (Object)true);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this.plugin, "callback");
            formShowParameter.setCloseCallBack(callBack);
            formShowParameter.setClientParam("requestBeforeClose", (Object)true);
            this.plugin.goUrl(formShowParameter, false);
        }
    }

    @Override
    public String getEntryEntity() {
        return this.plugin.getEntryEntity();
    }

    private void delEntryRowCfm() {
        String entryKey;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int entryRowCount = model.getEntryRowCount(entryKey = this.getEntryEntity());
        if (entryRowCount == 1) {
            String errMsg = ResManager.loadKDString((String)"\u9700\u81f3\u5c11\u4fdd\u7559\u4e00\u6761\u7269\u6599\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"MobBillEditTplPlugin_delFirstEntryRow", (String)"scmc-msmob-form", (Object[])new Object[0]);
            view.showTipNotification(errMsg);
            return;
        }
        int deleteRowIndex = model.getEntryCurrentRowIndex(entryKey);
        String delEntryRowCfmMsg = this.getDelEntryRowCfmMsg(entryKey, deleteRowIndex);
        view.showConfirm(delEntryRowCfmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteEntryRowCfirmCB"));
    }

    public String getDelEntryRowCfmMsg(String entryKey, int deleteRowIndex) {
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        DynamicObject material = (DynamicObject)model.getValue("material", deleteRowIndex);
        if (material != null) {
            String materialName = "";
            DynamicProperty property = material.getDynamicObjectType().getProperty("masterid");
            materialName = property instanceof BasedataProp ? material.getString("masterid.name") : material.getString("name");
            return String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u201c%s\u201d\u7269\u6599\u660e\u7ec6\u884c\uff1f", (String)"MobBillEditTplPlugin_1", (String)"scmc-msmob-form", (Object[])new Object[0]), materialName);
        }
        return this.getDelEntryRowCfmMsg(deleteRowIndex);
    }

    private String getDelEntryRowCfmMsg(int deleteRowIndex) {
        return String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\uff1f", (String)"MobBillEditTplPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]), deleteRowIndex + 1);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("deleteEntryRowCfirmCB".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.delEntryRowCfmCallBack();
        } else if ("beforeCloseConfirmCallBack".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.getView().close();
        }
    }

    private void delEntryRowCfmCallBack() {
        IDataModel model = this.getModel();
        String mobileEntryKey = this.getEntryEntity();
        int deleteRow = model.getEntryCurrentRowIndex(mobileEntryKey);
        DataChangedHandlerHelper.deleteEntry(this.plugin, this.plugin.getEntryRowDeletedHandler(), mobileEntryKey, deleteRow);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DataChangedHandlerHelper.onPropertyChanged(this.plugin, this.plugin.getPropertyChangedHandler(), e);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        DataChangedHandlerHelper.refreshPageOnEntryEditPageClosed(this.plugin);
    }

    private boolean hasCfmMsgBeforeClose() {
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        String changedFieldStr = pageCache.get("allChangedFields");
        if (StringUtils.isNotEmpty((CharSequence)changedFieldStr)) {
            List changedFieldList = JSON.parseArray((String)changedFieldStr, String.class);
            String changedFields = StringUtils.join((Object[])changedFieldList.toArray(), (String)",");
            String cfmMsg = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002\n\u53d8\u52a8\u5b57\u6bb5\uff1a%s", (String)"MobBillEditTplPlugin_2", (String)"scmc-msmob-form", (Object[])new Object[0]), changedFields);
            view.showConfirm(cfmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("beforeCloseConfirmCallBack"));
            return true;
        }
        return false;
    }

    @Override
    public FilterConstructor getFilterConstructor(FilterConstructor evt) {
        return null;
    }

    @Override
    public void updateData() {
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        String myLock = this.getPageCache().get("myLock");
        if ("true".equals(myLock)) {
            String billId = this.getPageCache().get("pcId");
            MutexHelper.release((String)this.getPcEntityKey(), (String)"modify", (String)billId);
        }
    }
}

