/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowDeletedHandler;
import kd.scmc.msmob.business.helper.change.handler.IPropertyChangedHandler;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.common.utils.CallAppMethodUtils;
import kd.scmc.msmob.common.utils.LabelAndToolUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.AbstractMobBillInfoPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.IMobBillEditable;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillEditTplPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillEditabilityPlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillViewTplPlugin;
import kd.scmc.msmob.pojo.FilterCondition;
import org.apache.commons.lang3.StringUtils;

public abstract class MobBillInfoTplPlugin
extends AbstractMobBillInfoPlugin {
    private static final Log LOG = LogFactory.getLog(MobBillInfoTplPlugin.class);
    private static final String MAIN_ORG = "mainOrg";
    private static final String BILLID = "billid";
    protected MobBillEditabilityPlugin editabilityPlugin;
    private String[] buttons = new String[]{"buttonunsubmit"};
    protected Set<String> operations = new HashSet<String>();
    private List<IPropertyChangedHandler> propertyChangedHandlers = new ArrayList<IPropertyChangedHandler>();
    private List<IEntryRowAddedHandler> entryRowAddedHandlers = new ArrayList<IEntryRowAddedHandler>();
    private List<IEntryRowDeletedHandler> entryRowDeletedHandlers = new ArrayList<IEntryRowDeletedHandler>();

    public Set<String> getOperations() {
        return this.operations;
    }

    public void setOperations(String opKey, boolean needExecute) {
        if (needExecute) {
            this.operations.add(opKey);
        } else {
            this.operations.remove(opKey);
        }
    }

    public MobBillInfoTplPlugin() {
        this.editabilityPlugin = this instanceof IMobBillEditable ? new MobBillEditTplPlugin(this) : new MobBillViewTplPlugin(this);
    }

    public boolean isEditable() {
        return this.editabilityPlugin.isEditable();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.buttons);
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.getEntryEntity());
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBillInfo();
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        this.editabilityPlugin.customEvent(e);
        JSONObject jsonObject = JSON.parseObject((String)e.getEventArgs());
        if ("shareCallBack".equals(jsonObject.get((Object)"callBackId"))) {
            String content = ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s", (String)"MobBillInfoTplPlugin_6", (String)"scmc-msmob-form", (Object[])new Object[]{this.getView().getModel().getValue("billNo")});
            CallAppMethodUtils.shareToApp(this, this.getWebPageUrl(), content);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && ("save".equals(key) || "submit".equals(key))) {
            DynamicObject pcEntity = BusinessDataServiceHelper.loadSingle((Object)this.getBillId(), (String)this.getPcEntityKey());
            EntityCacheHelper.savePcEntityToPageCache(this.getView(), pcEntity);
        }
    }

    public boolean isAddModificationMutex() {
        String billStatus = this.curData[0].getString("billstatus");
        boolean result = false;
        if (!this.isNew() && BillStatusEnum.SAVE.getValue().equals(billStatus) && this.isEditable() && !this.isFromList()) {
            result = true;
        }
        return result;
    }

    private boolean isNew() {
        if (this.getBillId() != null) {
            return !QueryServiceHelper.exists((String)this.getPcEntityKey(), (Object)this.getBillId());
        }
        return true;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.editabilityPlugin.beforeBindData(e);
    }

    @Override
    public void updateData() {
    }

    @Deprecated
    public String getEditFormId() {
        String errMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6682\u65e0\u7f16\u8f91\u9875\u9762\u201c%s\u201d\u3002", (String)"MobBillEditTplPlugin_NotSupportEditPage", (String)"scmc-msmob-form", (Object[])new Object[0]), this.getFormKey());
        LOG.warn("\u5f53\u524d\u5355\u636e\u6682\u65e0\u7f16\u8f91\u9875\u9762\u201c%s\u201d", (Object)this.getFormKey());
        throw new KDBizException(errMsg);
    }

    public void initBillInfo() {
        if (this.curData.length == 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u60a8\u65e0\u5f53\u524d\u5355\u636e\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"MobBillInfoTplPlugin_2", (String)"scmc-msmob-form", (Object[])new Object[0]), new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNoCancel, new ConfirmCallBackListener("unSee", (IFormPlugin)this));
            return;
        }
        if (this.curData.length == 1) {
            IDataModel model = this.getModel();
            DynamicObject bill = this.curData[0];
            this.cacheBillBaseInfo(model, bill);
            String mutex = (String)this.getView().getFormShowParameter().getCustomParam("mutex");
            if (mutex != null && !"".equals(mutex)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"mtoolbarap"});
            }
            this.cacheBillBaseInfo(model, this.curData[0]);
            this.setModelValue();
            this.setBillStatus();
            PermissionHelper.setViewByPermissions(this, this.curData[0].getPkValue());
        }
    }

    public boolean isFromList() {
        Object isFromList = this.getView().getFormShowParameter().getCustomParam("isFromList");
        if (isFromList instanceof Boolean) {
            return (Boolean)isFromList;
        }
        return false;
    }

    public boolean isCheckModifyPerm() {
        return !this.isNew() && this.isEditable();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "unSee": {
                if (messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Cancel) != 0) break;
                this.getView().close();
                break;
            }
            case "mutex": 
            case "modify": {
                if (messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
                    this.goViewPage(callBackId);
                    return;
                }
                if (messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Cancel) != 0) break;
                this.getView().close();
                break;
            }
        }
    }

    @Override
    public String getWebPageUrl() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object mainOrg = showParameter.getCustomParam(MAIN_ORG);
        return String.format("%s/%s?form=%s&billid=%s&mainOrg=%s", UrlService.getDomainContextUrl(), "mobile.html", this.getView().getEntityId(), this.getBillId(), mainOrg);
    }

    public Long getMainOrg() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object mainOrg = showParameter.getCustomParam(MAIN_ORG);
        if (mainOrg != null) {
            return Long.valueOf(mainOrg.toString());
        }
        return 0L;
    }

    private String getViewFormKey() {
        String viewFormKey;
        try {
            viewFormKey = this.getViewFormId();
        }
        catch (KDBizException e) {
            viewFormKey = this.getBillViewFormKey();
        }
        return viewFormKey;
    }

    public void goViewPage(String callBackId) {
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        formShowParameter.setFormId(this.getViewFormKey());
        formShowParameter.setCustomParam("mutex", (Object)callBackId);
        formShowParameter.setCustomParam(BILLID, (Object)this.getBillId().toString());
        formShowParameter.setCustomParam(MAIN_ORG, (Object)this.getMainOrg());
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, "callback");
        formShowParameter.setCloseCallBack(callBack);
        formShowParameter.setClientParam("requestBeforeClose", (Object)true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)formShowParameter);
        this.getView().close();
    }

    public void cacheBillBaseInfo(IDataModel model, DynamicObject bill) {
        String billId = bill.getPkValue().toString();
        model.setValue(BILLID, (Object)Long.valueOf(billId));
        this.getPageCache().put("pcId", billId);
        String pcEntityKey = bill.getDynamicObjectType().getName();
        this.getModel().setValue("pcentitykey", (Object)pcEntityKey);
    }

    @Override
    public Long getBillId() {
        IDataModel model = this.getModel();
        Object billId = model.getValue(BILLID);
        if (billId == null || billId.equals(0L)) {
            IFormView view = this.getView();
            FormShowParameter formShowParameter = view.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            billId = customParams.get(BILLID);
        }
        return billId == null ? 0L : Long.parseLong(billId.toString());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBillStatus();
        String pcId = this.getView().getPageCache().get("pcId");
        List attachments = AttachmentServiceHelper.getAttachments((String)this.getAttachmentEntityKey(), (Object)pcId, (String)"attachmentpanel", (boolean)true);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        List attachmentData = attachmentPanel.getAttachmentData();
        attachments.addAll(attachmentData);
        if (attachmentPanel != null) {
            attachmentPanel.bindData(attachments);
        }
    }

    protected String getAttachmentEntityKey() {
        return this.getPcEntityKey();
    }

    public void entryRowClick(RowClickEvent e) {
        super.entryRowClick(e);
        this.editabilityPlugin.entryRowClick(e);
    }

    public void setModelValue() {
        if (this.curData != null && this.curData.length != 0) {
            DynamicObject pcBillData = this.curData[0];
            DataSourceHelper.loadPcEntityToMobilePage(this, pcBillData, true);
        }
    }

    @Override
    public FilterConstructor getFilterConstructor(FilterConstructor evt) {
        MobileFormShowParameter param;
        Object billIdObject;
        if (evt == null) {
            evt = new FilterConstructor();
        }
        if ((billIdObject = (param = (MobileFormShowParameter)this.getView().getFormShowParameter()).getCustomParam(BILLID)) != null) {
            Long billId = Long.valueOf(billIdObject.toString());
            FilterCondition condition = new FilterCondition("id", "=", billId);
            evt.setFilters(Collections.singletonList(condition));
        }
        return evt;
    }

    public void setBillStatus() {
        String billStatus = (String)this.getModel().getValue("billStatus");
        if (billStatus != null) {
            LabelAndToolUtils.setLabelAndToolVisible(this.getView(), billStatus);
        }
    }

    @Override
    public String getFormKey() {
        return this.getView().getEntityId();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.checkLockInfo();
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        String mobEntryKey = this.getEntryEntity();
        String pcEntryKey = this.getPageCache().get(mobEntryKey);
        if (StringUtils.isNotEmpty((CharSequence)pcEntryKey)) {
            option.setVariableValue(mobEntryKey, pcEntryKey);
        }
    }

    public void checkLockInfo() {
        DataMutex dataMutex = DataMutex.create();
        Map lockInfo = dataMutex.getLockInfo(String.valueOf(this.getBillId()), MutexHelper.getMutexGroupId((String)this.getPcEntityKey(), (String)"modify"), this.getPcEntityKey());
        if (lockInfo == null) {
            return;
        }
        String userid = (String)lockInfo.get("userid");
        long currUserId = RequestContext.get().getCurrUserId();
        if (!String.valueOf(currUserId).equals(userid)) {
            String msg = ResManager.loadKDString((String)"\u60a8\u5df2\u88ab\u5f3a\u5236\u8e22\u51fa\u5355\u636e\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u8fdb\u5165\u5355\u636e\u3002", (String)"MobBillInfoTplPlugin_7", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    @Deprecated
    public String getViewFormId() {
        String errMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6682\u65e0\u67e5\u770b\u9875\u9762\u201c%s\u201d\u3002", (String)"MobBillEditTplPlugin_NotSupportViewPage", (String)"scmc-msmob-form", (Object[])new Object[0]), this.getFormKey());
        LOG.warn("\u5f53\u524d\u5355\u636e\u6682\u65e0\u67e5\u770b\u9875\u9762\u201c%s\u201d\u3002", (Object)this.getFormKey());
        throw new KDBizException(errMsg);
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        this.editabilityPlugin.pageRelease(e);
    }

    public DynamicObject convertToPcEntity() {
        return EntityCacheHelper.getPcEntityFromCache(this);
    }

    public DynamicObject getPcEntityById(String pcId) {
        if (pcId == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)pcId, (String)this.getPcEntityKey());
    }

    public final IPropertyChangedHandler getPropertyChangedHandler() {
        return context -> this.propertyChangedHandlers.forEach(iPropertyChangedHandler -> iPropertyChangedHandler.onPropertyChanged(context));
    }

    public final IEntryRowAddedHandler getEntryRowAddedHandler() {
        return context -> this.entryRowAddedHandlers.forEach(handler -> handler.onEntryRowAdded(context));
    }

    public final IEntryRowDeletedHandler getEntryRowDeletedHandler() {
        return context -> this.entryRowDeletedHandlers.forEach(handler -> handler.onEntryRowDeleted(context));
    }

    public final void registerPropertyChangedHandler(IPropertyChangedHandler propertyChangedHandler) {
        this.propertyChangedHandlers.add(propertyChangedHandler);
    }

    public final void registerEntryRowAddedHandler(IEntryRowAddedHandler entryRowAddedHandler) {
        this.entryRowAddedHandlers.add(entryRowAddedHandler);
    }

    public final void registerEntryRowDeletedHandler(IEntryRowDeletedHandler entryRowDeletedHandler) {
        this.entryRowDeletedHandlers.add(entryRowDeletedHandler);
    }
}

