/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.MobileSearchCancelListener;
import kd.bos.form.control.events.MobileSearchFocusListener;
import kd.bos.form.control.events.MobileSearchTextChangeEvent;
import kd.bos.form.control.events.MobileSearchTextChangeListener;
import kd.bos.form.control.events.PullRefreshEvent;
import kd.bos.form.control.events.PullRefreshListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PagerClickEvent;
import kd.bos.form.events.PagerClickListener;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.bos.list.MobileSearch;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scmc.msmob.business.helper.BarcodeParseHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.common.consts.DateRange;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.common.consts.SearchConstructor;
import kd.scmc.msmob.common.enums.BillSortType;
import kd.scmc.msmob.common.enums.BillStatusEnum;
import kd.scmc.msmob.common.utils.CallAppMethodUtils;
import kd.scmc.msmob.common.utils.CommonUtils;
import kd.scmc.msmob.common.utils.DateUtils;
import kd.scmc.msmob.common.utils.LabelAndToolUtils;
import kd.scmc.msmob.common.utils.PropertyValueUtils;
import kd.scmc.msmob.mvccore.JsonUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.AbstractMobFormPagePlugin;
import kd.scmc.msmob.plugin.tpl.basetpl.listtpl.MobileSearchApListTplListener;
import kd.scmc.msmob.pojo.FilterCondition;
import kd.scmc.msmob.pojo.PropertyNode;
import kd.scmc.msmob.pojo.QrCodeResult;
import kd.scmc.msmob.service.mservice.mobdata.IMobDataService;
import kd.scmc.msmob.service.mservice.mobdata.PageRequest;
import kd.scmc.msmob.service.mservice.mobdata.PageResult;
import kd.sdk.mpscmm.msmob.expoint.IMobListFilterPlugin;

public abstract class MobBillListTplPlugin
extends AbstractMobFormPagePlugin
implements MobileSearchTextChangeListener,
MobileSearchCancelListener,
RowClickEventListener,
PullRefreshListener,
PagerClickListener {
    private static final Log LOG = LogFactory.getLog(MobBillListTplPlugin.class);
    protected boolean loadByPage = true;
    private static final String SCMC_MSMOB = "scmc-msmob";
    protected static final String MOB_ID = "mobid";
    private static final String SEARCH_TEXT_CACHE_KEY = "SEARCH_TEXT";
    private static final String MOBILE_SEARCH = "mobilesearchap";
    private static final String SCAN = "scan";
    private static final String MUTEX = "mutex";
    private static final String BILLID = "billid";
    private String[] labelContainers = new String[]{"billnocardentryflexpanelap1", "cardentryflexpanelap1_2", "cardentryflexpanelap1_21"};
    protected int totalDataCount;
    private static final ThreadLocal<PageResult> pageResultThreadHolder = new ThreadLocal();
    private static final String SUMMARY_FIELDS_KEY = "SUMMARY_FIELDS_KEY";

    @Override
    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object billFormId = showParameter.getCustomParam("billFormId");
        Object appId = showParameter.getCustomParam("appId");
        if (showParameter instanceof MobileListShowParameter) {
            if (billFormId != null) {
                ((MobileListShowParameter)showParameter).setBillFormId(billFormId.toString());
            }
            if (appId != null) {
                showParameter.setAppId(appId.toString());
            }
        }
        String isFromTrackDown = (String)this.getView().getFormShowParameter().getCustomParam("isFromTrackDown");
        this.getPageCache().put("isFromTrackDown", isFromTrackDown);
        String tabKey = (String)this.getView().getFormShowParameter().getCustomParam("tabKey");
        this.getPageCache().put("tabKey", tabKey);
        String pcEntityParamKey = (String)this.getView().getFormShowParameter().getCustomParam("pcEntityNumber");
        this.getPageCache().put("pcEntityNumber", pcEntityParamKey);
        List<Long> idList = this.getSpecifiedBillIdList();
        if (idList != null && !idList.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap_scan", "filterflexap"});
        } else {
            this.setDefaultDate();
        }
        this.setInitFilterInfo();
        super.afterCreateNewData(e);
        this.setModelValue();
    }

    public Boolean isFromTrackDown() {
        String isFromTrackDown = this.getPageCache().get("isFromTrackDown");
        return "true".equals(isFromTrackDown);
    }

    private List<Long> getSpecifiedBillIdList() {
        String json = (String)this.getView().getFormShowParameter().getCustomParam("specifiedBillId");
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)json) ? null : JsonUtils.deserializeList(json, Long.class);
    }

    protected void displayFlexPanelGetMore(int pageIndex) {
        int totalDataCount;
        if (this.loadByPage) {
            return;
        }
        int pageSize = this.getPageSize();
        boolean isLastPage = (pageIndex + 1) * pageSize >= (totalDataCount = this.getView().getModel().getEntryEntity(this.getEntryEntity()).size());
        this.getView().setVisible(Boolean.valueOf(isLastPage), new String[]{"flexpanelap_getmore"});
    }

    private void setInitFilterInfo() {
        Map<String, Object> filterInfo = this.getInitFilterInfo();
        String pcEntityKey = this.getDataSourceConfig().getPcEntityKey();
        String mobListFormKey = this.getDataSourceConfig().getMobFormKey();
        this.expandInitFilterInfo(filterInfo, pcEntityKey, mobListFormKey);
        if (filterInfo != null && !filterInfo.isEmpty()) {
            for (Map.Entry<String, Object> filterEntry : filterInfo.entrySet()) {
                String filterKey = filterEntry.getKey();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)filterKey)) continue;
                Object filterValue = filterEntry.getValue();
                this.getModel().setValue(filterKey, filterValue);
            }
        }
    }

    private void expandInitFilterInfo(Map<String, Object> filterInfo, String pcEntityKey, String mobListFormKey) {
        PluginProxy pluginProxy = PluginProxy.create(IMobListFilterPlugin.class, (String)"SCMC_MSMOB_MOB_LIST_EXPAND_FITER");
        pluginProxy.callReplace(p -> {
            p.expandInitListFilterInfo(this.getView(), filterInfo, pcEntityKey, mobListFormKey);
            return null;
        });
    }

    public void setDefaultDate() {
        Date thisWeekStartDate = DateUtils.getThisWeekStartDate();
        Date thisWeekEndDate = DateUtils.getThisWeekEndDate();
        this.getModel().setValue("daterangefield_startdate", (Object)thisWeekStartDate);
        this.getModel().setValue("daterangefield_enddate", (Object)thisWeekEndDate);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.curData != null) {
            LabelAndToolUtils.cardEntryHideLabels(this, this.curData.length, this.getEntryEntity(), this.getLabelContainers());
        }
        String dateMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f", (String)"MobBillListTplPlugin_datetime", (String)"scmc-msmob-form", (Object[])new Object[0]);
        this.setFilterKeyPrompt("daterangefield", dateMsg);
        String comboMsg = ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001", (String)"MobBillListTplPlugin_combo", (String)"scmc-msmob-form", (Object[])new Object[0]);
        this.setFilterKeyPrompt("combofield", comboMsg);
        String mulBaseDataMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u7c7b\u578b", (String)"MobBillListTplPlugin_mulBaseData", (String)"scmc-msmob-form", (Object[])new Object[0]);
        this.setFilterKeyPrompt("mulbasedatafield", mulBaseDataMsg);
    }

    public String[] getLabelContainers() {
        return this.labelContainers;
    }

    public void setFilterKeyPrompt(String filterKey, String prompt) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        HashMap mapItem = new HashMap(4);
        HashMap<String, String> mapTip = new HashMap<String, String>(4);
        mapTip.put("zh_CN", prompt);
        mapItem.put("emptytip", mapTip);
        map.put("id", filterKey);
        map.put("item", mapItem);
        this.getView().updateControlMetadata(filterKey, map);
    }

    public List<FilterCondition> getFilters() {
        List<Long> idList;
        DynamicObjectCollection value;
        FilterCondition condition;
        String billStatus;
        ArrayList<FilterCondition> filters = new ArrayList<FilterCondition>(10);
        String billStatusValue = (String)this.getModel().getValue("combofield");
        if (billStatusValue != null && !"".equals(billStatusValue) && !"".equals(billStatus = billStatusValue.replace(",", "").replace(" ", ""))) {
            String[] split = billStatusValue.split(",");
            FilterCondition condition2 = new FilterCondition("billstatus", split);
            filters.add(condition2);
        }
        Date bizBeginTimeValue = (Date)this.getModel().getValue("daterangefield_startdate");
        Date bizEndTimeValue = (Date)this.getModel().getValue("daterangefield_enddate");
        Date date = bizEndTimeValue = bizEndTimeValue == null ? null : DateUtils.getDayEndTime(bizEndTimeValue);
        if (bizBeginTimeValue != null && bizEndTimeValue != null) {
            DateRange dateRange = new DateRange();
            dateRange.setStartDate(bizBeginTimeValue);
            dateRange.setEndDate(bizEndTimeValue);
            condition = new FilterCondition("biztime", dateRange);
            filters.add(condition);
        }
        if ((value = (DynamicObjectCollection)this.getModel().getValue("mulbasedatafield")) != null && !value.isEmpty()) {
            condition = new FilterCondition("biztype", value);
            filters.add(condition);
        }
        if ((idList = this.getSpecifiedBillIdList()) != null && !idList.isEmpty()) {
            FilterCondition condition3 = new FilterCondition("id", "in", idList);
            filters.add(condition3);
        }
        return filters;
    }

    public String getEntryEntity() {
        return "entryentity";
    }

    @Override
    public String getFormKey() {
        return this.getView().getEntityId();
    }

    public String getSearchText() {
        return this.getPageCache().get(SEARCH_TEXT_CACHE_KEY);
    }

    public SearchConstructor getSearchConstructor() {
        SearchConstructor searchConstructor = new SearchConstructor();
        List<String> searchKey = this.getSearchKey();
        if (searchKey != null && !searchKey.isEmpty()) {
            searchConstructor.setFields(searchKey);
            searchConstructor.setSearchText(this.getSearchText());
        }
        return searchConstructor;
    }

    @Override
    public void updateData() {
        this.curData = this.readData();
        this.setModelValue();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MobileSearch mobileSearchAp = (MobileSearch)this.getControl(MOBILE_SEARCH);
        mobileSearchAp.addMobileSearchTextChangeListener((MobileSearchTextChangeListener)this);
        mobileSearchAp.addMobileSearchCancelListener((MobileSearchCancelListener)this);
        mobileSearchAp.addMobileSearchFocusListener((MobileSearchFocusListener)new MobileSearchApListTplListener(this));
        mobileSearchAp.addMobileSearchCancelListener((MobileSearchCancelListener)new MobileSearchApListTplListener(this));
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.getEntryEntity());
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addPagerClickListener((PagerClickListener)this);
        CardEntry card = (CardEntry)this.getView().getControl(this.getEntryEntity());
        card.addPullRefreshlisteners((PullRefreshListener)this);
        this.addClickListeners(new String[]{"scanbtn"});
    }

    public void pullRefesh(PullRefreshEvent evt) {
        this.updateData();
    }

    public void click(MobileSearchTextChangeEvent mobileSearchTextChangeEvent) {
        MobileSearch mobileSearchAp = (MobileSearch)this.getControl(MOBILE_SEARCH);
        String text = mobileSearchAp.getText();
        this.getPageCache().put(SEARCH_TEXT_CACHE_KEY, text);
        this.updateData();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("scanbtn".equals(key)) {
            this.scanBtnClick(key);
        }
    }

    protected void scanBtnClick(String key) {
        this.getPageCache().put(SCAN, key);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        String value = e.getEventArgs();
        String key = e.getKey();
        JSONObject jsonObject = JSON.parseObject((String)e.getEventArgs());
        if ("shareCallBack".equals(jsonObject.get((Object)"callBackId"))) {
            String listContent = ResManager.loadKDString((String)"\u5355\u636e\u5217\u8868", (String)"YZJAppUtils_4", (String)"scmc-msmob-form", (Object[])new Object[0]);
            CallAppMethodUtils.shareToApp(this, this.getWebPageUrl(), listContent);
        }
        if ("callAppMethod".equals(key) && "scanQRCode".equals(eventName)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            Object codeStr = result.get("qrcode_str");
            String scanKey = this.getPageCache().get(SCAN);
            if ("scanbtn".equals(scanKey)) {
                this.handleQrCode((String)codeStr);
            }
        }
    }

    public void handleQrCode(String code) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)code)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u626b\u63cf\u7ed3\u679c\u4e3a\u7a7a", (String)"MobBillListTplPlugin_scan", (String)"scmc-msmob-form", (Object[])new Object[0]));
            return;
        }
        QrCodeResult qrCodeResult = BarcodeParseHelper.qrCodeParse(code);
        String billNo = "bill".equals(qrCodeResult.getCodeType()) ? (String)qrCodeResult.getAttribute("billno") : (String)qrCodeResult.getAttribute("number");
        if (StringUtils.isBlank((CharSequence)billNo)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6b63\u786e\u7684\u5355\u636e\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AppHomeCommonMorePlugin_2", (String)"scmc-msmob-form", (Object[])new Object[0]));
            return;
        }
        MobileSearch mobileSearchAp = (MobileSearch)this.getControl(MOBILE_SEARCH);
        mobileSearchAp.setText(billNo);
        LocaleString text = new LocaleString(billNo);
        mobileSearchAp.setEmptyText(text);
        this.getPageCache().put(SEARCH_TEXT_CACHE_KEY, billNo);
        this.updateData();
    }

    public void entryRowClick(RowClickEvent e) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Control source = (Control)e.getSource();
        String entryKey = source.getKey();
        if (entryKey.equals(this.getEntryEntity())) {
            int rowIndex = e.getRow();
            String pcEntityKey = this.getPcEntityKey();
            Long billId = (Long)model.getValue(MOB_ID, rowIndex);
            String billNo = (String)model.getValue("billno", rowIndex);
            String status = (String)model.getValue("billstatus", rowIndex);
            IPageCache pageCache = this.getView().getPageCache();
            pageCache.put("billno", billNo);
            pageCache.put(BILLID, billId == null ? "0" : billId.toString());
            String mainBizOrgKey = this.getMainBizOrgKey();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mainBizOrgKey)) {
                String errMsg = ResManager.loadKDString((String)"\u201c\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u6807\u8bc6\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MobBillListTplPlugin_mainBizOrgKeyErr", (String)"scmc-msmob-form", (Object[])new Object[0]);
                view.showErrorNotification(errMsg);
                return;
            }
            QFilter qFilter = new QFilter("id", "=", (Object)billId);
            DynamicObject billEntity = QueryServiceHelper.queryOne((String)pcEntityKey, (String)("billstatus," + mainBizOrgKey), (QFilter[])qFilter.toArray());
            if (billEntity == null) {
                String errMsg = this.getDeletedErrMsg(billNo);
                view.showErrorNotification(errMsg);
                this.updateData();
                return;
            }
            if (!status.equals(billEntity.getString("billstatus"))) {
                String errMsg = this.getChangedErrMsg(billNo);
                view.showErrorNotification(errMsg);
                this.updateData();
                return;
            }
            long orgId = billEntity.getLong(mainBizOrgKey);
            MobileFormShowParameter showParameter = new MobileFormShowParameter();
            MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
            Object orgIdAppHome = param.getCustomParam("orgid");
            showParameter.setCustomParam(BILLID, (Object)billId);
            showParameter.setCustomParam("billno", (Object)billNo);
            showParameter.setCustomParam("orgid", orgIdAppHome);
            showParameter.setCustomParam("mainOrg", (Object)orgId);
            showParameter.setCustomParam("isFromList", (Object)Boolean.TRUE);
            String billStatus = billEntity.getString("billstatus");
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            boolean checkModifyPerm = this.isCheckModifyPerm();
            showParameter.setCustomParam("checkModifyPerm", (Object)checkModifyPerm);
            if (!PermissionHelper.checkMutexAndModify(this, billStatus, billId, orgId)) {
                return;
            }
            if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
                this.setEditPageShowParameter(showParameter);
                String formKey = showParameter.getFormId();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formKey)) {
                    showParameter.setFormId(this.getBillEditFormKey());
                }
            } else {
                this.setViewPageShowParameter(showParameter);
                String formKey = showParameter.getFormId();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formKey)) {
                    showParameter.setFormId(this.getBillViewFormKey());
                }
            }
            showParameter.setClientParam("requestBeforeClose", (Object)true);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public String getDeletedErrMsg(String billNo) {
        if (billNo == null) {
            return String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (String)"MobBillListTplPlugin_3", (String)"scmc-msmob-form", (Object[])new Object[0]), new Object[0]);
        }
        return String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u5355\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (String)"MobBillListTplPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]), billNo);
    }

    public String getChangedErrMsg(String billNo) {
        String errMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u7ecf\u53d1\u751f\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (String)"MobBillListTplPlugin_errStatus", (String)"scmc-msmob-form", (Object[])new Object[0]), billNo);
        return errMsg;
    }

    public boolean isAddModificationMutex(String billStatus) {
        return BillStatusEnum.SAVE.getValue().equals(billStatus);
    }

    public boolean isCheckModifyPerm(String billStatus) {
        return this.isCheckModifyPerm() && BillStatusEnum.SAVE.getValue().equals(billStatus);
    }

    protected boolean isCheckModifyPerm() {
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String formKey;
        MobileFormShowParameter showParameter;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgId = param.getCustomParam("orgid");
        IPageCache pageCache = this.getView().getPageCache();
        String billno = pageCache.get("billno");
        String billIdStr = pageCache.get(BILLID);
        Long billId = Long.valueOf(billIdStr);
        if (MUTEX.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            showParameter = new MobileFormShowParameter();
            showParameter.setCustomParam(MUTEX, (Object)MUTEX);
            showParameter.setCustomParam("billno", (Object)billno);
            showParameter.setCustomParam(BILLID, (Object)billId);
            showParameter.setCustomParam("orgid", orgId);
            showParameter.getOpenStyle().setShowType(ShowType.Floating);
            this.setViewPageShowParameter(showParameter);
            formKey = showParameter.getFormId();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formKey)) {
                showParameter.setFormId(this.getBillViewFormKey());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)showParameter.getFormId())) {
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
        if ("modify".equals(callBackId)) {
            MutexHelper.release((String)this.getPcEntityKey(), (String)"modify", (String)billIdStr);
            if (messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
                MutexHelper.release((String)this.getPcEntityKey(), (String)"modify", (String)billIdStr);
                showParameter = new MobileFormShowParameter();
                showParameter.setCustomParam("billno", (Object)billno);
                showParameter.setCustomParam(BILLID, (Object)billId);
                showParameter.setCustomParam(MUTEX, (Object)MUTEX);
                showParameter.setCustomParam("orgid", orgId);
                showParameter.getOpenStyle().setShowType(ShowType.Floating);
                this.setViewPageShowParameter(showParameter);
                formKey = showParameter.getFormId();
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)formKey)) {
                    showParameter.setFormId(this.getBillViewFormKey());
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)showParameter.getFormId())) {
                    this.getView().showForm((FormShowParameter)showParameter);
                }
            }
        }
    }

    public void setViewPageShowParameter(MobileFormShowParameter showParameter) {
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openViewPageCbId"));
    }

    public void setEditPageShowParameter(MobileFormShowParameter showParameter) {
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openEditPageCbId"));
    }

    @Override
    public FilterConstructor getFilterConstructor(FilterConstructor evt) {
        if (evt == null) {
            evt = new FilterConstructor();
        }
        evt.setFilters(this.getFilters());
        evt.setSearch(this.getSearchConstructor());
        Map<String, BillSortType> sortMap = this.getSortMap();
        evt.setSort(sortMap);
        return evt;
    }

    protected Map<String, BillSortType> getSortMap() {
        return new LinkedHashMap<String, BillSortType>(16);
    }

    public void setModelValue() {
        IDataModel model = this.getModel();
        String mobileEntryKey = this.getEntryEntity();
        if (this.curData != null && this.curData.length != 0) {
            model.deleteEntryData(mobileEntryKey);
            model.batchCreateNewEntryRow(mobileEntryKey, this.totalDataCount);
            DynamicObjectCollection mobileEntry = model.getDataEntity(true).getDynamicObjectCollection(mobileEntryKey);
            for (int i = 0; i < this.curData.length; ++i) {
                DynamicObject mobileEntryRow = (DynamicObject)mobileEntry.get(i);
                for (Map.Entry<String, PropertyNode> key : this.getFieldMapping().entrySet()) {
                    mobileEntryRow.set(key.getKey(), this.curData[i].get(key.getValue().getFieldKey()));
                }
                mobileEntryRow.set(MOB_ID, this.curData[i].get("id"));
            }
        } else {
            model.deleteEntryData(mobileEntryKey);
        }
        this.displayFlexPanelGetMore(0);
        this.getView().updateView();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        if (!PropertyValueUtils.isValueChanged(e, 0)) {
            return;
        }
        IDataModel model = this.getModel();
        switch (propName = e.getProperty().getName()) {
            case "combofield": 
            case "mulbasedatafield": 
            case "daterangefield_startdate": 
            case "daterangefield_enddate": {
                model.beginInit();
                this.updateData();
                model.endInit();
                break;
            }
        }
    }

    public void summaryFields(String ... mobFieldKeys) {
        boolean isOnPageChanged;
        if (mobFieldKeys == null || mobFieldKeys.length == 0) {
            String keys = this.getPageCache().get(SUMMARY_FIELDS_KEY);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)keys)) {
                return;
            }
            mobFieldKeys = keys.split(",");
            isOnPageChanged = true;
        } else {
            this.getPageCache().put(SUMMARY_FIELDS_KEY, Arrays.stream(mobFieldKeys).collect(Collectors.joining(",")));
            isOnPageChanged = false;
        }
        if (CommonUtils.isNull(this.curData) && CommonUtils.isNull(pageResultThreadHolder.get())) {
            return;
        }
        for (String mobFieldKey : mobFieldKeys) {
            PropertyNode property = this.getFieldMapping().get(mobFieldKey);
            String pcEntryKey = this.getPcEntryKey(property);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pcEntryKey)) continue;
            String entryPropKey = property.getFieldKey();
            String setValueKey = org.apache.commons.lang3.StringUtils.substringAfter((String)entryPropKey, (String)(pcEntryKey + "."));
            IMetadata fieldType = property.getType();
            if (fieldType instanceof TextProp) {
                this.summaryTxtField(pcEntryKey, setValueKey, mobFieldKey, (TextProp)fieldType);
                continue;
            }
            if (!(fieldType instanceof DecimalProp)) continue;
            this.sumNumericField(pcEntryKey, setValueKey, mobFieldKey);
        }
        if (!isOnPageChanged) {
            this.getView().updateView(this.getEntryEntity());
        }
    }

    private void summaryTxtField(String pcEntryKey, String pcFieldKey, String mobFieldKey, TextProp fieldType) {
        int startIndex;
        DynamicObject[] data;
        PageResult pageResult = pageResultThreadHolder.get();
        if (pageResult != null) {
            data = pageResult.getData();
            startIndex = pageResult.getPageRequest().getPageIndex() * pageResult.getPageRequest().getPageSize();
        } else {
            data = this.curData;
            startIndex = 0;
        }
        IDataModel model = this.getModel();
        int maxFieldLen = fieldType.getMaxLenth();
        for (int i = 0; i < data.length; ++i) {
            DynamicObject bill = data[i];
            DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(pcEntryKey);
            LinkedHashSet<String> entryPropSet = new LinkedHashSet<String>(16);
            for (DynamicObject entryRow : entryColl) {
                Object fieldValue = entryRow.get(pcFieldKey);
                if (fieldValue == null) continue;
                entryPropSet.add(fieldValue.toString());
            }
            String entryPropTip = org.apache.commons.lang3.StringUtils.strip((String)((Object)entryPropSet).toString(), (String)"[]");
            String totalTips = String.format(ResManager.loadKDString((String)"\u5171%1$s\u79cd\uff1a%2$s", (String)"MobBillListTplPlugin_Tips", (String)"scmc-msmob-form", (Object[])new Object[0]), entryPropSet.size(), entryPropTip);
            int totalTipsLen = totalTips.length();
            int totalTipsMaxLen = totalTipsLen > maxFieldLen ? maxFieldLen : totalTipsLen;
            String totalMaxLenTips = totalTips.substring(0, totalTipsMaxLen);
            model.setValue(mobFieldKey, (Object)totalMaxLenTips, startIndex + i);
        }
    }

    private void sumNumericField(String pcEntryKey, String pcFieldKey, String mobFieldKey) {
        int startIndex;
        DynamicObject[] data;
        PageResult pageResult = pageResultThreadHolder.get();
        if (pageResult != null) {
            data = pageResult.getData();
            startIndex = pageResult.getPageRequest().getPageIndex() * pageResult.getPageRequest().getPageSize();
        } else {
            data = this.curData;
            startIndex = 0;
        }
        IDataModel model = this.getModel();
        for (int i = 0; i < data.length; ++i) {
            BigDecimal sumResult = BigDecimal.ZERO;
            DynamicObject bill = data[i];
            DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(pcEntryKey);
            for (DynamicObject entryRow : entryColl) {
                BigDecimal fieldValue = entryRow.getBigDecimal(pcFieldKey);
                if (fieldValue == null || BigDecimal.ZERO.compareTo(fieldValue) == 0) continue;
                sumResult = sumResult.add(fieldValue);
            }
            model.setValue(mobFieldKey, (Object)sumResult, startIndex + i);
        }
    }

    private String getPcEntryKey(PropertyNode property) {
        if (property == null) {
            return "";
        }
        Map.Entry<String, EntityType> entityTypeInfo = this.getEntityTypeInfo(property);
        EntityType entityType = entityTypeInfo.getValue();
        if (entityType instanceof MainEntityType || entityType instanceof SubEntryType) {
            return "";
        }
        String entryKey = entityTypeInfo.getKey();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entryKey)) {
            return "";
        }
        return entryKey;
    }

    public Map.Entry<String, EntityType> getEntityTypeInfo(PropertyNode propNode) {
        HashMap<String, Object> entityTypeMap = new HashMap<String, Object>(16);
        while (propNode != null) {
            IMetadata fieldType = propNode.getType();
            if (fieldType instanceof MainEntityType) {
                entityTypeMap.put(propNode.getFieldKey(), (MainEntityType)fieldType);
                break;
            }
            if (fieldType instanceof SubEntryType) {
                entityTypeMap.put(propNode.getFieldKey(), (SubEntryType)fieldType);
                break;
            }
            if (fieldType instanceof EntryType) {
                entityTypeMap.put(propNode.getFieldKey(), (EntryType)fieldType);
                break;
            }
            propNode = propNode.getParentNode();
        }
        return entityTypeMap.entrySet().iterator().next();
    }

    public void updateTrackDownPageTitle() {
        if (!this.isFromTrackDown().booleanValue()) {
            return;
        }
        String tabKey = this.getPageCache().get("tabKey");
        String pcEntityParamKey = this.getPageCache().get("pcEntityNumber");
        if (tabKey == null || pcEntityParamKey == null) {
            return;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pcEntityParamKey);
        int entryRowCount = this.getModel().getEntryRowCount("entryentity");
        String tabTitle = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09", (String)"BotpHelper_trackDown_label", (String)"scmc-msmob-form", (Object[])new Object[0]), mainType.getDisplayName().toString(), entryRowCount);
        HashMap<String, LocaleString> paramMap = new HashMap<String, LocaleString>(1);
        paramMap.put("text", new LocaleString(tabTitle));
        this.getView().getParentView().updateControlMetadata(tabKey, paramMap);
        this.getView().sendFormAction(this.getView().getParentView());
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "openViewPageCbId": {
                this.updateData();
                this.getView().updateView(this.getEntryEntity());
                this.updateTrackDownPageTitle();
                break;
            }
            case "openEditPageCbId": {
                this.updateData();
                this.getView().updateView(this.getEntryEntity());
                this.updateTrackDownPageTitle();
                String pcId = this.getPageCache().get(BILLID);
                if (pcId == null || "0".equals(pcId)) break;
                MutexHelper.release((String)this.getPcEntityKey(), (String)"modify", (String)pcId);
                break;
            }
        }
    }

    public void cancel() {
        this.updateData();
    }

    protected Map<String, Object> getInitFilterInfo() {
        return new HashMap<String, Object>(16);
    }

    protected String getMainBizOrgKey() {
        return "org";
    }

    @Override
    public String getWebPageUrl() {
        String billFormId;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String urlPart = String.format("%s/%s?form=%s", UrlService.getDomainContextUrl(), "mobile.html", this.getView().getEntityId());
        StringBuilder url = new StringBuilder(urlPart);
        Object org = showParameter.getCustomParam("org");
        Object orgid = showParameter.getCustomParam("orgid");
        Object orgBillNo = showParameter.getCustomParam("orgBillNo");
        String appId = showParameter.getAppId();
        if (orgid != null) {
            url.append("&orgid=").append(orgid);
        }
        if (org != null) {
            url.append("&org=").append(org);
        }
        if (orgBillNo != null) {
            url.append("&orgBillNo=").append(orgBillNo);
        }
        if (appId != null) {
            url.append("&appId=").append((Object)appId);
        }
        if (showParameter instanceof MobileListShowParameter && (billFormId = ((MobileListShowParameter)showParameter).getBillFormId()) != null) {
            url.append("&billFormId=").append(billFormId.toString());
        }
        return url.toString();
    }

    @Override
    public DynamicObject[] readData() {
        IMobDataService mobDataService = this.getMobDataService();
        FilterConstructor filterConstructor = this.getFilterConstructor(new FilterConstructor());
        this.expandListFilter(filterConstructor);
        if (this.loadByPage) {
            PageResult data = mobDataService.loadDataPage(this.getFormKey(), filterConstructor, this.dataSourceConfig, new PageRequest(0, this.getPageSize()));
            this.totalDataCount = data.getCount();
            return data.getData();
        }
        DynamicObject[] dynamicObjects = mobDataService.loadData(this.getFormKey(), filterConstructor, this.dataSourceConfig);
        this.totalDataCount = dynamicObjects.length;
        return dynamicObjects;
    }

    public void expandListFilter(FilterConstructor filterConstructor) {
        String mobFormKey = this.getDataSourceConfig().getMobFormKey();
        String pcEntityKey = this.getDataSourceConfig().getPcEntityKey();
        PluginProxy pluginProxy = PluginProxy.create(IMobListFilterPlugin.class, (String)"SCMC_MSMOB_MOB_LIST_EXPAND_FITER");
        List qFilters = pluginProxy.callReplace(p -> p.getExpandListFilter(this.getView(), pcEntityKey, mobFormKey));
        qFilters.forEach(qFilter -> filterConstructor.getFilters().add(new FilterCondition((QFilter)qFilter)));
    }

    protected int getPageSize() {
        CardEntry cardEntry = (CardEntry)this.getView().getControl(this.getEntryEntity());
        return cardEntry.getPageRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pagerClick(PagerClickEvent event) {
        if (!this.loadByPage) {
            return;
        }
        int currentPageIndex = event.getCurrentPageIndex() - 1;
        int pageSize = this.getPageSize();
        this.displayFlexPanelGetMore(currentPageIndex);
        String mobileEntryKey = this.getEntryEntity();
        IMobDataService mobDataService = this.getMobDataService();
        PageResult data = mobDataService.loadDataPage(this.getFormKey(), this.getFilterConstructor(new FilterConstructor()), this.dataSourceConfig, new PageRequest(currentPageIndex, pageSize));
        int totalDataCount = data.getCount();
        if (currentPageIndex * pageSize >= totalDataCount) {
            return;
        }
        DynamicObject[] newPageDatas = data.getData();
        IDataModel model = this.getModel();
        DynamicObjectCollection mobileEntry = model.getDataEntity(true).getDynamicObjectCollection(mobileEntryKey);
        int startIndex = currentPageIndex * pageSize;
        for (int i = 0; i < newPageDatas.length; ++i) {
            DynamicObject newPageData = newPageDatas[i];
            int index = startIndex + i;
            if (index > mobileEntry.size() - 1) {
                return;
            }
            DynamicObject mobileEntryRow = (DynamicObject)mobileEntry.get(index);
            for (Map.Entry<String, PropertyNode> key : this.getFieldMapping().entrySet()) {
                mobileEntryRow.set(key.getKey(), newPageData.get(key.getValue().getFieldKey()));
            }
            mobileEntryRow.set(MOB_ID, newPageData.get("id"));
        }
        if (totalDataCount < mobileEntry.size()) {
            int[] indexToDelete = new int[mobileEntry.size() - totalDataCount];
            for (int i = 0; i < indexToDelete.length; ++i) {
                indexToDelete[i] = totalDataCount + i;
            }
            this.getModel().deleteEntryRows(mobileEntryKey, indexToDelete);
        }
        try {
            pageResultThreadHolder.set(data);
            this.summaryFields(new String[0]);
        }
        finally {
            pageResultThreadHolder.remove();
        }
    }
}

