/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Tab;
import kd.bos.form.container.TabPage;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.MenuItem;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.business.helper.AttachedFileHelper;
import kd.scmc.msmob.business.helper.AttachmentHelper;
import kd.scmc.msmob.business.helper.BotpHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.common.utils.MobileControlUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillInfoTplPlugin;
import kd.scmc.msmob.pojo.PropertyNode;

public abstract class MobBizBillInfoTplPlugin
extends MobBillInfoTplPlugin {
    private static final Log LOG = LogFactory.getLog(MobBizBillInfoTplPlugin.class);
    private String[] buttons = new String[]{"buttonsave", "buttonsubmit", "buttonaudit", "buttonunsubmit", "buttonunaudit", "buttondelete", "buttonclose", "editop", "deleteop", "deleteopvector", "deleteopflex", "scanbtn", "trackdownbtn"};
    public static final String CLOSE_CUR_PAGE_AFTER_CLOSE_SUB_PAGE = "closeCurPage";

    public MobBizBillInfoTplPlugin() {
        this.registerEntryRowDeletedHandler(context -> this.setMainEntryTitle());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.buttons);
        this.addItemClickListeners(new String[]{"op_more", "more_btn", "scan"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    @Override
    public void initBillInfo() {
        super.initBillInfo();
        this.setMainEntryTitle();
    }

    public void afterRemove(UploadEvent evt) {
        this.editabilityPlugin.afterRemove(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String opItemKey = evt.getItemKey();
        Control control = (Control)evt.getSource();
        String ctrlKey = control.getKey();
        switch (opItemKey) {
            case "scmcinvquery": {
                this.clickMobInvQueryOp(ctrlKey, opItemKey, "material");
                break;
            }
            case "trackDown": {
                this.trackDown();
                break;
            }
        }
        this.editabilityPlugin.itemClick(evt);
    }

    protected void trackDown() {
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache(this);
        BotpHelper.trackDown(pcEntityFromCache, this.getView());
    }

    protected void clickMobInvQueryOp(String operationKey, String opItemKey, String materialKey) {
        String errMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6682\u4e0d\u652f\u6301\u5e93\u5b58\u67e5\u8be2\u64cd\u4f5c\uff0c\u8bf7\u7ee7\u627f\u5e76\u91cd\u5199MobBizBillInfoTplPlugin.clickMobInvQueryOp\u65b9\u6cd5\u3002", (String)"MobBizBillInfoTplPlugin_clickMobInvQueryOp", (String)"scmc-msmob-form", (Object[])new Object[0]), new Object[0]);
        throw new KDBizException(errMsg);
    }

    protected String matchEntryKey(String ctrlKey) {
        if (StringUtils.isEmpty((CharSequence)ctrlKey)) {
            return "";
        }
        List<String> allMobEntryKeys = this.getAllMobEntryKeys();
        for (String entryKey : allMobEntryKeys) {
            CardEntry cardEntry = (CardEntry)this.getControl(entryKey);
            List controls = cardEntry.getControls();
            for (Control control : controls) {
                String controlKey = control.getKey();
                if (!ctrlKey.equals(controlKey)) continue;
                return cardEntry.getKey();
            }
        }
        return "";
    }

    protected List<String> getAllMobEntryKeys() {
        Map allEntities = this.getModel().getDataEntityType().getAllEntities();
        List<String> entryKeys = allEntities.entrySet().stream().map(mapEntry -> !(mapEntry.getValue() instanceof SubEntryType) && mapEntry.getValue() instanceof EntryType ? (String)mapEntry.getKey() : "").filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        return entryKeys;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("trackdownbtn".equals(key)) {
            this.trackDown();
        }
        this.editabilityPlugin.click(evt);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        this.editabilityPlugin.confirmCallBack(messageBoxClosedEvent);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CLOSE_CUR_PAGE_AFTER_CLOSE_SUB_PAGE.equals(actionId)) {
            this.getView().close();
            return;
        }
        this.editabilityPlugin.closedCallBack(closedCallBackEvent);
        String entryKey = this.getEntryEntity();
        this.getView().updateView(entryKey);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.editabilityPlugin.propertyChanged(e);
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (AttachmentHelper.checkAttachmentSaveOrNot(this.getView())) {
            evt.setCancel(true);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (!AttachedFileHelper.checkAttacheFile(this, this.getBillId().toString()) || AttachmentHelper.checkAttachmentSaveOrNot(this.getView())) {
            args.setCancel(true);
        }
        this.editabilityPlugin.beforeDoOperation(args);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        this.editabilityPlugin.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        switch (operateKey = args.getOperateKey()) {
            case "save": {
                this.afterSaveOp(operationResult);
                break;
            }
            case "submit": {
                this.afterSubmitOp(operationResult);
                break;
            }
            case "delete": {
                this.afterDeleteOp(operationResult);
                break;
            }
            case "newentry": {
                this.setMainEntryTitle();
                break;
            }
            case "audit": {
                this.afterAuditOp(operationResult);
                break;
            }
            case "unsubmit": {
                this.afterUnSubmitOp(operationResult);
                break;
            }
            case "unaudit": {
                this.afterUnAuditOp(operationResult);
                break;
            }
        }
    }

    private void afterSaveOp(OperationResult operationResult) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        if (operationResult.isSuccess()) {
            IPageCache pageCache = this.getPageCache();
            String pcId = pageCache.get("pcId");
            AttachedFileHelper.saveAttacheFile(attachmentPanel, this.getPcEntityKey(), pcId);
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            cache.remove("TampAttCache" + this.getView().getPageId());
            List attachments = AttachmentServiceHelper.getAttachments((String)this.getPcEntityKey(), (Object)pcId, (String)"attachmentpanel", (boolean)true);
            if (attachmentPanel != null) {
                attachmentPanel.bindData(attachments);
            }
            this.getView().updateView();
        }
    }

    private void afterSubmitOp(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            IPageCache pageCache = this.getPageCache();
            String pcId = pageCache.get("pcId");
            this.afterSubmit(pcId);
            MutexHelper.release((String)this.getPcEntityKey(), (String)"modify", (String)pcId);
        } else {
            this.queryAndRefreshMainFields("billno");
        }
    }

    private void afterDeleteOp(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            IFormView view = this.getView();
            HashMap<String, String> key = new HashMap<String, String>(2);
            key.put("openNewForm", "true");
            view.setReturnData(key);
            view.close();
        }
    }

    private void afterAuditOp(OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            this.getModel().setValue("billstatus", (Object)"C");
            this.getView().updateView();
        }
    }

    private void afterUnSubmitOp(OperationResult operationResult) {
        String successMsg = ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f\u3002", (String)"MobBillInfoTplPlugin_1", (String)"scmc-msmob-form", (Object[])new Object[0]);
        if (operationResult.isSuccess()) {
            this.afterReverseOperation(successMsg);
        }
    }

    private void afterUnAuditOp(OperationResult operationResult) {
        String successMsg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f\u3002", (String)"MobBillInfoTplPlugin_unAuditOpMsg", (String)"scmc-msmob-form", (Object[])new Object[0]);
        if (operationResult.isSuccess()) {
            this.afterReverseOperation(successMsg);
        }
    }

    private void afterReverseOperation(String successMsg) {
        Boolean isModify = this.checkModifyPermission();
        if (Boolean.TRUE.equals(isModify)) {
            MobileFormShowParameter formShowParameter = this.createShowParameter(this.getEditFormId(), false);
            if (formShowParameter.getCustomParam("isFromList") != null) {
                formShowParameter.getCustomParams().remove("isFromList");
            }
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CUR_PAGE_AFTER_CLOSE_SUB_PAGE));
            this.goUrl(formShowParameter, true);
            LOG.debug("\u4ece\u8be6\u60c5\u9875\u8df3\u8f6c\u5230\u7f16\u8f91\u9875\uff1a{}", (Object)this.getEditFormId());
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"mtoolbarap"});
            this.getModel().setValue("billstatus", (Object)"A");
            this.getView().updateView();
        }
    }

    public void afterSubmit(String pcId) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        AttachedFileHelper.saveAttacheFile(attachmentPanel, this.getPcEntityKey(), pcId);
        Boolean isModify = this.checkModifyPermission();
        if (Boolean.TRUE.equals(isModify)) {
            MobileFormShowParameter formShowParameter = this.createShowParameter(this.getViewFormId(), false);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CUR_PAGE_AFTER_CLOSE_SUB_PAGE));
            this.goUrl(formShowParameter, true);
        } else {
            this.getModel().setValue("billstatus", (Object)"B");
            this.getView().updateView();
        }
    }

    protected boolean isPush() {
        return false;
    }

    protected void queryAndRefreshMainFields(String ... fieldKeys) {
        if (fieldKeys == null) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String pcEntityKey = this.getPcEntityKey();
        Long billId = this.getBillId();
        DynamicObject pcBillDy = null;
        if (!this.isPush()) {
            pcBillDy = this.curData != null && this.curData.length == 1 ? this.curData[0] : this.getPcEntityById(billId.toString());
        } else {
            boolean exists = QueryServiceHelper.exists((String)pcEntityKey, (Object)billId);
            if (exists) {
                pcBillDy = this.getPcEntityById(billId.toString());
            }
        }
        if (pcBillDy != null) {
            Map<String, PropertyNode> fieldMapping = this.getFieldMapping();
            if (fieldKeys.length == 0) {
                model.beginInit();
                for (Map.Entry<String, PropertyNode> entryCase : fieldMapping.entrySet()) {
                    String mobFieldKey = entryCase.getKey();
                    PropertyNode pcField = entryCase.getValue();
                    this.setMainFieldValue(model, pcBillDy, mobFieldKey, pcField);
                    view.updateView(mobFieldKey);
                }
                model.endInit();
            } else {
                model.beginInit();
                for (String mobFieldKey : fieldKeys) {
                    PropertyNode pcField;
                    if (StringUtils.isEmpty((CharSequence)mobFieldKey) || (pcField = fieldMapping.get(mobFieldKey)) == null) continue;
                    this.setMainFieldValue(model, pcBillDy, mobFieldKey, pcField);
                    view.updateView(mobFieldKey);
                }
                model.endInit();
            }
        }
    }

    private void setMainFieldValue(IDataModel model, DynamicObject pcbillData, String mobFieldKey, PropertyNode pcField) {
        if (pcField == null) {
            return;
        }
        PropertyNode parentNode = pcField.getParentNode();
        if (parentNode == null) {
            return;
        }
        if (parentNode.getType() instanceof MainEntityType) {
            model.setValue(mobFieldKey, pcbillData.get(pcField.getFieldKey()));
            return;
        }
        if (parentNode.getType() instanceof SubEntryType || parentNode.getType() instanceof EntryType) {
            return;
        }
        this.setMainFieldValue(model, pcbillData, mobFieldKey, pcField.getParentNode());
    }

    public Boolean checkModifyPermission() {
        MobileFormShowParameter param = (MobileFormShowParameter)this.getView().getFormShowParameter();
        Object orgId = param.getCustomParam("orgid");
        if (orgId != null) {
            return PermissionHelper.checkPermission(Long.valueOf(orgId.toString()), this.getPcAppId(), this.getPcEntityKey(), "4715a0df000000ac");
        }
        return Boolean.TRUE;
    }

    public void checkDataIsExist() {
        if (!QueryServiceHelper.exists((String)this.getPcEntityKey(), (Object)this.getBillId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"MobBillEditTplPlugin_11", (String)"scmc-msmob-form", (Object[])new Object[0]));
        }
    }

    public void setTabPageTitle(String tabPageKey, String tabPageTitle) {
        if (StringUtils.isEmpty((CharSequence)tabPageKey) || StringUtils.isEmpty((CharSequence)tabPageTitle)) {
            return;
        }
        Tab tab = (Tab)this.getControl("tabap");
        List items = tab.getItems();
        for (Control item : items) {
            TabPage tabPage;
            String key;
            if (!(item instanceof TabPage) || !tabPageKey.equals(key = (tabPage = (TabPage)item).getKey())) continue;
            LocaleString localeString = new LocaleString(tabPageTitle);
            tabPage.setText(localeString);
        }
    }

    public List<String> getAllButtonKeys() {
        ArrayList<String> buttonKeys = new ArrayList<String>(10);
        Toolbar toolBar = (Toolbar)this.getControl("mtoolbarap");
        List items = toolBar.getItems();
        for (Control control : items) {
            if (!(control instanceof MenuItem)) continue;
            buttonKeys.add(control.getKey());
        }
        return buttonKeys;
    }

    protected void setMainEntryTitle() {
        String mainEntryTitle = this.getMainEntryTitle();
        MobileControlUtils.updateLabelText(this.getView(), "mldetails_label", mainEntryTitle);
    }

    protected String getMainEntryTitle() {
        IDataModel model = this.getModel();
        String entryKey = this.getEntryEntity();
        int entryRowCount = model.getEntryRowCount(entryKey);
        String mainEntryTitle = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\uff08\u5171%s\u6761\uff09", (String)"MobBizBillInfoTplPlugin_MainEntryTitle", (String)"scmc-msmob-form", (Object[])new Object[0]), entryRowCount);
        return mainEntryTitle;
    }
}

