/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.msmob.business.helper.BotpHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBizBillInfoTplPlugin;

public class MobPushTargetBillInfoPlugin
extends MobBizBillInfoTplPlugin {
    @Override
    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        if (this.isPush()) {
            this.initPushBillInfo();
        } else {
            super.afterCreateNewData(e);
        }
    }

    @Override
    public boolean isPush() {
        IPageCache pageCache = this.getPageCache();
        String convertResult = pageCache.get("convertResult");
        if (StringUtils.isNotEmpty((String)convertResult)) {
            return true;
        }
        return this.getConvertResult() != null;
    }

    private String getConvertResult() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONObject convertResultJson = (JSONObject)formShowParameter.getCustomParam("convertResult");
        return convertResultJson == null ? null : convertResultJson.toJSONString();
    }

    private void initPushBillInfo() {
        String convertResult = this.getConvertResult();
        if (StringUtils.isEmpty((String)convertResult)) {
            return;
        }
        DynamicObject pushBill = BotpHelper.getPushBill(convertResult, true);
        List<DynamicObject> targetBills = Collections.singletonList(pushBill);
        this.curData = targetBills.toArray(new DynamicObject[targetBills.size()]);
        super.initBillInfo();
        this.cacheBillBaseInfo(this.getModel(), this.curData[0]);
    }

    public void setBtnVisible() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String billNo = (String)model.getValue("billno");
        String billStatus = (String)model.getValue("billstatus");
        if (StringUtils.isNotEmpty((String)billNo) && "A".equals(billStatus)) {
            view.setVisible(Boolean.TRUE, new String[]{"buttondelete"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"buttondelete"});
        }
        view.updateView("mtoolbarap");
    }

    @Override
    public boolean isAddModificationMutex() {
        if (this.isPush()) {
            return false;
        }
        return super.isAddModificationMutex();
    }

    @Override
    public void cacheBillBaseInfo(IDataModel model, DynamicObject bill) {
        super.cacheBillBaseInfo(model, bill);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("convertResult", this.getConvertResult());
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBtnVisible();
    }

    @Override
    public void click(EventObject e) {
        Control control = (Control)e.getSource();
        String key = control.getKey();
        if ("editop".equals(key)) {
            boolean isSaved = this.isSaved();
            if (!this.isPush() || isSaved) {
                super.checkDataIsExist();
            }
        }
        super.click(e);
    }

    public boolean isSaved() {
        String pcId;
        IPageCache pageCache = this.getPageCache();
        String pushSaveSuccess = pageCache.get("pushSaveSuccess");
        boolean isSaved = StringUtils.isNotEmpty((String)pushSaveSuccess);
        boolean exists = false;
        if (!isSaved && StringUtils.isNotEmpty((String)(pcId = pageCache.get("pcId")))) {
            Long billId = Long.valueOf(pcId);
            exists = QueryServiceHelper.exists((String)this.getPcEntityKey(), (Object)billId);
        }
        return isSaved || exists;
    }

    @Override
    public void setEntryViewParameter(Map<String, Object> customParams) {
        String convertResult = this.getPageCache().get("convertResult");
        customParams.put("convertResult", convertResult);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        OperateOption option = formOperate.getOption();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": 
            case "submit": {
                this.beforeSaveOrSubmit(option);
                break;
            }
        }
    }

    @Override
    public void checkLockInfo() {
        if (this.isPush()) {
            return;
        }
        super.checkLockInfo();
    }

    private void beforeSaveOrSubmit(OperateOption option) {
        if (this.isPush()) {
            option.setVariableValue("convertResult", this.getConvertResult());
            option.setVariableValue("isPushSaved", String.valueOf(this.isSaved()));
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "save": {
                this.afterSaveOrSubmit(args);
                this.setBtnVisible();
                if (!this.isPushAndOpSuccess(args)) break;
                StringBuilder errMsg = new StringBuilder();
                MutexHelper.require((IFormView)this.getView(), (String)this.getPcEntityKey(), (Object)this.getBillId(), (String)"modify", (boolean)Boolean.TRUE, (StringBuilder)errMsg);
                break;
            }
            case "submit": {
                this.afterSaveOrSubmit(args);
                break;
            }
        }
        super.afterDoOperation(args);
    }

    private boolean isPushAndOpSuccess(AfterDoOperationEventArgs args) {
        boolean isSuccess = args.getOperationResult().isSuccess();
        return this.isPush() && isSuccess;
    }

    private void afterSaveOrSubmit(AfterDoOperationEventArgs args) {
        if (this.isPushAndOpSuccess(args)) {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            IPageCache pageCache = this.getPageCache();
            String billId = pageCache.get("pcId");
            DynamicObject bill = super.getPcEntityById(billId);
            String billno = bill.getString("billno");
            model.beginInit();
            model.setValue("billno", (Object)billno);
            model.endInit();
            view.updateView("billno");
            pageCache.put("pushSaveSuccess", Boolean.TRUE.toString());
            DynamicObject pcEntity = BusinessDataServiceHelper.loadSingle((Object)this.getBillId(), (String)this.getPcEntityKey());
            EntityCacheHelper.savePcEntityToPageCache(this.getView(), pcEntity);
        }
    }

    @Override
    public DynamicObject getPcEntityById(String pcId) {
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        String mobEntryKey = this.getEntryEntity();
        int rowCount = model.getEntryRowCount(mobEntryKey);
        DynamicObject bill = this.getBill();
        if (rowCount < 1) {
            return bill;
        }
        if (this.isPush()) {
            String pcEntryKey = pageCache.get(mobEntryKey);
            DynamicObjectCollection pcEntryColl = bill.getDynamicObjectCollection(pcEntryKey);
            DynamicObjectCollection mobEntryColl = model.getEntryEntity(mobEntryKey);
            int pcEntrySize = pcEntryColl.size();
            int mobEntrySize = mobEntryColl.size();
            if (mobEntrySize == 0) {
                return bill;
            }
            int setEntryIdSize = pcEntrySize >= mobEntrySize ? mobEntrySize : pcEntrySize;
            for (int i = 0; i < setEntryIdSize; ++i) {
                DynamicObject pcEntryRow = (DynamicObject)pcEntryColl.get(i);
                DynamicObject mobEntryRow = (DynamicObject)mobEntryColl.get(i);
                Long mobEntryId = mobEntryRow.getLong("mobentryid");
                pcEntryRow.set("id", (Object)mobEntryId);
            }
        }
        return bill;
    }

    public DynamicObject getBill() {
        Long billId = this.getBillId();
        String convertResult = this.getConvertResult();
        DynamicObject bill = StringUtils.isEmpty((String)convertResult) || this.isSaved() ? super.getPcEntityById(billId.toString()) : BotpHelper.getPushBill(convertResult, false);
        return bill;
    }

    @Override
    public MobileFormShowParameter createShowParameter(String formId, boolean isOpenEntry) {
        MobileFormShowParameter formShowParameter = super.createShowParameter(formId, isOpenEntry);
        formShowParameter.setCustomParam("isSave", (Object)this.isSaved());
        formShowParameter.setCustomParam("mainOrg", (Object)this.getMainOrg());
        return formShowParameter;
    }
}

