/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl.botp;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.common.utils.BotpFilterUtils;
import kd.scmc.msmob.common.utils.ConverterUtils;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.listtpl.MobBizListMultiOperateTplPlugin;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.FilterCondition;
import kd.scmc.msmob.service.mservice.baseset.IDataSourceConfigService;
import kd.scmc.msmob.service.mservice.mobdata.IMobDataService;

public class BotpSrcBillPlugin
extends MobBizListMultiOperateTplPlugin {
    private DataSourceConfig targetDataSourceConfig;

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.updateData();
    }

    @Override
    public void entryRowClick(RowClickEvent e) {
        Boolean isSelected = (Boolean)this.getModel().getValue("selectedbox", e.getRow());
        this.getModel().beginInit();
        this.getModel().setValue("selectedbox", (Object)(isSelected == false ? 1 : 0), e.getRow());
        this.getModel().endInit();
        this.getView().updateView("selectedbox", e.getRow());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String pushOpKey;
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        String operateKey = args.getOperateKey();
        if (operationResult != null && operationResult.isSuccess() && StringUtils.isNotEmpty((CharSequence)(pushOpKey = this.getPushOpKey())) && pushOpKey.equals(operateKey)) {
            FormOperate formOperate = (FormOperate)args.getSource();
            OperateOption option = formOperate.getOption();
            this.afterDoPush(option);
        }
    }

    protected String getPushOpKey() {
        return "push";
    }

    private void afterDoPush(OperateOption option) {
        Map variables = option.getVariables();
        String convertResult = (String)variables.get("convertResult");
        if (StringUtils.isEmpty((CharSequence)convertResult)) {
            return;
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("convertResult", JSON.parseObject((String)convertResult));
        PageUtils.showFormPage(this.getView(), this.getTargetMobFormKey(), customParams, null);
    }

    protected String getTargetMobFormKey() {
        String errMsg = ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6682\u65f6\u4e0d\u652f\u6301\u5173\u8054\u751f\u6210\u9875\u3002", (String)"BotpSrcBillPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
        throw new KDBizException(errMsg);
    }

    @Override
    public void updateData() {
        List<FilterCondition> newfilters = this.getFilters();
        List<FilterCondition> pushFilterConditions = this.getPushFilterConditions();
        newfilters.addAll(pushFilterConditions);
        FilterConstructor filterConstructor = super.getFilterConstructor(new FilterConstructor());
        filterConstructor.setFilters(newfilters);
        IMobDataService mobDataService = this.getMobDataService();
        this.curData = mobDataService.loadData(this.getFormKey(), filterConstructor, this.getDataSourceConfig());
        this.setModelValue();
        this.getView().updateView();
    }

    private List<FilterCondition> getPushFilterConditions() {
        DynamicObject[] dynamicObjectArray = this.curData = this.curData == null || this.curData.length == 0 ? this.readData() : this.curData;
        if (this.curData == null || this.curData.length == 0) {
            return new ArrayList<FilterCondition>(10);
        }
        DataSourceConfig targetDataSourceConfig = this.getTargetDataSourceConfig();
        String targetEntityKey = targetDataSourceConfig.getPcEntityKey();
        String mainEntryKey = this.getMainEntryKeyOfTarget();
        QFilter pushFilter = BotpFilterUtils.getAvailableRuleFilters(this.curData, this.getPcEntityKey(), targetEntityKey, mainEntryKey);
        return ConverterUtils.getFilterConditionList(Collections.singletonList(pushFilter));
    }

    protected final DataSourceConfig getTargetDataSourceConfig() {
        IDataSourceConfigService dataSourceConfigService = this.getDataSourceConfigService();
        this.targetDataSourceConfig = this.targetDataSourceConfig == null ? dataSourceConfigService.getDataSourceConfig(this.getTargetMobFormKey()) : this.targetDataSourceConfig;
        return this.targetDataSourceConfig;
    }

    protected String getMainEntryKeyOfTarget() {
        DataSourceConfig targetDataSourceConfig = this.getTargetDataSourceConfig();
        String targetEntityKey = targetDataSourceConfig.getPcEntityKey();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)targetEntityKey);
        DynamicProperty entry = mainEntityType.getProperty("billentry");
        if (entry == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u4e0b\u63a8\u76ee\u6807\u5355\u201c%1$s\u201d\u7684\u5206\u5f55\u6807\u8bc6\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u5199getTargetEntityEntryKey\u65b9\u6cd5\u3002", (String)"BotpSrcBillPlugin_1", (String)"scmc-msmob-form", (Object[])new Object[0]), targetEntityKey, "billentry");
            throw new KDBizException(errMsg);
        }
        return "billentry";
    }
}

