/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl.botp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.scmc.msmob.common.design.MobileFormFactory;
import kd.scmc.msmob.mvccore.JsonUtils;
import org.apache.commons.lang3.StringUtils;

public class BotpTrackDownResultPlugin
extends AbstractMobFormPlugin
implements TreeNodeClickListener {
    private Map<Long, TableDefine> tableDefines = new HashMap<Long, TableDefine>();
    private static final String KEY_TABAP = "tabap";
    private static final String KEY_PRE_TARGETKEY = "tabbills";
    public static final String TRACK_DOWN_RESULT_PARAM = "TRACK_DOWN_RESULT_PARAM";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showTrackDownResults();
    }

    private void showTrackDownResults() {
        Map<Long, HashSet<Long>> mainTableIdMap = this.findLookDownMainTableIds();
        int i = 0;
        for (Map.Entry<Long, HashSet<Long>> entry : mainTableIdMap.entrySet()) {
            Long mainTableId = entry.getKey();
            HashSet<Long> billIds = entry.getValue();
            this.showList(mainTableId, billIds, i);
            ++i;
        }
    }

    private TableDefine loadTableDefine(Long tableId) {
        TableDefine tableDefine = this.tableDefines.get(tableId);
        if (tableDefine == null && (tableDefine = ConvertMetaServiceHelper.loadTableDefine((Long)tableId)) != null) {
            this.tableDefines.put(tableId, tableDefine);
        }
        return tableDefine;
    }

    private void showList(Long mainTableId, HashSet<Long> billIds, int index) {
        TableDefine tableDefine = this.loadTableDefine(mainTableId);
        if (tableDefine == null) {
            return;
        }
        String entityNumber = tableDefine.getEntityNumber();
        if (billIds == null || billIds.isEmpty()) {
            return;
        }
        FormShowParameter showParameter = this.createShowParameter(entityNumber, billIds, index);
        if (showParameter != null) {
            this.getView().showForm(showParameter);
        }
    }

    protected FormShowParameter createShowParameter(String pcEntityNumber, HashSet<Long> billIds, Integer index) {
        MobileFormFactory mobileFormFactory = new MobileFormFactory();
        String mobileListPage = mobileFormFactory.getMobileListKey(pcEntityNumber);
        boolean existsInMobile = StringUtils.isNotBlank((CharSequence)mobileListPage);
        MobileFormShowParameter mobileListShowParameter = new MobileFormShowParameter();
        mobileListShowParameter.setFormId(existsInMobile ? mobileListPage : "msmob_botp_trackdown_tips");
        mobileListShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        mobileListShowParameter.getOpenStyle().setTargetKey(KEY_PRE_TARGETKEY + index);
        mobileListShowParameter.setShowTitle(false);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pcEntityNumber);
        String tabTitle = String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s\uff09", (String)"BotpHelper_trackDown_label", (String)"scmc-msmob-form", (Object[])new Object[0]), mainType.getDisplayName().toString(), billIds.size());
        mobileListShowParameter.setCaption(tabTitle);
        this.createTabPage(index, KEY_PRE_TARGETKEY + index, new LocaleString(mobileListShowParameter.getCaption()));
        mobileListShowParameter.setHasRight(true);
        mobileListShowParameter.setCustomParam("isFromTrackDown", (Object)"true");
        mobileListShowParameter.setCustomParam("specifiedBillId", (Object)JsonUtils.serialize(billIds));
        mobileListShowParameter.setCustomParam("PC_ENTITY_PARAM_KEY", (Object)pcEntityNumber);
        mobileListShowParameter.setCustomParam("tabKey", (Object)(KEY_PRE_TARGETKEY + index));
        mobileListShowParameter.setCustomParam("pcEntityNumber", (Object)pcEntityNumber);
        return mobileListShowParameter;
    }

    private void createTabPage(Integer index, String key, LocaleString name) {
        Tab tab = (Tab)this.getView().getControl(KEY_TABAP);
        TabPageAp tabPageAp = new TabPageAp();
        tabPageAp.setKey(key);
        tabPageAp.setName(name);
        tab.insertControls(index.intValue(), Collections.singletonList(tabPageAp.createControl()));
    }

    private Map<Long, HashSet<Long>> findLookDownMainTableIds() {
        List linkDownNodes = (List)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam(TRACK_DOWN_RESULT_PARAM)));
        ArrayList targetNodes = new ArrayList();
        for (BFRowLinkDownNode node : linkDownNodes) {
            targetNodes.addAll(node.findAllChildNodes());
        }
        LinkedHashMap<Long, HashSet<Long>> targetTableIds = new LinkedHashMap<Long, HashSet<Long>>();
        for (BFRowLinkDownNode targetNode : targetNodes) {
            BFRowId rowId = targetNode.getRowId();
            this.addTableBillId(targetTableIds, rowId);
        }
        return targetTableIds;
    }

    private void addTableBillId(Map<Long, HashSet<Long>> allTableBillIds, BFRowId rowId) {
        Long mainTableId = rowId.getMainTableId();
        Long billId = rowId.getBillId();
        HashSet billIds = allTableBillIds.computeIfAbsent(mainTableId, k -> new HashSet());
        billIds.add(billId);
    }
}

