/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl.listtpl;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.msmob.business.helper.SchemeOpHelper;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.common.enums.BillSortType;
import kd.scmc.msmob.common.enums.SchemeEnum;
import kd.scmc.msmob.plugin.tpl.basetpl.AbstractMobFormPagePlugin;
import kd.scmc.msmob.pojo.FilterCondition;
import kd.scmc.msmob.pojo.PropertyNode;
import org.apache.commons.lang3.StringUtils;

public class FrequentSchemeListPlugin
extends AbstractMobFormPagePlugin
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(FrequentSchemeListPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String MOBID = "mobid";
    private static final String MOREFLEX = "moreflex";
    private static final String MSMOB_SCHEME_LIST = "msmob_scheme_list";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setModelValue();
        this.setVisible();
    }

    public void setVisible() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)showParameter.getCustomParam("schemeId");
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        for (int i = 0; i < this.curData.length; ++i) {
            if (Long.valueOf(this.curData[i].getLong("id")).equals(schemeId)) {
                this.getView().getPageCache().put("schemeId", schemeId.toString());
                continue;
            }
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"vectorap"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{MOREFLEX});
        CardEntry entry = (CardEntry)this.getControl(ENTRYENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public FilterConstructor getFilterConstructor(FilterConstructor evt) {
        HashMap<String, BillSortType> sort = new HashMap<String, BillSortType>(8);
        sort.put("default", BillSortType.DESC);
        sort.put("recentusetime", BillSortType.DESC);
        evt.setSort(sort);
        ArrayList<FilterCondition> conditionList = new ArrayList<FilterCondition>(8);
        Long currUserId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("creator", "=", (Object)currUserId);
        if (this.getSchemeType() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\u65b9\u6848\u7c7b\u578b\u3002", (String)"FrequentSchemeListPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]));
        }
        qFilter.and("schemetype", "=", (Object)this.getSchemeType());
        FilterCondition condition = new FilterCondition(qFilter);
        conditionList.add(condition);
        evt.setFilters(conditionList);
        return evt;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "moreflex": {
                MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
                String schemeId = this.getPageCache().get("schemeId");
                if (!StringUtils.isEmpty((CharSequence)schemeId)) {
                    Long id = Long.valueOf(schemeId);
                    formShowParameter.setCustomParam("schemeId", (Object)id);
                }
                String formKey = (String)this.getView().getFormShowParameter().getCustomParam("formKey");
                formShowParameter.setCustomParam("schemetype", (Object)this.getSchemeType());
                formShowParameter.setCustomParam("formKey", (Object)formKey);
                formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
                formShowParameter.setFormId(MSMOB_SCHEME_LIST);
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        Long entryId = (Long)this.getView().getModel().getValue(MOBID, rowIndex);
        this.updateScheme(entryId);
        this.getView().returnDataToParent((Object)entryId);
        this.getView().close();
    }

    private void updateScheme(Long entryId) {
        SchemeOpHelper.updateSchemeTime(entryId);
        String schemeName = (String)this.getView().getModel().getValue("shcemename");
        if (!SchemeEnum.RECENT_SCHEME_NAME.getName().equals(schemeName)) {
            DynamicObject scheme = SchemeOpHelper.getSingleScheme(entryId);
            String schemeDescription = (String)scheme.get("description");
            String content = (String)scheme.get("content_tag");
            SchemeOpHelper.saveRecentScheme(this.getSchemeType(), content, schemeDescription);
        }
    }

    public String getSchemeType() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (String)formShowParameter.getCustomParam("schemetype");
    }

    @Override
    public void updateData() {
        this.curData = this.readData();
        this.setModelValue();
    }

    public void setModelValue() {
        IDataModel model = this.getView().getModel();
        if (this.curData != null && this.curData.length != 0) {
            int entryRowCount = Math.min(this.curData.length, 4);
            model.deleteEntryData(ENTRYENTITY);
            model.batchCreateNewEntryRow(ENTRYENTITY, entryRowCount);
            for (int i = 0; i < entryRowCount; ++i) {
                for (Map.Entry<String, PropertyNode> key : this.getFieldMapping().entrySet()) {
                    model.setValue(key.getKey(), this.curData[i].get(key.getValue().getFieldKey()), i);
                    model.setValue(MOBID, this.curData[i].get("id"), i);
                }
            }
        } else {
            model.deleteEntryData(ENTRYENTITY);
        }
        this.getView().updateView(ENTRYENTITY);
    }
}

