/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl.listtpl;

import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBillListTplPlugin;
import kd.scmc.msmob.pojo.PropertyNode;

public class MobBizListMultiOperateTplPlugin
extends MobBillListTplPlugin {
    protected static final String SELECTED_BOX = "selectedbox";
    protected static final String CLEAR_SELECTED = "clearselected";
    protected static final String SHOW_ENTRY_BOX = "showentrybox";

    public MobBizListMultiOperateTplPlugin() {
        this.loadByPage = false;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CLEAR_SELECTED});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "showentrybox": {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(this.getEntryEntity());
                Set selectedId = entryEntity.stream().filter(entry -> entry.getBoolean(SELECTED_BOX)).map(entry -> entry.get("mobid")).collect(Collectors.toSet());
                this.updateData();
                boolean showEntry = (Boolean)this.getModel().getValue(SHOW_ENTRY_BOX);
                if (!showEntry) break;
                DynamicObjectCollection newEntryEntity = this.getModel().getEntryEntity(this.getEntryEntity());
                this.getModel().beginInit();
                for (int i = 0; i < newEntryEntity.size(); ++i) {
                    if (!selectedId.contains(((DynamicObject)newEntryEntity.get(i)).get("mobid"))) continue;
                    this.getModel().setValue(SELECTED_BOX, (Object)true, i);
                    this.getView().updateView(SELECTED_BOX, i);
                }
                this.getModel().endInit();
                break;
            }
        }
    }

    @Override
    public void click(EventObject e) {
        super.click(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        model.beginInit();
        DynamicObjectCollection modelEntry = model.getEntryEntity(this.getEntryEntity());
        for (int i = 0; i < modelEntry.size(); ++i) {
            model.setValue(SELECTED_BOX, (Object)false, i);
            view.updateView(SELECTED_BOX, i);
        }
        model.endInit();
    }

    @Override
    public void setModelValue() {
        IDataModel model = this.getModel();
        this.getModel().beginInit();
        if (this.curData != null && this.curData.length != 0) {
            model.deleteEntryData(this.getEntryEntity());
            Boolean showEntry = (Boolean)this.getModel().getValue(SHOW_ENTRY_BOX);
            for (int i = 0; i < this.curData.length; ++i) {
                if (showEntry.booleanValue()) {
                    this.setValueWithEntry(this.curData[i], this.getModel().getEntryRowCount(this.getEntryEntity()));
                } else {
                    this.setValueWithEntity(this.curData[i], this.getModel().getEntryRowCount(this.getEntryEntity()));
                }
                if (this.getModel().getEntryRowCount(this.getEntryEntity()) <= 100) {
                    continue;
                }
                break;
            }
        } else {
            model.deleteEntryData(this.getEntryEntity());
        }
        this.getModel().endInit();
        this.displayFlexPanelGetMore(0);
        this.getView().updateView();
    }

    private void setValueWithEntry(DynamicObject curEntity, int i) {
        IDataModel model = this.getModel();
        int entrySize = 0;
        for (Map.Entry<String, PropertyNode> key : this.getFieldMapping().entrySet()) {
            String pcKey = key.getValue().getFieldKey();
            String pcKeyPrefix = pcKey.split("\\.")[0];
            if (!(curEntity.getDynamicObjectType().getProperty(pcKeyPrefix) instanceof EntryProp)) continue;
            entrySize = curEntity.getDynamicObjectCollection(pcKeyPrefix).size();
        }
        if (entrySize > 0) {
            model.batchCreateNewEntryRow(this.getEntryEntity(), entrySize);
            for (int j = 0; j < entrySize; ++j) {
                for (Map.Entry<String, PropertyNode> key : this.getFieldMapping().entrySet()) {
                    String pcKey = key.getValue().getFieldKey();
                    String pcKeyPrefix = pcKey.split("\\.")[0];
                    if (curEntity.getDynamicObjectType().getProperty(pcKeyPrefix) instanceof EntryProp) {
                        if (curEntity.getDynamicObjectCollection(pcKeyPrefix).isEmpty()) continue;
                        model.setValue(key.getKey(), ((DynamicObject)curEntity.getDynamicObjectCollection(pcKeyPrefix).get(j)).get(pcKey.substring(pcKeyPrefix.length() + 1)), i + j);
                        model.setValue("mobid", curEntity.get("id"), i + j);
                        model.setValue("billentryid", ((DynamicObject)curEntity.getDynamicObjectCollection(pcKeyPrefix).get(j)).getPkValue(), i + j);
                        continue;
                    }
                    model.setValue(key.getKey(), curEntity.get(key.getValue().getFieldKey()), i + j);
                    model.setValue("mobid", curEntity.get("id"), i + j);
                }
            }
        }
    }

    private void setValueWithEntity(DynamicObject curEntity, int i) {
        IDataModel model = this.getModel();
        model.batchCreateNewEntryRow(this.getEntryEntity(), 1);
        for (Map.Entry<String, PropertyNode> key : this.getFieldMapping().entrySet()) {
            String pcKey = key.getValue().getFieldKey();
            String pcKeyPrefix = pcKey.split("\\.")[0];
            if (curEntity.getDynamicObjectType().getProperty(pcKeyPrefix) instanceof EntryProp) {
                if (curEntity.getDynamicObjectCollection(pcKeyPrefix).isEmpty()) continue;
                model.setValue(key.getKey(), ((DynamicObject)curEntity.getDynamicObjectCollection(pcKeyPrefix).get(0)).get(pcKey.substring(pcKeyPrefix.length() + 1)), i);
                model.setValue("mobid", curEntity.get("id"), i);
                continue;
            }
            model.setValue(key.getKey(), curEntity.get(key.getValue().getFieldKey()), i);
            model.setValue("mobid", curEntity.get("id"), i);
        }
    }
}

