/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl.listtpl;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.msmob.business.helper.SchemeOpHelper;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.common.enums.BillSortType;
import kd.scmc.msmob.common.enums.SchemeEnum;
import kd.scmc.msmob.plugin.tpl.basetpl.AbstractMobFormPagePlugin;
import kd.scmc.msmob.pojo.FilterCondition;
import kd.scmc.msmob.pojo.PropertyNode;

public class SchemeListTplPlugin
extends AbstractMobFormPagePlugin
implements RowClickEventListener {
    private static final Log LOG = LogFactory.getLog(SchemeListTplPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private static final String DELETE = "delete";
    private static final String ENTRY_ID = "mobid";
    private static final String SCHEME_NAME = "scheme_name";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entry = (CardEntry)this.getControl(ENTRYENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
    }

    @Override
    public FilterConstructor getFilterConstructor(FilterConstructor evt) {
        HashMap<String, BillSortType> sort = new HashMap<String, BillSortType>(8);
        sort.put("default", BillSortType.DESC);
        sort.put("recentusetime", BillSortType.DESC);
        evt.setSort(sort);
        ArrayList<FilterCondition> conditionList = new ArrayList<FilterCondition>(8);
        Long currUserId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("creator", "=", (Object)currUserId);
        if (this.getSchemeType() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\u65b9\u6848\u7c7b\u578b\u3002", (String)"FrequentSchemeListPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]));
        }
        qFilter.and("schemetype", "=", (Object)this.getSchemeType());
        FilterCondition condition = new FilterCondition(qFilter);
        conditionList.add(condition);
        evt.setFilters(conditionList);
        return evt;
    }

    public String getSchemeType() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (String)formShowParameter.getCustomParam("schemetype");
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setModelValue();
        this.setVisible();
    }

    @Override
    public void updateData() {
        this.setModelValue();
    }

    private void setVisible() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Long schemeId = (Long)showParameter.getCustomParam("schemeId");
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY);
        int entryCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        for (int i = 0; i < entryCount; ++i) {
            if (this.getModel().getValue(SCHEME_NAME, i).equals(SchemeEnum.RECENT_SCHEME_NAME.getName())) {
                cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), 0, new String[]{DELETE});
            }
            if (this.getModel().getValue(ENTRY_ID, i).equals(schemeId)) continue;
            cardEntry.setChildVisible(Boolean.FALSE.booleanValue(), i, new String[]{"vectorap"});
        }
    }

    public void setModelValue() {
        IDataModel model = this.getView().getModel();
        if (this.curData != null && this.curData.length != 0) {
            model.deleteEntryData(ENTRYENTITY);
            model.batchCreateNewEntryRow(ENTRYENTITY, this.curData.length);
            for (int i = 0; i < this.curData.length; ++i) {
                for (Map.Entry<String, PropertyNode> key : this.getFieldMapping().entrySet()) {
                    model.setValue(key.getKey(), this.curData[i].get(key.getValue().getFieldKey()), i);
                    model.setValue(ENTRY_ID, this.curData[i].get("id"), i);
                }
            }
        } else {
            model.deleteEntryData(ENTRYENTITY);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void entryRowClick(RowClickEvent evt) {
        int rowIndex = evt.getRow();
        Long entryId = (Long)this.getView().getModel().getValue(ENTRY_ID, rowIndex);
        this.updateScheme(entryId);
        String formKey = (String)this.getView().getFormShowParameter().getCustomParam("formKey");
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formKey);
        showParameter.setCustomParam("schemeId", (Object)entryId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)showParameter);
        this.getView().close();
    }

    private void updateScheme(Long entryId) {
        SchemeOpHelper.updateSchemeTime(entryId);
        String schemeName = (String)this.getView().getModel().getValue(SCHEME_NAME);
        if (!SchemeEnum.RECENT_SCHEME_NAME.getName().equals(schemeName)) {
            DynamicObject scheme = SchemeOpHelper.getSingleScheme(entryId);
            String schemeDescription = (String)scheme.get("description");
            String content = (String)scheme.get("content_tag");
            SchemeOpHelper.saveRecentScheme(this.getSchemeType(), content, schemeDescription);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        int currRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        Long schemeId = (Long)this.getView().getModel().getValue(ENTRY_ID, currRowIndex);
        switch (operateKey) {
            case "delete": {
                this.getModel().deleteEntryRow(ENTRYENTITY, currRowIndex);
                OperationResult op = SchemeOpHelper.deleteScheme(schemeId);
                if (op != null && op.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65b9\u6848\u5220\u9664\u6210\u529f\u3002", (String)"SchemeListTplPlugin_0", (String)"scmc-msmob-form", (Object[])new Object[0]));
                }
                this.getView().updateView(ENTRYENTITY);
                this.setVisible();
                break;
            }
        }
    }
}

