/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.basetpl.scan;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.RefreshResultType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.lang.Lang;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.OperationHandleHelper;
import kd.scmc.msmob.plugin.op.skill.ISkill;
import kd.scmc.msmob.plugin.tpl.basetpl.scan.MobScanResultTplPlugin;
import kd.scmc.msmob.pojo.QrCodeResult;

public class MobBizScanResultTplPlugin
extends MobScanResultTplPlugin {
    public static final String FALSE = "false";
    private static final String CODE_TYPE = "code_type";
    private String[] buttons = new String[]{"bar_skill", "bar_two_skills", "bar_three_skills"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"bar_more_skills"});
        this.addClickListeners(this.buttons);
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String type = (String)formShowParameter.getCustomParam("scanResultType");
        this.getView().getPageCache().put(CODE_TYPE, type);
        String defaultKey = this.handleResultConfig(type);
        this.setData();
        this.executeDefaultSkill(defaultKey);
    }

    protected void executeDefaultSkill(String Key) {
        IPageCache pageCache = this.getView().getPageCache();
        String isExecute = pageCache.get("executeDefaultSkill");
        if (!FALSE.equals(isExecute) && StringUtils.isNotBlank((CharSequence)Key)) {
            this.executeSkill(Key);
            pageCache.put("executeDefaultSkill", FALSE);
        }
    }

    public void setData() {
    }

    public QrCodeResult getParseResult() {
        String data = (String)this.getView().getFormShowParameter().getCustomParam("scanResultData");
        return (QrCodeResult)JSON.parseObject((String)data, QrCodeResult.class);
    }

    public DynamicObject getWarehouse(Object number) {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object id = formShowParameter.getCustomParam("orgid");
        QFilter qFilter = new QFilter("number", "=", number);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)Long.valueOf(String.valueOf(id)));
        if (baseDataFilter != null) {
            qFilter.and(baseDataFilter);
        }
        return BusinessDataServiceHelper.loadSingle((String)"bd_warehouse", (String)"id,name,number", (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject getLocation(Object number) {
        QFilter qFilter = new QFilter("number", "=", number);
        return BusinessDataServiceHelper.loadSingle((String)"bd_location", (String)"id,name,number", (QFilter[])new QFilter[]{qFilter});
    }

    public DynamicObject getMaterial(Object number) {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        Object id = formShowParameter.getCustomParam("orgid");
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)Long.valueOf(String.valueOf(id)));
        qFilter.and("number", "=", number);
        return BusinessDataServiceHelper.loadSingle((String)"bd_material", (String)"id,name,number,materialtype", (QFilter[])new QFilter[]{qFilter});
    }

    public String handleResultConfig(String type) {
        String defaultKey = "";
        if (StringUtils.isNotBlank((CharSequence)type)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"msmob_scan_result_cfg");
            MainEntityType dataEntityType = (MainEntityType)dynamicObject.getDataEntityType();
            String config = this.getView().getParentView().getPageCache().get("scanResultConfig");
            DynamicObject resultsConfig = EntityCacheHelper.deserializeFromStringToEntity(config, (IDataEntityType)dataEntityType);
            DynamicObjectCollection skills = resultsConfig.getDynamicObjectCollection("entryentity");
            ArrayList<String> buttons = new ArrayList<String>(3);
            if (skills != null && !skills.isEmpty()) {
                ArrayList<DynamicObject> skillList = new ArrayList<DynamicObject>(6);
                for (DynamicObject skill : skills) {
                    boolean enable = skill.getBoolean("isenable");
                    boolean defaultEnable = skill.getBoolean("defaultenabled");
                    if (enable) {
                        skillList.add(skill);
                    }
                    if (!defaultEnable) continue;
                    DynamicObject skillDyn = skill.getDynamicObject("skillname");
                    defaultKey = skillDyn.getString("number");
                }
                buttons.add("bar_skill");
                buttons.add("bar_two_skills");
                int size = skillList.size();
                if (size > 3) {
                    buttons.add("bar_more_skills");
                } else {
                    buttons.add("bar_three_skills");
                }
                Button barItemAp = (Button)this.getControl("bar_more_skills");
                IClientViewProxy proxy = (IClientViewProxy)barItemAp.getView().getService(IClientViewProxy.class);
                HashMap<String, ArrayList<Object>> dataMap = new HashMap<String, ArrayList<Object>>(6);
                ArrayList<Object> list = new ArrayList<Object>(6);
                list.add("bar_more_skills");
                list.add(dataMap);
                ArrayList<Object> itemLists = new ArrayList<Object>(6);
                dataMap.put("items", itemLists);
                HashMap<String, String> buttonMap = new HashMap<String, String>(6);
                HashMap<String, String> classPathMap = new HashMap<String, String>(6);
                ArrayList<String> visibleList = new ArrayList<String>(3);
                this.handleButton(buttons, skillList, size, itemLists, buttonMap, classPathMap, visibleList);
                this.getView().getPageCache().put("buttonKeys", JSON.toJSONString(visibleList));
                if (size > 3) {
                    proxy.addAction("updateControlMetadata", list);
                }
                this.getView().getPageCache().put("buttonKeyMap", JSON.toJSONString(buttonMap));
                this.getView().getPageCache().put("skillPluginClassPath", JSON.toJSONString(classPathMap));
            }
        }
        return defaultKey;
    }

    private void handleButton(List<String> buttons, List<DynamicObject> skillList, int size, List<Object> itemLists, Map<String, String> buttonMap, Map<String, String> classPathMap, List<String> visibleList) {
        for (int i = 0; i < size; ++i) {
            String key;
            DynamicObject skill = skillList.get(i);
            boolean enable = skill.getBoolean("isenable");
            if (!enable) continue;
            DynamicObject skillDyn = skill.getDynamicObject("skillname");
            String name = skillDyn.getString("name");
            String number = skillDyn.getString("number");
            String classPatch = skillDyn.getString("plugin_classpath");
            classPathMap.put(number, classPatch);
            if (i < 2 || i == 2 && size == 3) {
                key = buttons.get(i);
                visibleList.add(key);
                HashMap map = new HashMap(6);
                HashMap<Locale, String> langMap = new HashMap<Locale, String>(3);
                Lang lang = RequestContext.get().getLang();
                Locale locale = lang.getLocale();
                map.put("text", langMap);
                langMap.put(locale, name);
                buttonMap.put(key, number);
                this.getView().updateControlMetadata(key, map);
            }
            if (i < 2 || size <= 3) continue;
            key = buttons.get(2);
            visibleList.add(key);
            HashMap<String, Object> item = new HashMap<String, Object>(6);
            item.put("id", number);
            item.put("key", number);
            Lang lang = RequestContext.get().getLang();
            Locale locale = lang.getLocale();
            HashMap<Locale, String> languageMap = new HashMap<Locale, String>(3);
            languageMap.put(locale, name);
            item.put("title", languageMap);
            item.put("operationkey", "");
            itemLists.add(item);
        }
    }

    public String getSkillPluginClassPath(String key) {
        String classPath = "";
        String mapStr = this.getView().getPageCache().get("skillPluginClassPath");
        if (StringUtils.isNotBlank((CharSequence)mapStr)) {
            Map classPathMap = (Map)JSON.parseObject((String)mapStr, Map.class);
            classPath = (String)classPathMap.get(key);
        }
        return classPath;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.handleVisible();
    }

    public void refreshData() {
        String type = this.getView().getPageCache().get(CODE_TYPE);
        String defaultKey = this.handleResultConfig(type);
        this.setData();
        this.executeDefaultSkill(defaultKey);
        String success = ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"refreshData_success", (String)"scmc-msmob-form", (Object[])new Object[0]);
        ((MobileFormView)this.getView()).setRefreshResult(success, Integer.valueOf(3000), RefreshResultType.Success);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        this.executeSkill(itemKey);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        this.clickExecuteSkill(key);
    }

    public void clickExecuteSkill(String key) {
        String keyStr = this.getView().getPageCache().get("buttonKeyMap");
        if (StringUtils.isNotBlank((CharSequence)keyStr)) {
            Map hashMap = (Map)JSON.parseObject((String)keyStr, Map.class);
            String realKey = (String)hashMap.get(key);
            this.executeSkill(realKey);
        }
    }

    public void executeSkill(String key) {
        String classPath = this.getSkillPluginClassPath(key);
        ISkill operationInstance = OperationHandleHelper.getOperationInstance(classPath);
        QrCodeResult parseResult = this.getParseResult();
        operationInstance.handle(this.getView(), parseResult);
    }

    private void handleVisible() {
        IFormView view = this.getView();
        String keyStr = view.getPageCache().get("buttonKeys");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_skill", "bar_two_skills", "bar_three_skills", "bar_more_skills"});
        if (StringUtils.isNotBlank((CharSequence)keyStr)) {
            List buttons = (List)JSON.parseObject((String)keyStr, ArrayList.class);
            view.setVisible(Boolean.valueOf(true), buttons.toArray(new String[0]));
        }
    }
}

