/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.optpl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.service.mservice.baseset.impl.DataSourceConfigServiceImpl;
import kd.sdk.mpscmm.msmob.expoint.IMobOperationDataTransferPlugin;

public abstract class BaseTplOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(BaseTplOp.class);

    protected abstract String getOperationKey();

    protected DynamicObject processEntity(DynamicObject mobEntity, DynamicObject pcEntity) {
        LOG.debug("\u5904\u7406\u5b9e\u4f53\u6570\u636e\uff0c\u79fb\u52a8\u6570\u636e\uff1a{}\uff0cPC\u5b9e\u4f53\u6570\u636e\uff1a{}", (Object)mobEntity, (Object)pcEntity);
        return pcEntity;
    }

    protected void processOperationResult(OperationResult operationResult) {
        LOG.debug("\u5904\u7406\u64cd\u4f5c\u7ed3\u679c\uff0c \u64cd\u4f5c\u7ed3\u679c\uff1a {}", (Object)operationResult);
        if (operationResult != null) {
            String showFormId;
            InteractionContext context = operationResult.getInteractionContext();
            this.operationResult.setMessage(operationResult.getMessage());
            this.operationResult.setInteractionContext(context);
            if (context != null && (showFormId = context.getCustShowFormId()).equals("im_bal_opresult")) {
                String simpleMessage = context.getSimpleMessage();
                this.operationResult.setMessage(simpleMessage);
                this.operationResult.setInteractionContext(null);
            }
            this.operationResult.setSponsor(operationResult.getSponsor());
            this.operationResult.setFinishedTime(operationResult.getFinishedTime());
            this.operationResult.setStartTime(operationResult.getStartTime());
            this.operationResult.setValidateResult(operationResult.getValidateResult());
            this.operationResult.setAllErrorInfo(operationResult.getAllErrorInfo());
            this.operationResult.setBillCount(operationResult.getBillCount());
            this.operationResult.setBillNos(operationResult.getBillNos());
            this.operationResult.setClearText(operationResult.getClearText());
            this.operationResult.setSuccessPkIds(operationResult.getSuccessPkIds());
            this.operationResult.setSuccess(operationResult.isSuccess());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = this.getOperationKey();
        DataSourceConfigServiceImpl dataSourceConfigService = new DataSourceConfigServiceImpl();
        String mobFormKey = dataEntities[0].getDynamicObjectType().getName();
        DataSourceConfig dataSourceConfig = dataSourceConfigService.getDataSourceConfig(mobFormKey);
        String pcEntityKey = dataSourceConfig.getPcEntityKey();
        boolean canExecuteWithId = this.canExecuteWithId();
        try {
            OperationResult operationResult = canExecuteWithId ? this.executeWithId(operationKey, pcEntityKey, dataEntities) : this.executeWithEntity(operationKey, pcEntityKey, dataEntities);
            this.processOperationResult(operationResult);
        }
        catch (Exception exception) {
            Throwable exp;
            for (exp = exception.getCause(); exp != null && !(exp instanceof KDBizException); exp = exp.getCause()) {
            }
            if (exp == null) {
                throw exception;
            }
            LOG.info(String.format("\u79fb\u52a8\u4e2d\u53f0\u8c03\u7528\u5fae\u670d\u52a1\u51fa\u73b0\u5f02\u5e38\uff1a%1$s\uff0coperationKey\uff1a%2$s\uff0cpcEntityKey\uff1a%3$s", exp, operationKey, pcEntityKey));
            throw (KDBizException)exp;
        }
    }

    protected boolean canExecuteWithId() {
        String operationKey;
        switch (operationKey = this.getOperationKey()) {
            case "delete": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                return true;
            }
        }
        return false;
    }

    private OperationResult executeWithId(String operationKey, String pcEntityKey, DynamicObject[] dataEntities) {
        ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Long billId = dataEntity.getLong("billId");
            ids.add(billId);
        }
        LOG.info("\u6839\u636eID\u6267\u884c\uff0c ID\u5217\u8868\uff1a {}", ids);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)pcEntityKey, (Object[])ids.toArray(), (OperateOption)this.getOperateOption());
        return operationResult;
    }

    private OperationResult executeWithEntity(String operationKey, String pcEntityKey, DynamicObject[] dataEntities) {
        final OperateOption operateOption = this.getOperateOption();
        PluginProxy pluginProxy = PluginProxy.create((Object)new IMobOperationDataTransferPlugin(){

            public DynamicObject executeWithEntity(String operationKey, String pcEntityKey, DynamicObject dataEntity) {
                String pcEntityCacheStr = operateOption.getVariableValue("pcEntityCache");
                if (StringUtils.isEmpty((CharSequence)pcEntityCacheStr)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u4e2d\u65e0\u6cd5\u627e\u5230\u7f13\u5b58\u7684PC\u5355\u636e\u3002", (String)"Exception_pc_entity_not_found_error", (String)"scmc-msmob-form", (Object[])new Object[0]), new Object[0]));
                }
                return EntityCacheHelper.deserializeFromStringToEntity(pcEntityCacheStr, (IDataEntityType)MetadataServiceHelper.getDataEntityType((String)pcEntityKey));
            }
        }, IMobOperationDataTransferPlugin.class, (String)IMobOperationDataTransferPlugin.class.getName(), null);
        DynamicObject mobileEntity = dataEntities == null || dataEntities.length == 0 ? null : dataEntities[0];
        List objects = pluginProxy.callReplaceIfPresent(p -> {
            DynamicObject dynamicObject = p.executeWithEntity(operationKey, pcEntityKey, mobileEntity);
            return dynamicObject;
        });
        DynamicObject pcEntity = (DynamicObject)objects.get(objects.size() - 1);
        pcEntity = this.processEntity(mobileEntity, pcEntity);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)pcEntityKey, (DynamicObject[])new DynamicObject[]{pcEntity}, (OperateOption)operateOption);
        return operationResult;
    }

    protected DynamicObject beforeExeOpAfterDelEntryRows(DynamicObject mobEntity, DynamicObject pcEntity) {
        return pcEntity;
    }

    protected void delEntryRows(DynamicObject pcEntity, OperateOption option) {
        Long billId = pcEntity.getLong("id");
    }

    protected OperateOption getOperateOption() {
        OperateOption option = this.getOption();
        option.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
        option.setVariableValue("ishasright", String.valueOf(false));
        return option;
    }
}

