/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.plugin.tpl.optpl.botp;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.msmob.business.helper.BotpHelper;

public abstract class BotpPushTplOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(BotpPushTplOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List<ListSelectedRow> selectedRows = this.getSelectedRows(dataEntities);
        try (TraceSpan botpPushSpan = Tracer.create((String)"BotpHelper", (String)"push");){
            LOG.debug("\u5f00\u59cb\u4e0b\u63a8\uff0c\u6e90\u5355\uff1a{}, \u76ee\u6807\u5355\uff1a{}\u4e0b\u63a8\u6570\u91cf\uff1a {}", new Object[]{this.getSrcEntityKey(), this.getTargetEntityKey(), selectedRows.size()});
            ConvertOperationResult convertResult = BotpHelper.push(this.getSrcEntityKey(), this.getTargetEntityKey(), selectedRows);
            this.processConvertResult(convertResult);
        }
    }

    public abstract List<ListSelectedRow> getSelectedRows(DynamicObject[] var1);

    public abstract String getSrcEntityKey();

    public abstract String getTargetEntityKey();

    public void processConvertResult(ConvertOperationResult convertResult) {
        OperationResult operationResult = this.getOperationResult();
        LOG.debug("\u5904\u7406\u64cd\u4f5c\u7ed3\u679c\uff0c \u64cd\u4f5c\u7ed3\u679c\uff1a {}", (Object)convertResult);
        if (convertResult == null) {
            operationResult.setSuccess(false);
            return;
        }
        this.operationResult.setFinishedTime(convertResult.getFinishedTime());
        this.operationResult.setStartTime(convertResult.getStartTime());
        this.operationResult.setMessage(convertResult.getMessage());
        this.operationResult.setSuccessPkIds(convertResult.getTargetBillIds().stream().collect(Collectors.toList()));
        this.operationResult.setSuccess(true);
        OperateOption operateOption = this.getOption();
        operateOption.setVariableValue("convertResult", SerializationUtils.toJsonString((Object)convertResult));
    }
}

