/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.report.filter;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.util.StringUtils;

public class MobInputFilterSchemeNamePlugin
extends AbstractMobBillPlugIn {
    private static final String CANCEL_BTN = "cancelbtn";
    private static final String CONFIRM_BTN = "confirmbtn";
    private static final String NAME = "name";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CANCEL_BTN, CONFIRM_BTN});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object name = formShowParameter.getCustomParam(NAME);
        if (name != null && StringUtils.isNotEmpty((String)String.valueOf(name))) {
            this.getModel().setValue(NAME, name);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "cancelbtn": {
                this.cancelOp();
                break;
            }
            case "confirmbtn": {
                this.confirmOp();
                break;
            }
        }
    }

    private void confirmOp() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        Object name = this.getModel().getValue(NAME);
        map.put(NAME, name == null ? "" : String.valueOf(name));
        map.put("type", "1");
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private void cancelOp() {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("type", "0");
        this.getView().returnDataToParent(map);
        this.getView().close();
    }
}

