/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.service.mservice.baseset.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.business.helper.change.MetaResolveHelper;
import kd.scmc.msmob.business.helper.change.MobilePageRelation;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.EntryMappingRelationship;
import kd.scmc.msmob.pojo.PropertyNode;
import kd.scmc.msmob.service.mservice.baseset.IDataSourceConfigService;

public class DataSourceConfigServiceImpl
implements IDataSourceConfigService {
    private static final Log log = LogFactory.getLog(DataSourceConfigServiceImpl.class);
    private static final String SELECT_FIELDS = "mobform,pcentityobject,entryentity.mobfieldkey,entryentity.pcfieldkey,entryentity.pcfieldminlen,entryentity.mobfieldminlen,entryentity.mobentrykey,entryentity.pcfieldmaxlen,entryentity.mobfieldmaxlen,searchkeyentry.searchfieldkey,entrymappingentity.mob_entryidkey,entrymappingentity.mob_entrykey,entrymappingentity.pc_entryidkey,entrymappingentity.pc_entrykey";

    @Override
    public DataSourceConfig getDataSourceConfig(String mobFormKey) {
        log.info("\u201cDataSourceConfigServiceImpl\u201d\u7c7b\u8c03\u7528\u7684\u201cgetDataSourceConfig\u201d\u65b9\u6cd5\u7684\u5165\u53c2\u201cmobFormKey\u201d\uff1a{}", (Object)mobFormKey);
        if (StringUtils.isEmpty((CharSequence)mobFormKey)) {
            String errMsg = ResManager.loadKDString((String)"\u201cDataSourceConfigServiceImpl\u201d\u7c7b\u8c03\u7528\u7684\u201cgetDataSourceConfig\u201d\u65b9\u6cd5\u7684\u5165\u53c2\u201cmobFormKey\u201d\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataSourceConfigServiceImpl_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        if (!MetaUtils.isExistsMeta(mobFormKey)) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u9875\u9762\u5143\u6570\u636e\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataSourceConfigServiceImpl_notExists", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFormKey);
            log.warn("\u9875\u9762\u5143\u6570\u636e\u201c%s\u201d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (Object)mobFormKey);
            throw new KDBizException(errMsg);
        }
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("mobform.number", "=", (Object)mobFormKey);
        DynamicObject dataSrcConfig = BusinessDataServiceHelper.loadSingle((String)"mob_datasourceconfig", (String)SELECT_FIELDS, (QFilter[])qFilter.toArray());
        if (dataSrcConfig == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u201c%s\u201d\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u6216\u542f\u7528\u8be5\u79fb\u52a8\u8868\u5355\u7684\u6570\u636e\u6e90\u914d\u7f6e\u3002", (String)"DataSourceConfigServiceImpl_1", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFormKey);
            log.warn("\u79fb\u52a8\u8868\u5355\u201c{}\u201d\u5bf9\u5e94\u7684\u6570\u636e\u6e90\u914d\u7f6e\u4e3a\u7a7a\u6216\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u7ef4\u62a4\u6216\u542f\u7528\u8be5\u79fb\u52a8\u8868\u5355\u7684\u6570\u636e\u6e90\u914d\u7f6e\u3002", (Object)mobFormKey);
            throw new KDBizException(errMsg);
        }
        DynamicObject pcEntity = dataSrcConfig.getDynamicObject("pcentityobject");
        String pcEntityObjKey = pcEntity.getString("number");
        DynamicObjectCollection entryRows = dataSrcConfig.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection searchKeyEntryRows = dataSrcConfig.getDynamicObjectCollection("searchkeyentry");
        DynamicObjectCollection entryMappingColl = dataSrcConfig.getDynamicObjectCollection("entrymappingentity");
        Map<String, PropertyNode> pcPropNodeMap = DataSourceConfigHelper.getPcPropNodeMap(pcEntityObjKey);
        Map<String, PropertyNode> fieldMapping = this.buildFieldMapping(mobFormKey, pcEntityObjKey, pcPropNodeMap, entryRows);
        List<String> searchFieldKeys = this.getSearchFieldKeys(pcEntityObjKey, mobFormKey, pcPropNodeMap, searchKeyEntryRows);
        List<EntryMappingRelationship> entryMappingRelationships = this.getEntryMappingRelationships(entryMappingColl);
        Map<String, List<String>> mobEntryKeyToFiledKeys = this.getMobEntryKeyToFiledKeys(dataSrcConfig);
        dataSourceConfig.setMobFormKey(mobFormKey);
        dataSourceConfig.setPcEntityKey(pcEntityObjKey);
        dataSourceConfig.setFieldMapping(fieldMapping);
        dataSourceConfig.setEntryMappingRelationships(entryMappingRelationships);
        dataSourceConfig.setSearchFieldKeys(searchFieldKeys);
        dataSourceConfig.setMobEntryKeyToFieldKeys(mobEntryKeyToFiledKeys);
        return dataSourceConfig;
    }

    private List<EntryMappingRelationship> getEntryMappingRelationships(DynamicObjectCollection entryMappingColl) {
        ArrayList<EntryMappingRelationship> entryMappingRelations = new ArrayList<EntryMappingRelationship>(10);
        if (entryMappingColl == null || entryMappingColl.isEmpty()) {
            return entryMappingRelations;
        }
        for (DynamicObject entryMappingRelation : entryMappingColl) {
            EntryMappingRelationship entryMappingRelationship = new EntryMappingRelationship();
            String mobEntryKey = entryMappingRelation.getString("mob_entrykey");
            String mobEntryIdKey = entryMappingRelation.getString("mob_entryidkey");
            String pcEntryKey = entryMappingRelation.getString("pc_entrykey");
            String pcEntryIdKey = entryMappingRelation.getString("pc_entryidkey");
            entryMappingRelationship.setMobEntryKey(mobEntryKey);
            entryMappingRelationship.setMobEntryIdKey(mobEntryIdKey);
            entryMappingRelationship.setPcEntryKey(pcEntryKey);
            entryMappingRelationship.setPcEntryIdKey(pcEntryIdKey);
            entryMappingRelations.add(entryMappingRelationship);
        }
        return entryMappingRelations;
    }

    private Map<String, List<String>> getMobEntryKeyToFiledKeys(DynamicObject dataSrcConfig) {
        DynamicObjectCollection entryColl = dataSrcConfig.getDynamicObjectCollection("entryentity");
        String mobileFormKey = dataSrcConfig.get("mobform.number").toString();
        MobilePageRelation mobilePageRelation = MetaResolveHelper.resolveMobilePage(mobileFormKey);
        HashMap<String, List<String>> mobEntryKeyToFiledKeys = new HashMap<String, List<String>>(16);
        if (entryColl == null || entryColl.isEmpty()) {
            return mobEntryKeyToFiledKeys;
        }
        for (DynamicObject entryRow : entryColl) {
            String mobFieldKey = entryRow.getString("mobfieldkey");
            String mobEntryKey = mobilePageRelation.getEntryNameByFieldName(mobFieldKey);
            if (!StringUtils.isNotEmpty((CharSequence)mobEntryKey)) continue;
            ArrayList<String> currEntryFieldKeys = (ArrayList<String>)mobEntryKeyToFiledKeys.get(mobEntryKey);
            if (currEntryFieldKeys == null) {
                currEntryFieldKeys = new ArrayList<String>(10);
            }
            currEntryFieldKeys.add(mobFieldKey);
            mobEntryKeyToFiledKeys.put(mobEntryKey, currEntryFieldKeys);
        }
        return mobEntryKeyToFiledKeys;
    }

    private Map<String, PropertyNode> buildFieldMapping(String mobFormKey, String pcEntityObjKey, Map<String, PropertyNode> pcPropNodeMap, DynamicObjectCollection entryRows) {
        MainEntityType mobDataEntityType = MetadataServiceHelper.getDataEntityType((String)mobFormKey);
        Map mobFormAllFields = mobDataEntityType.getAllFields();
        if (mobFormAllFields == null || mobFormAllFields.size() == 0) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u201c%s\u201d\u7684\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4e3a\u8be5\u79fb\u52a8\u8868\u5355\u6dfb\u52a0\u5b57\u6bb5\u3002", (String)"DataSourceConfigServiceImpl_2", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFormKey);
            log.warn("\u79fb\u52a8\u8868\u5355\u201c{}\u201d\u7684\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u5148\u4e3a\u8be5\u79fb\u52a8\u8868\u5355\u6dfb\u52a0\u5b57\u6bb5\u3002", (Object)mobFormKey);
            throw new KDBizException(errMsg);
        }
        Set mobFormFields = mobFormAllFields.keySet();
        HashMap<String, PropertyNode> fieldMapping = new HashMap<String, PropertyNode>(16);
        for (int i = 0; i < entryRows.size(); ++i) {
            DynamicObject entryRow = (DynamicObject)entryRows.get(i);
            String mobFieldKey = entryRow.getString("mobfieldkey");
            if (!mobFormFields.contains(mobFieldKey)) {
                log.warn("\u79fb\u52a8\u8868\u5355\u201c{}\u201d\u7684\u5b57\u6bb5\u201c{}\u201d\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u5373\u65f6\u7ef4\u62a4\u8be5\u79fb\u52a8\u8868\u5355\u7684\u6570\u636e\u6e90\u914d\u7f6e\u3002", (Object)mobFormKey, (Object)mobFieldKey);
                continue;
            }
            String pcFieldKey = entryRow.getString("pcfieldkey");
            PropertyNode pcPropNode = pcPropNodeMap.get(pcFieldKey);
            if (pcPropNode == null) {
                log.warn("PC\u7aef\u5b9e\u4f53\u201c{}\u201d\u7684\u5b57\u6bb5\u201c{}\u201d\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u5373\u65f6\u7ef4\u62a4\u79fb\u52a8\u8868\u5355\u201c{}\u201d\u7684\u6570\u636e\u6e90\u914d\u7f6e\u3002", new Object[]{pcEntityObjKey, pcFieldKey, mobFormKey});
                continue;
            }
            IMetadata pcFieldType = pcPropNode.getType();
            IDataEntityProperty mobFieldType = (IDataEntityProperty)mobFormAllFields.get(mobFieldKey);
            if (!DataSourceConfigHelper.checkTypeExcepted((IMetadata)mobFieldType, pcFieldType)) {
                log.warn("\u79fb\u52a8\u8868\u5355\u5b57\u6bb5\u201c{}\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u5b57\u6bb5\u201c{}\u201d\u7684\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u79fb\u52a8\u8868\u5355\u201c{}\u201d\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c\u201c{}\u201d\u884c\u4fe1\u606f\u6216\u4fee\u6539\u79fb\u52a8\u8868\u5355\u5b57\u6bb5\u201c{}\u201d\u7684\u7c7b\u578b\u3002", new Object[]{mobFieldKey, pcFieldKey, mobFormKey, i + 1, mobFieldKey});
                String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u5b57\u6bb5\u201c%1$s\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u5b57\u6bb5\u201c%2$s\u201d\u7684\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u79fb\u52a8\u8868\u5355\u201c%3$s\u201d\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c\u201c%4$s\u201d\u884c\u4fe1\u606f\u6216\u4fee\u6539\u79fb\u52a8\u8868\u5355\u5b57\u6bb5\u201c%5$s\u201d\u7684\u7c7b\u578b\u3002\n", (String)"DataSourceConfigSubmitValidator_2", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFieldKey, pcFieldKey, mobFormKey, i + 1, mobFieldKey);
                throw new KDBizException(errMsg);
            }
            this.checkTxtFieldLen(entryRow, (IMetadata)mobFieldType, pcFieldType, mobFormKey, i);
            fieldMapping.put(mobFieldKey, pcPropNode);
        }
        return fieldMapping;
    }

    private void checkTxtFieldLen(DynamicObject entryRow, IMetadata mobFieldType, IMetadata pcFieldType, String mobFormKey, int entryRowIndex) {
        int mobFieldMinLen;
        if (!(mobFieldType instanceof TextProp) || !(pcFieldType instanceof TextProp)) {
            return;
        }
        String pcFieldKey = entryRow.getString("pcfieldkey");
        String mobFieldKey = entryRow.getString("mobfieldkey");
        TextProp pcTextProp = (TextProp)pcFieldType;
        TextProp mobTextProp = (TextProp)mobFieldType;
        int pcFieldMinLen = pcTextProp.getMinLenth();
        if (pcFieldMinLen != (mobFieldMinLen = mobTextProp.getMinLenth())) {
            log.warn("\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c{}\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u6587\u672c\u5b57\u6bb5\u201c{}\u201d\u7684\u201c\u6700\u5c0f\u957f\u5ea6{}\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u79fb\u52a8\u8868\u5355\u201c{}\u201d\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c\u201c{}\u201d\u884c\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c{}\u201d\u7684\u201c\u6700\u5c0f\u957f\u5ea6\u201d\u3002", new Object[]{mobFieldKey, pcFieldKey, pcFieldMinLen, mobFormKey, entryRowIndex + 1, mobFieldKey});
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%1$s\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u6587\u672c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u201c\u6700\u5c0f\u957f\u5ea6[%3$s]\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u79fb\u52a8\u8868\u5355\u201c%4$s\u201d\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c\u201c%5$s\u201d\u884c\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%6$s\u201d\u7684\u201c\u6700\u5c0f\u957f\u5ea6\u201d\u3002", (String)"DataSourceConfigSubmitValidator_3", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFieldKey, pcFieldKey, pcFieldMinLen, mobFormKey, entryRowIndex + 1, mobFieldKey);
            throw new KDBizException(errMsg);
        }
        int pcFieldMaxLen = pcTextProp.getMaxLenth();
        int mobFieldMaxLen = mobTextProp.getMaxLenth();
        if (mobFieldMaxLen != pcFieldMaxLen) {
            log.warn("\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c{}\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u6587\u672c\u5b57\u6bb5\u201c{}\u201d\u7684\u201c\u6700\u5927\u957f\u5ea6{}\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u79fb\u52a8\u8868\u5355\u201c{}\u201d\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c\u201c{}\u201d\u884c\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c{}\u201d\u7684\u201c\u6700\u5927\u957f\u5ea6\u201d\u3002", new Object[]{mobFieldKey, pcFieldKey, pcFieldMaxLen, mobFormKey, entryRowIndex + 1, mobFieldKey});
            String errMsg = String.format(ResManager.loadKDString((String)"\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%1$s\u201d\u4e0ePC\u7aef\u5b9e\u4f53\u6587\u672c\u5b57\u6bb5\u201c%2$s\u201d\u7684\u201c\u6700\u5927\u957f\u5ea6[%3$s]\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u79fb\u52a8\u8868\u5355\u201c%4$s\u201d\u7684\u201c\u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u201d\u7b2c\u201c%5$s\u201d\u884c\u79fb\u52a8\u8868\u5355\u6587\u672c\u5b57\u6bb5\u201c%6$s\u201d\u7684\u201c\u6700\u5927\u957f\u5ea6\u201d\u3002", (String)"DataSourceConfigSubmitValidator_4", (String)"scmc-msmob-form", (Object[])new Object[0]), mobFieldKey, pcFieldKey, pcFieldMaxLen, mobFormKey, entryRowIndex + 1, mobFieldKey);
            throw new KDBizException(errMsg);
        }
    }

    private List<String> getSearchFieldKeys(String mobFormKey, String pcEntityKey, Map<String, PropertyNode> pcPropNodeMap, DynamicObjectCollection searchFieldEntry) {
        ArrayList<String> searchFieldKeys = new ArrayList<String>(10);
        if (searchFieldEntry == null || searchFieldEntry.isEmpty()) {
            return searchFieldKeys;
        }
        for (DynamicObject searchField : searchFieldEntry) {
            String searchFieldKey = searchField.getString("searchfieldkey");
            if (!StringUtils.isNotEmpty((CharSequence)searchFieldKey)) continue;
            PropertyNode pcPropNode = pcPropNodeMap.get(searchFieldKey);
            if (pcPropNode == null) {
                log.warn("PC\u7aef\u5b9e\u4f53\u201c{}\u201d\u7684\u5b57\u6bb5\u201c{}\u201d\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u5373\u65f6\u7ef4\u62a4\u79fb\u52a8\u8868\u5355\u201c{}\u201d\u7684\u6570\u636e\u6e90\u914d\u7f6e\u3002", new Object[]{pcEntityKey, searchFieldKey, mobFormKey});
                continue;
            }
            searchFieldKeys.add(searchFieldKey);
        }
        return searchFieldKeys;
    }
}

