/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.service.mservice.mobdata.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.ORMException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.QFilterHint;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.scmc.msmob.business.helper.MobileBusinessDataServiceHelper;
import kd.scmc.msmob.common.consts.DateRange;
import kd.scmc.msmob.common.consts.FilterConstructor;
import kd.scmc.msmob.common.consts.SearchConstructor;
import kd.scmc.msmob.common.enums.BillSortType;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.FilterCondition;
import kd.scmc.msmob.pojo.PropertyNode;
import kd.scmc.msmob.service.mservice.baseset.IDataSourceConfigService;
import kd.scmc.msmob.service.mservice.baseset.impl.DataSourceConfigServiceImpl;
import kd.scmc.msmob.service.mservice.mobdata.IMobDataService;
import kd.scmc.msmob.service.mservice.mobdata.PageRequest;
import kd.scmc.msmob.service.mservice.mobdata.PageResult;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class MobDataServiceImpl
implements IMobDataService {
    private static final Log log = LogFactory.getLog(MobDataServiceImpl.class);
    public static final int DEFAULT_SIZE = 100;
    private IDataSourceConfigService dataSourceConfigService;

    @Override
    public DynamicObject[] loadData(String mobBillKey, FilterConstructor filterConstructor) {
        return this.loadData(mobBillKey, filterConstructor, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DynamicObject[] loadData(String mobBillKey, FilterConstructor filterConstructor, DataSourceConfig dataSourceConfig) {
        if (filterConstructor == null) {
            log.info("\u53c2\u6570\u201cfilterConstructor\u201d\u4e3anull");
            filterConstructor = new FilterConstructor();
        }
        try (TraceSpan span = Tracer.create((String)"MobDataServiceImpl", (String)"loadData");){
            DynamicObject[] result;
            log.info("\u53c2\u6570\u201cfilterConstructor\u201d: \u641c\u7d22\u5185\u5bb9\u201c{}\u201d\uff0c\u8fc7\u6ee4\u5185\u5bb9\u201c{}\u201d\uff0c\u6392\u5e8f\u5185\u5bb9\u201c{}\u201d", new Object[]{filterConstructor.getSearch(), filterConstructor.getFilters(), filterConstructor.getSort()});
            if (dataSourceConfig == null) {
                dataSourceConfig = this.getDataSourceConfig(mobBillKey);
            }
            Map<String, PropertyNode> fieldMapping = this.getFieldMapping(dataSourceConfig);
            Collection<PropertyNode> pcFieldPropNodes = fieldMapping.values();
            String selectFields = this.createSelectFields(pcFieldPropNodes);
            QFilter qFilter = this.createFilter(fieldMapping, filterConstructor);
            String orderBy = this.createOrderBy(filterConstructor);
            log.info("\u53c2\u6570\u201cload\u201d: \u641c\u7d22key\u201c{}\u201d\uff0c\u641c\u7d22\u5b57\u6bb5\u201c{}\u201d\uff0c\u8fc7\u6ee4\u6761\u4ef6\u201c{}\u201d\uff0c\u6392\u5e8f\u201c{}\u201d\uff0c\u67e5\u8be2\u6761\u6570\u201c{}\u201d", new Object[]{dataSourceConfig.getPcEntityKey(), selectFields, ArrayUtils.toString((Object)qFilter.toArray()), orderBy, 100});
            String appId = MetadataServiceHelper.getDataEntityType((String)dataSourceConfig.getMobFormKey()).getAppId();
            if (filterConstructor.isLoadWithPermission()) {
                DynamicObject[] result2;
                DynamicObject[] dynamicObjectArray = result2 = BusinessDataServiceHelper.loadWithPermission((String)dataSourceConfig.getPcEntityKey(), (String)selectFields, (QFilter[])qFilter.toArray(), (String)orderBy, (int)100, (String)appId);
                return dynamicObjectArray;
            }
            DynamicObject[] dynamicObjectArray = result = BusinessDataServiceHelper.load((String)dataSourceConfig.getPcEntityKey(), (String)selectFields, (QFilter[])qFilter.toArray(), (String)orderBy, (int)100);
            return dynamicObjectArray;
        }
        catch (ORMException ormException) {
            MobDataServiceImpl.handleException(ormException);
            throw ormException;
        }
    }

    private static void handleException(ORMException ormException) {
        String code;
        log.warn((Throwable)ormException);
        ErrorCode errorCode = ormException.getErrorCode();
        if (errorCode != null && "excessiveInParameters".equals(code = errorCode.getCode())) {
            String errMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u7f29\u5c0f\u67e5\u8be2\u8303\u56f4\u3002", (String)"MobDataServiceImpl_in_too_big", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
    }

    @Override
    public PageResult loadDataPage(String mobBillKey, FilterConstructor filterConstructor, DataSourceConfig dataSourceConfig, PageRequest page) {
        DynamicObject[] dynamicObjects;
        int dataCount;
        int pageIndex = page.getPageIndex();
        int pageSize = Math.min(page.getPageSize(), 100);
        try (TraceSpan span = Tracer.create((String)"MobDataServiceImpl", (String)"loadDataPage");){
            if (dataSourceConfig == null) {
                dataSourceConfig = this.getDataSourceConfig(mobBillKey);
            }
            Map<String, PropertyNode> fieldMapping = this.getFieldMapping(dataSourceConfig);
            Collection<PropertyNode> pcFieldPropNodes = fieldMapping.values();
            String selectFields = this.createSelectFields(pcFieldPropNodes);
            QFilter qFilter = this.createFilter(fieldMapping, filterConstructor);
            String orderBy = this.createOrderBy(filterConstructor);
            log.info("\u53c2\u6570\u201cloadDataPage\u201d: \u641c\u7d22key\u201c{}\u201d\uff0c\u641c\u7d22\u5b57\u6bb5\u201c{}\u201d\uff0c\u8fc7\u6ee4\u6761\u4ef6\u201c{}\u201d\uff0c\u6392\u5e8f\u201c{}\u201d\u201d", new Object[]{dataSourceConfig.getPcEntityKey(), selectFields, ArrayUtils.toString((Object)qFilter.toArray()), orderBy});
            String appId = MetadataServiceHelper.getDataEntityType((String)dataSourceConfig.getMobFormKey()).getAppId();
            if (filterConstructor.isLoadWithPermission()) {
                dataCount = MobileBusinessDataServiceHelper.countWithPermission(dataSourceConfig.getPcEntityKey(), qFilter.toArray(), appId);
                dynamicObjects = MobileBusinessDataServiceHelper.loadWithPermission(dataSourceConfig.getPcEntityKey(), selectFields, qFilter.toArray(), orderBy, pageIndex, pageSize, appId);
            } else {
                dataCount = MobileBusinessDataServiceHelper.count(dataSourceConfig.getPcEntityKey(), qFilter.toArray());
                dynamicObjects = BusinessDataServiceHelper.load((String)dataSourceConfig.getPcEntityKey(), (String)selectFields, (QFilter[])qFilter.toArray(), (String)orderBy, (int)pageIndex, (int)pageSize);
            }
        }
        catch (ORMException ormException) {
            MobDataServiceImpl.handleException(ormException);
            throw ormException;
        }
        PageResult pageResult = new PageResult();
        pageResult.setData(dynamicObjects);
        pageResult.setCount(Math.min(dataCount, 100));
        pageResult.setPageRequest(page);
        return pageResult;
    }

    private DataSourceConfig getDataSourceConfig(String mobBill) {
        try (TraceSpan span = Tracer.create((String)"MobDataServiceImpl", (String)"getDataSourceConfig");){
            log.debug("\u6267\u884c\u65b9\u6cd5\u201cgetDataSourceConfig\u201d\u64cd\u4f5cmobBill\u201c{}\u201d", (Object)mobBill);
            IDataSourceConfigService dataSourceConfigService = this.getDataSourceConfigService();
            DataSourceConfig dataSourceConfig = dataSourceConfigService.getDataSourceConfig(mobBill);
            if (dataSourceConfig == null) {
                String errMsg = ResManager.loadKDString((String)"\u8be5\u8868\u5355\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\uff0c\u5c06\u83b7\u53d6\u4e0d\u5230\u6570\u636e\u3002", (String)"MobDataServiceImpl_2", (String)"scmc-msmob-form", (Object[])new Object[0]);
                log.info("\u6267\u884c\u65b9\u6cd5\u201cgetDataSourceConfig\u201ddataSourceConfig \u4e3anull\u201c{}\u201d", (Object)mobBill);
                throw new KDBizException(errMsg);
            }
            log.info("\u6267\u884c\u65b9\u6cd5\u201cgetDataSourceConfig\u201d\u7ed3\u675f,\u83b7\u53d6dataSourceConfig \u79fb\u52a8\u8868\u540d\u79f0\u201c{}\u201d\uff0cpc\u8868\u540d\u79f0\u201c{}\u201d\uff0c\u6620\u5c04\u5b57\u6bb5\u6570\u91cf\u201c{}\u201d", new Object[]{dataSourceConfig.getMobFormKey(), dataSourceConfig.getPcEntityKey(), dataSourceConfig.getFieldMapping()});
            DataSourceConfig dataSourceConfig2 = dataSourceConfig;
            return dataSourceConfig2;
        }
    }

    private Map<String, PropertyNode> getFieldMapping(DataSourceConfig config) {
        Map<String, PropertyNode> fieldMapping = config.getFieldMapping();
        if (fieldMapping == null || fieldMapping.isEmpty()) {
            String errMsg = ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\u65e0\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u5355\u636e\u7684\u6620\u5c04\u914d\u7f6e\u3002", (String)"MobDataServiceImpl_1", (String)"scmc-msmob-form", (Object[])new Object[0]);
            throw new KDBizException(errMsg);
        }
        return fieldMapping;
    }

    private String createSelectFields(Collection<PropertyNode> pcFieldPropNodes) {
        try (TraceSpan span = Tracer.create((String)"MobDataServiceImpl", (String)"createSelectFields");){
            ArrayList<String> strings = new ArrayList<String>(pcFieldPropNodes.size());
            for (PropertyNode propertyNode : pcFieldPropNodes) {
                this.addEntityTypeField(propertyNode, strings);
            }
            String string = strings.stream().collect(Collectors.joining(","));
            return string;
        }
    }

    private void addEntityTypeField(PropertyNode propertyNode, List<String> strings) {
        PropertyNode parentNode = propertyNode.getParentNode();
        if (parentNode.getType() instanceof MainEntityType) {
            strings.add(propertyNode.getFieldKey());
            return;
        }
        if (parentNode.getType() instanceof EntityType) {
            strings.add(propertyNode.getFieldKey());
            return;
        }
        if (parentNode.getType() instanceof SubEntryType) {
            strings.add(propertyNode.getFieldKey());
            return;
        }
        this.addEntityTypeField(parentNode, strings);
    }

    private QFilter createFilter(Map<String, PropertyNode> fieldMapping, FilterConstructor filterConstructor) {
        try (TraceSpan span = Tracer.create((String)"MobDataServiceImpl", (String)"createFilter");){
            List<FilterCondition> filters;
            QFilter qFilter = new QFilter("1", "=", (Object)1);
            SearchConstructor search = filterConstructor.getSearch();
            if (search != null && !StringUtils.isEmpty((CharSequence)search.getSearchText())) {
                List<String> fields = search.getFields();
                QFilter fLikeFilter = QFilter.ftlike((String)search.getSearchText(), (String[])fields.toArray(new String[0]));
                fLikeFilter.setQFilterHint((QFilterHint)QFilterHint.FTLIKE_CONTAINS);
                qFilter.and(fLikeFilter);
            }
            if ((filters = filterConstructor.getFilters()) != null) {
                for (FilterCondition condition : filters) {
                    if (!condition.sysFilter()) {
                        qFilter.and(condition.getFilter());
                        continue;
                    }
                    PropertyNode propertyNode = fieldMapping.get(condition.getFilterKey());
                    if (condition.getFilterValue() == null || propertyNode == null) continue;
                    this.createFieldFilter(qFilter, condition, propertyNode.getFieldKey());
                }
                log.info("\u6267\u884c\u65b9\u6cd5\u201ccreateSelectFields\u201d\u7ed3\u675ffilterConstructor\u201c{}\u201d", (Object)qFilter.toArray().length);
            }
            QFilter qFilter2 = qFilter;
            return qFilter2;
        }
    }

    private void createFieldFilter(QFilter qFilter, FilterCondition condition, String field) {
        try (TraceSpan span = Tracer.create((String)"MobDataServiceImpl", (String)"createFieldFilter");){
            if (condition.getFilterValue() instanceof DynamicObjectCollection) {
                DynamicObjectCollection value = (DynamicObjectCollection)condition.getFilterValue();
                ArrayList<String> bizTypeNames = new ArrayList<String>(value.size());
                for (DynamicObject dynamicObject : value) {
                    DynamicObject bizType = dynamicObject.getDynamicObject("fbasedataid");
                    if (bizType == null) continue;
                    String bizTypeName = bizType.getString("name");
                    bizTypeNames.add(bizTypeName);
                }
                qFilter.and(field + ".name", "in", bizTypeNames);
                return;
            }
            if (condition.getFilterValue() instanceof DateRange) {
                DateRange dateRange = (DateRange)condition.getFilterValue();
                qFilter.and(new QFilter(field, ">=", (Object)dateRange.getStartDate()));
                qFilter.and(new QFilter(field, "<=", (Object)dateRange.getEndDate()));
                return;
            }
            if (condition.getFilterValue() instanceof String[]) {
                String[] value = (String[])condition.getFilterValue();
                ArrayList<String> mulComboList = new ArrayList<String>(value.length);
                for (String mulCombo : value) {
                    if (StringUtils.isEmpty((CharSequence)mulCombo)) continue;
                    mulComboList.add(mulCombo);
                }
                qFilter.and(field, "in", mulComboList);
                return;
            }
            qFilter.and(new QFilter(field, "=", (Object)condition.getFilterValue().toString()));
        }
    }

    private String createOrderBy(FilterConstructor filterConstructor) {
        try (TraceSpan span = Tracer.create((String)"MobDataServiceImpl", (String)"createOrderBy");){
            log.debug("\u6267\u884c\u65b9\u6cd5\u201ccreateOrderBy\u201dfilterConstructor\u201c{}\u201d", (Object)filterConstructor);
            StringBuilder orderBySb = new StringBuilder();
            Object orderByStr = null;
            Map<String, BillSortType> sort = filterConstructor.getSort();
            if (sort != null && !sort.isEmpty()) {
                for (Map.Entry<String, BillSortType> m : sort.entrySet()) {
                    String field = m.getKey();
                    if (field == null) continue;
                    orderBySb.append(field).append(' ').append((Object)m.getValue()).append(',');
                }
                orderByStr = orderBySb.toString().substring(0, orderBySb.length() - 1);
            }
            log.info("\u6267\u884c\u65b9\u6cd5\u201ccreateOrderBy\u201d\u7ed3\u675fsubstring\u201c{}\u201d", orderByStr);
            Iterator<Map.Entry<String, BillSortType>> iterator = orderByStr;
            return iterator;
        }
    }

    private IDataSourceConfigService getDataSourceConfigService() {
        if (this.dataSourceConfigService == null) {
            this.dataSourceConfigService = new DataSourceConfigServiceImpl();
        }
        return this.dataSourceConfigService;
    }
}

