/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.service.mservice.upgrade.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;

public class BarcodeParseUpgradeImpl
implements IUpgradeService {
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        DBRoute scmRoute = new DBRoute("scm");
        String queryParseServiceParam = "select fid from t_msmob_parseservice where fnumber = 'upgrade_data'";
        DataSet generatedParseServiceDataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)scmRoute, (String)queryParseServiceParam);
        if (generatedParseServiceDataSet.hasNext()) {
            Map<String, Object> resultMap = this.getNotUpgradedMap();
            return new UpgradeResult(resultMap);
        }
        generatedParseServiceDataSet.close();
        DBRoute sysRoute = new DBRoute("sys");
        String querySysParam = "select fdata from t_bas_sysparameter where fparamid = '2NXUHR3W9H2D'";
        DataSet dataSet = DB.queryDataSet((String)this.getClass().getName(), (DBRoute)sysRoute, (String)querySysParam);
        if (dataSet == null) {
            Map<String, Object> resultMap = this.getNotUpgradedMap();
            return new UpgradeResult(resultMap);
        }
        if (dataSet.hasNext()) {
            Row row = dataSet.next();
            String data = row.getString("fdata");
            if (data == null) {
                Map<String, Object> resultMap = this.getNotUpgradedMap();
                return new UpgradeResult(resultMap);
            }
            Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            String cloudId = (String)dataMap.get("cloudid");
            String appId = (String)dataMap.get("appid");
            String serviceName = (String)dataMap.get("servicename");
            String methodName = (String)dataMap.get("methodname");
            if (cloudId != null && appId != null && serviceName != null && methodName != null) {
                QFilter qFilter = new QFilter("priority", "is not null", null);
                DynamicObjectCollection lowPriorityConfig = QueryServiceHelper.query((String)"msmob_parseserviceconfig", (String)"priority", (QFilter[])qFilter.toArray(), (String)"priority desc", (int)1);
                int priority = ((DynamicObject)lowPriorityConfig.get(0)).getInt("priority");
                long id = DB.genLongId((String)"t_msmob_parseservice");
                String insertSql = "insert into t_msmob_parseservice (fid,fnumber,fname,fcondition,fispreset,fpriority,fstatus,fenable,fcloudid,fappid,fservicename,fmethodname,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fmasterid,fexplanation) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                Object[] params = this.buildParam(id, priority, cloudId, appId, serviceName, methodName);
                String[] pkIds = DB.genStringIds((String)"t_msmob_parseservice_l", (int)2);
                String insertLanguageSql = "insert into t_msmob_parseservice_l (fpkid,fid,flocaleid,fname,fexplanation) values (?,?,?,?,?)";
                List<Object[]> languageParams = this.buildLanguageParams(pkIds, id);
                try {
                    DB.execute((DBRoute)scmRoute, (String)insertSql, (Object[])params);
                    DB.executeBatch((DBRoute)scmRoute, (String)insertLanguageSql, languageParams);
                }
                catch (Exception e) {
                    UpgradeResult result = new UpgradeResult();
                    result.setSuccess(false);
                    String message = "database execution failed,errorInfo" + e.getMessage();
                    result.setErrorInfo(message);
                    result.setLog(message);
                    return result;
                }
                HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
                resultMap.put("info", "upgrade Success");
                resultMap.put("success", Boolean.TRUE);
                return new UpgradeResult(resultMap);
            }
        }
        dataSet.close();
        Map<String, Object> resultMap = this.getNotUpgradedMap();
        return new UpgradeResult(resultMap);
    }

    private Map<String, Object> getNotUpgradedMap() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("info", "is not need Upgrade");
        resultMap.put("success", Boolean.TRUE);
        return resultMap;
    }

    private Object[] buildParam(long id, int priority, String cloudId, String appId, String serviceName, String methodName) {
        Object[] params = new Object[]{id, "upgrade_data", ResManager.loadKDString((String)"\u7801\u89e3\u6790\u670d\u52a1\u7cfb\u7edf\u81ea\u52a8\u8fc1\u79fb\u521b\u5efa", (String)"BarcodeParseUpgradeImpl_0", (String)"scmc-msmob-form", (Object[])new Object[0]), " ", "0", priority + 1, "A", "1", cloudId, appId, serviceName, methodName, 1L, new Date(), 1L, new Date(), id, " "};
        return params;
    }

    private List<Object[]> buildLanguageParams(String[] pkIds, long id) {
        ArrayList<Object[]> list = new ArrayList<Object[]>(2);
        list.add(this.buildLanguageParam(pkIds[0], id));
        list.add(this.buildOtherLanguageParam(pkIds[1], id));
        return list;
    }

    private Object[] buildLanguageParam(String pkId, long id) {
        Object[] params = new Object[]{pkId, id, "zh_CN", ResManager.loadKDString((String)"\u7801\u89e3\u6790\u670d\u52a1\u7cfb\u7edf\u81ea\u52a8\u8fc1\u79fb\u521b\u5efa", (String)"BarcodeParseUpgradeImpl_0", (String)"scmc-msmob-form", (Object[])new Object[0]), " "};
        return params;
    }

    private Object[] buildOtherLanguageParam(String pkId, long id) {
        Object[] params = new Object[]{pkId, id, "zh_TW", ResManager.loadKDString((String)"\u78bc\u89e3\u6790\u670d\u52d9\u7cfb\u7d71\u81ea\u52d5\u9077\u79fb\u5275\u5efa", (String)"BarcodeParseUpgradeImpl_1", (String)"scmc-msmob-form", (Object[])new Object[0]), " "};
        return params;
    }
}

