/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.webapi.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppInfo;
import kd.bos.url.UrlService;
import kd.scmc.msmob.business.helper.AppParameterHelper;
import kd.scmc.msmob.webapi.helper.UnitOrgHelper;
import kd.scmc.msmob.webapi.pojo.AppEntry;
import org.apache.commons.lang.StringUtils;

public class MobileAppHelper {
    public static List<AppEntry> getAppEntryInfoList() {
        ArrayList<AppEntry> appEntryInfos = new ArrayList<AppEntry>();
        RequestContext requestContext = RequestContext.get();
        long currUserId = requestContext.getCurrUserId();
        String userType = UnitOrgHelper.getCursUserBaseType(currUserId);
        MobileAppHelper.addEmployeeApps(appEntryInfos, userType);
        MobileAppHelper.addSupplierApps(appEntryInfos, userType);
        return appEntryInfos;
    }

    private static void addEmployeeApps(ArrayList<AppEntry> appEntryInfos, String userType) {
        if ("100".equals(userType) || "300".equals(userType)) {
            appEntryInfos.add(new AppEntry(MobileAppHelper.getUrl("mobpm_homepage_v4"), MobileAppHelper.getImageUrl("/icons/mobile/shortcut_entrance/moblie_ydcg_40_40.png"), MobileAppHelper.getAppName("mobpm_homepage_v4")));
            appEntryInfos.add(new AppEntry(MobileAppHelper.getUrl("mobsm_apphome_new"), MobileAppHelper.getImageUrl("/icons/mobile/shortcut_entrance/moblie_ydxs_40_40.png"), MobileAppHelper.getAppName("mobsm_apphome_new")));
            appEntryInfos.add(new AppEntry(MobileAppHelper.getUrl("mobim_homepage_v4"), MobileAppHelper.getImageUrl("/icons/mobile/shortcut_entrance/moblie_ydkc_40_40.png"), MobileAppHelper.getAppName("mobim_homepage_v4")));
            String mallAppName = ResManager.loadKDString((String)"\u91c7\u8d2d\u5546\u57ce", (String)"MobileHomePageInfos_0", (String)"scmc-msmob-form", (Object[])new Object[0]);
            appEntryInfos.add(new AppEntry(MobileAppHelper.getUrl("mobpur_mob_mal"), MobileAppHelper.getImageUrl("/kingdee/scmc/images/mobile/icons/entrance/gylyd_cgsc_80_80.png"), mallAppName));
            appEntryInfos.add(new AppEntry(MobileAppHelper.getUrl("mobpur_homepage_v4"), MobileAppHelper.getImageUrl("/kingdee/scmc/images/mobile/icons/entrance/gylyd_cgxt_80_80.png"), MobileAppHelper.getAppName("mobpur_homepage_v4")));
        }
    }

    private static void addSupplierApps(ArrayList<AppEntry> appEntryInfos, String userType) {
        if ("200".equals(userType) || "300".equals(userType)) {
            appEntryInfos.add(new AppEntry(MobileAppHelper.getUrl("mobsp_apphomepage_new"), MobileAppHelper.getImageUrl("/kingdee/scmc/images/mobile/icons/entrance/gylyd_gysmh_80_80.png"), MobileAppHelper.getAppName("mobsp_apphomepage_new")));
        }
    }

    private static String getAppName(String homPageFormKey) {
        AppInfo appInfo = AppParameterHelper.getBizAppByFormId(homPageFormKey);
        return appInfo != null ? appInfo.getName().getLocaleValue() : "";
    }

    private static String getUrl(String homPageFormKey) {
        return UrlService.getDomainContextUrl() + "/mobile.html?form=" + homPageFormKey;
    }

    private static String getImageUrl(String imageRelativeUrl) {
        if (StringUtils.isBlank((String)imageRelativeUrl)) {
            return "";
        }
        return UrlService.getMobileDomainContextUrl() + imageRelativeUrl;
    }
}

