/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.webapi.business.reply.handler;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.webapi.business.reply.AbstractReplyHandler;
import kd.scmc.msmob.webapi.enums.QuestionType;
import kd.scmc.msmob.webapi.vo.PromptParams;
import kd.scmc.msmob.webapi.vo.Reply;

public class InventoryQueryReplyHandler
extends AbstractReplyHandler {
    @Override
    public void processText(PromptParams promptParams, Reply reply) {
        String orgId = promptParams.getOrgId();
        String materialName = reply.getText();
        QFilter qFilter = new QFilter("material.name", "=", (Object)materialName);
        qFilter.and("org", "=", (Object)Long.valueOf(orgId));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"im_inv_realbalance", (String)"baseqty,avbbaseqty,lockbaseqty,baseunit.name", (QFilter[])qFilter.toArray(), null, (int)1);
        this.processMaterialInfoReply(reply, dataSet);
    }

    private void processMaterialInfoReply(Reply reply, DataSet dataSet) {
        if (dataSet.hasNext()) {
            Row row = dataSet.next();
            HashMap<String, String> materialMap = new HashMap<String, String>(4);
            materialMap.put("baseqty", row.getBigDecimal("baseqty") != null ? row.getBigDecimal("baseqty").toPlainString() : null);
            materialMap.put("lockbaseqty", row.getBigDecimal("lockbaseqty") != null ? row.getBigDecimal("lockbaseqty").toPlainString() : null);
            materialMap.put("avbbaseqty", row.getBigDecimal("avbbaseqty") != null ? row.getBigDecimal("avbbaseqty").toPlainString() : null);
            materialMap.put("baseunit", row.getString("baseunit.name"));
            reply.setText(JSON.toJSONString(materialMap));
            return;
        }
        reply.setQuestionType(QuestionType.INVENTORY_QUERY.getCode());
        String text = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7269\u6599\u540d\u4e3a%s\u7684\u7269\u6599\u3002", (String)"InventoryQueryReplyHandler_0", (String)"scmc-msmob-form", (Object[])new Object[0]), reply.getText());
        reply.setText(text);
    }
}

