/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.webapi.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.portal.util.ImageUtil;
import kd.scmc.msmob.webapi.business.helper.MobileAppHelper;
import kd.scmc.msmob.webapi.pojo.AppEntry;
import kd.scmc.msmob.webapi.pojo.ChatMessage;
import kd.scmc.msmob.webapi.pojo.OrgInfo;
import kd.scmc.msmob.webapi.pojo.PageInfo;
import kd.scmc.msmob.webapi.service.imp.UserInfoServiceImpl;
import kd.scmc.msmob.webapi.vo.QueryOrgParam;

@ApiController(value="msmob", desc="\u5e93\u5b58\u7ec4\u7ec7\u83b7\u53d6\u5904\u7406")
@ApiMapping(value="userInfo")
public class UserInfoController {
    private static final Log log = LogFactory.getLog(UserInfoController.class);

    @ApiGetMapping(value="getInitUserInfo")
    public CustomApiResult<Map<String, String>> getInitUserInfo() {
        UserInfoServiceImpl userInfoService = new UserInfoServiceImpl();
        OrgInfo orgInfo = userInfoService.getDefaultOrg();
        RequestContext requestContext = RequestContext.get();
        HashMap<String, String> userInfo = new HashMap<String, String>(4);
        userInfo.put("orgId", orgInfo.getOrgId());
        userInfo.put("orgNumber", orgInfo.getOrgNumber());
        userInfo.put("orgName", orgInfo.getOrgName());
        userInfo.put("userId", String.valueOf(requestContext.getCurrUserId()));
        userInfo.put("userName", requestContext.getUserName());
        userInfo.put("userType", requestContext.getUserType());
        userInfo.put("avatar", ImageUtil.getCurrentUserAvatarPath((boolean)true));
        return CustomApiResult.success(userInfo);
    }

    @ApiPostMapping(value="getOrgRange")
    public CustomApiResult<@ApiResponseBody(value="\u5bf9\u5e94\u7684\u7ec4\u7ec7\u9875\u4fe1\u606f") PageInfo> getOrgRange(@ApiRequestBody(value="\u83b7\u53d6\u7ec4\u7ec7\u53c2\u6570") QueryOrgParam queryOrgParam) {
        UserInfoServiceImpl userInfoService = new UserInfoServiceImpl();
        return CustomApiResult.success(userInfoService.getOrgRange(queryOrgParam.getPageNum(), queryOrgParam.getPageSize(), queryOrgParam.getSearchText()));
    }

    @ApiPostMapping(value="getHistoryChatInfos")
    public CustomApiResult<@ApiResponseBody(value="\u5bf9\u5e94\u7684\u5386\u53f2\u6d88\u606f\u9875\u4fe1\u606f") PageInfo> getHistoryChatInfos(@ApiParam(value="latestTimeStamp", required=true) @ApiParam(value="latestTimeStamp", required=true) Long latestTimeStamp, @ApiParam(value="pageSize", required=true) @ApiParam(value="pageSize", required=true) Integer pageSize) {
        UserInfoServiceImpl userInfoService = new UserInfoServiceImpl();
        PageInfo<ChatMessage> historyChatInfo = userInfoService.getHistoryChatInfo(latestTimeStamp, pageSize);
        return CustomApiResult.success(historyChatInfo);
    }

    @ApiGetMapping(value="getAppEntryInfos")
    public CustomApiResult<List<AppEntry>> getAppEntryInfos() {
        List<AppEntry> appEntryList = MobileAppHelper.getAppEntryInfoList();
        return CustomApiResult.success(appEntryList);
    }

    @ApiGetMapping(value="verification")
    public CustomApiResult<Map<String, Object>> verificationLicense() {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("hasLicense", true);
        data.put("message", "");
        return CustomApiResult.success(data);
    }
}

