/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.webapi.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.scmc.msmob.webapi.pojo.OrgInfo;
import kd.scmc.msmob.webapi.pojo.PageInfo;
import org.apache.commons.lang.StringUtils;

public class BizPartnerHelper {
    public static boolean isEnableChangeSupplier() {
        Object publicValue = SystemParamServiceHelper.loadPublicParameterFromCache((String)"enable_switch_bizpartner");
        boolean enableChangeSupplier = false;
        if (null != publicValue) {
            enableChangeSupplier = Boolean.parseBoolean(publicValue.toString());
        }
        return enableChangeSupplier;
    }

    public static OrgInfo getDefaultBizPartner() {
        OrgInfo orgInfo = new OrgInfo();
        RequestContext rc = RequestContext.get();
        Long bizPartnerId = rc.getBizPartnerId();
        QFilter filter = new QFilter("id", "=", (Object)bizPartnerId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject bizPartner = BusinessDataServiceHelper.loadSingle((String)"bd_bizpartner", (String)"id,name,number", (QFilter[])filters);
        if (bizPartner != null) {
            orgInfo.setOrgName(bizPartner.getString("name"));
            orgInfo.setOrgNumber(bizPartner.getString("number"));
            orgInfo.setOrgId(Long.toString(bizPartnerId));
        }
        return orgInfo;
    }

    public static int getBizPartnerTotal() {
        ORM orm = ORM.create();
        QFilter filter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()).and("enable", "=", (Object)"1");
        return orm.count(BizPartnerHelper.class.getName(), "bos_bizpartneruser", "bizpartner", filter.toArray());
    }

    public static PageInfo<OrgInfo> getBizPartnerRange(int pageNum, int pageSize, String searchText) {
        PageInfo<OrgInfo> pageInfo = new PageInfo<OrgInfo>();
        pageInfo.setPageNum(pageNum);
        pageInfo.setPageSize(pageSize);
        boolean enableChangeSupplier = BizPartnerHelper.isEnableChangeSupplier();
        if (!enableChangeSupplier) {
            pageInfo.setTotal(0);
            pageInfo.setItems(new ArrayList(0));
            return pageInfo;
        }
        List<OrgInfo> bizPartner = BizPartnerHelper.getBizPartner(pageNum, pageSize, searchText);
        pageInfo.setItems(bizPartner);
        pageInfo.setTotal(BizPartnerHelper.getBizPartnerTotal());
        return pageInfo;
    }

    private static List<OrgInfo> getBizPartner(int pageNum, int pageSize, String searchText) {
        DynamicObject[] bizPartnerUsers;
        ArrayList<OrgInfo> partnerList = new ArrayList<OrgInfo>(10);
        QFilter filter = new QFilter("user", "=", (Object)RequestContext.get().getCurrUserId()).and("enable", "=", (Object)"1");
        if (StringUtils.isNotBlank((String)searchText)) {
            filter.and(new QFilter("bizpartner.name", "like", (Object)("%" + searchText + "%")).or("bizpartner.number", "like", (Object)("%" + searchText + "%")));
        }
        if ((bizPartnerUsers = BusinessDataServiceHelper.load((String)"bos_bizpartneruser", (String)"bizpartner.name,bizpartner.number,bizpartner.id,", (QFilter[])filter.toArray(), (String)"bizpartner.number", (int)((pageNum - 1) * pageSize), (int)pageSize)).length > 0) {
            Arrays.stream(bizPartnerUsers).forEach(bizPartnerUser -> {
                DynamicObject bizPartner = (DynamicObject)bizPartnerUser.get("bizpartner");
                OrgInfo orgInfo = new OrgInfo();
                orgInfo.setOrgName(bizPartner.getString("name"));
                orgInfo.setOrgNumber(bizPartner.getString("number"));
                orgInfo.setOrgId(bizPartner.getString("id"));
                partnerList.add(orgInfo);
            });
        }
        return partnerList;
    }
}

