/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.webapi.helper;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.msmob.webapi.helper.MobileChatParamsHelper;
import kd.scmc.msmob.webapi.pojo.ChatMessage;
import org.apache.commons.collections.CollectionUtils;

public class HistoryChatInfosHelper {
    public static List<ChatMessage> getChatMessages(long lastTimeStamp, int pageSize, long chatInfoId) {
        QFilter qFilter = new QFilter("chatinfoid", "=", (Object)chatInfoId);
        qFilter.and("time", "<", (Object)lastTimeStamp);
        DynamicObjectCollection gaiChatItem = QueryServiceHelper.query((String)"gai_chat_item", (String)"id,time,content_tag,type", (QFilter[])qFilter.toArray(), (String)"time desc", (int)pageSize);
        return gaiChatItem.stream().map(item -> new ChatMessage(item.getString("id"), item.getString("time"), item.getInt("type") == 1, item.getString("content_tag"))).collect(Collectors.toList());
    }

    public static long getChatInfoId() {
        long currUserId = RequestContext.get().getCurrUserId();
        String chatSessionId = MobileChatParamsHelper.getChatSessionId();
        QFilter qFilter = new QFilter("userid", "=", (Object)currUserId);
        qFilter.and("chatsessionid", "=", (Object)chatSessionId);
        List gaiChatItem = QueryServiceHelper.queryPrimaryKeys((String)"gai_chat_info", (QFilter[])qFilter.toArray(), null, (int)1);
        return CollectionUtils.isEmpty((Collection)gaiChatItem) ? 0L : Long.parseLong(gaiChatItem.get(0).toString());
    }

    public static int getHistoryMessageTotal(long chatInfoId) {
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("chatinfoid", "=", (Object)chatInfoId);
        return orm.count(RequestContext.get().getTraceId(), "gai_chat_item", "chatinfoid,type,time", qFilter.toArray(), (Distinctable)WithDistinctable.get());
    }
}

