/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.webapi.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.webapi.pojo.OrgInfo;
import kd.scmc.msmob.webapi.pojo.PageInfo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class UnitOrgHelper {
    public static String getCursUserBaseType(Long userId) {
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map types = UserServiceHelper.getUserBaseTypeByIds(userIds);
        if (types != null && types.size() > 0) {
            return String.valueOf(types.get(userId));
        }
        return "";
    }

    public static PageInfo<OrgInfo> getUnitOrgRange(int pageNum, int pageSize, String searchText) {
        HasPermOrgResult hasPermOrgResult;
        QFilter customFilter = new QFilter("1", "=", (Object)1);
        if (StringUtils.isNotBlank((String)searchText)) {
            customFilter.and(new QFilter("name", "like", (Object)("%" + searchText + "%")).or("number", "like", (Object)("%" + searchText + "%")));
        }
        if (!(hasPermOrgResult = PermissionServiceHelper.getUserHasPermOrgs((long)UserServiceHelper.getCurrentUserId(), (boolean)false)).hasAllOrgPerm()) {
            customFilter.and("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
        }
        PageInfo<OrgInfo> pageInfo = new PageInfo<OrgInfo>();
        List<OrgInfo> orgInfos = UnitOrgHelper.listOrgInfos(pageNum, pageSize, "bos_org", customFilter);
        int total = UnitOrgHelper.getUnitOrgTotal(customFilter.toArray());
        pageInfo.setItems(orgInfos);
        pageInfo.setTotal(total);
        pageInfo.setPageNum(pageNum);
        pageInfo.setPageSize(pageSize);
        return pageInfo;
    }

    public static OrgInfo getDefaultUnitOrg() {
        List<Long> hasPermOrgList = PermissionHelper.getUserAllHasPermOrgs();
        RequestContext requestContext = RequestContext.get();
        long orgId = requestContext.getOrgId();
        if (CollectionUtils.isNotEmpty(hasPermOrgList) && !hasPermOrgList.contains(orgId)) {
            orgId = hasPermOrgList.get(0);
        }
        QFilter qFilter = new QFilter("id", "=", (Object)orgId);
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"number,id,name", (QFilter[])qFilter.toArray());
        OrgInfo orgInfo = new OrgInfo();
        if (org != null) {
            orgInfo.setOrgNumber(org.getString("number"));
            orgInfo.setOrgName(org.getString("name"));
            orgInfo.setOrgId(org.getString("id"));
        }
        return orgInfo;
    }

    private static int getUnitOrgTotal(QFilter[] filters) {
        ORM orm = ORM.create();
        return orm.count(RequestContext.get().getTraceId(), "bos_org", "id,name,number,orgpattern.name", filters, (Distinctable)WithDistinctable.get());
    }

    private static List<OrgInfo> listOrgInfos(int pageNum, int pageSize, String entityName, QFilter customFilter) {
        ArrayList<OrgInfo> orgInfos = new ArrayList<OrgInfo>(pageSize);
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(RequestContext.get().getTraceId(), entityName, "id,name,number", customFilter.toArray(), "number", (pageNum - 1) * pageSize, pageSize, (Distinctable)WithDistinctable.get());){
            ds.forEach(row -> {
                OrgInfo orgInfo = new OrgInfo();
                orgInfo.setOrgId(row.getString("id"));
                orgInfo.setOrgName(row.getString("name"));
                orgInfo.setOrgNumber(row.getString("number"));
                orgInfos.add(orgInfo);
            });
            ArrayList<OrgInfo> arrayList = orgInfos;
            return arrayList;
        }
    }
}

