/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.webapi.service.imp;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scmc.msmob.business.helper.AppParameterHelper;
import kd.scmc.msmob.webapi.business.reply.AbstractReplyHandler;
import kd.scmc.msmob.webapi.enums.QuestionType;
import kd.scmc.msmob.webapi.helper.MobileChatParamsHelper;
import kd.scmc.msmob.webapi.service.IPromptService;
import kd.scmc.msmob.webapi.vo.PromptParams;
import kd.scmc.msmob.webapi.vo.PromptResult;
import kd.scmc.msmob.webapi.vo.PromptResultData;
import org.apache.commons.lang3.StringUtils;

public class PromptServiceImpl
implements IPromptService {
    private static final Log logger = LogFactory.getLog(PromptServiceImpl.class);

    @Override
    public PromptResult getPromptResult(PromptParams promptParams) {
        promptParams.setPromptNumber(this.getPromptNumber());
        promptParams.setChatSessionId(MobileChatParamsHelper.getChatSessionId());
        PromptResult promptResult = this.callSyncService(promptParams);
        this.processReply(promptParams, promptResult);
        return promptResult;
    }

    private String getPromptNumber() {
        Object promptNumber = AppParameterHelper.getAppParameter("msmob_paramsetup", "prompt_number");
        if (promptNumber != null) {
            return String.valueOf(promptNumber);
        }
        return "";
    }

    private void processReply(PromptParams promptParams, PromptResult promptResult) {
        PromptResultData data = promptResult.getData();
        if (promptResult.getData() != null && promptResult.getData().getReply() != null) {
            AbstractReplyHandler replyHandler = QuestionType.getReplyHandler(data.getReply().getQuestionType());
            replyHandler.handle(promptParams, promptResult.getData().getReply());
        }
    }

    private PromptResult callSyncService(PromptParams promptParams) {
        Map<String, String> varParams = PromptServiceImpl.getVarParams(promptParams);
        Object[] params = new Object[]{promptParams.getChatSessionId(), this.getPromptId(promptParams.getPromptNumber()), promptParams.getInput(), varParams};
        logger.info(String.format("\u3010GPT\u63d0\u793a-OpenApi\u670d\u52a1\u3011\u8c03\u7528-\u5f00\u59cb\uff0cchatSessionId:%s \uff0cparams\uff1a%s", promptParams.getChatSessionId(), JSON.toJSONString((Object)promptParams)));
        Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPromptService", (String)"syncCallUseHistoryMsg", (Object[])params);
        logger.info(String.format("\u3010GPT\u63d0\u793a-OpenApi\u670d\u52a1\u3011\u8c03\u7528-\u5b8c\u6210\uff0c\u7ed3\u679c:%s", resultMap));
        ObjectMapper objectMapper = new ObjectMapper();
        return (PromptResult)objectMapper.convertValue((Object)resultMap, PromptResult.class);
    }

    private static Map<String, String> getVarParams(PromptParams callVO) {
        Map<String, String> varParams = callVO.getVarParams();
        String domain = varParams.get("domain");
        if (StringUtils.isBlank((CharSequence)domain)) {
            varParams.put("domain", UrlService.getDomainContextUrl());
        }
        return varParams;
    }

    private Long getPromptId(String promptNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)promptNumber);
        DynamicObject promptDy = QueryServiceHelper.queryOne((String)"gai_prompt", (String)"id", (QFilter[])qFilter.toArray());
        return promptDy != null ? promptDy.getLong("id") : 0L;
    }
}

