/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.msmob.webapi.service.imp;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.msmob.webapi.helper.BizPartnerHelper;
import kd.scmc.msmob.webapi.helper.HistoryChatInfosHelper;
import kd.scmc.msmob.webapi.helper.UnitOrgHelper;
import kd.scmc.msmob.webapi.pojo.ChatMessage;
import kd.scmc.msmob.webapi.pojo.OrgInfo;
import kd.scmc.msmob.webapi.pojo.PageInfo;
import kd.scmc.msmob.webapi.service.IUserInfoService;

public class UserInfoServiceImpl
implements IUserInfoService {
    private static final Log log = LogFactory.getLog(UserInfoServiceImpl.class);

    @Override
    public PageInfo<OrgInfo> getOrgRange(int pageNum, int pageSize, String searchText) {
        RequestContext requestContext = RequestContext.get();
        long currUserId = requestContext.getCurrUserId();
        String cursUserBaseType = UnitOrgHelper.getCursUserBaseType(currUserId);
        if ("200".equals(cursUserBaseType)) {
            return BizPartnerHelper.getBizPartnerRange(pageNum, pageSize, searchText);
        }
        return UnitOrgHelper.getUnitOrgRange(pageNum, pageSize, searchText);
    }

    @Override
    public OrgInfo getDefaultOrg() {
        RequestContext requestContext = RequestContext.get();
        long currUserId = requestContext.getCurrUserId();
        String cursUserBaseType = UnitOrgHelper.getCursUserBaseType(currUserId);
        if ("200".equals(cursUserBaseType)) {
            return BizPartnerHelper.getDefaultBizPartner();
        }
        return UnitOrgHelper.getDefaultUnitOrg();
    }

    @Override
    public PageInfo<ChatMessage> getHistoryChatInfo(long lastTimeStamp, int pageSize) {
        PageInfo<ChatMessage> chatMessagePageInfo = new PageInfo<ChatMessage>();
        long chatInfoId = HistoryChatInfosHelper.getChatInfoId();
        List<ChatMessage> chatMessgeList = HistoryChatInfosHelper.getChatMessages(lastTimeStamp, pageSize, chatInfoId);
        chatMessagePageInfo.setItems(chatMessgeList);
        chatMessagePageInfo.setTotal(HistoryChatInfosHelper.getHistoryMessageTotal(chatInfoId));
        chatMessagePageInfo.setPageNum(-1);
        chatMessagePageInfo.setPageSize(pageSize);
        return chatMessagePageInfo;
    }
}

