/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.report.form;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskParam;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.log4j.Logger;

public class SyncDataListFormPlugin
extends AbstractReportFormPlugin
implements AfterF7SelectListener {
    private static Logger logger = Logger.getLogger(SyncDataListFormPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dvF7 = (BasedataEdit)this.getView().getControl("dataversion");
        dvF7.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("instid", (Object)ORM.create().genLongId("msplan_ds_version"));
        this.getView().updateView("instid");
        BasedataEdit f7 = (BasedataEdit)this.getView().getControl("syncsettings");
        f7.setQFilter(new QFilter("number", "in", new HashSet()));
        this.getView().setVisible(Boolean.FALSE, new String[]{"exportexcel"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if ("exportnow".equals(operateKey)) {
            ReportList srcRpt = (ReportList)this.getControl("srclistap");
            String exportExcel = srcRpt.exportExcel();
            this.getView().download(exportExcel);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"SyncDataListFormPlugin_0", (String)"mpscmm-msplan-report", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (!"refresh".equals(args.getOperateKey())) {
            return;
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        IReportCache cache = ReportCacheManager.getInstance().getCache();
        ReportList srcRpt = (ReportList)this.getControl("srclistap");
        ReportListModel model = (ReportListModel)srcRpt.getReportModel();
        String pageId = model.getPageId();
        String ctrlId = "srclistap";
        ReportTaskParam tp = new ReportTaskParam();
        tp.setReportName("dataversion");
        tp.setPluginClassName(srcRpt.getReportPluginClassName());
        tp.setDataSource(srcRpt.getDataSource());
        tp.setQueryDataSource(srcRpt.getDataSourceId());
        tp.setOtherParam((Object)queryParam);
        cache.setReportTaskParam(pageId, ctrlId, tp);
        srcRpt.submitTask(queryParam, (Object)String.valueOf(this.getModel().getValue("instId")));
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        HashMap<String, String> customParam;
        FilterInfo filter = queryParam.getFilter();
        DynamicObject selectedVersion = filter.getDynamicObject("dataversion");
        DynamicObject selectedSettings = filter.getDynamicObject("syncsettings");
        StringBuilder tips = new StringBuilder();
        if (selectedVersion == null) {
            tips.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u7248\u672c\u3002", (String)"SyncDataListFormPlugin_1", (String)"mpscmm-msplan-report", (Object[])new Object[0]));
            if (selectedSettings == null) {
                tips.append(String.format(ResManager.loadKDString((String)"%s\u201c\u540c\u6b65\u8bbe\u7f6e\u201d", (String)"SyncDataListFormPlugin_2", (String)"mpscmm-msplan-report", (Object[])new Object[0]), "\u3001"));
            }
            tips.append('\u3002');
        } else if (selectedSettings == null) {
            tips.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u6b65\u8bbe\u7f6e\u3002", (String)"SyncDataListFormPlugin_3", (String)"mpscmm-msplan-report", (Object[])new Object[0]));
        } else {
            try (DataSet hisDs = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "msplan_ds_version", "id, hisentity.id, hisentity.activestatus", new QFilter[]{new QFilter("id", "=", selectedVersion.get("id")), new QFilter("hisentity.activestatus", "=", (Object)"A")});){
                if (!hisDs.hasNext()) {
                    tips.append(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u201c\u6570\u636e\u7248\u672c\u201d\u4e2d\u6ca1\u6709\u6fc0\u6d3b\u72b6\u6001\u7684\u540c\u6b65\u5386\u53f2\u8bb0\u5f55\u3002", (String)"SyncDataListFormPlugin_4", (String)"mpscmm-msplan-report", (Object[])new Object[0]));
                }
            }
        }
        if (tips.length() > 0) {
            this.getView().showTipNotification(tips.toString());
        }
        if ((customParam = queryParam.getCustomParam()) == null) {
            customParam = new HashMap<String, String>();
            queryParam.setCustomParam(customParam);
        }
        customParam.put("_pageCacheId", this.getView().getPageId());
        return tips.length() == 0;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String instId;
        super.beforeClosed(e);
        try {
            instId = String.valueOf(this.getModel().getValue("instid"));
        }
        catch (Throwable ex) {
            logger.error((Object)"\u83b7\u53d6\u6a21\u578bID\u5931\u8d25", ex);
            this.getView().showMessage(ex.getMessage());
            return;
        }
        instId = instId + ".";
        DistributeSessionlessCache globalCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        globalCache.remove(instId + "queryArgs");
        globalCache.remove("");
    }

    public void afterF7Select(AfterF7SelectEvent evt) {
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject ver = data.getDynamicObject("dataversion");
        data.set("syncsettings", null);
        BasedataEdit f7 = (BasedataEdit)this.getView().getControl("syncsettings");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("number", "in", new HashSet()));
        f7.setQFilters(filters);
        if (ver == null) {
            return;
        }
        filters.clear();
        ver = BusinessDataServiceHelper.loadSingleFromCache((Object)ver.get("id"), (String)"msplan_ds_version", (String)"id, datasyncselector");
        HashSet<String> numbers = new HashSet<String>();
        DynamicObjectCollection settingsList = ver.getDynamicObjectCollection("datasyncselector");
        for (DynamicObject settings : settingsList) {
            settings = settings.getDynamicObject("fbasedataid");
            String num = settings.getString("number");
            numbers.add(num);
        }
        filters.add(new QFilter("number", "in", numbers));
        f7.setQFilters(filters);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        if ("dataversion".equals(prop)) {
            DynamicObject data = this.getModel().getDataEntity();
            data.set("syncsettings", null);
            data.set("materials", null);
            this.getView().updateView("syncsettings");
            this.getView().updateView("materials");
            ReportList srcRpt = (ReportList)this.getControl("reportlistap");
            srcRpt.initEmptyGrid();
            ReportList srclistap = (ReportList)this.getControl("srclistap");
            srclistap.initEmptyGrid();
        }
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            event.setFilter(true);
            event.setSort(true);
        }
    }
}

