/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.report.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.datasync.report.query.SyncDataListQueryPlugin;
import kd.mpscmm.msplan.mservice.service.datasync.func.DataSyncRunnable;
import kd.mpscmm.msplan.mservice.service.datasync.utils.MMFilterUtil;
import org.apache.log4j.Logger;

public class CurrentDataListQueryPlugin
extends SyncDataListQueryPlugin {
    private static Logger logger = Logger.getLogger(CurrentDataListQueryPlugin.class);

    @Override
    protected DataSet doQuery(Long versionId, String etStr, List<String> selectFields, QFilter[] filters) {
        ArrayList<String> viewFields = new ArrayList<String>(selectFields.size());
        for (String f : selectFields) {
            if (f.startsWith(etStr + ".")) {
                f = f.substring(etStr.length() + 1);
            }
            viewFields.add(f);
        }
        selectFields.clear();
        selectFields.addAll(viewFields);
        String fields = "id, datasyncselector.fbasedataid, hisentity.syncstatus, hisentity.startdatetime, hisentity.activestatus";
        fields = fields + ", subentryentity.hismainentity, subentryentity.hisfilter_tag, subentryentity.hisstatus";
        DynamicObject dataVer = BusinessDataServiceHelper.loadSingleFromCache((Object)versionId, (String)"msplan_ds_version", (String)fields);
        DynamicObjectCollection hisEntrys = dataVer.getDynamicObjectCollection("hisentity");
        QFilter[] hisEntry = null;
        for (QFilter[] e : hisEntrys) {
            if (!"A".equals(e.getString("activestatus"))) continue;
            hisEntry = e;
            break;
        }
        HashSet<String> addedCols = new HashSet<String>(selectFields);
        if (filters != null) {
            for (QFilter f : filters) {
                QFilter[] allFilters;
                for (QFilter sub : allFilters = f.recombine()) {
                    String p = sub.getProperty();
                    if ("1".equals(p) || "id".equalsIgnoreCase(p) || addedCols.contains(p)) continue;
                    selectFields.add(p);
                    addedCols.add(p);
                }
            }
        }
        StringBuilder filterStr = new StringBuilder();
        QFilter defFilter = null;
        if (hisEntry != null) {
            DynamicObjectCollection hisSettings = hisEntry.getDynamicObjectCollection("subentryentity");
            for (DynamicObject hisSettingsEntry : hisSettings) {
                String filterVal;
                String status;
                DynamicObject entityType = hisSettingsEntry.getDynamicObject("hismainentity");
                if (!etStr.equals(entityType.getString("number")) || !"S".equals(status = hisSettingsEntry.getString("hisstatus")) || StringUtils.isEmpty((String)(filterVal = hisSettingsEntry.getString("hisfilter_tag")))) continue;
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterVal, FilterCondition.class);
                QFilter f = DataSyncRunnable.parse2QFilter((MainEntityType)MetadataServiceHelper.getDataEntityType((String)etStr), (FilterCondition)filterCondition);
                if (defFilter == null) {
                    defFilter = f;
                    continue;
                }
                if (f != null) {
                    QFilter[] allFilters = f.recombine();
                    if (allFilters == null) continue;
                    for (QFilter sub : allFilters) {
                        String p = sub.getProperty();
                        if ("1".equals(p) || "id".equalsIgnoreCase(p) || addedCols.contains(p)) continue;
                        selectFields.add(p);
                        addedCols.add(p);
                    }
                    if (filterStr.length() > 0) {
                        filterStr.append(" or ");
                    }
                    filterStr.append('(');
                    MMFilterUtil.qfilter2String((StringBuilder)filterStr, (QFilter)f);
                    filterStr.append(')');
                    continue;
                }
                filterStr.setLength(0);
                break;
            }
        }
        StringBuilder sb = new StringBuilder(selectFields.get(0));
        for (int i = 1; i < selectFields.size(); ++i) {
            sb.append(", ").append(selectFields.get(i));
        }
        if (filters == null) {
            filters = new QFilter[]{defFilter};
        } else if (defFilter != null) {
            QFilter[] copy = new QFilter[filters.length + 1];
            copy[0] = defFilter;
            System.arraycopy(filters, 0, copy, 1, filters.length);
            filters = copy;
        }
        DataSet ds = ORM.create().queryDataSet(CurrentDataListQueryPlugin.class.getName(), etStr, sb.toString(), filters, "id desc");
        logger.warn((Object)String.format("mmc-datasync-realtime-datas-query, defaultFilter: [%s]", filterStr));
        if (filterStr.length() > 0) {
            ds = ds.filter(filterStr.toString());
        }
        sb.setLength(0);
        sb.append("Cast(").append((String)viewFields.get(0)).append(" as String) as ").append((String)viewFields.get(0));
        for (int i = 1; i < viewFields.size(); ++i) {
            sb.append(", ").append("Cast(").append((String)viewFields.get(i)).append(" as String) as ").append((String)viewFields.get(i));
        }
        ds = ds.select(sb.toString());
        this.rowMeta = ds.getRowMeta();
        return ds;
    }

    @Override
    public DataSet query(ReportQueryParam queryParam, Object append) throws Throwable {
        return super.sortAndFilter(queryParam, super.query(queryParam, append));
    }
}

