/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.report.query;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.datasource.DBConfig;
import kd.bos.db.datasource.DataSourceFactory;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.mpscmm.msplan.datasync.report.query.SyncDataListQueryPlugin;
import org.apache.log4j.Logger;

public class SQLExplainQueryPlugin
extends AbstractReportListDataPlugin {
    private static Logger logger = Logger.getLogger(SQLExplainQueryPlugin.class);
    protected RowMeta rowMeta;

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        FilterInfo filter = queryParam.getFilter();
        String type = filter.getString("type");
        try {
            switch (type) {
                case "executeplan": {
                    return this.querySQLPlanUsage(queryParam);
                }
                case "index": {
                    return this.queryIndexUsage(queryParam);
                }
                case "disk": {
                    return this.queryDiskUsage(queryParam);
                }
                case "column": {
                    return this.queryColumnUsage(queryParam);
                }
                case "distribution": {
                    return this.queryDiskDistributionUsage(queryParam);
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)"\u6570\u636e\u67e5\u8be2\u5931\u8d25", e);
            this.rowMeta = null;
        }
        return Algo.create((String)SyncDataListQueryPlugin.class.getName()).createDataSetBuilder(new RowMeta(new Field[0])).build();
    }

    private DataSet querySQLPlanUsage(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        String dbRouteKey = filter.getString("dbroutekey");
        String sql = filter.getString("sql");
        return (DataSet)DB.query((DBRoute)new DBRoute(dbRouteKey), (String)("/*dialect*/explain " + sql), (ResultSetHandler)new ResultSetHandler<DataSet>(){

            public DataSet handle(ResultSet rs) throws Exception {
                ResultSetMetaData meta = rs.getMetaData();
                int count = meta.getColumnCount();
                ArrayList<Field> fields = new ArrayList<Field>(count);
                for (int i = 1; i <= count; ++i) {
                    String colLabel = meta.getColumnLabel(i);
                    fields.add(new Field(colLabel, (DataType)DataType.StringType));
                }
                SQLExplainQueryPlugin.this.rowMeta = new RowMeta(fields.toArray(new Field[0]));
                DataSetBuilder builder = Algo.create((String)SQLExplainQueryPlugin.class.getName()).createDataSetBuilder(SQLExplainQueryPlugin.this.rowMeta);
                while (rs.next()) {
                    Object[] row = new Object[fields.size()];
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        String colLabel = meta.getColumnLabel(i);
                        row[i - 1] = String.valueOf(rs.getObject(colLabel));
                    }
                    builder.append(row);
                }
                return builder.build();
            }
        });
    }

    private DataSet queryIndexUsage(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        String dbRouteKey = filter.getString("dbroutekey");
        String sql = filter.getString("sql");
        return (DataSet)DB.query((DBRoute)new DBRoute(dbRouteKey), (String)("/*dialect*/show index from " + sql), (ResultSetHandler)new ResultSetHandler<DataSet>(){

            public DataSet handle(ResultSet rs) throws Exception {
                ResultSetMetaData meta = rs.getMetaData();
                int count = meta.getColumnCount();
                ArrayList<Field> fields = new ArrayList<Field>(count);
                for (int i = 1; i <= count; ++i) {
                    String colLabel = meta.getColumnLabel(i);
                    fields.add(new Field(colLabel, (DataType)DataType.StringType));
                }
                SQLExplainQueryPlugin.this.rowMeta = new RowMeta(fields.toArray(new Field[0]));
                DataSetBuilder builder = Algo.create((String)SQLExplainQueryPlugin.class.getName()).createDataSetBuilder(SQLExplainQueryPlugin.this.rowMeta);
                while (rs.next()) {
                    Object[] row = new Object[fields.size()];
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        String colLabel = meta.getColumnLabel(i);
                        row[i - 1] = String.valueOf(rs.getObject(colLabel));
                    }
                    builder.append(row);
                }
                return builder.build();
            }
        });
    }

    private DataSet queryDiskUsage(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        String dbRouteKey = filter.getString("dbroutekey");
        RequestContext rc = RequestContext.get();
        DBConfig dbCfg = DataSourceFactory.getDBConfig((String)rc.getTenantId(), (String)dbRouteKey, (String)rc.getAccountId());
        String tableName = filter.getString("sql");
        String sql = String.format("/*dialect*/SELECT TABLE_NAME AS '%s',", ResManager.loadKDString((String)"\u8868\u540d", (String)"SQLExplainQueryPlugin_0", (String)"mpscmm-msplan-report", (Object[])new Object[0]));
        sql = sql + String.format(" CONCAT(ROUND(TABLE_ROWS/10000, 2), '%1$s') AS '%2$s',", ResManager.loadKDString((String)"\u4e07\u884c", (String)"SQLExplainQueryPlugin_1", (String)"mpscmm-msplan-report", (Object[])new Object[0]), ResManager.loadKDString((String)"\u884c\u6570", (String)"SQLExplainQueryPlugin_5", (String)"mpscmm-msplan-report", (Object[])new Object[0]));
        sql = sql + String.format(" CONCAT(ROUND(DATA_LENGTH/(1024*1024*1024), 2), ' GB') AS '%s',", ResManager.loadKDString((String)"\u8868\u7a7a\u95f4", (String)"SQLExplainQueryPlugin_2", (String)"mpscmm-msplan-report", (Object[])new Object[0]));
        sql = sql + String.format(" CONCAT(ROUND(INDEX_LENGTH/(1024*1024*1024), 2), ' GB') AS '%s',", ResManager.loadKDString((String)"\u7d22\u5f15\u7a7a\u95f4", (String)"SQLExplainQueryPlugin_3", (String)"mpscmm-msplan-report", (Object[])new Object[0]));
        sql = sql + String.format(" CONCAT(ROUND((DATA_LENGTH+INDEX_LENGTH)/(1024*1024*1024),2),' GB') AS'%s'", ResManager.loadKDString((String)"\u603b\u7a7a\u95f4", (String)"SQLExplainQueryPlugin_4", (String)"mpscmm-msplan-report", (Object[])new Object[0]));
        sql = sql + " FROM information_schema.TABLES WHERE TABLE_SCHEMA = '%s' AND TABLE_NAME = '%s' ORDER BY TABLE_ROWS DESC;";
        return (DataSet)DB.query((DBRoute)new DBRoute(dbRouteKey), (String)String.format(sql, dbCfg.getSchema(), tableName), (ResultSetHandler)new ResultSetHandler<DataSet>(){

            public DataSet handle(ResultSet rs) throws Exception {
                ResultSetMetaData meta = rs.getMetaData();
                int count = meta.getColumnCount();
                ArrayList<Field> fields = new ArrayList<Field>(count);
                for (int i = 1; i <= count; ++i) {
                    String colLabel = meta.getColumnLabel(i);
                    fields.add(new Field(colLabel, (DataType)DataType.StringType));
                }
                SQLExplainQueryPlugin.this.rowMeta = new RowMeta(fields.toArray(new Field[0]));
                DataSetBuilder builder = Algo.create((String)SQLExplainQueryPlugin.class.getName()).createDataSetBuilder(SQLExplainQueryPlugin.this.rowMeta);
                while (rs.next()) {
                    Object[] row = new Object[fields.size()];
                    for (int i = 1; i <= meta.getColumnCount(); ++i) {
                        String colLabel = meta.getColumnLabel(i);
                        row[i - 1] = String.valueOf(rs.getObject(colLabel));
                    }
                    builder.append(row);
                }
                return builder.build();
            }
        });
    }

    private DataSet queryColumnUsage(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        String dbRouteKey = filter.getString("dbroutekey");
        String tableName = filter.getString("sql");
        RequestContext rc = RequestContext.get();
        DBConfig dbCfg = DataSourceFactory.getDBConfig((String)rc.getTenantId(), (String)dbRouteKey, (String)rc.getAccountId());
        String sql = "SELECT COLUMN_NAME, ISNULL(CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION) AS 'DATA_LENGTH', DATA_TYPE";
        sql = sql + ", NUMERIC_PRECISION as 'DATA_PRECISION', NUMERIC_SCALE as 'DATA_SCALE' FROM information_schema.columns WHERE";
        sql = sql + " TABLE_SCHEMA='%s' AND (TABLE_NAME = '%s' OR TABLE_NAME = '%s')";
        DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)new DBRoute(dbRouteKey), (String)String.format(sql, dbCfg.getSchema(), tableName.toUpperCase(), tableName.toLowerCase()));
        this.rowMeta = ds.getRowMeta();
        return ds;
    }

    private DataSet queryDiskDistributionUsage(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        String dbRouteKey = filter.getString("dbroutekey");
        String tableName = filter.getString("sql");
        RequestContext rc = RequestContext.get();
        DBConfig dbCfg = DataSourceFactory.getDBConfig((String)rc.getTenantId(), (String)dbRouteKey, (String)rc.getAccountId());
        String sql = "SELECT PARTITION_NAME,PARTITION_METHOD,PARTITION_EXPRESSION,PARTITION_DESCRIPTION,TABLE_ROWS,SUBPARTITION_NAME,";
        sql = sql + "SUBPARTITION_METHOD,SUBPARTITION_EXPRESSION FROM information_schema.PARTITIONS WHERE TABLE_SCHEMA='%s' AND (TABLE_NAME='%s' OR TABLE_NAME = '%s');";
        DataSet ds = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)new DBRoute(dbRouteKey), (String)String.format(sql, dbCfg.getSchema(), tableName.toUpperCase(), tableName.toLowerCase()));
        this.rowMeta = ds.getRowMeta();
        return ds;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (columns == null) {
            columns = new ArrayList<AbstractReportColumn>();
        }
        if (this.rowMeta == null) {
            return columns;
        }
        int len = this.rowMeta.getFieldCount();
        for (int i = 0; i < len; ++i) {
            Field field = this.rowMeta.getField(i);
            ReportColumn endRpt = new ReportColumn();
            endRpt.setCaption(new LocaleString(field.getName()));
            endRpt.setFieldKey(field.getName());
            endRpt.setZeroShow(true);
            endRpt.setFieldType("text");
            endRpt.setScale(10);
            columns.add((AbstractReportColumn)endRpt);
        }
        return columns;
    }
}

