/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.datasync.report.query;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.mservice.service.datasync.MMCSnapDataVisitor;
import org.apache.log4j.Logger;

public class SyncDataListQueryPlugin
extends AbstractReportListDataPlugin {
    private static Logger logger = Logger.getLogger(SyncDataListQueryPlugin.class);
    protected static final String orderBys = "id desc";
    protected RowMeta rowMeta;
    protected String instId;
    protected DataSetBuilder builder = Algo.create((String)SyncDataListQueryPlugin.class.getName()).createDataSetBuilder(new RowMeta(new Field[0]));
    protected DataSet empty = this.builder.build();
    protected String pageCacheId;
    private static final String CACHE_COL_MAP = "colNameMap";
    private Map<String, String> colMap;

    public DataSet query(ReportQueryParam queryParam, Object append) throws Throwable {
        block35: {
            this.pageCacheId = (String)queryParam.getCustomParam().get("_pageCacheId");
            FilterInfo filter = queryParam.getFilter();
            Long versionId = filter.getLong("dataversion");
            Long id = filter.getLong("syncsettings");
            DynamicObject selectedSettings = QueryServiceHelper.queryOne((String)"msplan_ds_settings", (String)"id, materialfield", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            try (DataSet hisDs = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "msplan_ds_version", "id, hisentity.id, hisentity.activestatus", new QFilter[]{new QFilter("id", "=", (Object)versionId), new QFilter("hisentity.activestatus", "=", (Object)"A")});){
                if (!hisDs.hasNext()) {
                    logger.warn((Object)String.format("mmc-datasync-no-match-sync-hisentry, vid: %s", versionId));
                    break block35;
                }
                Row row = hisDs.next();
                Long entryId = row.getLong("hisentity.id");
                try (DataSet syncEntrys = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)new DBRoute("scm"), (String)("select fhissettings, fhisentity, fhisfilter_tag, fhiscols_tag, fhisstatus from t_msplan_dv_detail where fentryid = " + entryId));){
                    QFilter[] filters = null;
                    DynamicObjectCollection selectedMaterials = filter.getDynamicObjectCollection("materials");
                    String materialField = selectedSettings.getString("materialfield");
                    ArrayList<String> selectedFields = new ArrayList<String>();
                    HashSet<String> addedCols = new HashSet<String>();
                    if (!StringUtils.isEmpty((String)materialField) && selectedMaterials != null && selectedMaterials.size() > 0) {
                        HashSet<Long> ids = new HashSet<Long>();
                        for (DynamicObject m : selectedMaterials) {
                            ids.add(m.getLong("id"));
                        }
                        QFilter materialFilter = new QFilter(materialField, "in", ids);
                        filters = new QFilter[]{materialFilter};
                        selectedFields.add(materialField);
                        addedCols.add(materialField);
                    }
                    while (syncEntrys.hasNext()) {
                        row = syncEntrys.next();
                        if (!id.equals(row.getLong("fhissettings"))) continue;
                        String etStr = row.getString("fhisentity");
                        String colStr = row.getString("fhiscols_tag");
                        List cols = JSON.parseArray((String)colStr, String.class);
                        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)etStr);
                        for (String col : cols) {
                            if (addedCols.contains(col)) continue;
                            addedCols.add(col);
                            String[] tags = col.split("\\.");
                            DynamicProperty prop = this.getLeafProp((IDataEntityType)type, tags, 0);
                            if (prop == null || StringUtils.isEmpty((String)prop.getAlias())) continue;
                            selectedFields.add(col);
                        }
                        logger.warn((Object)String.format("mmc-datasync-match-sync-hisentry, vid: %s, sid: %s, fields: %s", versionId, id, colStr));
                        DataSet dataSet = this.sortAndFilter(queryParam, this.doQuery(versionId, etStr, selectedFields, filters));
                        return dataSet;
                    }
                    logger.warn((Object)String.format("mmc-datasync-no-match-sync-entity, vid: %s, sid: %s", versionId, id));
                }
            }
        }
        return this.empty;
    }

    private DynamicProperty getLeafProp(IDataEntityType rootType, String[] tags, int idx) {
        DynamicCollectionProperty dcp;
        if (!(rootType instanceof DynamicObjectType)) {
            return null;
        }
        if (rootType.getName().equals(tags[idx])) {
            ++idx;
        }
        if (idx == tags.length) {
            return null;
        }
        DynamicProperty prop = ((DynamicObjectType)rootType).getProperty(tags[idx]);
        if (prop == null) {
            return null;
        }
        if (idx == tags.length - 1) {
            return prop;
        }
        IDataEntityType subType = null;
        if (prop instanceof DynamicComplexProperty) {
            DynamicComplexProperty dcp2 = (DynamicComplexProperty)prop;
            if (StringUtils.isEmpty((String)dcp2.getAlias())) {
                return null;
            }
            subType = dcp2.getComplexType();
        } else if (prop instanceof DynamicCollectionProperty && StringUtils.isEmpty((String)(subType = (dcp = (DynamicCollectionProperty)prop).getItemType()).getAlias())) {
            return null;
        }
        if (subType == null) {
            return prop;
        }
        return this.getLeafProp(subType, tags, ++idx);
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (columns == null) {
            columns = new ArrayList<AbstractReportColumn>();
        }
        if (this.rowMeta == null) {
            return columns;
        }
        HashMap<String, String> colMap = new HashMap<String, String>(this.rowMeta.getFieldCount());
        int len = this.rowMeta.getFieldCount();
        for (int i = 0; i < len; ++i) {
            Field field = this.rowMeta.getField(i);
            ReportColumn endRpt = new ReportColumn();
            String name = field.getName();
            endRpt.setCaption(new LocaleString(name));
            endRpt.setFieldKey(name);
            endRpt.setZeroShow(true);
            endRpt.setFieldType("text");
            endRpt.setScale(10);
            columns.add((AbstractReportColumn)endRpt);
            colMap.put(name.replace('.', '_'), name);
        }
        PageCache pageCache = new PageCache(this.pageCacheId);
        String str = SerializationUtils.serializeToBase64(colMap);
        pageCache.put(CACHE_COL_MAP, str);
        return columns;
    }

    protected DataSet doQuery(Long versionId, String etStr, List<String> selectFields, QFilter[] filters) {
        selectFields = selectFields.stream().map(x -> x.replace(etStr + ".", "")).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder(selectFields.get(0));
        for (int i = 1; i < selectFields.size(); ++i) {
            sb.append(", ").append(selectFields.get(i));
        }
        DynamicObject latestVersion = MMCSnapDataVisitor.loadLatestHisEntry((Long)versionId);
        if (latestVersion == null) {
            return this.empty;
        }
        DataSet ds = new MMCSnapDataVisitor().localFastDataVisit(versionId, null, etStr, sb.toString(), filters, orderBys);
        sb.setLength(0);
        sb.append("Cast(").append(selectFields.get(0)).append(" as String) as ").append(selectFields.get(0));
        for (int i = 1; i < selectFields.size(); ++i) {
            sb.append(", ").append("Cast(").append(selectFields.get(i)).append(" as String) as ").append(selectFields.get(i));
        }
        ds = ds.select(sb.toString());
        this.rowMeta = ds.getRowMeta();
        return ds;
    }

    protected DataSet sortAndFilter(ReportQueryParam queryParam, DataSet dataSet) {
        String sortInfo;
        if (queryParam.getFilter().getHeadFilters() != null && !queryParam.getFilter().getHeadFilters().isEmpty()) {
            for (QFilter qf : queryParam.getFilter().getHeadFilters()) {
                String ft = qf.toString();
                if (ft.contains("null ''")) {
                    ft = ft.replace("null ''", "null");
                }
                ft = this.replaceColName(ft);
                dataSet = dataSet.filter(ft);
            }
        }
        if ((sortInfo = queryParam.getSortInfo()) != null) {
            sortInfo = this.replaceColName(sortInfo);
            dataSet = dataSet.orderBy(new String[]{sortInfo});
        }
        return dataSet;
    }

    private String replaceColName(String filterColName) {
        Map<String, String> colMap = this.getColMap();
        if (colMap == null) {
            return filterColName;
        }
        CharSequence[] split = filterColName.split(" ");
        split[0] = colMap.get(split[0]);
        filterColName = String.join((CharSequence)" ", split);
        return filterColName;
    }

    private Map<String, String> getColMap() {
        if (this.colMap != null) {
            return this.colMap;
        }
        PageCache pageCache = new PageCache(this.pageCacheId);
        String str = pageCache.get(CACHE_COL_MAP);
        if (str == null) {
            return null;
        }
        this.colMap = (Map)SerializationUtils.deSerializeFromBase64((String)str);
        return this.colMap;
    }
}

