/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class AdjustSuggestReleaseValidator
extends AbstractValidator {
    private static final String APPLICATION_NAME = "mpscmm-msplan-opplugin";
    private static final String MSPLAN_ADJUST_SUGGEST_REL = "msplan_adjustsuggest_rel";
    private static final String SAVE = "save";
    private static final String ENABLE = "enable";
    private static final String STATUS = "status";

    public void validate() {
        String opKey = this.getOperateKey();
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        QFilter statusFilter = new QFilter(STATUS, "=", (Object)"C");
        if (SAVE.equals(opKey)) {
            this.checkMustInput();
            this.saveOperationValidate(enableFilter, statusFilter);
        } else if (ENABLE.equals(opKey)) {
            this.enableOperationValidate(enableFilter, statusFilter);
        }
    }

    private void checkMustInput() {
        for (ExtendedDataEntity dynamicObject : this.getDataEntities()) {
            DynamicObject baseData = dynamicObject.getDataEntity();
            DynamicObjectCollection entrys = baseData.getDynamicObjectCollection("entryentity");
            boolean isHav = true;
            List<String> mustInputField = this.getMustInputField();
            for (DynamicObject entry : entrys) {
                ArrayList<String> subEntryFields = new ArrayList<String>(entrys.size());
                DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subEntry : subEntrys) {
                    String subEntryField = subEntry.getString("adjustsugfieldsign");
                    if (!mustInputField.contains(subEntryField)) continue;
                    subEntryFields.add(subEntryField);
                    String changebillfieldsign = subEntry.getString("changebillfieldsign");
                    if (!StringUtils.isBlank((CharSequence)changebillfieldsign)) continue;
                    isHav = false;
                }
                if (subEntryFields.containsAll(mustInputField)) continue;
                isHav = false;
            }
            if (isHav) continue;
            this.addErrorMessage(dynamicObject, ResManager.loadKDString((String)"\u8c03\u6574\u5efa\u8bae\u91ca\u653e\u5b57\u6bb5\u914d\u7f6e\u5fc5\u987b\u586b\u5199\u8c03\u6574\u5efa\u8bae\u5b57\u6bb5\u201c\u6570\u91cf\u201d\u3001\u201c\u8c03\u6574\u53ef\u7528\u65e5\u671f\u201d\u3001\u201c\u8c03\u6574\u539f\u56e0\u201d\u548c\u5bf9\u5e94\u53d8\u66f4\u5355\u5b57\u6bb5\u3002", (String)"AdjustSuggestReleaseValidator_3", (String)APPLICATION_NAME, (Object[])new Object[0]));
        }
    }

    private List<String> getMustInputField() {
        ArrayList<String> mustInputFields = new ArrayList<String>(3);
        mustInputFields.add("qty");
        mustInputFields.add("adjustdate");
        mustInputFields.add("adjustcause");
        return mustInputFields;
    }

    private void saveOperationValidate(QFilter enableFilter, QFilter statusFilter) {
        boolean isEnable;
        QFilter pkFilter = new QFilter("id", "!=", this.dataEntities[0].getDataEntity().getPkValue());
        boolean bl = isEnable = this.dataEntities[0].getDataEntity().getInt(ENABLE) != 0;
        if (isEnable && QueryServiceHelper.exists((String)MSPLAN_ADJUST_SUGGEST_REL, (QFilter[])new QFilter[]{enableFilter, statusFilter, pkFilter})) {
            for (ExtendedDataEntity data : this.dataEntities) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u53ef\u7528\u7684\u8c03\u6574\u5efa\u8bae\u91ca\u653e\u914d\u7f6e,\u8bf7\u5148\u7981\u7528\u3002", (String)"AdjustSuggestReleaseValidator_0", (String)APPLICATION_NAME, (Object[])new Object[0]));
            }
        }
    }

    private void enableOperationValidate(QFilter enableFilter, QFilter statusFilter) {
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)MSPLAN_ADJUST_SUGGEST_REL, (String)"number", (QFilter[])new QFilter[]{enableFilter, statusFilter});
        if (dynamicObject != null) {
            for (ExtendedDataEntity data : this.dataEntities) {
                if (Objects.equals(dynamicObject.get("number"), data.getBillNo())) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u53ef\u7528\u7684\u8c03\u6574\u5efa\u8bae\u91ca\u653e\u914d\u7f6e,\u8bf7\u5148\u7981\u7528\u3002", (String)"AdjustSuggestReleaseValidator_0", (String)APPLICATION_NAME, (Object[])new Object[0]));
            }
        } else {
            int n = this.dataEntities.length;
            for (int i = 0; i < n; ++i) {
                if (i == 0) continue;
                this.addErrorMessage(this.dataEntities[i], ResManager.loadKDString((String)"\u5df2\u8bbe\u7f6e\u7b2c\u4e00\u6761\u9009\u4e2d\u6570\u636e\u4e3a\u53ef\u7528\u3002", (String)"AdjustSuggestReleaseValidator_2", (String)APPLICATION_NAME, (Object[])new Object[0]));
            }
        }
    }
}

