/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;

public class InventoryLevelImportPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(InventoryLevelImportPlugin.class);
    private static Set<String> mrpNotImportFieldSet = new HashSet<String>(16);
    private static Set<String> scmNotImportFieldSet = new HashSet<String>(16);
    public static Set<String> dimensionSet = new HashSet<String>(5);
    private static Set<String> orgMaterialSet = new HashSet<String>(2);
    private static Map<String, String> fieldMap = new HashMap<String, String>(8);

    public boolean validateDatas(Map<Integer, String> dataMap, String url, Map<String, Integer> columnMap, Set<String> fieldSet, String appId) {
        for (Map.Entry<Integer, String> entry : dataMap.entrySet()) {
            String field = entry.getValue();
            if ("number".equals(field) || "dimension.number".equals(field)) {
                columnMap.put(field, entry.getKey());
            }
            if (!"mrp".equals(appId) && fieldSet.contains(field)) {
                this.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5\uff1a\u201c%s\u201d\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u5bfc\u5165\u6a21\u677f\u3002", (String)"InventoryLevelImportPlugin_10", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), fieldMap.getOrDefault(field, field)), url);
                return false;
            }
            if (!"mrp".equals(appId) || !fieldSet.contains(field)) continue;
            this.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u4e0d\u5b58\u5728\u5b57\u6bb5\uff1a\u201c%s\u201d\uff0c\u8bf7\u4f7f\u7528MRP\u4e13\u7528\u5bfc\u5165\u6a21\u677f\u3002", (String)"InventoryLevelImportPlugin_11", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), fieldMap.getOrDefault(field, field)), url);
            return false;
        }
        return true;
    }

    public boolean validateColumns(Map<Integer, String> dataMap, String url, Set<String> fieldSet, Set<String> dsFieldSet, String appId) {
        String field;
        for (Map.Entry<Integer, String> entry : dataMap.entrySet()) {
            String field2 = entry.getValue();
            if (!"mrp".equals(appId) && fieldSet.contains(field2)) {
                this.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5\uff1a\u201c%s\u201d\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u5bfc\u5165\u6a21\u677f\u3002", (String)"InventoryLevelImportPlugin_10", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), fieldMap.getOrDefault(field2, field2)), url);
                return false;
            }
            if ("mrp".equals(appId) && fieldSet.contains(field2)) {
                this.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u4e0d\u5b58\u5728\u5b57\u6bb5\uff1a\u201c%s\u201d\uff0c\u8bf7\u4f7f\u7528MRP\u4e13\u7528\u5bfc\u5165\u6a21\u677f\u3002", (String)"InventoryLevelImportPlugin_11", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), fieldMap.getOrDefault(field2, field2)), url);
                return false;
            }
            dsFieldSet.remove(field2);
        }
        if (!"mrp".equals(appId) && !dsFieldSet.isEmpty()) {
            field = (String)dsFieldSet.stream().findFirst().get();
            this.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u7f3a\u5c11\u5b57\u6bb5\uff1a\u201c%s\u201d\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u5bfc\u5165\u6a21\u677f\u3002", (String)"InventoryLevelImportPlugin_12", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), fieldMap.getOrDefault(field, field)), url);
            return false;
        }
        if ("mrp".equals(appId) && !dsFieldSet.isEmpty()) {
            field = (String)dsFieldSet.stream().findFirst().get();
            this.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u7f3a\u5c11\u5b57\u6bb5\uff1a\u201c%s\u201d\uff0c\u8bf7\u4f7f\u7528MRP\u4e13\u7528\u5bfc\u5165\u6a21\u677f\u3002", (String)"InventoryLevelImportPlugin_13", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), fieldMap.getOrDefault(field, field)), url);
            return false;
        }
        return true;
    }

    public boolean validateColNotExists(Map<Integer, String> dataMap, String url, Set<String> fieldSet, String appId) {
        for (Map.Entry<Integer, String> entry : dataMap.entrySet()) {
            String field = entry.getValue();
            fieldSet.remove(field);
        }
        if (!fieldSet.isEmpty()) {
            String field = (String)fieldSet.stream().findFirst().get();
            this.addErrorMessage(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5bfc\u5165\u6a21\u677f\u4e2d\u4e0d\u5b58\u5728\u5b57\u6bb5\uff1a\u201c%s\u201d\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684\u5bfc\u5165\u6a21\u677f\u3002", (String)"InventoryLevelImportPlugin_10", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), fieldMap.getOrDefault(field, field)), url);
            return false;
        }
        return true;
    }

    public void addErrorMessage(String errorMessage, String url) {
        this.ctx.getLogger(url).log(Integer.valueOf(0), errorMessage);
        this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
        this.ctx.setResolveComplete(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        String appId = this.ctx.getFormShowParameterAppId();
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>(2);
        for (String url : this.ctx.getAllUrls()) {
            InputStream in = null;
            try {
                in = service.getInputStream(url);
                List<Map<Integer, String>> excelList = InventoryLevelImportPlugin.readExcel(in);
                boolean isMultiImport = false;
                if (excelList == null || excelList.size() <= 2) continue;
                Map<Integer, String> dataMap = excelList.get(2);
                if (!(!"mrp".equals(appId) || this.validateDatas(dataMap, url, columnMap, mrpNotImportFieldSet, appId) && this.validateColNotExists(dataMap, url, orgMaterialSet, appId))) {
                    return;
                }
                if (!"mrp".equals(appId) && !this.validateDatas(dataMap, url, columnMap, scmNotImportFieldSet, appId)) {
                    return;
                }
                int dimensionIndex = columnMap.get("dimension.number") == null ? -1 : (Integer)columnMap.get("dimension.number");
                int numberIndex = columnMap.get("number") == null ? -1 : (Integer)columnMap.get("dimension.number");
                String dimensionNumber = "";
                if (dimensionIndex != -1 && numberIndex != -1) {
                    for (int index = 4; index < excelList.size(); ++index) {
                        Map<Integer, String> dataIndex = excelList.get(index);
                        if ((dataIndex.get(dimensionIndex) != null || dataIndex.get(numberIndex) != null) && isMultiImport) {
                            this.addErrorMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u4e0d\u652f\u6301\u540c\u65f6\u5bfc\u5165\u591a\u6761\u6570\u636e\u3002", (String)"InventoryLevelImportPlugin_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), url);
                            return;
                        }
                        if (dataIndex.get(dimensionIndex) == null && dataIndex.get(numberIndex) == null) continue;
                        isMultiImport = true;
                        dimensionNumber = dataIndex.get(dimensionIndex);
                    }
                }
                if ("mrp".equals(appId) || !StringUtils.isNotEmpty((CharSequence)dimensionNumber)) continue;
                HashSet<String> dsFieldSet = new HashSet<String>(5);
                QFilter dimensionNumberFilter = new QFilter("number", "=", (Object)dimensionNumber);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"InventoryLevel", (String)"msplan_plan_dimension", (String)"entryentity.associationobject associationobject", (QFilter[])new QFilter[]{dimensionNumberFilter}, null);){
                    for (Row row : dataSet) {
                        String associationobject = row.getString("associationobject") + ".number";
                        dsFieldSet.add(associationobject);
                        dimensionSet.remove(associationobject);
                    }
                }
                if (this.validateColumns(dataMap, url, dimensionSet, dsFieldSet, appId)) continue;
                return;
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.addErrorMessage(ExceptionUtils.getExceptionStackTraceMessage((Exception)e), url);
                return;
            }
            finally {
                this.safeClose(in);
            }
        }
        super.resolveExcel();
    }

    private void safeClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    public static List<Map<Integer, String>> readExcel(InputStream inputStream) throws Exception {
        final LinkedList<Map<Integer, String>> sheet = new LinkedList<Map<Integer, String>>();
        try {
            new ExcelReader().read(inputStream, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    sheet.add(row.getData());
                }
            });
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return sheet;
    }

    static {
        mrpNotImportFieldSet.add("bd_warehouse.number");
        mrpNotImportFieldSet.add("bd_warehouse.name");
        mrpNotImportFieldSet.add("bd_materialgroupstandard.number");
        mrpNotImportFieldSet.add("bd_materialgroupstandard.name");
        mrpNotImportFieldSet.add("bd_materialgroup.number");
        mrpNotImportFieldSet.add("bd_materialgroup.name");
        mrpNotImportFieldSet.add("datestart");
        mrpNotImportFieldSet.add("dateend");
        scmNotImportFieldSet.add("materialattr");
        scmNotImportFieldSet.add("operator");
        scmNotImportFieldSet.add("reservedtype");
        scmNotImportFieldSet.add("yield");
        scmNotImportFieldSet.add("wastagerate");
        scmNotImportFieldSet.add("wastagerateformula");
        scmNotImportFieldSet.add("inspectionleadtime");
        scmNotImportFieldSet.add("preprocessingtime");
        scmNotImportFieldSet.add("postprocessingtime");
        scmNotImportFieldSet.add("plantag");
        dimensionSet.add("bos_org.number");
        dimensionSet.add("bd_warehouse.number");
        dimensionSet.add("bd_materialgroupstandard.number");
        dimensionSet.add("bd_materialgroup.number");
        dimensionSet.add("bd_material.number");
        orgMaterialSet.add("bd_material.number");
        orgMaterialSet.add("bos_org.number");
        fieldMap.put("bos_org.number", ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7.\u7f16\u7801", (String)"InventoryLevelImportPlugin_5", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        fieldMap.put("bd_material.number", ResManager.loadKDString((String)"\u7269\u6599.\u7f16\u7801", (String)"InventoryLevelImportPlugin_6", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        fieldMap.put("bd_warehouse.number", ResManager.loadKDString((String)"\u4ed3\u5e93.\u7f16\u7801", (String)"InventoryLevelImportPlugin_7", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        fieldMap.put("bd_materialgroupstandard.number", ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u6807\u51c6.\u7f16\u7801", (String)"InventoryLevelImportPlugin_8", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        fieldMap.put("bd_materialgroup.number", ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b.\u7f16\u7801", (String)"InventoryLevelImportPlugin_9", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
    }
}

