/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mpscmm.msplan.business.inventory.InvLevelConst;
import kd.mpscmm.msplan.business.inventory.InventoryDimension;
import kd.mpscmm.msplan.business.inventory.InventoryUtil;
import kd.mpscmm.msplan.mrp.business.helper.PlanViewOrgHelper;

public class InventoryLevelSaveValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<ExtendedDataEntity> dataEntityList = new ArrayList<ExtendedDataEntity>(Arrays.asList(this.dataEntities));
        if (dataEntityList.size() == 0) {
            return;
        }
        DynamicObject firstData = ((ExtendedDataEntity)dataEntityList.get(0)).getDataEntity();
        String type = firstData.getString("type");
        IDataEntityType dataEntityType = firstData.getDataEntityType();
        EntryProp entryProp = (EntryProp)dataEntityType.getProperties().get((Object)"entryentity");
        IDataEntityProperty seqProp = ((EntryType)entryProp.getItemType()).getSeqProperty();
        if (seqProp == null) {
            return;
        }
        this.checkImportSave(dataEntityList);
        HashSet<Long> orgSet = new HashSet<Long>(16);
        HashSet<Long> materielSet = new HashSet<Long>(16);
        this.checkBaseData(dataEntityList, orgSet, materielSet);
        if ("A".equals(type)) {
            this.checkExist(dataEntityList);
            this.checkMtPlan(dataEntityList, orgSet, materielSet);
        }
    }

    private void checkBaseData(List<ExtendedDataEntity> dataEntityList, Set<Long> orgSet, Set<Long> materielSet) {
        Iterator<ExtendedDataEntity> iterator = dataEntityList.iterator();
        while (iterator.hasNext()) {
            ExtendedDataEntity dataEntity = iterator.next();
            DynamicObject inventrory = dataEntity.getDataEntity();
            Object dimension = inventrory.getDynamicObject("dimension").getPkValue();
            InventoryDimension dim = InventoryUtil.getDimension((Object)dimension);
            DynamicObjectCollection entryentity = inventrory.getDynamicObjectCollection("entryentity");
            List<String> errList = this.checkSaveData(entryentity, dim, orgSet, materielSet);
            if (errList.isEmpty()) continue;
            for (String err : errList) {
                this.addErrorMessage(dataEntity, err);
            }
            iterator.remove();
        }
    }

    private void checkImportSave(List<ExtendedDataEntity> dataEntityList) {
        String operateKey = this.getOperateKey();
        Iterator<ExtendedDataEntity> iterator = dataEntityList.iterator();
        while (iterator.hasNext()) {
            ExtendedDataEntity dataEntity = iterator.next();
            String status = dataEntity.getDataEntity().getString("status");
            if (!"save".equals(operateKey) || "A".equals(status)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u80fd\u4fdd\u5b58\u3002", (String)"InventoryLevelSaveValidator_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            iterator.remove();
        }
    }

    private void checkExist(List<ExtendedDataEntity> dataEntityList) {
        block25: {
            DynamicObject dynamicObject;
            StringBuilder errorMessage;
            String scopeControlInvNumber;
            String scopeControlOrgName;
            boolean hasScopeControlDatas;
            HashMap<Long, String> orgToNumberMap;
            HashMap<Long, String> orgToNameMap;
            HashMap<Long, HashSet<Long>> scopeControlMap;
            block24: {
                String ctrlView = PlanViewOrgHelper.getCtrlViewByEntityType((String)"msplan_invlevel");
                HashSet<Long> idSet = new HashSet<Long>(dataEntityList.size());
                for (ExtendedDataEntity extendedDataEntity : dataEntityList) {
                    if (extendedDataEntity == null || extendedDataEntity.getDataEntity() == null) continue;
                    idSet.add(extendedDataEntity.getDataEntity().getLong("id"));
                }
                QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)"A"), new QFilter("ctrlstrategy", "in", (Object)new String[]{"5", "6"}), new QFilter("id", "not in", idSet)};
                String shareData = "";
                String shareOrg = "";
                scopeControlMap = new HashMap<Long, HashSet<Long>>(16);
                orgToNameMap = new HashMap<Long, String>(16);
                orgToNumberMap = new HashMap<Long, String>(16);
                hasScopeControlDatas = false;
                scopeControlOrgName = "";
                scopeControlInvNumber = "";
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"InventoryLevelSaveValidator", (String)"msplan_invlevel", (String)"id,number,createorg,createorg.name,type,status,enable,ctrlstrategy", (QFilter[])qFilters, null);){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        if ("5".equals(row.getString("ctrlstrategy"))) {
                            shareData = row.getString("number");
                            shareOrg = row.getString("createorg.name");
                            break;
                        }
                        if (row.get("createorg") == null || row.getLong("createorg") == 0L) continue;
                        Long createorg = row.getLong("createorg");
                        String number = row.getString("number");
                        String createOrgName = row.getString("createorg.name");
                        if (StringUtils.isEmpty((CharSequence)scopeControlOrgName)) {
                            scopeControlOrgName = createOrgName;
                        }
                        if (StringUtils.isEmpty((CharSequence)scopeControlInvNumber)) {
                            scopeControlInvNumber = number;
                        }
                        orgToNameMap.put(createorg, createOrgName);
                        orgToNumberMap.put(createorg, number);
                        if (scopeControlMap.get(createorg) == null) {
                            ArrayList<Long> orgList = new ArrayList<Long>(2);
                            orgList.add(createorg);
                            HashSet<Long> orgSet = new HashSet<Long>(16);
                            List superOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)ctrlView, (long)createorg);
                            List subOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)ctrlView, orgList, (boolean)true);
                            this.addScopeOrgs(orgSet, superOrgs);
                            this.addScopeOrgs(orgSet, subOrgs);
                            scopeControlMap.put(createorg, orgSet);
                        }
                        hasScopeControlDatas = true;
                    }
                }
                if (shareData.isEmpty()) break block24;
                for (ExtendedDataEntity extendedDataEntity : dataEntityList) {
                    errorMessage = new StringBuilder();
                    dynamicObject = extendedDataEntity.getDataEntity();
                    if (dynamicObject.get("ctrlstrategy") == null || !"5".equals(dynamicObject.getString("ctrlstrategy")) && !"6".equals(dynamicObject.getString("ctrlstrategy"))) continue;
                    errorMessage.append(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%2$s\u201d\u5168\u5c40\u5171\u4eab\u6570\u636e\u3002", (String)"InventoryLevelSaveValidator_20", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), shareOrg, shareData));
                    this.addErrorMessage(extendedDataEntity, errorMessage.toString());
                }
                break block25;
            }
            if (scopeControlMap.isEmpty()) break block25;
            for (ExtendedDataEntity extendedDataEntity : dataEntityList) {
                errorMessage = new StringBuilder();
                dynamicObject = extendedDataEntity.getDataEntity();
                if ("5".equals(dynamicObject.getString("ctrlstrategy")) && hasScopeControlDatas) {
                    errorMessage.append(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%2$s\u201d\u7ba1\u63a7\u8303\u56f4\u5185\u5171\u4eab\u6570\u636e\u3002", (String)"InventoryLevelSaveValidator_27", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), scopeControlOrgName, scopeControlInvNumber));
                    this.addErrorMessage(extendedDataEntity, errorMessage.toString());
                    errorMessage.setLength(0);
                    continue;
                }
                if (dynamicObject.get("ctrlstrategy") == null || !"5".equals(dynamicObject.getString("ctrlstrategy")) && !"6".equals(dynamicObject.getString("ctrlstrategy")) || dynamicObject.get("createorg") == null) continue;
                DynamicObject createOrg = (DynamicObject)dynamicObject.get("createorg");
                Long createOrgId = createOrg.getLong("id");
                if (scopeControlMap.get(createOrgId) != null) {
                    errorMessage.append(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%2$s\u201d\u7ba1\u63a7\u8303\u56f4\u5185\u5171\u4eab\u6570\u636e\u3002", (String)"InventoryLevelSaveValidator_27", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), orgToNameMap.get(createOrgId), orgToNumberMap.get(createOrgId)));
                    this.addErrorMessage(extendedDataEntity, errorMessage.toString());
                    continue;
                }
                for (Map.Entry entry : scopeControlMap.entrySet()) {
                    Long orgId = (Long)entry.getKey();
                    Set scopes = (Set)entry.getValue();
                    if (!scopes.contains(createOrgId)) continue;
                    errorMessage.setLength(0);
                    errorMessage.append(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\u4e0b\u5df2\u5b58\u5728\u201c%2$s\u201d\u7ba1\u63a7\u8303\u56f4\u5185\u5171\u4eab\u6570\u636e\u3002", (String)"InventoryLevelSaveValidator_27", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), orgToNameMap.get(orgId), orgToNumberMap.get(orgId)));
                    this.addErrorMessage(extendedDataEntity, errorMessage.toString());
                }
            }
        }
    }

    private void addScopeOrgs(Set<Long> orgSet, List<Long> superOrgs) {
        for (Long org : superOrgs) {
            orgSet.add(org);
        }
    }

    private void checkMtPlan(List<ExtendedDataEntity> successEntity, Set<Long> orgSet, Set<Long> materielSet) {
        Set<String> mtPlanInfoSet = this.getMtPlanInfoSet(orgSet, materielSet);
        for (ExtendedDataEntity dataEntity : successEntity) {
            DynamicObject dt = dataEntity.getDataEntity();
            DynamicObjectCollection entryentity = dt.getDynamicObjectCollection("entryentity");
            for (DynamicObject dyn : entryentity) {
                Long orgId = 0L;
                if (dyn.getDynamicObject("bos_org") != null) {
                    orgId = dyn.getDynamicObject("bos_org").getLong("id");
                }
                Long materialId = 0L;
                if (dyn.getDynamicObject("bd_material") != null) {
                    materialId = dyn.getDynamicObject("bd_material").getLong("id");
                }
                if (orgId == 0L || materialId == 0L) continue;
                StringBuilder value = new StringBuilder();
                value.append(orgId).append('-').append(materialId);
                int seq = dyn.getInt("seq");
                if (!mtPlanInfoSet.contains(value.toString())) continue;
                String format = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7ec4\u7ec7 + \u7269\u6599\u5df2\u7ecf\u5b58\u5728\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u4e0d\u80fd\u65b0\u589e\u4fee\u6539\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u3002", (String)"InventoryLevelSaveValidator_2", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), seq);
                this.addErrorMessage(dataEntity, format);
            }
        }
    }

    private Set<String> getMtPlanInfoSet(Set<Long> orgSet, Set<Long> materielSet) {
        return this.mtPlanInfoSet(orgSet, materielSet);
    }

    private void checkGTZero(String col, String colName, DynamicObject row, List<String> errs) {
        BigDecimal val = row.getBigDecimal(col);
        if (val == null || val.compareTo(BigDecimal.ZERO) <= 0) {
            String format = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u5b57\u6bb5\u201c%s\u201d\u503c\u9700\u8981\u5927\u4e8e0\u3002", (String)"InventoryLevelSaveValidator_3", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), row.getInt("seq"), colName);
            errs.add(format);
        }
    }

    private List<String> checkSaveData(DynamicObjectCollection entity, InventoryDimension dim, Set<Long> orgSet, Set<Long> materielSet) {
        List key;
        ArrayList<Range> errList = new ArrayList<Range>(4);
        ArrayList<String> errResults = new ArrayList<String>(4);
        List entityNames = dim.getEntityNames();
        Map entityToNameMap = dim.getEntityToNameMap();
        boolean hasMtType = entityNames.contains("bd_materialgroupstandard");
        HashMap<Long, Long> orgToMttype = new HashMap<Long, Long>(4);
        HashMap<List, List> oldDataMap = new HashMap<List, List>();
        HashMap<List, List> newDataMap = new HashMap<List, List>();
        long fakeId = 1L;
        boolean hasAll = dim.hasMtAndGrp();
        for (DynamicObject row : entity) {
            long l;
            String err;
            int seq = row.getInt("seq");
            if (row.getDynamicObject("bos_org") != null) {
                orgSet.add(row.getDynamicObject("bos_org").getLong("id"));
            }
            if (row.getDynamicObject("bd_material") != null) {
                materielSet.add(row.getDynamicObject("bd_material").getLong("id"));
            }
            for (Map.Entry entry : entityToNameMap.entrySet()) {
                DynamicObject val = row.getDynamicObject((String)entry.getKey());
                if (val != null || hasAll && "bd_material".equals(entry.getKey())) continue;
                String format = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%d\u884c\uff1a\u201c%s\u201d\u3002", (String)"InventoryLevelSaveValidator_4", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), seq, entry.getValue());
                errResults.add(format);
            }
            String planType = row.getString("plantype");
            if (InvLevelConst.PlanType.get((String)planType) == InvLevelConst.PlanType.REORDER) {
                row.set("max", (Object)0.0);
                row.set("min", (Object)0.0);
                this.checkGTZero("reorder", ResManager.loadKDString((String)"\u518d\u8ba2\u8d27\u70b9", (String)"InventoryLevelSaveValidator_5", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), row, errResults);
                this.checkGTZero("ecobatch", ResManager.loadKDString((String)"\u7ecf\u6d4e\u6279\u91cf", (String)"InventoryLevelSaveValidator_6", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), row, errResults);
            } else if (InvLevelConst.PlanType.get((String)planType) == InvLevelConst.PlanType.MAXMIN) {
                row.set("reorder", (Object)0.0);
                row.set("ecobatch", (Object)0.0);
                row.set("dailyconsume", (Object)0.0);
                this.checkGTZero("max", ResManager.loadKDString((String)"\u6700\u5927\u503c", (String)"InventoryLevelSaveValidator_7", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), row, errResults);
                this.checkGTZero("min", ResManager.loadKDString((String)"\u6700\u5c0f\u503c", (String)"InventoryLevelSaveValidator_8", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), row, errResults);
                BigDecimal max = row.getBigDecimal("max");
                BigDecimal min = row.getBigDecimal("min");
                if (max.compareTo(min) <= 0) {
                    String err2 = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u6700\u5927\u503c\u9700\u8981\u5927\u4e8e\u6700\u5c0f\u503c\u3002", (String)"InventoryLevelSaveValidator_9", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), seq);
                    errResults.add(err2);
                }
            }
            if (row.getDate("datestart") == null) {
                err = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u751f\u6548\u65e5\u671f\u5fc5\u5f55\u3002", (String)"InventoryLevelSaveValidator_10", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), seq);
                errResults.add(err);
            }
            if (row.getDate("dateend") == null) {
                err = String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a\u5931\u6548\u65e5\u671f\u5fc5\u5f55\u3002", (String)"InventoryLevelSaveValidator_11", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), seq);
                errResults.add(err);
            }
            if (!errResults.isEmpty()) continue;
            long id = row.getLong("id");
            Range range = new Range();
            if (id == 0L) {
                long l2 = fakeId;
                l = l2;
                fakeId = l2 + 1L;
            } else {
                l = id;
            }
            range.id = l;
            ArrayList<Object> grps = new ArrayList<Object>(8);
            for (String entityName : entityNames) {
                DynamicObject dd = row.getDynamicObject(entityName);
                Object val = dd == null ? null : dd.getPkValue();
                grps.add(val);
            }
            boolean newData = row.getDataEntityState().isChanged();
            if (newData) {
                newDataMap.computeIfAbsent(grps, k -> new ArrayList(2)).add(range);
            } else {
                oldDataMap.computeIfAbsent(grps, k -> new ArrayList(2)).add(range);
            }
            Long org = (Long)row.getDynamicObject("bos_org").getPkValue();
            if (hasMtType) {
                Long mttype = (Long)row.getDynamicObject("bd_materialgroupstandard").getPkValue();
                range.mtType = mttype;
                if (newData) {
                    orgToMttype.putIfAbsent(org, mttype);
                } else {
                    orgToMttype.put(org, mttype);
                }
            }
            range.org = org;
            range.startDate = row.getDate("datestart").getTime();
            range.endDate = row.getDate("dateend").getTime();
            range.dyn = row;
            range.seq = seq;
            range.planType = row.getString("plantype");
        }
        if (!errResults.isEmpty()) {
            return errResults;
        }
        HashMap<List, String> dimPlanType = new HashMap<List, String>(4);
        for (Map.Entry entry : oldDataMap.entrySet()) {
            key = (List)entry.getKey();
            List value = (List)entry.getValue();
            if (value.size() <= 0) continue;
            dimPlanType.put(key, ((Range)value.get(0)).planType);
        }
        for (Map.Entry entry : newDataMap.entrySet()) {
            key = (List)entry.getKey();
            List ranges = (List)entry.getValue();
            String firstPlanType = (String)dimPlanType.get(key);
            for (Range range : ranges) {
                int seq = range.seq;
                StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u5206\u5f55\u884c", (String)"InventoryLevelSaveValidator_12", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
                sb.append(seq).append('\uff1a');
                int length = sb.length();
                if (hasMtType) {
                    Long srcMttype = (Long)orgToMttype.get(range.org);
                    if (!range.mtType.equals(srcMttype)) {
                        sb.append(ResManager.loadKDString((String)"\u540c\u7ec4\u7ec7\u4e0b\u7269\u6599\u5206\u7c7b\u6807\u51c6\u4e0d\u4e00\u81f4\u3002", (String)"InventoryLevelSaveValidator_13", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
                    }
                }
                if (range.startDate > range.endDate) {
                    sb.append(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"InventoryLevelSaveValidator_14", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
                }
                if (firstPlanType == null) {
                    firstPlanType = range.planType;
                } else if (!firstPlanType.equals(range.planType)) {
                    sb.append(ResManager.loadKDString((String)"\u540c\u4e00\u7ef4\u5ea6\u4e0b\uff0c\u8ba1\u5212\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"InventoryLevelSaveValidator_15", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
                }
                if (sb.length() <= length) continue;
                range.errInfo = sb.toString();
                errList.add(range);
            }
        }
        if (!errList.isEmpty()) {
            return errList.stream().map(x -> ((Range)x).errInfo).collect(Collectors.toList());
        }
        for (List ranges : newDataMap.values()) {
            int size = ranges.size();
            for (int i = 0; i < size - 1; ++i) {
                Range range = (Range)ranges.get(i);
                List<Range> subRanges = ranges.subList(i + 1, size);
                errList.addAll(this.checkRanges(Collections.singletonList(range), subRanges));
            }
        }
        if (!errList.isEmpty()) {
            return errList.stream().map(x -> ((Range)x).errInfo).collect(Collectors.toList());
        }
        for (Map.Entry entry : newDataMap.entrySet()) {
            List key2 = (List)entry.getKey();
            List ranges = (List)entry.getValue();
            List destRanges = (List)oldDataMap.get(key2);
            if (destRanges == null) continue;
            errList.addAll(this.checkRanges(ranges, destRanges));
        }
        return errList.stream().map(x -> ((Range)x).errInfo).collect(Collectors.toList());
    }

    private List<Range> checkRanges(List<Range> srcRange, List<Range> destRange) {
        ArrayList<Range> list = new ArrayList<Range>(4);
        for (Range src : srcRange) {
            StringBuilder msb = new StringBuilder();
            ArrayList<Range> mlist = new ArrayList<Range>(destRange.size());
            for (Range dest : destRange) {
                if (src.id == dest.id || !this.isIntersect(src.startDate, src.endDate, dest.startDate, dest.endDate)) continue;
                mlist.add(dest);
            }
            if (mlist.isEmpty()) continue;
            int seq = src.dyn.getInt("seq");
            ArrayList<Integer> seqLst = new ArrayList<Integer>(8);
            for (Range range : mlist) {
                seqLst.add(range.seq);
            }
            msb.append(ResManager.loadKDString((String)"\u5206\u5f55", (String)"InventoryLevelSaveValidator_16", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0])).append(seq).append(ResManager.loadKDString((String)"\u884c\uff1a", (String)"InventoryLevelSaveValidator_17", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            if (!seqLst.isEmpty()) {
                msb.append(ResManager.loadKDString((String)"\u4e0e\u5206\u5f55\u884c", (String)"InventoryLevelSaveValidator_18", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0])).append(this.wrapList(seqLst)).append(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u91cd\u53e0\u3002", (String)"InventoryLevelSaveValidator_19", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            }
            src.errInfo = msb.toString();
            list.add(src);
        }
        return list;
    }

    private <T> String wrapList(List<T> list) {
        String s = list.toString();
        return s.replace('[', '\u3010').replaceAll("]", "\u3011");
    }

    private <T extends Comparable<T>> boolean isIntersect(T s1, T e1, T s2, T e2) {
        if (s1.compareTo(s2) >= 0 && s1.compareTo(e2) <= 0) {
            return true;
        }
        if (e1.compareTo(s2) >= 0 && e1.compareTo(e2) <= 0) {
            return true;
        }
        return s1.compareTo(s2) < 0 && e1.compareTo(e2) > 0;
    }

    private Set<String> mtPlanInfoSet(Set<Long> orgSet, Set<Long> materielSet) {
        HashSet<String> set = new HashSet<String>();
        QFilter[] qFilter = new QFilter[]{new QFilter("createorg", "in", orgSet), new QFilter("masterid", "in", materielSet)};
        DynamicObjectCollection querys = QueryServiceHelper.query((String)"mpdm_materialplan", (String)"masterid,createorg", (QFilter[])qFilter);
        for (DynamicObject query : querys) {
            long orgId = query.getLong("createorg");
            long materialId = query.getLong("masterid");
            StringBuilder materialPlan = new StringBuilder();
            materialPlan.append(orgId).append('-').append(materialId);
            set.add(materialPlan.toString());
        }
        return set;
    }

    private static class Range {
        private long id = 0L;
        private long startDate = 0L;
        private long endDate = 0L;
        private int seq;
        private String planType;
        private Long org;
        private Long mtType;
        private DynamicObject dyn;
        private String errInfo;

        private Range() {
        }
    }
}

