/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class MultiOrgSupdemValidator
extends AbstractValidator {
    private static final String NODEDETAILS = "mrp_nodedetails";
    private static final String ENABLE = "enable";
    private static final String PARENTDNYID = "parentdnyid";

    public void validate() {
        String operate;
        switch (operate = this.getOperateKey()) {
            case "submit": 
            case "save": {
                this.checkData(operate);
                break;
            }
        }
    }

    private void checkData(String operate) {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            Object pkValue = dataEntity.getPkValue();
            DynamicObjectCollection query = QueryServiceHelper.query((String)NODEDETAILS, (String)"id", (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)pkValue.toString()).and(new QFilter(ENABLE, "=", (Object)"1"))});
            Object[] ob = new Object[query.size()];
            int k = 0;
            for (DynamicObject dynamicObject : query) {
                ob[k] = dynamicObject.getLong("id");
                ++k;
            }
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)NODEDETAILS);
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ob, (DynamicObjectType)dynamicObject.getDynamicObjectType());
            String billNo = this.dataEntities[i].getBillNo();
            if (load.length == 0 && "submit".equals(operate)) {
                if ("mrp".equals(this.getAppId())) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u9700\u5173\u7cfb\u5b9a\u4e49\u9875\u7b7e\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"MultiOrgSupdemValidator_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
                } else {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u8868\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"MultiOrgSupdemValidator_44", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
            for (DynamicObject value : load) {
                boolean checkdemandorg = this.checkdemandorg(value, i, billNo);
                this.checkSupplyOrgEqualsDemandOrg(value, i, "defaultsupply", "defaultsupplyorg", "defaultsupplyrule");
                this.checkSpecialMaterialSet(value, i);
                if (!checkdemandorg) continue;
                this.checkStockTypeAndStockStatus(value, i);
                Map<String, String> rowMap = this.checkStockSupplyOrgSet(value, i);
                if (rowMap.get("isContinue") != null) continue;
                this.checkSamePriorityData(i, rowMap, "1", "stocksorgentrentryentity", value);
                this.checkStockSupplyStockSet(value, i);
                this.checkStockSupplyMateriaSet(value, i);
            }
        }
    }

    public String getAppId() {
        return (String)this.getValidateContext().getOption().getVariables().get("appnumber");
    }

    private boolean checkdemandorg(DynamicObject dataEntity, int i, String billNo) {
        DynamicObject demandorg = dataEntity.getDynamicObject("demandorg");
        DynamicObject stockdemandorg = dataEntity.getDynamicObject("stockdemandorg");
        if (demandorg == null) {
            if (stockdemandorg != null) {
                // empty if block
            }
        } else {
            if (stockdemandorg == null) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u5bf9\u5e94\u7684\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7684\u503c\u3002", (String)"MultiOrgSupdemValidator_45", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorg.getString("number"), demandorg.getString("name")));
                return false;
            }
            this.dataEntities[i].setBillNo(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%1$s\u9700\u6c42\u7ec4\u7ec7\u4e3a%2$s\u3002", (String)"MultiOrgSupdemValidator_34", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), billNo, demandorg.getString("name")));
        }
        return true;
    }

    private void checkStockSupplyMateriaSet(DynamicObject dataEntity, int i) {
        HashMap<String, String> orgRowMap = new HashMap<String, String>(16);
        HashMap<String, String> rowMap = new HashMap<String, String>(16);
        HashMap<String, String> scaleMap = new HashMap<String, String>(16);
        DynamicObjectCollection material = dataEntity.getDynamicObjectCollection("materialsetup");
        if (material.size() > 0) {
            for (DynamicObject dynamicObject : material) {
                if (dynamicObject.getDynamicObject("materialorg") == null || dynamicObject.getDynamicObject("materiel") == null) continue;
                this.getMaterialSamePriorityData(dynamicObject, rowMap, true);
                this.getMaterialSamePriorityData(dynamicObject, orgRowMap, false);
                this.getMaterialScale(dynamicObject, scaleMap);
            }
        }
        this.checkSamePriorityData(i, rowMap, "1", "materialsetup", dataEntity);
        this.checkSamePriorityData(i, orgRowMap, "2", "materialsetup", dataEntity);
        this.checkMaterialScale(i, scaleMap, dataEntity);
    }

    private void getMaterialScale(DynamicObject dynamicObject, Map<String, String> scaleMap) {
        String materialOrgId = dynamicObject.getDynamicObject("materialorg").getString("id");
        String materialId = dynamicObject.getDynamicObject("materiel").getString("id");
        String key = materialOrgId + "," + materialId;
        BigDecimal stockratio = dynamicObject.getBigDecimal("stockratio");
        String seq = dynamicObject.getString("seq");
        String id = dynamicObject.getString("id");
        if (scaleMap.containsKey(key)) {
            String value = scaleMap.get(key);
            String[] split = value.split("\\|\\|");
            stockratio = stockratio.add(new BigDecimal(split[0]));
            String row = split[1] + "," + seq;
            id = split[2] + "," + id;
            value = stockratio + "||" + row + "||" + id;
            scaleMap.put(key, value);
        } else {
            scaleMap.put(key, stockratio + "||" + seq + "||" + id);
        }
    }

    private QFilter[] getAllMateriaAndOrgFilter(Map<String, String> scaleMap, DynamicObject dataEntity) {
        ArrayList<Long> materialList = new ArrayList<Long>(16);
        ArrayList<Long> materielOrgList = new ArrayList<Long>(16);
        for (Map.Entry<String, String> mapEntry : scaleMap.entrySet()) {
            String key = mapEntry.getKey();
            String[] split = key.split(",");
            materielOrgList.add(Long.parseLong(split[0]));
            materialList.add(Long.parseLong(split[1]));
        }
        QFilter isNotMineqfilter = new QFilter("id", "!=", (Object)dataEntity.getLong("id"));
        QFilter qfilter = new QFilter("materialsetup.materialorg.id", "in", materielOrgList);
        QFilter mfilter = new QFilter("materialsetup.materiel.id", "in", materialList);
        QFilter enablefilter = new QFilter(ENABLE, "=", (Object)"1");
        return new QFilter[]{qfilter, mfilter, enablefilter, isNotMineqfilter};
    }

    private void getOtherScaleData(QFilter[] allMateriaAndOrgFilter, Map<String, String> otherscaleMap) {
        DynamicObjectCollection materials = QueryServiceHelper.query((String)NODEDETAILS, (String)"id,materialsetup.materialorg.id,materialsetup.materiel.id,materialsetup.stockratio", (QFilter[])allMateriaAndOrgFilter);
        for (DynamicObject material : materials) {
            String materialorgId = material.getString("materialsetup.materialorg.id");
            String materielId = material.getString("materialsetup.materiel.id");
            String key = materialorgId + "," + materielId;
            BigDecimal bigDecimal = material.getBigDecimal("materialsetup.stockratio");
            String id = material.getString("id");
            if (otherscaleMap.containsKey(key)) {
                String value = otherscaleMap.get(key);
                String[] split = value.split("\\|\\|");
                bigDecimal = bigDecimal.add(new BigDecimal(split[0]));
                id = split[1] + "," + id;
                value = bigDecimal + "||" + id;
                otherscaleMap.put(key, value);
            }
            otherscaleMap.put(key, bigDecimal + "||" + id);
        }
    }

    private void checkMaterialScale(int i, Map<String, String> scaleMap, DynamicObject dataEntity) {
        HashMap<String, String> otherscaleMap = new HashMap<String, String>(8);
        Map<String, String> demandorgNameAndNumber = this.getDemandorgNameAndNumber(dataEntity);
        String demandorgName = demandorgNameAndNumber.get("name");
        String demandorgNumber = demandorgNameAndNumber.get("number");
        QFilter[] allMateriaAndOrgFilter = this.getAllMateriaAndOrgFilter(scaleMap, dataEntity);
        this.getOtherScaleData(allMateriaAndOrgFilter, otherscaleMap);
        for (Map.Entry<String, String> mapEntry : scaleMap.entrySet()) {
            String key = mapEntry.getKey();
            String value = mapEntry.getValue();
            String[] split = value.split("\\|\\|");
            BigDecimal bigDecimal = new BigDecimal(split[0]);
            if (bigDecimal.compareTo(BigDecimal.ONE) > 0) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u7b2c%3$s\u884c\u53ef\u4f9b\u5e94\u6bd4\u4f8b\u6570\u503c\u76f8\u52a0\u4e3a%4$s,\u8be5\u503c\u5927\u4e8e1,\u8bf7\u5904\u7406\u884c\u3002", (String)"MultiOrgSupdemValidator_46", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, split[1], split[0]));
                continue;
            }
            if (!otherscaleMap.containsKey(key)) continue;
            String otherValue = (String)otherscaleMap.get(key);
            String[] split1 = otherValue.split("\\|\\|");
            ArrayList<String> idList = new ArrayList<String>(Arrays.asList(split1[1].split(",")));
            if (idList.contains(split[2].split(",")[0])) {
                if (new BigDecimal(split1[0]).compareTo(BigDecimal.ONE) <= 0) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u7b2c%3$s\u884c\u5e93\u5b58\u7ec4\u7ec7+\u7269\u6599\u7684\u5404\u9879\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e4b\u548c\u4e3a%4$s,\u8be5\u503c\u5927\u4e8e1,\u8bf7\u5904\u7406\u884c\u3002", (String)"MultiOrgSupdemValidator_47", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, split[1], split1[0]));
                continue;
            }
            BigDecimal Scale = new BigDecimal(split1[0]).add(bigDecimal);
            if (Scale.compareTo(BigDecimal.ONE) <= 0) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u7b2c%3$s\u884c\u5e93\u5b58\u7ec4\u7ec7+\u7269\u6599\u7684\u5404\u9879\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e4b\u548c\u4e3a%4$s,\u8be5\u503c\u5927\u4e8e1,\u8bf7\u5904\u7406\u884c\u3002", (String)"MultiOrgSupdemValidator_47", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, split[1], Scale.setScale(2)));
        }
    }

    private void getMaterialSamePriorityData(DynamicObject dynamicObject, Map<String, String> rowMap, boolean isDim) {
        String materialId = dynamicObject.getDynamicObject("materiel").getString("id");
        String key = "";
        if (isDim) {
            String materialOrgId = dynamicObject.getDynamicObject("materialorg").getString("id");
            DynamicObject stock = dynamicObject.getDynamicObject("stock");
            String stockId = "";
            if (stock != null) {
                stockId = stock.getString("id");
            }
            DynamicObject stockindex = dynamicObject.getDynamicObject("stockindexs");
            String stockIndexId = "";
            if (stockindex != null) {
                stockIndexId = stockindex.getString("id");
            }
            key = materialOrgId + "," + materialId + "," + stockId + "," + stockIndexId;
        } else {
            String supplypriority = dynamicObject.getString("prioritylevel");
            key = materialId + "," + supplypriority;
        }
        String seq = dynamicObject.getString("seq");
        if (rowMap.containsKey(key)) {
            seq = rowMap.get(key) + "," + seq;
            rowMap.put(key, seq);
            if (!rowMap.containsKey("isSame")) {
                rowMap.put("isSame", "1");
            }
        }
        rowMap.put(key, seq);
    }

    private void checkStockSupplyStockSet(DynamicObject dataEntity, int i) {
        Map<String, String> demandorgNameAndNumber = this.getDemandorgNameAndNumber(dataEntity);
        String demandorgNumber = demandorgNameAndNumber.get("number");
        String demandorgName = demandorgNameAndNumber.get("name");
        DynamicObjectCollection stocks = dataEntity.getDynamicObjectCollection("stocksetupentryentity");
        HashMap<String, String> orgRowMap = new HashMap<String, String>(16);
        HashMap<String, String> rowMap = new HashMap<String, String>(16);
        String setup = "";
        if (dataEntity.get("stocksetup") != null) {
            setup = dataEntity.getString("stocksetup");
        }
        if (stocks != null && stocks.size() > 0 && "1".equals(setup)) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5f53\u4ed3\u5e93\u8bbe\u7f6e\u9009\u9879\u4e3a\u5168\u90e8\u4ed3\u5e93\u65f6\uff0c\u4e0d\u5141\u8bb8\u4ed3\u5e93\u8bbe\u7f6e\u4e0b\u6709\u503c\u3002", (String)"MultiOrgSupdemValidator_6", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
        } else if (!("1".equals(setup) || stocks != null && stocks.size() != 0)) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4ed3\u5e93\u8bbe\u7f6e\u7684\u503c\u3002", (String)"MultiOrgSupdemValidator_37", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgNumber, demandorgName));
        } else if (!"1".equals(setup)) {
            for (DynamicObject stock : stocks) {
                if (stock.get("stockorg") == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u4ed3\u5e93\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_8", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), stock.getInt("seq")));
                }
                if (stock.get("stocknumber") == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u4ed3\u5e93\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7684\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_9", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), stock.getInt("seq")));
                }
                if (stock.get("stockorg") == null || stock.get("stocknumber") == null) continue;
                this.getStockSamePriorityData(stock, rowMap, true);
                this.getStockSamePriorityData(stock, orgRowMap, false);
            }
        }
        this.checkSamePriorityData(i, rowMap, "2", "stocksorgentrentryentity", dataEntity);
        this.checkSamePriorityData(i, orgRowMap, "3", "stocksorgentrentryentity", dataEntity);
    }

    private void getStockSamePriorityData(DynamicObject stock, Map<String, String> rowMap, boolean isDim) {
        String stockorgId = stock.getDynamicObject("stockorg").getString("id");
        String key = "";
        if (isDim) {
            String stocknumberId = stock.getDynamicObject("stocknumber").getString("id");
            DynamicObject stockindex = stock.getDynamicObject("stockindex");
            String stockindexId = "";
            if (stockindex != null) {
                stockindexId = stockindex.getString("id");
            }
            key = stockorgId + "," + stocknumberId + "," + stockindexId;
        } else {
            String supplypriority = stock.getString("supplypriority");
            key = stockorgId + "," + supplypriority;
        }
        String seq = stock.getString("seq");
        if (rowMap.containsKey(key)) {
            seq = rowMap.get(key) + "," + seq;
            if (!rowMap.containsKey("isSame")) {
                rowMap.put("isSame", "1");
            }
        }
        rowMap.put(key, seq);
    }

    private void getSamePriorityData(DynamicObject stockOrg, Map<String, String> rowMap) {
        String priority = stockOrg.getString("priority");
        String seq = stockOrg.getString("seq");
        if (rowMap.containsKey(priority)) {
            seq = rowMap.get(priority) + "," + seq;
            if (!rowMap.containsKey("isSame")) {
                rowMap.put("isSame", "1");
            }
        }
        rowMap.put(priority, seq);
    }

    private Map<String, String> checkStockSupplyOrgSet(DynamicObject dataEntity, int i) {
        Map<String, String> demandorgNameAndNumber = this.getDemandorgNameAndNumber(dataEntity);
        String demandorgNumber = demandorgNameAndNumber.get("number");
        String demandorgName = demandorgNameAndNumber.get("name");
        HashMap<String, String> rowMap = new HashMap<String, String>(16);
        DynamicObjectCollection stocksOrg = dataEntity.getDynamicObjectCollection("stocksorgentrentryentity");
        if (stocksOrg.size() > 0) {
            for (DynamicObject stockOrg : stocksOrg) {
                if (stockOrg.getDynamicObject("storageorg") == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7b2c%3$s\u884c\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_10", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, stockOrg.getInt("seq")));
                } else {
                    this.getSamePriorityData(stockOrg, rowMap);
                }
                if (stockOrg.get("stockscale") != null) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7b2c%3$s\u884c\u7684\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_48", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, stockOrg.getInt("seq")));
            }
        } else {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u503c\u3002", (String)"MultiOrgSupdemValidator_38", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgNumber, demandorgName));
            rowMap.put("isContinue", "1");
        }
        return rowMap;
    }

    private void checkSamePriorityData(int i, Map<String, String> rowMap, String sign, String entitySign, DynamicObject dataEntity) {
        if (rowMap.containsKey("isSame")) {
            Map<String, String> demandorgNameAndNumber = this.getDemandorgNameAndNumber(dataEntity);
            String demandorgName = demandorgNameAndNumber.get("name");
            String demandorgNumber = demandorgNameAndNumber.get("number");
            for (Map.Entry<String, String> mapEntry : rowMap.entrySet()) {
                String value;
                if ("isSame".equals(mapEntry.getKey()) || !(value = mapEntry.getValue()).contains(",")) continue;
                if ("stocksorgentrentryentity".equals(entitySign)) {
                    if ("1".equals(sign)) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\uff0c\u7ec4\u7ec7\u8bbe\u7f6e\u7b2c\u201c%3$s\u201d\u884c\u4f18\u5148\u7ea7\u91cd\u590d\uff0c\u8bf7\u5904\u7406\u3002", (String)"MultiOrgSupdemValidator_13", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, value));
                        continue;
                    }
                    if ("2".equals(sign)) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u4ed3\u5e93\u8bbe\u7f6e\u7b2c\u201c%3$s\u201d\u884c\u5b58\u5728\u91cd\u590d\u884c\uff0c\u8bf7\u5904\u7406\u3002", (String)"MultiOrgSupdemValidator_14", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, value));
                        continue;
                    }
                    if (!"3".equals(sign)) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%3$s\u884c\u4f18\u5148\u7ea7\u91cd\u590d\uff0c\u8bf7\u5904\u7406\u3002", (String)"MultiOrgSupdemValidator_15", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, value));
                    continue;
                }
                if ("1".equals(sign)) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7269\u6599\u8bbe\u7f6e\u7b2c\u201c%3$s\u201d\u884c\u5b58\u5728\u91cd\u590d\u884c\uff0c\u8bf7\u5904\u7406\u3002", (String)"MultiOrgSupdemValidator_16", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, value));
                    continue;
                }
                if (!"2".equals(sign)) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7269\u6599\u8bbe\u7f6e\u7b2c%3$s\u884c\u7269\u6599\u548c\u4f18\u5148\u7ea7\u91cd\u590d\uff0c\u8bf7\u5904\u7406\u3002", (String)"MultiOrgSupdemValidator_17", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, value));
            }
        }
    }

    private void checkStockTypeAndStockStatus(DynamicObject dataEntity, int i) {
        Map<String, String> demandorgNameAndNumber = this.getDemandorgNameAndNumber(dataEntity);
        MulBasedataDynamicObjectCollection stocktype = (MulBasedataDynamicObjectCollection)dataEntity.get("stocktype");
        MulBasedataDynamicObjectCollection stockstatus = (MulBasedataDynamicObjectCollection)dataEntity.get("stockstatus");
        if (stocktype.size() == 0) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\u4e3a%s\u53c2\u4e0eMRP\u5e93\u5b58\u7c7b\u578b\u7684\u503c\u3002", (String)"MultiOrgSupdemValidator_18", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgNameAndNumber.get("name")));
        }
        if (stockstatus.size() == 0) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u9700\u6c42\u7ec4\u7ec7\u4e3a%s\u53c2\u4e0eMRP\u5e93\u5b58\u72b6\u6001\u7684\u503c\u3002", (String)"MultiOrgSupdemValidator_49", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgNameAndNumber.get("name")));
        }
    }

    private Map<String, String> getDemandorgNameAndNumber(DynamicObject dataEntity) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        String demandorgNumber = "";
        String demandorgName = "";
        DynamicObject demandorg = dataEntity.getDynamicObject("demandorg");
        DynamicObject stockdemandorg = dataEntity.getDynamicObject("stockdemandorg");
        if (demandorg != null) {
            demandorgNumber = demandorg.getString("number");
            demandorgName = demandorg.getString("name");
        } else if (stockdemandorg != null) {
            demandorgNumber = stockdemandorg.getString("number");
            demandorgName = stockdemandorg.getString("name");
        }
        map.put("name", demandorgName);
        map.put("number", demandorgNumber);
        return map;
    }

    private Map<String, Map<String, List<DynamicObject>>> getAllSortEntity(DynamicObject dataEntity) {
        HashMap<String, Map<String, List<DynamicObject>>> sortMap = new HashMap<String, Map<String, List<DynamicObject>>>(16);
        DynamicObjectCollection materialentryentity = dataEntity.getDynamicObjectCollection("materialentryentity");
        DynamicObjectCollection supplyorgentryentity = dataEntity.getDynamicObjectCollection("supplyorgentryentity");
        this.putValueToMap(sortMap, materialentryentity, "material", "msupplyorggroup");
        this.putValueToMap(sortMap, supplyorgentryentity, "supply", "ssupplyorggroup");
        return sortMap;
    }

    private void putValueToMap(Map<String, Map<String, List<DynamicObject>>> sortMap, DynamicObjectCollection dynamicObjects, String sign, String group) {
        for (DynamicObject material : dynamicObjects) {
            DynamicObject msupplyorggroup = material.getDynamicObject(group);
            if (msupplyorggroup == null) {
                return;
            }
            String id = msupplyorggroup.getString("id");
            String name = msupplyorggroup.getString("name");
            String key = id + "," + name;
            if (sortMap.containsKey(key)) {
                if (sortMap.get(key).containsKey(sign)) {
                    sortMap.get(key).get(sign).add(material);
                    continue;
                }
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
                list.add(material);
                sortMap.get(key).put(sign, list);
                continue;
            }
            HashMap map = new HashMap();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
            list.add(material);
            map.put(sign, list);
            sortMap.put(key, map);
        }
    }

    private void checkSpecialMaterialSet(DynamicObject dataEntity, int i) {
        DynamicObject demandorg = dataEntity.getDynamicObject("demandorg");
        if (demandorg == null) {
            return;
        }
        String demandorgNumber = dataEntity.getDynamicObject("demandorg").getString("number");
        String demandorgName = dataEntity.getDynamicObject("demandorg").getString("name");
        Map<String, Map<String, List<DynamicObject>>> allSortEntity = this.getAllSortEntity(dataEntity);
        for (Map.Entry<String, Map<String, List<DynamicObject>>> mapEntrys : allSortEntity.entrySet()) {
            String key = mapEntrys.getKey();
            String name = key.split(",")[1];
            Map<String, List<DynamicObject>> value = mapEntrys.getValue();
            List<DynamicObject> materialList = value.get("material");
            List<DynamicObject> supplyList = value.get("supply");
            if (materialList != null && materialList.size() > 0) {
                if (supplyList != null && supplyList.size() > 0) {
                    int supplyRow = 1;
                    for (DynamicObject material : materialList) {
                        if (material.getDynamicObject("materialnumber") == null) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u7269\u6599\u8bbe\u7f6e%3$s\u5206\u7ec4\u4e2d\u7b2c%4$s\u884c\u7684\u7269\u6599\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_50", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, name, supplyRow));
                        }
                        ++supplyRow;
                    }
                    supplyRow = 1;
                    for (DynamicObject supply : supplyList) {
                        if (supply.getDynamicObject("supplyorg") != null) {
                            if (!demandorgNumber.equals(supply.getDynamicObject("supplyorg").getString("number")) && this.isEmpty(supply, "supplyrule").booleanValue()) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e%3$s\u5206\u7ec4\u4e2d\u7b2c%4$s\u884c\u7684\u4f9b\u5e94\u89c4\u5219\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_51", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, name, supplyRow));
                            }
                        } else {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4f9b\u5e94\u7ec4\u7ec7\u8868%3$s\u5206\u7ec4\u4e2d\u7b2c%4$s\u884c\u7684\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_41", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, name, supplyRow));
                        }
                        if (supply.get("supplyproportion") == null) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4f9b\u5e94\u7ec4\u7ec7\u8868%3$s\u5206\u7ec4\u4e2d\u7b2c%4$s\u884c\u7684\u4f9b\u5e94\u6bd4\u4f8b\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_42", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, name, supplyRow));
                        }
                        ++supplyRow;
                    }
                    continue;
                }
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e%3$s\u5206\u7ec4\u4f9b\u5e94\u7ec4\u7ec7\u8868\u7684\u503c\u3002", (String)"MultiOrgSupdemValidator_24", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, key.split(",")[1]));
                continue;
            }
            if (supplyList.size() <= 0) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e%3$s\u5206\u7ec4\u7269\u6599\u8bbe\u7f6e\u8868\u7684\u503c\u3002", (String)"MultiOrgSupdemValidator_25", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), key.split(",")[1]));
        }
    }

    public Boolean isEmpty(DynamicObject defaultsupply, String supplyrule) {
        if (defaultsupply.getString(supplyrule) == null || defaultsupply.getString(supplyrule).isEmpty()) {
            return true;
        }
        return false;
    }

    private void checkSupplyOrgEqualsDemandOrg(DynamicObject dataEntity, int i, String sign, String supplyorg, String supplyrule) {
        Map<String, String> demandorgNameAndNumber = this.getDemandorgNameAndNumber(dataEntity);
        String demandorgNumber = demandorgNameAndNumber.get("number");
        String demandorgName = demandorgNameAndNumber.get("name");
        DynamicObjectCollection supplys = dataEntity.getDynamicObjectCollection(sign);
        if (supplys.size() > 0) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            for (DynamicObject supply : supplys) {
                if (supply.getDynamicObject(supplyorg) != null) {
                    if (!demandorgNumber.equals(supply.getDynamicObject(supplyorg).getString("number")) && this.isEmpty(supply, supplyrule).booleanValue()) {
                        if ("defaultsupply".equals(sign)) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\uff0c\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u7b2c%3$s\u884c\u7684\u4f9b\u5e94\u89c4\u5219\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_26", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, supply.getInt("seq")));
                        } else {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\uff0c\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u7b2c%3$s\u884c\u7684\u4f9b\u5e94\u89c4\u5219\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_27", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, supply.getInt("seq")));
                        }
                    }
                } else if (!"defaultsupply".equals(sign)) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\uff0c\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u7b2c%3$s\u884c\u7684\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_28", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, supply.getInt("seq")));
                }
                if (!"defaultsupply".equals(sign)) continue;
                if (supply.get("supplyratio") == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\u4e3a\uff1a%1$s\uff08%2$s\uff09\u4e2d\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u7b2c%3$s\u884c\u7684\u4f9b\u5e94\u6bd4\u4f8b\u4e3a\u7a7a\u3002", (String)"MultiOrgSupdemValidator_52", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber, supply.getInt("seq")));
                    continue;
                }
                bigDecimal = bigDecimal.add(supply.getBigDecimal("supplyratio"));
            }
            if (bigDecimal.compareTo(BigDecimal.ONE) != 0) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u7684\u4f9b\u5e94\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u4e3a1\u3002", (String)"MultiOrgSupdemValidator_30", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgName, demandorgNumber));
            }
        } else if ("defaultsupply".equals(sign)) {
            if ("mrp".equals(this.getAppId())) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u5bf9\u5e94\u7684\u4f9b\u5e94\u7f51\u7edc\u7684\u503c\u3002", (String)"MultiOrgSupdemValidator_53", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgNumber, demandorgName));
            }
        } else {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4f9b\u5e94\u7f51\u7edc\u9700\u6c42\u7ec4\u7ec7\uff1a%1$s\uff08%2$s\uff09\u4e2d\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4f9b\u5e94\u7ec4\u7ec7\u8868\u7684\u503c\u3002", (String)"MultiOrgSupdemValidator_54", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), demandorgNumber, demandorgName));
        }
    }
}

