/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class NodeDetailValidator
extends AbstractValidator {
    public void validate() {
        String operate;
        switch (operate = this.getOperateKey()) {
            case "save": 
            case "submit": {
                this.checkData();
                break;
            }
        }
    }

    private void checkData() {
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject dataEntity = this.dataEntities[i].getDataEntity();
            String sign = dataEntity.getString("sign");
            if ("supplyorg".equals(sign)) {
                this.checkSupplyOrgEqualsDemandOrg(dataEntity, i, "defaultsupply", "defaultsupplyorg", "defaultsupplyrule");
                this.checkSpecialMaterialSet(dataEntity, i);
                continue;
            }
            if ("stocksupply".equals(sign)) {
                this.checkOrgValue(dataEntity, i);
                this.checkStockTypeAndStockStatus(dataEntity, i);
                Map<String, String> rowMap = this.checkStockSupplyOrgSet(dataEntity, i);
                this.checkSamePriorityData(i, rowMap, "1", "stocksorgentrentryentity");
                this.checkStockSupplyStockSet(dataEntity, i);
                this.checkStockSupplyMateriaSet(dataEntity, i);
                continue;
            }
            Map variables = this.getOption().getVariables();
            DynamicObject demandorg = dataEntity.getDynamicObject("demandorg");
            if (!variables.containsKey("isNew") || demandorg != null) {
                this.checkSupplyOrgEqualsDemandOrg(dataEntity, i, "defaultsupply", "defaultsupplyorg", "defaultsupplyrule");
            }
            this.checkSpecialMaterialSet(dataEntity, i);
            this.checkOrgValue(dataEntity, i);
            this.checkStockTypeAndStockStatus(dataEntity, i);
            Map<String, String> rowMap = this.checkStockSupplyOrgSet(dataEntity, i);
            this.checkSamePriorityData(i, rowMap, "1", "stocksorgentrentryentity");
            this.checkStockSupplyStockSet(dataEntity, i);
            this.checkStockSupplyMateriaSet(dataEntity, i);
        }
    }

    private void checkOrgValue(DynamicObject dataEntity, int i) {
        DynamicObject demandorg = dataEntity.getDynamicObject("stockdemandorg");
        if (demandorg == null) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"NodeDetailValidator_24", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    public String getAppId() {
        return (String)this.getValidateContext().getOption().getVariables().get("appnumber");
    }

    private void checkStockTypeAndStockStatus(DynamicObject dataEntity, int i) {
        MulBasedataDynamicObjectCollection stocktype = (MulBasedataDynamicObjectCollection)dataEntity.get("stocktype");
        MulBasedataDynamicObjectCollection stockstatus = (MulBasedataDynamicObjectCollection)dataEntity.get("stockstatus");
        if (stocktype.size() == 0) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53c2\u4e0eMRP\u5e93\u5b58\u7c7b\u578b\u7684\u503c\u3002", (String)"NodeDetailValidator_25", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        if (stockstatus.size() == 0) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53c2\u4e0eMRP\u5e93\u5b58\u72b6\u6001\u7684\u503c\u3002", (String)"NodeDetailValidator_26", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void checkSpecialMaterialSet(DynamicObject dataEntity, int i) {
        DynamicObject demandorg = dataEntity.getDynamicObject("demandorg");
        if (demandorg == null) {
            return;
        }
        String demandorgNumber = dataEntity.getDynamicObject("demandorg").getString("number");
        Map<String, Map<String, List<DynamicObject>>> allSortEntity = this.getAllSortEntity(dataEntity);
        HashMap<String, BigDecimal> ratioMap = new HashMap<String, BigDecimal>(8);
        for (Map.Entry<String, Map<String, List<DynamicObject>>> entry : allSortEntity.entrySet()) {
            String key = entry.getKey();
            String name = key.split(",")[1];
            Map<String, List<DynamicObject>> value = entry.getValue();
            List<DynamicObject> materialList = value.get("material");
            List<DynamicObject> supplyList = value.get("supply");
            if (materialList != null && materialList.size() > 0) {
                if (supplyList != null && supplyList.size() > 0) {
                    int supplyRow = 1;
                    for (DynamicObject material : materialList) {
                        if (material.getDynamicObject("materialnumber") == null) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u7269\u6599\u8bbe\u7f6e%1$s\u5206\u7ec4\u4e2d\u7b2c%2$s\u884c\u7684\u7269\u6599\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_56", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), name, supplyRow));
                        }
                        ++supplyRow;
                    }
                    supplyRow = 1;
                    BigDecimal bigDecimal = BigDecimal.ZERO;
                    for (DynamicObject supply : supplyList) {
                        if (supply.getDynamicObject("supplyorg") != null) {
                            if (!demandorgNumber.equals(supply.getDynamicObject("supplyorg").getString("number")) && this.isEmpty(supply, "supplyrule").booleanValue()) {
                                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e%1$s\u5206\u7ec4\u4e2d\u7b2c%2$s\u884c\u7684\u4f9b\u5e94\u89c4\u5219\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_57", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), name, supplyRow));
                            }
                        } else {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e%1$s\u5206\u7ec4\u4e2d\u7b2c%2$s\u884c\u7684\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_58", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), name, supplyRow));
                        }
                        if (supply.get("supplyproportion") == null || BigDecimal.ZERO.compareTo(supply.getBigDecimal("supplyproportion")) == 0) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e%1$s\u5206\u7ec4\u4e2d\u7b2c%2$s\u884c\u7684\u4f9b\u5e94\u6bd4\u4f8b\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_59", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), name, supplyRow));
                        } else {
                            bigDecimal = bigDecimal.add(supply.getBigDecimal("supplyproportion"));
                        }
                        ++supplyRow;
                    }
                    ratioMap.put(name, bigDecimal);
                    continue;
                }
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4e2d%s\u5206\u7ec4\u4e2d\u4f9b\u5e94\u7ec4\u7ec7\u8868\u7684\u503c\u3002", (String)"NodeDetailValidator_31", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), key.split(",")[1]));
                continue;
            }
            if (supplyList.size() <= 0) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4e2d%s\u5206\u7ec4\u4e2d\u7269\u6599\u8bbe\u7f6e\u8868\u7684\u503c\u3002", (String)"NodeDetailValidator_32", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), key.split(",")[1]));
        }
        for (Map.Entry<String, Map<String, List<Object>>> entry : ratioMap.entrySet()) {
            String name = entry.getKey();
            BigDecimal bigDecimal = (BigDecimal)((Object)entry.getValue());
            if (bigDecimal.compareTo(BigDecimal.ONE) == 0) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e%s\u5206\u7ec4\u4e2d\u4f9b\u5e94\u7ec4\u7ec7\u7684\u6bd4\u4f8b\u4e0d\u7b49\u4e8e1\u3002", (String)"NodeDetailValidator_62", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), name));
        }
    }

    private Map<String, Map<String, List<DynamicObject>>> getAllSortEntity(DynamicObject dataEntity) {
        HashMap<String, Map<String, List<DynamicObject>>> sortMap = new HashMap<String, Map<String, List<DynamicObject>>>(16);
        DynamicObjectCollection materialentryentity = dataEntity.getDynamicObjectCollection("materialentryentity");
        DynamicObjectCollection supplyorgentryentity = dataEntity.getDynamicObjectCollection("supplyorgentryentity");
        this.putValueToMap(sortMap, materialentryentity, "material", "msupplyorggroup");
        this.putValueToMap(sortMap, supplyorgentryentity, "supply", "ssupplyorggroup");
        return sortMap;
    }

    private void putValueToMap(Map<String, Map<String, List<DynamicObject>>> sortMap, DynamicObjectCollection dynamicObjects, String sign, String group) {
        for (DynamicObject material : dynamicObjects) {
            DynamicObject msupplyorggroup = material.getDynamicObject(group);
            String id = msupplyorggroup.getString("id");
            String name = msupplyorggroup.getString("name");
            String key = id + "," + name;
            if (sortMap.containsKey(key)) {
                if (sortMap.get(key).containsKey(sign)) {
                    sortMap.get(key).get(sign).add(material);
                    continue;
                }
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
                list.add(material);
                sortMap.get(key).put(sign, list);
                continue;
            }
            HashMap map = new HashMap();
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
            list.add(material);
            map.put(sign, list);
            sortMap.put(key, map);
        }
    }

    private boolean checkSamePriorityData(int i, Map<String, String> rowMap, String sign, String entitySign) {
        boolean isNext = true;
        if (rowMap.containsKey("isSame")) {
            for (Map.Entry<String, String> mapEntry : rowMap.entrySet()) {
                String value;
                if ("isSame".equals(mapEntry.getKey()) || !(value = mapEntry.getValue()).contains(",")) continue;
                if ("stocksorgentrentryentity".equals(entitySign)) {
                    if ("1".equals(sign)) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7ec4\u7ec7\u8bbe\u7f6e\u7b2c%s\u884c\u4f18\u5148\u7ea7\u91cd\u590d,\u8bf7\u5904\u7406\u91cd\u590d\u884c\u3002", (String)"NodeDetailValidator_34", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), value));
                        isNext = false;
                        continue;
                    }
                    if ("2".equals(sign)) {
                        this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%s\u884c\u5b58\u5728\u5e93\u5b58\u7ec4\u7ec7,\u4ed3\u5e93,\u4ed3\u4f4d\u90fd\u76f8\u540c,\u8bf7\u5904\u7406\u91cd\u590d\u884c\u3002", (String)"NodeDetailValidator_35", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), value));
                        isNext = false;
                        continue;
                    }
                    if (!"3".equals(sign)) continue;
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%s\u884c\u4f18\u5148\u7ea7\u91cd\u590d,\u8bf7\u5904\u7406\u91cd\u590d\u884c\u3002", (String)"NodeDetailValidator_36", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), value));
                    isNext = false;
                    continue;
                }
                if ("1".equals(sign)) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7269\u6599\u8bbe\u7f6e\u7b2c%s\u884c\u5b58\u5728\u5e93\u5b58\u7ec4\u7ec7\u3001\u7269\u6599\u3001\u4ed3\u5e93\u3001\u4ed3\u4f4d\u90fd\u76f8\u540c\uff0c\u8bf7\u5904\u7406\u3002", (String)"NodeDetailValidator_37", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), value));
                    isNext = false;
                    continue;
                }
                if (!"2".equals(sign)) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7269\u6599\u8bbe\u7f6e\uff1a\u7b2c\u201c%s\u201d\u884c\u7269\u6599\u548c\u4f18\u5148\u7ea7\u91cd\u590d\uff0c\u8bf7\u5904\u7406\u91cd\u590d\u884c\u3002", (String)"NodeDetailValidator_20", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), value));
                isNext = false;
            }
        }
        return isNext;
    }

    private void checkStockSupplyMateriaSet(DynamicObject dataEntity, int i) {
        boolean materialsetup1;
        boolean materialsetup;
        HashMap<String, String> orgRowMap = new HashMap<String, String>(16);
        HashMap<String, String> rowMap = new HashMap<String, String>(16);
        HashMap<String, String> scaleMap = new HashMap<String, String>(16);
        DynamicObjectCollection material = dataEntity.getDynamicObjectCollection("materialsetup");
        if (material.size() > 0) {
            for (DynamicObject dynamicObject : material) {
                if (dynamicObject.getDynamicObject("materialorg") == null || dynamicObject.getDynamicObject("materiel") == null) continue;
                this.getMaterialSamePriorityData(dynamicObject, rowMap, true);
                this.getMaterialSamePriorityData(dynamicObject, orgRowMap, false);
                this.getMaterialScale(dynamicObject, scaleMap);
            }
        }
        if ((materialsetup = this.checkSamePriorityData(i, rowMap, "1", "materialsetup")) && (materialsetup1 = this.checkSamePriorityData(i, orgRowMap, "2", "materialsetup"))) {
            this.checkMaterialScale(i, scaleMap, dataEntity);
        }
    }

    private void checkMaterialScale(int i, Map<String, String> scaleMap, DynamicObject dataEntity) {
        HashMap<String, String> otherscaleMap = new HashMap<String, String>(8);
        QFilter[] allMateriaAndOrgFilter = this.getAllMateriaAndOrgFilter(scaleMap, dataEntity);
        this.getOtherScaleData(allMateriaAndOrgFilter, otherscaleMap);
        for (Map.Entry<String, String> mapEntry : scaleMap.entrySet()) {
            String key = mapEntry.getKey();
            String value = mapEntry.getValue();
            String[] split = value.split("\\|\\|");
            BigDecimal bigDecimal = new BigDecimal(split[0]);
            if (bigDecimal.compareTo(BigDecimal.ONE) > 0) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\uff1a\u7b2c%1$s\u884c\u53ef\u4f9b\u5e94\u6bd4\u4f8b\u6570\u503c\u76f8\u52a0\u4e3a%2$s\uff0c\u8be5\u503c\u5927\u4e8e\u5176\u4e0a\u9650\u503c1\uff0c\u8bf7\u5904\u7406\u3002", (String)"NodeDetailValidator_60", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), split[1], split[0]));
                continue;
            }
            if (!otherscaleMap.containsKey(key)) continue;
            String otherValue = (String)otherscaleMap.get(key);
            String[] split1 = otherValue.split("\\|\\|");
            ArrayList<String> idList = new ArrayList<String>(Arrays.asList(split1[1].split(",")));
            if (idList.contains(split[2].split(",")[0])) {
                if (new BigDecimal(split1[0]).compareTo(BigDecimal.ONE) <= 0) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\uff1a\u7b2c%1$s\u884c\u5e93\u5b58\u7ec4\u7ec7\u548c\u7269\u6599\u5728\u6570\u636e\u5e93\u7684\u5404\u9879\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e4b\u548c\u4e3a%2$s\uff0c\u8be5\u503c\u5927\u4e8e\u5176\u4e0a\u9650\u503c1\uff0c\u8bf7\u5904\u7406\u3002", (String)"NodeDetailValidator_61", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), split[1], split1[0]));
                continue;
            }
            BigDecimal Scale = new BigDecimal(split1[0]).add(bigDecimal);
            if (Scale.compareTo(BigDecimal.ONE) <= 0) continue;
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\uff1a\u7b2c%1$s\u884c\u5e93\u5b58\u7ec4\u7ec7\u548c\u7269\u6599\u5728\u6570\u636e\u5e93\u7684\u5404\u9879\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e4b\u548c\u4e3a%2$s\uff0c\u8be5\u503c\u5927\u4e8e\u5176\u4e0a\u9650\u503c1\uff0c\u8bf7\u5904\u7406\u3002", (String)"NodeDetailValidator_61", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), split[1], Scale.setScale(2)));
        }
    }

    private void getOtherScaleData(QFilter[] allMateriaAndOrgFilter, Map<String, String> otherscaleMap) {
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"mrp_nodedetails", (String)"id,materialsetup.materialorg.id,materialsetup.materiel.id,materialsetup.stockratio", (QFilter[])allMateriaAndOrgFilter);
        for (DynamicObject material : materials) {
            String materialorgId = material.getString("materialsetup.materialorg.id");
            String materielId = material.getString("materialsetup.materiel.id");
            String key = materialorgId + "," + materielId;
            BigDecimal bigDecimal = material.getBigDecimal("materialsetup.stockratio");
            String id = material.getString("id");
            if (otherscaleMap.containsKey(key)) {
                String value = otherscaleMap.get(key);
                String[] split = value.split("\\|\\|");
                bigDecimal = bigDecimal.add(new BigDecimal(split[0]));
                id = split[1] + "," + id;
                value = bigDecimal + "||" + id;
                otherscaleMap.put(key, value);
            }
            otherscaleMap.put(key, bigDecimal + "||" + id);
        }
    }

    private QFilter[] getAllMateriaAndOrgFilter(Map<String, String> scaleMap, DynamicObject dataEntity) {
        ArrayList<Long> materialList = new ArrayList<Long>(16);
        ArrayList<Long> materielOrgList = new ArrayList<Long>(16);
        for (Map.Entry<String, String> mapEntry : scaleMap.entrySet()) {
            String key = mapEntry.getKey();
            String[] split = key.split(",");
            materielOrgList.add(Long.parseLong(split[0]));
            materialList.add(Long.parseLong(split[1]));
        }
        Long id = dataEntity.getLong("id");
        QFilter qfilter = new QFilter("materialsetup.materialorg.id", "in", materielOrgList);
        QFilter mfilter = new QFilter("materialsetup.materiel.id", "in", materialList);
        QFilter enablefilter = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = null;
        if (id != null && id != 0L) {
            QFilter isNotMineqfilter = new QFilter("id", "!=", (Object)id);
            qFilters = new QFilter[]{qfilter, mfilter, enablefilter, isNotMineqfilter};
        } else {
            qFilters = new QFilter[]{qfilter, mfilter, enablefilter};
        }
        return qFilters;
    }

    private void getMaterialScale(DynamicObject dynamicObject, Map<String, String> scaleMap) {
        String materialOrgId = dynamicObject.getDynamicObject("materialorg").getString("id");
        String materialId = dynamicObject.getDynamicObject("materiel").getString("id");
        String key = materialOrgId + "," + materialId;
        BigDecimal stockratio = dynamicObject.getBigDecimal("stockratio");
        String seq = dynamicObject.getString("seq");
        String id = dynamicObject.getString("id");
        if (scaleMap.containsKey(key)) {
            String value = scaleMap.get(key);
            String[] split = value.split("\\|\\|");
            stockratio = stockratio.add(new BigDecimal(split[0]));
            String row = split[1] + "," + seq;
            id = split[2] + "," + id;
            value = stockratio + "||" + row + "||" + id;
            scaleMap.put(key, value);
        } else {
            scaleMap.put(key, stockratio + "||" + seq + "||" + id);
        }
    }

    private void getMaterialSamePriorityData(DynamicObject dynamicObject, Map<String, String> rowMap, boolean isDim) {
        String materialId = dynamicObject.getDynamicObject("materiel").getString("id");
        String key = "";
        if (isDim) {
            String materialOrgId = dynamicObject.getDynamicObject("materialorg").getString("id");
            DynamicObject stock = dynamicObject.getDynamicObject("stock");
            String stockId = "";
            if (stock != null) {
                stockId = stock.getString("id");
            }
            DynamicObject stockindex = dynamicObject.getDynamicObject("stockindexs");
            String stockIndexId = "";
            if (stockindex != null) {
                stockIndexId = stockindex.getString("id");
            }
            key = materialOrgId + "," + materialId + "," + stockId + "," + stockIndexId;
        } else {
            String supplypriority = dynamicObject.getString("prioritylevel");
            key = materialId + "," + supplypriority;
        }
        String seq = dynamicObject.getString("seq");
        if (rowMap.containsKey(key)) {
            seq = rowMap.get(key) + "," + seq;
            rowMap.put(key, seq);
            if (!rowMap.containsKey("isSame")) {
                rowMap.put("isSame", "1");
            }
        }
        rowMap.put(key, seq);
    }

    private void checkStockSupplyStockSet(DynamicObject dataEntity, int i) {
        DynamicObjectCollection stocks = dataEntity.getDynamicObjectCollection("stocksetupentryentity");
        HashMap<String, String> orgRowMap = new HashMap<String, String>(16);
        HashMap<String, String> rowMap = new HashMap<String, String>(16);
        String setup = "";
        if (dataEntity.get("stocksetup") != null) {
            setup = dataEntity.getString("stocksetup");
        }
        if (stocks != null && stocks.size() > 0 && "1".equals(setup)) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5f53\u4ed3\u5e93\u8bbe\u7f6e\u9009\u9879\u4e3a\u5168\u90e8\u4ed3\u5e93\u65f6\uff0c\u4e0d\u5141\u8bb8\u4ed3\u5e93\u8bbe\u7f6e\u4e0b\u6709\u503c\u3002", (String)"NodeDetailValidator_10", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
        } else if (!("1".equals(setup) || stocks != null && stocks.size() != 0)) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u4ed3\u5e93\u8bbe\u7f6e\u7684\u503c\u3002", (String)"NodeDetailValidator_39", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
        } else if (!"1".equals(setup)) {
            for (DynamicObject stock : stocks) {
                if (stock.get("stockorg") == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u4ed3\u5e93\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_40", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), stock.getInt("seq")));
                }
                if (stock.get("stocknumber") == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u4ed3\u5e93\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7684\u4ed3\u5e93\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_41", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), stock.getInt("seq")));
                }
                if (stock.get("stockorg") == null || stock.get("stocknumber") == null) continue;
                this.getStockSamePriorityData(stock, rowMap, true);
                this.getStockSamePriorityData(stock, orgRowMap, false);
            }
        }
        this.checkSamePriorityData(i, rowMap, "2", "stocksorgentrentryentity");
        this.checkSamePriorityData(i, orgRowMap, "3", "stocksorgentrentryentity");
    }

    private void getStockSamePriorityData(DynamicObject stock, Map<String, String> rowMap, boolean isDim) {
        String stockorgId = stock.getDynamicObject("stockorg").getString("id");
        String key = "";
        if (isDim) {
            String stocknumberId = stock.getDynamicObject("stocknumber").getString("id");
            DynamicObject stockindex = stock.getDynamicObject("stockindex");
            String stockindexId = "";
            if (stockindex != null) {
                stockindexId = stockindex.getString("id");
            }
            key = stockorgId + "," + stocknumberId + "," + stockindexId;
        } else {
            String supplypriority = stock.getString("supplypriority");
            key = stockorgId + "," + supplypriority;
        }
        String seq = stock.getString("seq");
        if (rowMap.containsKey(key)) {
            seq = rowMap.get(key) + "," + seq;
            if (!rowMap.containsKey("isSame")) {
                rowMap.put("isSame", "1");
            }
        }
        rowMap.put(key, seq);
    }

    private Map<String, String> checkStockSupplyOrgSet(DynamicObject dataEntity, int i) {
        HashMap<String, String> rowMap = new HashMap<String, String>(16);
        DynamicObjectCollection stocksOrg = dataEntity.getDynamicObjectCollection("stocksorgentrentryentity");
        if (stocksOrg.size() > 0) {
            for (DynamicObject stockOrg : stocksOrg) {
                if (stockOrg.getDynamicObject("storageorg") != null) {
                    this.getSamePriorityData(stockOrg, rowMap);
                }
                if (stockOrg.get("stockscale") != null) continue;
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7684\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_43", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), stockOrg.getInt("seq")));
            }
        } else {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u503c\u3002", (String)"NodeDetailValidator_44", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
        }
        return rowMap;
    }

    private void getSamePriorityData(DynamicObject stockOrg, Map<String, String> rowMap) {
        String priority = stockOrg.getString("priority");
        String seq = stockOrg.getString("seq");
        if (rowMap.containsKey(priority)) {
            seq = rowMap.get(priority) + "," + seq;
            if (!rowMap.containsKey("isSame")) {
                rowMap.put("isSame", "1");
            }
        }
        rowMap.put(priority, seq);
    }

    private void checkSupplyOrgEqualsDemandOrg(DynamicObject dataEntity, int i, String sign, String supplyorg, String supplyrule) {
        String demandorgNumber = "";
        DynamicObject demandorg = dataEntity.getDynamicObject("demandorg");
        if (demandorg == null) {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"NodeDetailValidator_63", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
        } else {
            demandorgNumber = dataEntity.getDynamicObject("demandorg").getString("number");
        }
        DynamicObjectCollection supplys = dataEntity.getDynamicObjectCollection(sign);
        if (supplys.size() > 0) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            for (DynamicObject supply : supplys) {
                if (supply.getDynamicObject(supplyorg) != null) {
                    if (!demandorgNumber.equals(supply.getDynamicObject(supplyorg).getString("number")) && this.isEmpty(supply, supplyrule).booleanValue()) {
                        if ("defaultsupply".equals(sign)) {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u7684\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7684\u4f9b\u5e94\u89c4\u5219\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_45", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), supply.getInt("seq")));
                        } else {
                            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u7684\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7684\u4f9b\u5e94\u89c4\u5219\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_46", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), supply.getInt("seq")));
                        }
                    }
                } else if (!"defaultsupply".equals(sign)) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u7684\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7684\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_47", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), supply.getInt("seq")));
                }
                if (!"defaultsupply".equals(sign)) continue;
                if (supply.get("supplyratio") == null) {
                    this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u7684\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\u7b2c%s\u884c\u7684\u4f9b\u5e94\u6bd4\u4f8b\u4e3a\u7a7a\u3002", (String)"NodeDetailValidator_48", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), supply.getInt("seq")));
                    continue;
                }
                bigDecimal = bigDecimal.add(supply.getBigDecimal("supplyratio"));
            }
            if (bigDecimal.compareTo(BigDecimal.ONE) != 0) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc\u7684\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\u4f9b\u5e94\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u7b49\u4e8e1\u3002", (String)"NodeDetailValidator_49", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
            }
        } else if ("defaultsupply".equals(sign)) {
            if ("mrp".equals(this.getAppId())) {
                this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4f9b\u5e94\u7f51\u7edc\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u3002", (String)"NodeDetailValidator_50", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
            }
        } else {
            this.addErrorMessage(this.dataEntities[i], String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4f9b\u5e94\u7ec4\u7ec7\u8868\u7684\u503c\u3002", (String)"NodeDetailValidator_51", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    public Boolean isEmpty(DynamicObject defaultsupply, String supplyrule) {
        if (defaultsupply.getString(supplyrule) == null || defaultsupply.getString(supplyrule).isEmpty()) {
            return true;
        }
        return false;
    }
}

