/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.BatchImportSheetHandler;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.common.consts.PlanCalendarImportConst;
import kd.mpscmm.common.enums.PlanCalendarImportEnum;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class PlanCalendarImportOp
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(PlanCalendarImportOp.class);
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader reader = new ExcelReader();
        for (String url : this.ctx.getAllUrls()) {
            InputStream in = null;
            try {
                in = service.getInputStream(url);
                InputStream newIn = null;
                HashMap error = Maps.newHashMapWithExpectedSize((int)1);
                HashMap<Integer, Integer> oldExcelRelIndex = new HashMap<Integer, Integer>();
                try {
                    List<Map<Integer, String>> excelList = PlanCalendarImportOp.readExcel(in);
                    newIn = this.overWriteList(excelList, error, oldExcelRelIndex);
                    if (error != null && error.size() > 0) {
                        StringBuilder allError = new StringBuilder();
                        for (Map.Entry map : error.entrySet()) {
                            allError.append((String)map.getValue()).append("\n\r");
                        }
                        this.ctx.getLogger(url).log(Integer.valueOf(0), allError.toString());
                        this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
                        this.ctx.setResolveComplete(url);
                    }
                    in = newIn == null ? service.getInputStream(url) : newIn;
                    this.mainEntityType = this.buildMainEntityType(new JSONObject());
                    if (this.mainEntityType instanceof QueryEntityType) {
                        this.mainEntityType = ((QueryEntityType)this.mainEntityType).getMainEntityType();
                    }
                    reader.read(in, (SheetHandler)new BatchImportSheetHandler(this.ctx, this.mainEntityType, url));
                }
                catch (Throwable ex) {
                    String importErrMsg = ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u8bf7\u6309\u7167\u6279\u6ce8\u6b63\u786e\u586b\u5199\u3002", (String)"PlanCalendarImportOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
                    log.error("\u8ba1\u5212\u65e5\u5386\u5f15\u5165\u5931\u8d25\uff0c\u5f02\u5e38\u4e3a\uff1a", ex);
                    this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                    this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
                    this.ctx.setResolveComplete(url);
                }
            }
            catch (Throwable e) {
                String importErrMsg = ResManager.loadKDString((String)"\u8f93\u5165\u7684\u6570\u636e\u4e0d\u5408\u6cd5\uff0c\u8bf7\u6309\u7167\u6279\u6ce8\u6b63\u786e\u586b\u5199\u3002", (String)"PlanCalendarImportOp_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
                log.error("\u8ba1\u5212\u65e5\u5386\u5f15\u5165\u5931\u8d25\uff0c\u5f02\u5e38\u4e3a\uff1a", e);
                this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
                this.ctx.setResolveComplete(url);
            }
            finally {
                PlanCalendarImportOp.safeClose(in);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream overWriteList(List<Map<Integer, String>> excelList, Map<Integer, String> error, Map<Integer, Integer> oldExcelRelIndex) throws ParseException, IOException {
        ByteArrayOutputStream baos = null;
        ByteArrayInputStream newIn = null;
        SXSSFWorkbook newExcel = null;
        try {
            List<List<String>> overrideList = new ArrayList<List<String>>(16);
            newExcel = new SXSSFWorkbook();
            newExcel = this.createExcelTemp(excelList, newExcel);
            int year = this.getYear(new Date());
            int startYear = year - 3;
            int endYear = year + 10;
            SXSSFSheet newSheet = newExcel.getSheetAt(0);
            if (excelList != null && excelList.size() > 0) {
                HashMap<String, String> dataCellMap = new HashMap<String, String>(16);
                HashSet<String> datetypes = new HashSet<String>(2);
                Map<Integer, String> attrMap = excelList.get(2);
                for (int i = 4; i < excelList.size(); ++i) {
                    String errormessage;
                    StringBuilder errmessagebd = new StringBuilder(ResManager.loadKDString((String)"\u8ba1\u5212\u65e5\u5386\u5f15\u5165\u9519\u8bef\u4fe1\u606f\uff1a\u7b2c%1$s\u884c", (String)"PlanCalendarImportOp_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
                    Map<Integer, String> dataMap = excelList.get(i);
                    HashMap<String, String> attrDataMap = new HashMap<String, String>(dataMap.size());
                    for (int j = 0; j < attrMap.size(); ++j) {
                        String data = dataMap.get(j);
                        String key = attrMap.get(j);
                        if (data != null && ("startdate".equals(key) || "enddate".equals(key))) {
                            data = data.replaceAll("/", "-");
                        }
                        attrDataMap.put(key, data);
                    }
                    String number = (String)attrDataMap.get("number");
                    String datetype = (String)attrDataMap.get("datetype");
                    String startdate = (String)attrDataMap.get("startdate");
                    String enddate = (String)attrDataMap.get("enddate");
                    String restdatetype = (String)attrDataMap.get("datetype");
                    if (number != null && number.length() > 0 && !number.equals(dataCellMap.get("number"))) {
                        if (dataCellMap.get("number") != null && ((String)dataCellMap.get("number")).length() > 0) {
                            overrideList = this.overWriteData(dataCellMap, datetypes, overrideList);
                            dataCellMap.clear();
                            datetypes.clear();
                        }
                        if (StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate) || StringUtils.isBlank((CharSequence)restdatetype)) {
                            error.put(i, String.format(errmessagebd.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5f00\u59cb\u65f6\u95f4\uff0c\u7ed3\u675f\u65f6\u95f4\uff0c\u4f11\u606f\u65e5\u7c7b\u578b\u3002", (String)"PlanCalendarImportOp_2", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0])).toString(), i + 1));
                            continue;
                        }
                        errormessage = this.analysisDate(startdate);
                        if (StringUtils.isNotBlank((CharSequence)errormessage)) {
                            error.put(i, String.format(errmessagebd.append(errormessage).toString(), i + 1));
                            continue;
                        }
                        Date date = this.sdf.parse(startdate);
                        int impStartYear = this.getYear(date);
                        if (impStartYear < startYear || impStartYear > endYear) {
                            error.put(i, String.format(errmessagebd.append(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u8d85\u51fa\u6709\u6548\u671f\u95f4\u53ef\u9009\u8303\u56f4\uff1a%2$s\u5e74~%3$s\u5e74\u3002", (String)"PlanCalendarImportOp_3", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0])).toString(), i + 1, startYear, endYear));
                            continue;
                        }
                        startdate = this.sdf.format(date);
                        errormessage = this.analysisDate(enddate);
                        if (StringUtils.isNotBlank((CharSequence)errormessage)) {
                            error.put(i, String.format(errmessagebd.append(errormessage).toString(), i + 1));
                            continue;
                        }
                        date = this.sdf.parse(enddate);
                        int impEndYear = this.getYear(date);
                        if (impEndYear < startYear || impEndYear > endYear) {
                            error.put(i, String.format(errmessagebd.append(ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f\u8d85\u51fa\u6709\u6548\u671f\u95f4\u53ef\u9009\u8303\u56f4\uff1a%2$s\u5e74~%3$s\u5e74\u3002", (String)"PlanCalendarImportOp_4", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0])).toString(), i + 1, startYear, endYear));
                            continue;
                        }
                        enddate = this.sdf.format(date);
                        if (startdate.compareTo(enddate) > 0) {
                            error.put(i, String.format(errmessagebd.append(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanCalendarImportOp_5", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0])).toString(), i + 1));
                            continue;
                        }
                        errormessage = this.analysisDatetype(restdatetype, datetypes, startdate, enddate, null);
                        if (StringUtils.isNotBlank((CharSequence)errormessage)) {
                            error.put(i, String.format(errmessagebd.append(errormessage).toString(), i + 1));
                            continue;
                        }
                        dataCellMap.put("number", number);
                        dataCellMap.put("name.zh_CN", (String)attrDataMap.get("name.zh_CN"));
                        dataCellMap.put("createorg.number", (String)attrDataMap.get("createorg.number"));
                        dataCellMap.put("createorg.name", (String)attrDataMap.get("createorg.name"));
                        dataCellMap.put("startdate", startdate);
                        dataCellMap.put("enddate", enddate);
                        continue;
                    }
                    if (datetype == null) continue;
                    errormessage = this.analysisDatetype(restdatetype, datetypes, null, null, dataCellMap);
                    if (!StringUtils.isNotBlank(error)) continue;
                    error.put(i, String.format(errmessagebd.append(errormessage).toString(), i + 1));
                }
                if (dataCellMap.size() > 0) {
                    overrideList = this.overWriteData(dataCellMap, datetypes, overrideList);
                }
            }
            for (int i = 0; i < overrideList.size(); ++i) {
                int num = newSheet.getLastRowNum() + 1;
                Row newRow = newSheet.createRow(num);
                List sub_list = (List)overrideList.get(i);
                for (int j = 0; j < sub_list.size(); ++j) {
                    newRow.createCell(j).setCellValue((String)sub_list.get(j));
                }
            }
            baos = new ByteArrayOutputStream(1024);
            newExcel.write((OutputStream)baos);
            newIn = new ByteArrayInputStream(baos.toByteArray());
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (newExcel != null) {
                newExcel.close();
            }
        }
        return newIn;
    }

    private int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    private String analysisDate(String datetemp) {
        String error = "";
        try {
            Date date = this.sdf.parse(datetemp);
            datetemp = this.sdf.format(date);
        }
        catch (Exception e) {
            error = ResManager.loadKDString((String)"\u65f6\u95f4\u683c\u5f0f\u5fc5\u987b\u4e3ayyyy-MM-dd\u6216yyyy/MM/dd\u3002", (String)"PlanCalendarImportOp_6", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
            return error;
        }
        return error;
    }

    public List<String> getDefaultLockUIs() {
        ArrayList<String> lockList = new ArrayList<String>();
        lockList.add("btndownload");
        return lockList;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        return super.save(rowdatas, logger);
    }

    private List<List<String>> overWriteData(Map<String, String> dataCellMap, Set<String> datetypes, List<List<String>> overrideList) throws ParseException {
        HashMap<Integer, String> datamap = new HashMap<Integer, String>(32);
        String startDate = dataCellMap.get("startdate");
        String endDate = dataCellMap.get("enddate");
        datamap.put(0, startDate.substring(0, 4));
        datamap.put(1, startDate.substring(5, 7));
        datamap.put(2, endDate.substring(0, 4));
        datamap.put(3, endDate.substring(5, 7));
        datamap.put(4, dataCellMap.get("number"));
        datamap.put(5, dataCellMap.get("name.zh_CN"));
        datamap.put(6, PlanCalendarImportConst.FREEDAY_FALSE);
        datamap.put(7, PlanCalendarImportConst.FREEDAY_FALSE);
        datamap.put(8, PlanCalendarImportConst.FREEDAY_FALSE);
        datamap.put(9, PlanCalendarImportConst.FREEDAY_FALSE);
        datamap.put(10, PlanCalendarImportConst.FREEDAY_FALSE);
        datamap.put(11, PlanCalendarImportConst.FREEDAY_FALSE);
        datamap.put(12, PlanCalendarImportConst.FREEDAY_FALSE);
        datamap.put(13, dataCellMap.get("createorg.number"));
        datamap.put(14, dataCellMap.get("createorg.name"));
        HashMap<String, String> dateentryMap = new HashMap<String, String>();
        HashSet<String> freeDateSet = new HashSet<String>();
        for (String string : datetypes) {
            String[] dates;
            String type = string.substring(0, string.indexOf(61));
            String data = string.substring(string.indexOf(61) + 1);
            data = data.replace('\uff0c', ',');
            block19: for (String date : dates = data.split(",")) {
                if (date == null || date.length() <= 0) continue;
                date = date.replaceAll("\n", "");
                if (PlanCalendarImportOp.isDate(date = date.replaceAll("\r", ""), this.sdf)) {
                    Date datenew = this.sdf.parse(date);
                    dateentryMap.put(this.sdf.format(datenew), type);
                    continue;
                }
                if (PlanCalendarImportOp.isDate(date, this.sdf) || !PlanCalendarImportConst.FREEDAY.equals(type)) continue;
                switch (date) {
                    case "\u5468\u65e5": {
                        datamap.put(6, PlanCalendarImportConst.FREEDAY_TRUE);
                        freeDateSet.add(PlanCalendarImportEnum.ISSUNREST.getValue());
                        continue block19;
                    }
                    case "\u5468\u4e00": {
                        datamap.put(7, PlanCalendarImportConst.FREEDAY_TRUE);
                        freeDateSet.add(PlanCalendarImportEnum.ISMONREST.getValue());
                        continue block19;
                    }
                    case "\u5468\u4e8c": {
                        datamap.put(8, PlanCalendarImportConst.FREEDAY_TRUE);
                        freeDateSet.add(PlanCalendarImportEnum.ISTUEREST.getValue());
                        continue block19;
                    }
                    case "\u5468\u4e09": {
                        datamap.put(9, PlanCalendarImportConst.FREEDAY_TRUE);
                        freeDateSet.add(PlanCalendarImportEnum.ISWEDREST.getValue());
                        continue block19;
                    }
                    case "\u5468\u56db": {
                        datamap.put(10, PlanCalendarImportConst.FREEDAY_TRUE);
                        freeDateSet.add(PlanCalendarImportEnum.ISTHUREST.getValue());
                        continue block19;
                    }
                    case "\u5468\u4e94": {
                        datamap.put(11, PlanCalendarImportConst.FREEDAY_TRUE);
                        freeDateSet.add(PlanCalendarImportEnum.ISFRIREST.getValue());
                        continue block19;
                    }
                    case "\u5468\u516d": {
                        datamap.put(12, PlanCalendarImportConst.FREEDAY_TRUE);
                        freeDateSet.add(PlanCalendarImportEnum.ISSATREST.getValue());
                        continue block19;
                    }
                }
            }
        }
        List<String> alldate = this.getBetweenDate(startDate, endDate);
        for (String date : alldate) {
            Date freedate = this.sdf.parse(date);
            if (dateentryMap.get(date) != null) continue;
            if (freeDateSet != null && freeDateSet.contains(PlanCalendarImportOp.getWeekOfDate(freedate))) {
                dateentryMap.put(date, PlanCalendarImportConst.FREEDAY);
                continue;
            }
            dateentryMap.put(date, PlanCalendarImportConst.WorkDAY);
        }
        if (dateentryMap != null && dateentryMap.size() > 0) {
            Iterator iterator = dateentryMap.entrySet().iterator();
            boolean bool = true;
            while (iterator.hasNext()) {
                Map.Entry e = iterator.next();
                String date = (String)e.getKey();
                if (bool) {
                    datamap.put(15, date);
                    datamap.put(16, (String)dateentryMap.get(date));
                    overrideList.add(this.initCellList(datamap, 17));
                    continue;
                }
                overrideList.add(this.initCellList(datamap, 17));
            }
        }
        return overrideList;
    }

    private String analysisDatetype(String datetype, Set<String> datetypes, String startDate, String endDate, Map<String, String> dataCellMap) {
        String error = "";
        try {
            Set<Object> datatypeSet = Sets.newHashSetWithExpectedSize((int)16);
            datatypeSet.add(datetype);
            datatypeSet = this.getDateType((Set<String>)datatypeSet, PlanCalendarImportConst.FREEDAY);
            datatypeSet = this.getDateType((Set<String>)datatypeSet, PlanCalendarImportConst.HOLIDAY);
            datetypes.addAll((Collection<String>)datatypeSet);
            if (StringUtils.isBlank((CharSequence)startDate)) {
                startDate = dataCellMap.get("startdate");
            }
            if (StringUtils.isBlank((CharSequence)endDate)) {
                endDate = dataCellMap.get("enddate");
            }
            List<String> alldate = this.getBetweenDate(startDate, endDate);
            for (String string : datatypeSet) {
                String[] dates;
                String type = string.substring(0, datetype.indexOf(61));
                if (StringUtils.isBlank((CharSequence)type)) {
                    error = ResManager.loadKDString((String)"\u4f11\u606f\u65e5\u7c7b\u578b\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u6b63\u786e\u586b\u5199\u3002", (String)"PlanCalendarImportOp_7", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
                    return error;
                }
                String data = string.substring(datetype.indexOf(61) + 1);
                data = data.replace('\uff0c', ',');
                for (String date : dates = data.split(",")) {
                    if (date == null || date.length() <= 0) continue;
                    date = date.replaceAll("\n", "");
                    if (PlanCalendarImportOp.isDate(date = date.replaceAll("\r", ""), this.sdf)) {
                        Date datenew = this.sdf.parse(date);
                        String dateStr = this.sdf.format(datenew);
                        if (alldate.contains(dateStr)) continue;
                        error = ResManager.loadKDString((String)"\u4f11\u606f\u65e5\u7c7b\u578b\u914d\u7f6e\u65f6\u95f4\u672a\u5728\u53ef\u7528\u8303\u56f4\u5185\uff0c\u8bf7\u6b63\u786e\u586b\u5199\u3002", (String)"PlanCalendarImportOp_8", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
                        return error;
                    }
                    if (!PlanCalendarImportOp.isDate(date, this.sdf) && PlanCalendarImportConst.FREEDAY.equals(type)) {
                        switch (date) {
                            case "\u5468\u65e5": 
                            case "\u5468\u4e00": 
                            case "\u5468\u4e8c": 
                            case "\u5468\u4e09": 
                            case "\u5468\u56db": 
                            case "\u5468\u4e94": 
                            case "\u5468\u516d": {
                                break;
                            }
                            default: {
                                error = ResManager.loadKDString((String)"\u4f11\u606f\u65e5\u7c7b\u578b\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u6b63\u786e\u586b\u5199\u3002", (String)"PlanCalendarImportOp_7", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
                                return error;
                            }
                        }
                        continue;
                    }
                    error = ResManager.loadKDString((String)"\u4f11\u606f\u65e5\u7c7b\u578b\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u6b63\u786e\u586b\u5199\u3002", (String)"PlanCalendarImportOp_7", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
                    return error;
                }
            }
        }
        catch (Exception e) {
            error = ResManager.loadKDString((String)"\u4f11\u606f\u65e5\u7c7b\u578b\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u6b63\u786e\u586b\u5199\u3002", (String)"PlanCalendarImportOp_7", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
            return error;
        }
        return error;
    }

    private Set<String> getDateType(Set<String> datatypeSet, String datetype) {
        HashSet result = Sets.newHashSetWithExpectedSize((int)(datatypeSet.size() * 2));
        for (String datatypes : datatypeSet) {
            String[] splits = datatypes.split(datetype);
            if (splits.length >= 2) {
                for (String split : splits) {
                    if (!StringUtils.isNotBlank((CharSequence)split)) continue;
                    if (split.startsWith("=")) {
                        result.add(datetype + split);
                        continue;
                    }
                    result.add(split);
                }
                continue;
            }
            if (splits.length > 1) continue;
            result.addAll(Arrays.asList(splits));
        }
        return result;
    }

    public static boolean isDate(String value, SimpleDateFormat sdf) {
        ParsePosition pos = new ParsePosition(0);
        try {
            sdf.setLenient(false);
            Date date = sdf.parse(value, pos);
            if (date == null) {
                return false;
            }
            return pos.getIndex() <= sdf.format(date).length();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void threeLineCell(Row row3) {
        row3.createCell(0).setCellValue(PlanCalendarImportEnum.EXPIRINGYEARFROM.getName());
        row3.createCell(1).setCellValue(PlanCalendarImportEnum.EXPIRINGMONTHFROM.getName());
        row3.createCell(2).setCellValue(PlanCalendarImportEnum.EXPIRINGYEARTO.getName());
        row3.createCell(3).setCellValue(PlanCalendarImportEnum.EXPIRINGMONTHTO.getName());
        row3.createCell(4).setCellValue(PlanCalendarImportEnum.NUMBER.getName());
        row3.createCell(5).setCellValue(PlanCalendarImportEnum.NAME.getName());
        row3.createCell(6).setCellValue(PlanCalendarImportEnum.ISSUNREST.getName());
        row3.createCell(7).setCellValue(PlanCalendarImportEnum.ISMONREST.getName());
        row3.createCell(8).setCellValue(PlanCalendarImportEnum.ISTUEREST.getName());
        row3.createCell(9).setCellValue(PlanCalendarImportEnum.ISWEDREST.getName());
        row3.createCell(10).setCellValue(PlanCalendarImportEnum.ISTHUREST.getName());
        row3.createCell(11).setCellValue(PlanCalendarImportEnum.ISFRIREST.getName());
        row3.createCell(12).setCellValue(PlanCalendarImportEnum.ISSATREST.getName());
        row3.createCell(13).setCellValue(PlanCalendarImportEnum.CREATEORG_NUMBER.getName());
        row3.createCell(14).setCellValue(PlanCalendarImportEnum.CREATEORG_NAME.getName());
        row3.createCell(15).setCellValue(PlanCalendarImportEnum.WORKDATE.getName());
        row3.createCell(16).setCellValue(PlanCalendarImportEnum.DATETYPE.getName());
    }

    private SXSSFWorkbook createExcelTemp(List<Map<Integer, String>> excelList, SXSSFWorkbook newExcel) {
        SXSSFSheet newExcelSheet = newExcel.createSheet();
        Row row1 = newExcelSheet.createRow(0);
        Row row2 = newExcelSheet.createRow(1);
        Row row3 = newExcelSheet.createRow(2);
        Row row4 = newExcelSheet.createRow(3);
        row1.createCell(0).setCellValue(excelList.get(0).get(0));
        row1.createCell(15).setCellValue(ResManager.loadKDString((String)"\u5355\u636e\u4f53 # dateentry", (String)"PlanCalendarImportOp_9", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        row2.createCell(0).setCellValue(ResManager.loadKDString((String)"\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42", (String)"PlanCalendarImportOp_10", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        this.threeLineCell(row3);
        this.fourLineCell(row4);
        return newExcel;
    }

    private void fourLineCell(Row row4) {
        row4.createCell(0).setCellValue(PlanCalendarImportEnum.EXPIRINGYEARFROM.getValue());
        row4.createCell(1).setCellValue(PlanCalendarImportEnum.EXPIRINGMONTHFROM.getValue());
        row4.createCell(2).setCellValue(PlanCalendarImportEnum.EXPIRINGYEARTO.getValue());
        row4.createCell(3).setCellValue(PlanCalendarImportEnum.EXPIRINGMONTHTO.getValue());
        row4.createCell(4).setCellValue(PlanCalendarImportEnum.NUMBER.getValue());
        row4.createCell(5).setCellValue(PlanCalendarImportEnum.NAME.getValue());
        row4.createCell(6).setCellValue(PlanCalendarImportEnum.ISSUNREST.getValue());
        row4.createCell(7).setCellValue(PlanCalendarImportEnum.ISMONREST.getValue());
        row4.createCell(8).setCellValue(PlanCalendarImportEnum.ISTUEREST.getValue());
        row4.createCell(9).setCellValue(PlanCalendarImportEnum.ISWEDREST.getValue());
        row4.createCell(10).setCellValue(PlanCalendarImportEnum.ISTHUREST.getValue());
        row4.createCell(11).setCellValue(PlanCalendarImportEnum.ISFRIREST.getValue());
        row4.createCell(12).setCellValue(PlanCalendarImportEnum.ISSATREST.getValue());
        row4.createCell(13).setCellValue(PlanCalendarImportEnum.CREATEORG_NUMBER.getValue());
        row4.createCell(14).setCellValue(PlanCalendarImportEnum.CREATEORG_NAME.getValue());
        row4.createCell(15).setCellValue(PlanCalendarImportEnum.WORKDATE.getValue());
        row4.createCell(16).setCellValue(PlanCalendarImportEnum.DATETYPE.getValue());
    }

    private List<String> initCellList(Map<Integer, String> map, Integer number) {
        ArrayList<String> cellList = new ArrayList<String>(number);
        for (int i = 0; i < number; ++i) {
            if (map == null || map.size() <= 0) continue;
            boolean iscell = false;
            if (map != null) {
                for (Map.Entry<Integer, String> entry : map.entrySet()) {
                    if (entry.getKey() != i) continue;
                    iscell = true;
                    cellList.add(entry.getValue());
                    map.remove(entry.getKey());
                    break;
                }
            }
            if (iscell) continue;
            cellList.add("");
        }
        return cellList;
    }

    public static List<Map<Integer, String>> readExcel(InputStream inputStream) throws Exception {
        final LinkedList<Map<Integer, String>> sheet = new LinkedList<Map<Integer, String>>();
        try {
            new ExcelReader().read(inputStream, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    sheet.add(row.getData());
                }
            });
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return sheet;
    }

    public static String getWeekOfDate(Date dt) {
        String[] weekDays = new String[]{PlanCalendarImportEnum.ISSUNREST.getValue(), PlanCalendarImportEnum.ISMONREST.getValue(), PlanCalendarImportEnum.ISTUEREST.getValue(), PlanCalendarImportEnum.ISWEDREST.getValue(), PlanCalendarImportEnum.ISTHUREST.getValue(), PlanCalendarImportEnum.ISFRIREST.getValue(), PlanCalendarImportEnum.ISSATREST.getValue()};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w <= 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public List<String> getBetweenDate(String begin, String end) throws ParseException {
        String newend;
        ArrayList<String> betweenList = new ArrayList<String>();
        Calendar startDay = Calendar.getInstance();
        startDay.setTime(this.sdf.parse(begin));
        startDay.add(5, -1);
        this.sdf.parse(end);
        do {
            startDay.add(5, 1);
            Date newDate = startDay.getTime();
            newend = this.sdf.format(newDate);
            betweenList.add(newend);
        } while (!end.equals(newend));
        return betweenList;
    }

    public static void safeClose(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }
}

