/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class PlanProgramDefSaveValidator
extends AbstractValidator {
    public void validate() {
        this.validateMustInputField();
        this.validateAutoAuditAndDropType();
    }

    private void validateMustInputField() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            String dropOrderType;
            boolean isDropTypeBlank;
            boolean isAutoDrop;
            String auditOrderType;
            boolean isAuditTypeBlank;
            DynamicObject planProgram = dataEntity.getDataEntity();
            boolean isAutoAudit = planProgram.getBoolean("isautoauditplanbill");
            if (isAutoAudit && (isAuditTypeBlank = this.isMulComboBlank(auditOrderType = planProgram.getString("auditordertype")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6295\u653e\u53c2\u6570-\u81ea\u52a8\u5ba1\u6838\u8ba2\u5355\u7c7b\u578b\u3002", (String)"PlanProgramDefSaveValidator_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            }
            if (!(isAutoDrop = planProgram.getBoolean("isautodropplanbill")) || !(isDropTypeBlank = this.isMulComboBlank(dropOrderType = planProgram.getString("dropordertype")))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6295\u653e\u53c2\u6570-\u81ea\u52a8\u6295\u653e\u8ba2\u5355\u7c7b\u578b\u3002", (String)"PlanProgramDefSaveValidator_2", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isMulComboBlank(String mulCombValue) {
        if (StringUtils.isBlank((CharSequence)mulCombValue)) {
            return true;
        }
        String[] splitValue = mulCombValue.split(",");
        boolean isBlank = true;
        for (String value : splitValue) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            isBlank = false;
            break;
        }
        return isBlank;
    }

    private void validateAutoAuditAndDropType() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject planProgram = dataEntity.getDataEntity();
            String auditOrderType = planProgram.getString("auditordertype");
            auditOrderType = auditOrderType == null ? "" : auditOrderType;
            String[] auditOrderTypeSplit = auditOrderType.split(",");
            Set auditOrderTypeSet = Arrays.stream(auditOrderTypeSplit).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            String dropOrderType = planProgram.getString("dropordertype");
            dropOrderType = dropOrderType == null ? "" : dropOrderType;
            String[] dropOrderTypeSplit = dropOrderType.split(",");
            Set dropOrderTypeSet = Arrays.stream(dropOrderTypeSplit).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            dropOrderTypeSet.removeAll(auditOrderTypeSet);
            if (dropOrderTypeSet.isEmpty()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u81ea\u52a8\u6295\u653e\u8ba2\u5355\u7c7b\u578b\u8303\u56f4\u4e0d\u53ef\u8d85\u8fc7\u81ea\u52a8\u5ba1\u6838\u8ba2\u5355\u7c7b\u578b\u8303\u56f4\u3002", (String)"PlanProgramDefSaveValidator_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
        }
    }
}

