/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;

public class PriorityTypeSaveValidator
extends AbstractValidator {
    private static final String SAVE = "save";
    private static final String SUBMIT = "submit";
    private static final String ENTRYENTITY = "entryentity";
    private static final String ELEMENTOBJ = "elementobject.id";
    private static final String ELEMENTNAME = "elementname";
    private static final String ELEMENTTYPE = "elementtype";
    private static final String SEQ = "seq";

    public void validate() {
        String operate = this.getOperateKey();
        if (SAVE.equals(operate) || SUBMIT.equals(operate)) {
            this.verifySave();
            this.hasSamePriority();
        }
    }

    private void verifySave() {
        ExtendedDataEntity[] objs;
        for (ExtendedDataEntity obj : objs = this.getDataEntities()) {
            DynamicObjectCollection dyns = obj.getDataEntity().getDynamicObjectCollection(ENTRYENTITY);
            Iterator its = dyns.iterator();
            HashMap<String, Set<Integer>> map = new HashMap<String, Set<Integer>>(16);
            HashMap<String, Set<Integer>> nameMap = new HashMap<String, Set<Integer>>(16);
            while (its.hasNext()) {
                String message;
                String sort;
                DynamicObject dyn = (DynamicObject)its.next();
                int seq = dyn.getInt(SEQ);
                if (dyn.getDynamicObjectType().getProperty("elementobject") != null && dyn.get(ELEMENTOBJ) != null) {
                    String id = dyn.getString(ELEMENTOBJ);
                    Set<Integer> seqSet = new HashSet<Integer>();
                    if (map.get(id) != null) {
                        seqSet = (Set)map.get(id);
                    }
                    seqSet.add(seq);
                    map.put(id, seqSet);
                    MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)id);
                    String tableName = dataEntityType.getAlias();
                    String dbroute = dataEntityType.getDBRouteKey();
                    if (StringUtils.isNotEmpty((CharSequence)tableName) && !this.exitsTable(new DBRoute(dbroute), tableName)) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u4f18\u5148\u7ea7\u7c7b\u578b\u5b9a\u4e49\u7b2c%s\u884c\u5206\u5f55\u7684\u8981\u7d20\u5bf9\u8c61\u7684\u6570\u636e\u5e93\u8868\u3002", (String)"PriorityTypeSaveValidator_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), seq));
                    } else if (StringUtils.isEmpty((CharSequence)tableName)) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\uff0c\u4f18\u5148\u7ea7\u7c7b\u578b\u5b9a\u4e49\u7b2c%s\u884c\u5206\u5f55\u7684\u8981\u7d20\u5bf9\u8c61\u672a\u7ed1\u5b9a\u6570\u636e\u5e93\u8868\u3002", (String)"PriorityTypeSaveValidator_2", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), seq));
                    }
                }
                String elementType = "";
                if (dyn.get(ELEMENTTYPE) != null) {
                    elementType = dyn.getString(ELEMENTTYPE);
                }
                String proprityDefine = "";
                if (dyn.get("prioritydefine") != null) {
                    proprityDefine = dyn.getString("prioritydefine");
                }
                if ("0".equals(elementType)) {
                    sort = "";
                    if (dyn.get("sort") != null) {
                        sort = dyn.getString("sort");
                    }
                    if (StringUtils.isBlank((CharSequence)sort)) {
                        message = String.format(ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u4e2d%1$s\u884c\u8981\u7d20\u7c7b\u578b\u4e3a\u6570\u503c\u65f6\uff0c\u6392\u5e8f\u65b9\u5f0f\u5fc5\u586b\u3002", (String)"PriorityTypeSaveValidator_5", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), seq);
                        this.addErrorMessage(obj, message);
                    }
                }
                if ("1".equals(elementType) && "1".equals(proprityDefine)) {
                    sort = "";
                    if (dyn.get("sort") != null) {
                        sort = dyn.getString("sort");
                    }
                    if (StringUtils.isBlank((CharSequence)sort)) {
                        message = String.format(ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u4e2d%1$s\u884c\u8981\u7d20\u7c7b\u578b\u4e3a\u65e5\u671f\u4e14\u4f18\u5148\u7ea7\u65b9\u5f0f\u4e3a\u6392\u5e8f\u65f6\uff0c\u6392\u5e8f\u65b9\u5f0f\u5fc5\u586b\u3002", (String)"PriorityTypeSaveValidator_7", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), seq);
                        this.addErrorMessage(obj, message);
                    }
                }
                if (dyn.getString(ELEMENTNAME) == null || dyn.getString(ELEMENTTYPE) == null) continue;
                String name = dyn.getString(ELEMENTNAME);
                String type = dyn.getString(ELEMENTTYPE);
                String all = name + type;
                Set<Integer> seqSet = new HashSet<Integer>();
                if (nameMap.get(all) != null) {
                    seqSet = (Set)nameMap.get(all);
                }
                seqSet.add(dyn.getInt(SEQ));
                nameMap.put(all, seqSet);
            }
            this.verifyErrorMessage(obj, map);
            this.verifyNameMessage(obj, nameMap);
        }
    }

    private boolean exitsTable(DBRoute route, String tableName) {
        return DB.exitsTable((DBRoute)route, (String)tableName);
    }

    private void verifyErrorMessage(ExtendedDataEntity obj, Map<String, Set<Integer>> map) {
        Collection<Set<Integer>> coll = map.values();
        for (Set<Integer> set : coll) {
            if (set.size() <= 1) continue;
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4f18\u5148\u7ea7\u7c7b\u578b\u5b9a\u4e49\uff0c\u7b2c%s\u884c\u5206\u5f55\u5b58\u5728\u76f8\u540c\u8981\u7d20\u5bf9\u8c61\u7684\u6570\u636e\uff0c\u8bf7\u5904\u7406\u91cd\u590d\u884c\u6570\u636e\u3002", (String)"PriorityTypeSaveValidator_3", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), set));
        }
    }

    private void verifyNameMessage(ExtendedDataEntity obj, Map<String, Set<Integer>> map) {
        Collection<Set<Integer>> coll = map.values();
        for (Set<Integer> set : coll) {
            if (set.size() <= 1) continue;
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4f18\u5148\u7ea7\u7c7b\u578b\u5b9a\u4e49\u7b2c%s\u884c\u5206\u5f55\u5b58\u5728\u76f8\u540c\u7684\u8981\u7d20\u7c7b\u578b\u548c\u8981\u7d20\u540d\u79f0\uff0c\u8bf7\u5904\u7406\u91cd\u590d\u884c\u6570\u636e\u3002", (String)"PriorityTypeSaveValidator_4", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), set));
        }
    }

    private void hasSamePriority() {
        ExtendedDataEntity[] objs;
        for (ExtendedDataEntity obj : objs = this.getDataEntities()) {
            DynamicObjectCollection dyns = obj.getDataEntity().getDynamicObjectCollection(ENTRYENTITY);
            Iterator its = dyns.iterator();
            HashMap sortMap = new HashMap(16);
            while (its.hasNext()) {
                DynamicObject dyn = (DynamicObject)its.next();
                int seq = dyn.getInt(SEQ);
                String priority = dyn.getString("prioritydefine");
                Set<Integer> seqSet = new HashSet<Integer>();
                if (sortMap.get(priority) != null) {
                    seqSet = (Set)sortMap.get(priority);
                }
                seqSet.add(seq);
                sortMap.put(priority, seqSet);
            }
            if (sortMap.size() <= 1 || sortMap.get("1") == null || sortMap.get("2") == null) continue;
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u540c\u4e00\u4f18\u5148\u7ea7\u7c7b\u578b\u4e2d\uff0c\u4e0d\u5141\u8bb8\u540c\u65f6\u5b58\u5728 \u6392\u5e8f\u548c\u6b65\u957f\u4e24\u79cd\u4f18\u5148\u7ea7\u65b9\u5f0f\u3002", (String)"PriorityTypeSaveValidator_6", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

