/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.opplugin;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class StockSupplyValidator
extends AbstractValidator {
    public static final String Save = "save";
    public static final String Submit = "submit";
    public static final String[] stockname = new String[]{"stockorg", "stocknumber", "stockindex", "supplypriority"};
    public static final String[] materialname = new String[]{"materiel", "materialorg", "stock", "stockindexs", "prioritylevel"};

    public void validate() {
        String operate = this.getOperateKey();
        if (Save.equals(operate) || Submit.equals(operate)) {
            ExtendedDataEntity[] objs;
            for (ExtendedDataEntity obj : objs = this.getDataEntities()) {
                DynamicObject dyn = obj.getDataEntity();
                DynamicObjectCollection stocks = dyn.getDynamicObjectCollection("stocksetupentry");
                String setup = "";
                if (dyn.get("stocksetup") != null) {
                    setup = dyn.getString("stocksetup");
                }
                DynamicObjectCollection orgCollection = dyn.getDynamicObjectCollection("entryentity");
                HashSet<Long> orgIds = new HashSet<Long>(orgCollection.size());
                for (DynamicObject orgCol : orgCollection) {
                    DynamicObject org = orgCol.getDynamicObject("storageorg");
                    if (org == null) continue;
                    orgIds.add(org.getLong("id"));
                }
                if (stocks != null && stocks.size() > 0 && "1".equals(setup)) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u5f53\u4ed3\u5e93\u8bbe\u7f6e\u9009\u9879\u4e3a\u5168\u90e8\u4ed3\u5e93\u65f6\uff0c\u4e0d\u5141\u8bb8\u4ed3\u5e93\u8bbe\u7f6e\u4e0b\u6709\u503c\u3002", (String)"StockSupplyValidator_0", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
                } else if (!("1".equals(setup) || stocks != null && stocks.size() != 0)) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u5f53\u4ed3\u5e93\u8bbe\u7f6e\u9009\u9879\u4e0d\u4e3a\u5168\u90e8\u4ed3\u5e93\u65f6\uff0c\u4e0d\u5141\u8bb8\u4ed3\u5e93\u8bbe\u7f6e\u6ca1\u6709\u503c\u3002", (String)"StockSupplyValidator_1", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
                } else if (!"1".equals(setup)) {
                    for (DynamicObject stock : stocks) {
                        QFilter warehouseFilter;
                        DynamicObject stockorg = stock.getDynamicObject("stockorg");
                        DynamicObject stocknumber = stock.getDynamicObject("stocknumber");
                        if (stockorg == null) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u5206\u5f55\u7684\u7b2c%s\u884c\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"StockSupplyValidator_13", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), stock.getInt("seq")));
                            continue;
                        }
                        if (!orgIds.contains(stockorg.getLong("id"))) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u5206\u5f55\u7684\u7b2c%s\u884c\u7684\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5728\u7ec4\u7ec7\u8bbe\u7f6e\u8303\u56f4\u5185\u3002", (String)"StockSupplyValidator_26", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), stock.getInt("seq")));
                            continue;
                        }
                        if (stocknumber == null) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u5206\u5f55\u7684\u7b2c%s\u884c\u7684\u4ed3\u5e93\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"StockSupplyValidator_28", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), stock.getInt("seq")));
                            continue;
                        }
                        QFilter isinit = new QFilter("initstatus", "=", (Object)"B");
                        isinit.and(new QFilter("enable", "=", (Object)"1"));
                        isinit.and(new QFilter("startstatus", "=", (Object)"B"));
                        QFilter orgFilter = new QFilter("org", "=", (Object)stockorg.getLong("id"));
                        if (QueryServiceHelper.exists((String)"im_warehousesetup", (QFilter[])new QFilter[]{orgFilter, warehouseFilter = new QFilter("warehouse", "=", (Object)stocknumber.getLong("id")), isinit})) continue;
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u5206\u5f55\u7684\u7b2c%s\u884c\u7684\u4ed3\u5e93\u7f16\u7801\u4e0d\u662f\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u5df2\u542f\u7528\u3001\u5df2\u521d\u59cb\u5316\u7684\u4ed3\u5e93\u3002", (String)"StockSupplyValidator_27", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), stock.getInt("seq")));
                    }
                }
                this.verifyOrgSetUp(obj, dyn);
                this.verifyStockSetUp(obj, dyn);
                this.verifyMaterialSetUp(obj, dyn);
                DynamicObjectCollection typeCollection = dyn.getDynamicObjectCollection("stockstypeentity");
                DynamicObjectCollection statusCollection = dyn.getDynamicObjectCollection("entryentity2");
                this.verifyErrorMessage(obj, typeCollection, "stocktype.id", ResManager.loadKDString((String)"\u5e93\u5b58\u7c7b\u578b\u5206\u5f55\u7684\u7b2c%s\u884c\u5b58\u5728\u6709\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u5220\u9664\u6389\u91cd\u590d\u884c\u3002", (String)"StockSupplyValidator_15", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
                this.verifyErrorMessage(obj, statusCollection, "stocktype1.id", ResManager.loadKDString((String)"\u5e93\u5b58\u72b6\u6001\u5206\u5f55\u7684\u7b2c%s\u884c\u5b58\u5728\u6709\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u5220\u9664\u6389\u91cd\u590d\u884c\u3002", (String)"StockSupplyValidator_16", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]));
            }
        }
    }

    public void verifyOrgSetUp(ExtendedDataEntity obj, DynamicObject dyn) {
        String objhtml = ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u7b2c%s\u884c\u5e93\u5b58\u7ec4\u7ec7\u91cd\u590d,\u8bf7\u5904\u7406\u91cd\u590d\u884c\u3002", (String)"StockSupplyValidator_17", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
        String integerhtml = ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u7b2c%s\u884c\u4f18\u5148\u7ea7\u91cd\u590d,\u8bf7\u5904\u7406\u91cd\u590d\u884c\u3002", (String)"StockSupplyValidator_18", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
        DynamicObjectCollection orgCollection = dyn.getDynamicObjectCollection("entryentity");
        StringBuilder errorMessage = this.vertifyComboxMessage(orgCollection, "storageorg", "priority", objhtml, integerhtml, Boolean.TRUE, Boolean.TRUE);
        if (errorMessage.length() > 0) {
            this.addErrorMessage(obj, errorMessage.toString());
        }
    }

    public void verifyStockSetUp(ExtendedDataEntity obj, DynamicObject dyn) {
        String stocksetup;
        String stockhtml = ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%s\u884c\u5b58\u5728\u5e93\u5b58\u7ec4\u7ec7,\u4ed3\u5e93,\u4ed3\u4f4d\u90fd\u76f8\u540c,\u8bf7\u5904\u7406\u91cd\u590d\u884c\u6570\u636e\u3002", (String)"StockSupplyValidator_19", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
        String stockprihtml = ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u7b2c%s\u884c\u5b58\u5728\u5e93\u5b58\u7ec4\u7ec7\u548c\u4f18\u5148\u7ea7\u90fd\u76f8\u540c,\u8bf7\u5904\u7406\u91cd\u590d\u884c\u6570\u636e\u3002", (String)"StockSupplyValidator_20", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
        DynamicObjectCollection stockCollection = dyn.getDynamicObjectCollection("stocksetupentry");
        StringBuilder errorMessage = this.verifyFieldsMessage(stockCollection, stockname, stockhtml, "3".equals(stocksetup = dyn.getString("stocksetup")) ? "" : stockprihtml, new Boolean[]{Boolean.FALSE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE});
        if (errorMessage.length() > 0) {
            this.addErrorMessage(obj, errorMessage.toString());
        }
    }

    public void verifyMaterialSetUp(ExtendedDataEntity obj, DynamicObject dyn) {
        String materialhtml = ResManager.loadKDString((String)"\u7269\u6599\u8bbe\u7f6e\u7b2c%s\u884c\u5b58\u5728\u5e93\u5b58\u7ec4\u7ec7,\u7269\u6599,\u4ed3\u5e93,\u4ed3\u4f4d\u90fd\u76f8\u540c,\u8bf7\u5904\u7406\u91cd\u590d\u884c\u6570\u636e\u3002", (String)"StockSupplyValidator_21", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
        String materialprihtml = ResManager.loadKDString((String)"\u7269\u6599\u8bbe\u7f6e\u7f6e\u7b2c%s\u884c\u5b58\u5728\u7269\u6599\u548c\u4f18\u5148\u7ea7\u90fd\u76f8\u540c,\u8bf7\u5904\u7406\u91cd\u590d\u884c\u6570\u636e\u3002", (String)"StockSupplyValidator_22", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]);
        DynamicObjectCollection materialCollection = dyn.getDynamicObjectCollection("materialsetup");
        StringBuilder errorMessage = this.verifyFieldsMessage(materialCollection, materialname, materialhtml, materialprihtml, new Boolean[]{Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE});
        this.verifyScale(obj, dyn, materialCollection);
        if (errorMessage.length() > 0) {
            this.addErrorMessage(obj, errorMessage.toString());
        }
    }

    public void verifyScale(ExtendedDataEntity obj, DynamicObject dyn, DynamicObjectCollection materialCollection) {
        if (materialCollection != null) {
            HashMap<String, BigDecimal> materialScaleMap = new HashMap<String, BigDecimal>(materialCollection.size());
            HashSet<Long> orgSet = new HashSet<Long>(materialCollection.size());
            HashSet<Long> materialSet = new HashSet<Long>(materialCollection.size());
            for (DynamicObject materialDynObject : materialCollection) {
                if (materialDynObject.get("materialorg") == null || materialDynObject.get("materiel") == null) continue;
                DynamicObject materialOrg = materialDynObject.getDynamicObject("materialorg");
                DynamicObject material = materialDynObject.getDynamicObject("materiel");
                orgSet.add(materialOrg.getLong("id"));
                materialSet.add(material.getLong("id"));
                StringBuilder key = new StringBuilder();
                key.append(materialOrg.getLong("id")).append('\u0001').append(material.getLong("id"));
                BigDecimal scale = materialDynObject.getBigDecimal("stockratio");
                if (materialScaleMap.get(key.toString()) == null) {
                    materialScaleMap.put(key.toString(), scale);
                    continue;
                }
                BigDecimal newScale = (BigDecimal)materialScaleMap.get(key.toString());
                scale = newScale.add(scale);
                materialScaleMap.put(key.toString(), scale);
            }
            this.verifyMaterialScale(obj, dyn, materialCollection, materialScaleMap, orgSet, materialSet);
        }
    }

    private void queryAndCountScale(DynamicObject dyn, Map<String, BigDecimal> materialScaleMap, Set<Long> orgSet, Set<Long> materialSet) {
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"mrp_stocksupply_policy", (String)"materialsetup.materialorg,materialsetup.materiel,materialsetup.stockratio", (QFilter[])this.getmaterialfilters(dyn, orgSet, materialSet));
        for (DynamicObject currentmaterial : materials) {
            BigDecimal currentscale = currentmaterial.getBigDecimal("materialsetup.stockratio");
            Long orgId = 0L;
            Long materialId = 0L;
            if (currentmaterial.get("materialsetup.materialorg") != null) {
                orgId = currentmaterial.getLong("materialsetup.materialorg");
            }
            if (currentmaterial.get("materialsetup.materiel") != null) {
                materialId = currentmaterial.getLong("materialsetup.materiel");
            }
            StringBuilder comboxKey = new StringBuilder();
            comboxKey.append(orgId).append('\u0001').append(materialId);
            if (materialScaleMap.get(comboxKey.toString()) != null) {
                BigDecimal materialScale = materialScaleMap.get(comboxKey.toString());
                BigDecimal resultScale = currentscale.add(materialScale);
                materialScaleMap.put(comboxKey.toString(), resultScale);
                continue;
            }
            materialScaleMap.put(comboxKey.toString(), currentscale);
        }
    }

    private void verifyMaterialScale(ExtendedDataEntity obj, DynamicObject dyn, DynamicObjectCollection materialCollection, Map<String, BigDecimal> materialScaleMap, Set<Long> orgSet, Set<Long> materialSet) {
        this.queryAndCountScale(dyn, materialScaleMap, orgSet, materialSet);
        for (DynamicObject materialDynObject : materialCollection) {
            BigDecimal result;
            if (materialDynObject.get("materialorg") == null || materialDynObject.get("materiel") == null) continue;
            DynamicObject materialOrg = materialDynObject.getDynamicObject("materialorg");
            DynamicObject material = materialDynObject.getDynamicObject("materiel");
            StringBuilder key = new StringBuilder();
            key.append(materialOrg.getLong("id")).append('\u0001').append(material.getLong("id"));
            if (materialScaleMap.get(key.toString()) == null || (result = materialScaleMap.get(key.toString())).compareTo(BigDecimal.ONE) <= 0) continue;
            StringBuilder errorMessage = new StringBuilder();
            errorMessage.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u8bbe\u7f6e\u4e2d\u7b2c%1$s\u884c\u5e93\u5b58\u7ec4\u7ec7+\u7269\u6599\u7684\u5404\u9879\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e4b\u548c\u4e3a%2$s,\u5df2\u7ecf\u5927\u4e8e\u4e86\u5176\u4e0a\u9650\u503c1,\u8bf7\u91cd\u65b0\u7ed9\u5b83\u7684\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u8d4b\u503c\u3002", (String)"StockSupplyValidator_23", (String)"mpscmm-msplan-opplugin", (Object[])new Object[0]), materialDynObject.getInt("seq"), result.doubleValue()));
            this.addErrorMessage(obj, errorMessage.toString());
        }
    }

    private QFilter[] getmaterialfilters(DynamicObject dyn, Set<Long> orgSet, Set<Long> materialSet) {
        QFilter orgFilter = new QFilter("materialsetup.materialorg.id", "in", orgSet);
        QFilter mFilter = new QFilter("materialsetup.materiel.id", "in", materialSet);
        QFilter sfilter = new QFilter("id", "!=", (Object)dyn.getLong("id"));
        return new QFilter[]{orgFilter, mFilter, sfilter};
    }

    public StringBuilder verifyFieldsMessage(DynamicObjectCollection stracoll, String[] dynname, String dynhtml, String integerhtml, Boolean[] isMust) {
        HashMap stramap = new HashMap(16);
        HashMap primap = new HashMap();
        StringBuilder errormessage = new StringBuilder();
        for (int i = 0; i < stracoll.size(); ++i) {
            StringBuilder idstr = new StringBuilder();
            StringBuilder pristr = new StringBuilder();
            DynamicObject dynobj = (DynamicObject)stracoll.get(i);
            for (int j = 0; j < dynname.length - 1; ++j) {
                long id;
                boolean flag;
                boolean bl = flag = isMust[j] == false || dynobj.get(dynname[j]) != null;
                if (!flag) {
                    return errormessage;
                }
                long l = id = dynobj.get(dynname[j]) == null ? 0L : ((DynamicObject)dynobj.get(dynname[j])).getLong("id");
                if (j == 0 && id != 0L) {
                    pristr.append(id);
                }
                idstr.append(id);
            }
            int priority = dynobj.getInt(dynname[dynname.length - 1]);
            if (priority == 0 && isMust[dynname.length - 1].booleanValue()) {
                return errormessage;
            }
            pristr.append(priority);
            int seq = dynobj.getInt("seq");
            Set<Integer> straset = new HashSet<Integer>(16);
            if (stramap.get(idstr.toString()) != null) {
                straset = (Set)stramap.get(idstr.toString());
            }
            straset.add(seq);
            stramap.put(idstr.toString(), straset);
            if (pristr.length() <= 0) continue;
            Set<Integer> priset = new HashSet<Integer>();
            if (primap.get(pristr.toString()) != null) {
                priset = (Set)primap.get(pristr.toString());
            }
            priset.add(seq);
            primap.put(pristr.toString(), priset);
        }
        if (StringUtils.isNotBlank((CharSequence)dynhtml)) {
            StockSupplyValidator.addErrorMessage(errormessage, stramap, dynhtml);
        }
        if (StringUtils.isNotBlank((CharSequence)integerhtml)) {
            StockSupplyValidator.addErrorMessage(errormessage, primap, integerhtml);
        }
        return errormessage;
    }

    public void verifyErrorMessage(ExtendedDataEntity obj, DynamicObjectCollection typeCollection, String field, String formatMessage) {
        if (!typeCollection.isEmpty()) {
            HashMap map = new HashMap();
            for (DynamicObject type : typeCollection) {
                Set<Integer> set;
                long id = type.getLong(field);
                int seq = type.getInt("seq");
                if (map.get(id) == null) {
                    set = new HashSet<Integer>();
                    set.add(seq);
                    map.put(id, set);
                    continue;
                }
                set = (Set)map.get(id);
                set.add(seq);
            }
            for (Map.Entry entrys : map.entrySet()) {
                Set set = (Set)entrys.getValue();
                if (set.size() < 2) continue;
                this.addErrorMessage(obj, String.format(formatMessage, set));
            }
        }
    }

    public StringBuilder vertifyComboxMessage(DynamicObjectCollection stracoll, String objname, String intername, String objhtml, String integerhtml, Boolean objMust, Boolean interMust) {
        HashMap stramap = new HashMap(16);
        HashMap primap = new HashMap(16);
        StringBuilder errormessage = new StringBuilder();
        for (int i = 0; i < stracoll.size(); ++i) {
            Set<Integer> priset;
            Set<Integer> straset;
            int priority;
            long straid;
            DynamicObject dynobj = (DynamicObject)stracoll.get(i);
            if ((objMust.booleanValue() || dynobj.get(objname) != null) && (interMust.booleanValue() || dynobj.get(intername) != null)) {
                straid = dynobj.get(objname) == null ? 0L : ((DynamicObject)dynobj.get(objname)).getLong("id");
                priority = dynobj.getInt(intername);
                straset = new HashSet();
                if (stramap.get(straid) != null) {
                    straset = (Set)stramap.get(straid);
                }
                priset = new HashSet();
                if (primap.get(priority) != null) {
                    priset = (Set)primap.get(priority);
                }
            } else {
                return errormessage;
            }
            straset.add(dynobj.getInt("seq"));
            priset.add(dynobj.getInt("seq"));
            stramap.put(straid, straset);
            primap.put(priority, priset);
        }
        StockSupplyValidator.addErrorMessage(errormessage, stramap, objhtml);
        StockSupplyValidator.addErrorMessage(errormessage, primap, integerhtml);
        return errormessage;
    }

    private static void addErrorMessage(StringBuilder errormessage, Map<?, Set<Integer>> map, String error) {
        Collection<Set<Integer>> coll = map.values();
        for (Set<Integer> set : coll) {
            if (set.size() < 2) continue;
            String msg = String.format(error, set);
            errormessage.append(msg);
        }
    }
}

